/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.craccd.sqlHelper.bean.Sort;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.cym.config.InitConfig;
import com.cym.model.Http;
import com.cym.model.LogInfo;
import com.cym.service.HttpService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/adminPage/http"})
public class HttpController
extends BaseController {
    @Autowired
    HttpService httpService;
    @Autowired
    SettingService settingService;

    @RequestMapping(value={""})
    public ModelAndView index(HttpSession httpSession, ModelAndView modelAndView) {
        List httpList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Http.class);
        modelAndView.addObject("httpList", (Object)httpList);
        modelAndView.setViewName("/adminPage/http/index");
        return modelAndView;
    }

    @RequestMapping(value={"addOver"})
    @ResponseBody
    public JsonResult addOver(Http http) {
        if (StrUtil.isEmpty((CharSequence)http.getId())) {
            http.setSeq(this.httpService.buildOrder());
        }
        this.sqlHelper.insertOrUpdate((Object)http);
        return this.renderSuccess();
    }

    @RequestMapping(value={"detail"})
    @ResponseBody
    public JsonResult detail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Http.class));
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public JsonResult del(String id) {
        this.sqlHelper.deleteById(id, Http.class);
        return this.renderSuccess();
    }

    @RequestMapping(value={"addGiudeOver"})
    @ResponseBody
    public JsonResult addGiudeOver(String json, Boolean logStatus, Boolean webSocket) {
        Http http;
        List https = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)json), Http.class);
        if (logStatus.booleanValue()) {
            http = new Http();
            http.setName("log_format");
            http.setValue("main escape=json '" + this.buildLogFormat() + "'");
            http.setUnit("");
            https.add(http);
            http = new Http();
            http.setName("access_log");
            http.setValue(InitConfig.home + "log/access.log main");
            http.setUnit("");
            https.add(http);
        }
        if (webSocket.booleanValue()) {
            http = new Http();
            http.setName("map");
            http.setValue("$http_upgrade $connection_upgrade {\r\n    default upgrade;\r\n    '' close;\r\n}\r\n");
            http.setUnit("");
            https.add(http);
        }
        this.httpService.setAll(https);
        return this.renderSuccess();
    }

    private String buildLogFormat() {
        LogInfo logInfo = new LogInfo();
        logInfo.setRemoteAddr("$remote_addr");
        logInfo.setRemoteUser("$remote_user");
        logInfo.setTimeLocal("$time_local");
        logInfo.setRequest("$request");
        logInfo.setHttpHost("$http_host");
        logInfo.setStatus("$status");
        logInfo.setRequestLength("$request_length");
        logInfo.setBodyBytesDent("$body_bytes_sent");
        logInfo.setHttpReferer("$http_referer");
        logInfo.setHttpUserAgent("$http_user_agent");
        logInfo.setRequestTime("$request_time");
        logInfo.setUpstreamResponseTime("$upstream_response_time");
        return JSONUtil.toJsonStr((Object)logInfo);
    }

    @RequestMapping(value={"setOrder"})
    @ResponseBody
    public JsonResult setOrder(String id, Integer count) {
        this.httpService.setSeq(id, count);
        return this.renderSuccess();
    }
}

