/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.craccd.sqlHelper.utils.ConditionAndWrapper;
import cn.craccd.sqlHelper.utils.ConditionWrapper;
import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.ShearCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.captcha.generator.RandomGenerator;
import cn.hutool.core.util.StrUtil;
import com.cym.config.VersionConfig;
import com.cym.model.Admin;
import com.cym.model.Remote;
import com.cym.service.AdminService;
import com.cym.service.CreditService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.PwdCheckUtil;
import com.cym.utils.SystemTool;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/adminPage/login"})
@Controller
public class LoginController
extends BaseController {
    @Autowired
    AdminService adminService;
    @Autowired
    CreditService creditService;
    @Autowired
    VersionConfig versionConfig;
    @Value(value="${project.version}")
    String currentVersion;
    @Autowired
    SettingService settingService;

    @RequestMapping(value={"map"})
    public ModelAndView map(ModelAndView modelAndView) {
        modelAndView.setViewName("/adminPage/login/map");
        return modelAndView;
    }

    @RequestMapping(value={""})
    public ModelAndView admin(ModelAndView modelAndView) {
        modelAndView.addObject("adminCount", (Object)this.sqlHelper.findCountByQuery((ConditionWrapper)new ConditionAndWrapper(), Admin.class));
        modelAndView.setViewName("/adminPage/login/index");
        return modelAndView;
    }

    @RequestMapping(value={"login"})
    @ResponseBody
    public JsonResult submitLogin(String name, String pass, String code, HttpSession httpSession) {
        String imgCode = (String)httpSession.getAttribute("imgCode");
        if (StrUtil.isNotEmpty((CharSequence)imgCode) && !imgCode.equalsIgnoreCase(code)) {
            return this.renderError(this.m.get("loginStr.backError1"));
        }
        if (this.adminService.login(name, pass)) {
            httpSession.setAttribute("localType", (Object)"local");
            httpSession.setAttribute("isLogin", (Object)true);
            this.versionConfig.getNewVersion();
            return this.renderSuccess();
        }
        return this.renderError(this.m.get("loginStr.backError2"));
    }

    @RequestMapping(value={"loginOut"})
    public String loginOut(HttpSession httpSession) {
        httpSession.removeAttribute("isLogin");
        return "redirect:/adminPage/login";
    }

    @RequestMapping(value={"noServer"})
    public ModelAndView noServer(ModelAndView modelAndView) {
        modelAndView.setViewName("/adminPage/login/noServer");
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"getCredit"})
    public JsonResult getCredit(String name, String pass) {
        if (this.adminService.login(name, pass)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("creditKey", this.creditService.make());
            map.put("system", SystemTool.getSystem());
            return this.renderSuccess(map);
        }
        return this.renderError(this.m.get("loginStr.backError3"));
    }

    @ResponseBody
    @RequestMapping(value={"getLocalType"})
    public JsonResult getLocalType(HttpSession httpSession) {
        String localType = (String)httpSession.getAttribute("localType");
        if (StrUtil.isNotEmpty((CharSequence)localType)) {
            if ("local".equals(localType)) {
                return this.renderSuccess((Object)this.m.get("remoteStr.local"));
            }
            Remote remote = (Remote)httpSession.getAttribute("remote");
            if (StrUtil.isNotEmpty((CharSequence)remote.getDescr())) {
                return this.renderSuccess((Object)remote.getDescr());
            }
            return this.renderSuccess((Object)(remote.getIp() + ":" + remote.getPort()));
        }
        return this.renderSuccess((Object)"");
    }

    @ResponseBody
    @RequestMapping(value={"changeLang"})
    public JsonResult changeLang() {
        if (this.settingService.get("lang") != null && this.settingService.get("lang").equals("en_US")) {
            this.settingService.set("lang", "");
        } else {
            this.settingService.set("lang", "en_US");
        }
        return this.renderSuccess();
    }

    @RequestMapping(value={"addAdmin"})
    @ResponseBody
    public JsonResult addAdmin(String name, String pass) {
        Long adminCount = this.sqlHelper.findCountByQuery((ConditionWrapper)new ConditionAndWrapper(), Admin.class);
        if (adminCount > 0L) {
            return this.renderError(this.m.get("loginStr.backError4"));
        }
        if (!(PwdCheckUtil.checkContainUpperCase((String)pass) && PwdCheckUtil.checkContainLowerCase((String)pass) && PwdCheckUtil.checkContainDigit((String)pass) && PwdCheckUtil.checkPasswordLength((String)pass, (String)"8", (String)"100"))) {
            return this.renderError(this.m.get("loginStr.tips"));
        }
        Admin admin = new Admin();
        admin.setName(name);
        admin.setPass(pass);
        this.sqlHelper.insert((Object)admin);
        return this.renderSuccess();
    }

    @RequestMapping(value={"/getCode"})
    public void getCode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ShearCaptcha captcha = CaptchaUtil.createShearCaptcha((int)100, (int)40);
        captcha.setGenerator((CodeGenerator)new RandomGenerator("0123456789", 4));
        String createText = captcha.getCode();
        httpServletRequest.getSession().setAttribute("imgCode", (Object)createText);
        captcha.write((OutputStream)httpServletResponse.getOutputStream());
    }
}

