/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import com.cym.model.MonitorInfo;
import com.cym.service.MonitorService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SystemTool;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/adminPage/monitor"})
@Controller
public class MonitorController
extends BaseController {
    @Autowired
    MonitorService monitorService;
    @Autowired
    SettingService settingService;

    @RequestMapping(value={""})
    public ModelAndView index(HttpSession httpSession, ModelAndView modelAndView) {
        ArrayList list = new ArrayList();
        if (SystemTool.isWindows().booleanValue()) {
            File[] roots;
            for (File file : roots = File.listRoots()) {
                HashMap<String, String> map = new HashMap<String, String>();
                long freeSpace = file.getFreeSpace();
                long totalSpace = file.getTotalSpace();
                long usableSpace = totalSpace - freeSpace;
                map.put("path", file.getPath());
                map.put("freeSpace", freeSpace / 1024L / 1024L / 1024L + "G");
                map.put("usableSpace", usableSpace / 1024L / 1024L / 1024L + "G");
                map.put("totalSpace", totalSpace / 1024L / 1024L / 1024L + "G");
                map.put("percent", NumberUtil.decimalFormat((String)"#.##%", (double)((double)usableSpace / (double)totalSpace)));
                list.add(map);
            }
        } else {
            try {
                List lines = RuntimeUtil.execForLines((String[])new String[]{"df -h"});
                for (int i = 1; i < lines.size(); ++i) {
                    String line = (String)lines.get(i);
                    if (!line.startsWith(File.separator)) continue;
                    while (line.contains("  ")) {
                        line = line.replace("  ", " ");
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    String[] names = line.split(" ");
                    map.put("path", names[0]);
                    map.put("freeSpace", names[3]);
                    map.put("usableSpace", names[2]);
                    map.put("totalSpace", names[1]);
                    map.put("percent", names[4]);
                    list.add(map);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        modelAndView.addObject("list", list);
        String nginxPath = this.settingService.get("nginxPath");
        String nginxExe = this.settingService.get("nginxExe");
        String nginxDir = this.settingService.get("nginxDir");
        Boolean isInit = StrUtil.isNotEmpty((CharSequence)nginxExe) || StrUtil.isNotEmpty((CharSequence)nginxPath);
        if (StrUtil.isEmpty((CharSequence)nginxExe)) {
            nginxExe = "nginx";
        }
        modelAndView.addObject("nginxDir", (Object)nginxDir);
        modelAndView.addObject("nginxExe", (Object)nginxExe);
        modelAndView.addObject("nginxPath", (Object)nginxPath);
        modelAndView.addObject("isInit", (Object)isInit.toString());
        modelAndView.setViewName("/adminPage/monitor/index");
        return modelAndView;
    }

    @RequestMapping(value={"check"})
    @ResponseBody
    public JsonResult check() {
        MonitorInfo monitorInfo = this.monitorService.getMonitorInfo();
        return this.renderSuccess((Object)monitorInfo);
    }

    @RequestMapping(value={"addNginxGiudeOver"})
    @ResponseBody
    public JsonResult addNginxGiudeOver(String nginxDir, String nginxExe, String nginxPath) {
        this.settingService.set("nginxDir", nginxDir);
        this.settingService.set("nginxExe", nginxExe);
        this.settingService.set("nginxPath", nginxPath);
        return this.renderSuccess();
    }
}

