/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.cym.controller.MainController;
import com.cym.controller.adminPage.ConfController;
import com.cym.ext.AsycPack;
import com.cym.ext.Tree;
import com.cym.model.Group;
import com.cym.model.Remote;
import com.cym.service.ConfService;
import com.cym.service.GroupService;
import com.cym.service.RemoteService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.NginxUtils;
import com.cym.utils.SystemTool;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/adminPage/remote"})
public class RemoteController
extends BaseController {
    final RemoteService remoteService;
    final SettingService settingService;
    final ConfService confService;
    final GroupService groupService;
    final ConfController confController;
    final MainController mainController;
    @Value(value="${project.version}")
    String projectVersion;
    @Value(value="${server.port}")
    Integer port;

    public RemoteController(RemoteService remoteService, SettingService settingService, ConfService confService, GroupService groupService, ConfController confController, MainController mainController) {
        this.remoteService = remoteService;
        this.settingService = settingService;
        this.confService = confService;
        this.groupService = groupService;
        this.confController = confController;
        this.mainController = mainController;
    }

    @RequestMapping(value={"version"})
    @ResponseBody
    public Map<String, Object> version() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", this.projectVersion);
        if (NginxUtils.isRun()) {
            map.put("nginx", 1);
        } else {
            map.put("nginx", 0);
        }
        return map;
    }

    @RequestMapping(value={""})
    public ModelAndView index(ModelAndView modelAndView) {
        modelAndView.setViewName("/adminPage/remote/index");
        modelAndView.addObject("projectVersion", (Object)this.projectVersion);
        return modelAndView;
    }

    @RequestMapping(value={"allTable"})
    @ResponseBody
    public List<Remote> allTable() {
        List remoteList = this.sqlHelper.findAll(Remote.class);
        for (Remote remote : remoteList) {
            remote.setStatus(Integer.valueOf(0));
            remote.setType(Integer.valueOf(0));
            if (remote.getParentId() == null) {
                remote.setParentId("");
            }
            try {
                String json = HttpUtil.get((String)(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/remote/version?creditKey=" + remote.getCreditKey()), (int)1000);
                if (!StrUtil.isNotEmpty((CharSequence)json)) continue;
                Map map = (Map)JSONUtil.toBean((String)json, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (boolean)false);
                remote.setStatus(Integer.valueOf(1));
                remote.setVersion((String)map.get("version"));
                remote.setNginx((Integer)map.get("nginx"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Remote remoteLocal = new Remote();
        remoteLocal.setId("local");
        remoteLocal.setIp("");
        remoteLocal.setProtocol("");
        remoteLocal.setParentId("");
        remoteLocal.setDescr(this.m.get("remoteStr.local"));
        Map map = this.version();
        remoteLocal.setVersion((String)map.get("version"));
        remoteLocal.setNginx((Integer)map.get("nginx"));
        remoteLocal.setPort(this.port);
        remoteLocal.setStatus(Integer.valueOf(1));
        remoteLocal.setType(Integer.valueOf(0));
        remoteLocal.setMonitor(Integer.valueOf(this.settingService.get("monitorLocal") != null ? Integer.parseInt(this.settingService.get("monitorLocal")) : 0));
        remoteLocal.setSystem(SystemTool.getSystem());
        remoteList.add(0, remoteLocal);
        List groupList = this.sqlHelper.findAll(Group.class);
        for (Group group : groupList) {
            Remote remoteGroup = new Remote();
            remoteGroup.setDescr(group.getName());
            remoteGroup.setId(group.getId());
            remoteGroup.setParentId(group.getParentId() != null ? group.getParentId() : "");
            remoteGroup.setType(Integer.valueOf(1));
            remoteGroup.setIp("");
            remoteGroup.setProtocol("");
            remoteGroup.setVersion("");
            remoteGroup.setSystem("");
            remoteList.add(remoteGroup);
        }
        return remoteList;
    }

    @RequestMapping(value={"addGroupOver"})
    @ResponseBody
    public JsonResult addGroupOver(Group group) {
        this.sqlHelper.insertOrUpdate((Object)group);
        return this.renderSuccess();
    }

    @RequestMapping(value={"groupDetail"})
    @ResponseBody
    public JsonResult groupDetail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Group.class));
    }

    @RequestMapping(value={"delGroup"})
    @ResponseBody
    public JsonResult delGroup(String id) {
        this.groupService.delete(id);
        return this.renderSuccess();
    }

    @RequestMapping(value={"getGroupTree"})
    @ResponseBody
    public JsonResult getGroupTree() {
        List groups = this.groupService.getListByParent(null);
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        this.fillTree(groups, treeList);
        Tree tree = new Tree();
        tree.setName(this.m.get("remoteStr.noGroup"));
        tree.setValue("");
        treeList.add(0, tree);
        return this.renderSuccess(treeList);
    }

    private void fillTree(List<Group> groups, List<Tree> treeList) {
        for (Group group : groups) {
            Tree tree = new Tree();
            tree.setName(group.getName());
            tree.setValue(group.getId());
            ArrayList treeSubList = new ArrayList();
            this.fillTree(this.groupService.getListByParent(group.getId()), treeSubList);
            tree.setChildren(treeSubList);
            treeList.add(tree);
        }
    }

    @RequestMapping(value={"getCmdRemote"})
    @ResponseBody
    public JsonResult getCmdRemote() {
        List groups = this.groupService.getListByParent(null);
        List remotes = this.remoteService.getListByParent(null);
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        this.fillTreeRemote(groups, remotes, treeList);
        Tree tree = new Tree();
        tree.setName(this.m.get("remoteStr.local"));
        tree.setValue(this.m.get("remoteStr.local"));
        treeList.add(0, tree);
        return this.renderSuccess(treeList);
    }

    private void fillTreeRemote(List<Group> groups, List<Remote> remotes, List<Tree> treeList) {
        Tree tree;
        for (Group group : groups) {
            tree = new Tree();
            tree.setName(group.getName());
            tree.setValue(group.getId());
            ArrayList treeSubList = new ArrayList();
            this.fillTreeRemote(this.groupService.getListByParent(group.getId()), this.remoteService.getListByParent(group.getId()), treeSubList);
            tree.setChildren(treeSubList);
            treeList.add(tree);
        }
        for (Remote remote : remotes) {
            tree = new Tree();
            tree.setName(remote.getIp() + "\u3010" + remote.getDescr() + "\u3011");
            tree.setValue(remote.getId());
            treeList.add(tree);
        }
    }

    @RequestMapping(value={"cmdOver"})
    @ResponseBody
    public JsonResult cmdOver(String[] remoteId, String cmd) {
        if (remoteId == null || remoteId.length == 0) {
            return this.renderSuccess((Object)"\u672a\u9009\u62e9\u670d\u52a1\u5668");
        }
        StringBuilder rs = new StringBuilder();
        for (String id : remoteId) {
            JsonResult jsonResult = null;
            if (id.equals("local")) {
                if (cmd.contentEquals("check")) {
                    jsonResult = this.confController.check(null, null, null);
                }
                if (cmd.contentEquals("reload")) {
                    jsonResult = this.confController.reload(null, null, null);
                }
                if (cmd.contentEquals("start")) {
                    jsonResult = this.confController.start(null, null, null);
                }
                if (cmd.contentEquals("stop")) {
                    jsonResult = this.confController.stop(null, null);
                }
                if (cmd.contentEquals("update")) {
                    jsonResult = this.renderError(this.m.get("remoteStr.notAllow"));
                }
                rs.append("<span class='blue'>" + this.m.get("remoteStr.local") + "> </span>");
            } else {
                Remote remote = (Remote)this.sqlHelper.findById(id, Remote.class);
                rs.append("<span class='blue'>").append(remote.getIp()).append("> </span>");
                try {
                    String json = HttpUtil.get((String)(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/conf/" + cmd + "?creditKey=" + remote.getCreditKey()));
                    jsonResult = (JsonResult)JSONUtil.toBean((String)json, JsonResult.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (jsonResult != null) {
                if (jsonResult.isSuccess()) {
                    rs.append(jsonResult.getObj().toString());
                } else {
                    rs.append(jsonResult.getMsg());
                }
            }
            rs.append("<br>");
        }
        return this.renderSuccess((Object)rs.toString());
    }

    @RequestMapping(value={"asyc"})
    @ResponseBody
    public JsonResult asyc(String fromId, String[] remoteId) {
        if (StrUtil.isEmpty((CharSequence)fromId) || remoteId == null || remoteId.length == 0) {
            return this.renderSuccess((Object)this.m.get("remoteStr.noChoice"));
        }
        Remote remoteFrom = (Remote)this.sqlHelper.findById(fromId, Remote.class);
        String json = remoteFrom == null ? this.getAsycPack() : HttpUtil.get((String)(remoteFrom.getProtocol() + "://" + remoteFrom.getIp() + ":" + remoteFrom.getPort() + "/adminPage/remote/getAsycPack?creditKey=" + remoteFrom.getCreditKey()), (int)1000);
        for (String remoteToId : remoteId) {
            if (remoteToId.equals("local")) {
                this.setAsycPack(json);
                continue;
            }
            Remote remoteTo = (Remote)this.sqlHelper.findById(remoteToId, Remote.class);
            try {
                String version = HttpUtil.get((String)(remoteTo.getProtocol() + "://" + remoteTo.getIp() + ":" + remoteTo.getPort() + "/adminPage/remote/version?creditKey=" + remoteTo.getCreditKey()), (int)1000);
                if (!StrUtil.isNotEmpty((CharSequence)version)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("json", json);
                HttpUtil.post((String)(remoteTo.getProtocol() + "://" + remoteTo.getIp() + ":" + remoteTo.getPort() + "/adminPage/remote/setAsycPack?creditKey=" + remoteTo.getCreditKey()), map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.renderSuccess();
    }

    @RequestMapping(value={"getAsycPack"})
    @ResponseBody
    public String getAsycPack() {
        AsycPack asycPack = this.confService.getAsycPack();
        return JSONUtil.toJsonPrettyStr((Object)asycPack);
    }

    @RequestMapping(value={"setAsycPack"})
    @ResponseBody
    public JsonResult setAsycPack(String json) {
        AsycPack asycPack = (AsycPack)JSONUtil.toBean((String)json, AsycPack.class);
        this.confService.setAsycPack(asycPack);
        return this.renderSuccess();
    }

    @RequestMapping(value={"addOver"})
    @ResponseBody
    public JsonResult addOver(Remote remote) {
        remote.setIp(remote.getIp().trim());
        if (this.remoteService.hasSame(remote)) {
            return this.renderError(this.m.get("remoteStr.sameIp"));
        }
        this.remoteService.getCreditKey(remote);
        if (StrUtil.isNotEmpty((CharSequence)remote.getCreditKey())) {
            this.sqlHelper.insertOrUpdate((Object)remote);
            return this.renderSuccess();
        }
        return this.renderError(this.m.get("remoteStr.noAuth"));
    }

    @RequestMapping(value={"detail"})
    @ResponseBody
    public JsonResult detail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Remote.class));
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public JsonResult del(String id) {
        this.sqlHelper.deleteById(id, Remote.class);
        return this.renderSuccess();
    }

    @RequestMapping(value={"content"})
    @ResponseBody
    public JsonResult content(String id) {
        Remote remote = (Remote)this.sqlHelper.findById(id, Remote.class);
        String rs = HttpUtil.get((String)(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/remote/readContent?creditKey=" + remote.getCreditKey()));
        return this.renderSuccess((Object)rs);
    }

    @RequestMapping(value={"readContent"})
    @ResponseBody
    public String readContent() {
        String nginxPath = this.settingService.get("nginxPath");
        if (FileUtil.exist((String)nginxPath)) {
            return FileUtil.readString((String)nginxPath, (Charset)StandardCharsets.UTF_8);
        }
        return this.m.get("remoteStr.noFile");
    }

    @RequestMapping(value={"change"})
    @ResponseBody
    public JsonResult change(String id, HttpSession httpSession) {
        Remote remote = (Remote)this.sqlHelper.findById(id, Remote.class);
        if (remote == null) {
            httpSession.setAttribute("localType", (Object)"local");
            httpSession.removeAttribute("remote");
        } else {
            httpSession.setAttribute("localType", (Object)"remote");
            httpSession.setAttribute("remote", (Object)remote);
        }
        return this.renderSuccess();
    }

    @RequestMapping(value={"nginxStatus"})
    @ResponseBody
    public JsonResult nginxStatus(HttpSession httpSession) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mail", this.settingService.get("mail"));
        String nginxMonitor = this.settingService.get("nginxMonitor");
        map.put("nginxMonitor", nginxMonitor != null ? nginxMonitor : "false");
        return this.renderSuccess(map);
    }

    @RequestMapping(value={"nginxOver"})
    @ResponseBody
    public JsonResult nginxOver(String mail, String nginxMonitor) {
        this.settingService.set("mail", mail);
        this.settingService.set("nginxMonitor", nginxMonitor);
        return this.renderSuccess();
    }

    @RequestMapping(value={"setMonitor"})
    @ResponseBody
    public JsonResult setMonitor(String id, Integer monitor) {
        if (!"local".equals(id)) {
            Remote remote = new Remote();
            remote.setId(id);
            remote.setMonitor(monitor);
            this.sqlHelper.updateById((Object)remote);
        } else {
            this.settingService.set("monitorLocal", monitor.toString());
        }
        return this.renderSuccess();
    }
}

