/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.craccd.sqlHelper.bean.Page;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.cym.ext.ServerExt;
import com.cym.model.Cert;
import com.cym.model.Location;
import com.cym.model.Server;
import com.cym.model.Upstream;
import com.cym.model.Www;
import com.cym.service.ParamService;
import com.cym.service.ServerService;
import com.cym.service.SettingService;
import com.cym.service.UpstreamService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.TelnetUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/adminPage/server"})
public class ServerController
extends BaseController {
    @Autowired
    ServerService serverService;
    @Autowired
    UpstreamService upstreamService;
    @Autowired
    ParamService paramService;
    @Autowired
    SettingService settingService;

    @RequestMapping(value={""})
    public ModelAndView index(HttpSession httpSession, ModelAndView modelAndView, Page page, String sort, String direction, String keywords) {
        page = this.serverService.search(page, sort, direction, keywords);
        ArrayList<ServerExt> exts = new ArrayList<ServerExt>();
        for (Server server : page.getRecords(Server.class)) {
            ServerExt serverExt = new ServerExt();
            if (server.getEnable() == null) {
                server.setEnable(Boolean.valueOf(false));
            }
            serverExt.setServer(server);
            if (server.getProxyType() == 0) {
                serverExt.setLocationStr(this.buildLocationStr(server.getId()));
            } else {
                Upstream upstream = (Upstream)this.sqlHelper.findById(server.getProxyUpstreamId(), Upstream.class);
                serverExt.setLocationStr(this.m.get("serverStr.server") + ": " + (upstream != null ? upstream.getName() : ""));
            }
            exts.add(serverExt);
        }
        page.setRecords(exts);
        modelAndView.addObject("page", (Object)page);
        List upstreamList = this.upstreamService.getListByProxyType(Integer.valueOf(0));
        modelAndView.addObject("upstreamList", (Object)upstreamList);
        modelAndView.addObject("upstreamSize", (Object)upstreamList.size());
        List upstreamTcpList = this.upstreamService.getListByProxyType(Integer.valueOf(1));
        modelAndView.addObject("upstreamTcpList", (Object)upstreamTcpList);
        modelAndView.addObject("upstreamTcpSize", (Object)upstreamTcpList.size());
        modelAndView.addObject("certList", (Object)this.sqlHelper.findAll(Cert.class));
        modelAndView.addObject("wwwList", (Object)this.sqlHelper.findAll(Www.class));
        modelAndView.addObject("sort", (Object)sort);
        modelAndView.addObject("direction", (Object)direction);
        modelAndView.addObject("keywords", (Object)keywords);
        modelAndView.setViewName("/adminPage/server/index");
        return modelAndView;
    }

    private String buildLocationStr(String id) {
        ArrayList<String> str = new ArrayList<String>();
        List locations = this.serverService.getLocationByServerId(id);
        for (Location location : locations) {
            if (location.getType() == 0) {
                str.add("<span class='path'>" + location.getPath() + "</span><span class='value'>" + location.getValue() + "</span>");
                continue;
            }
            if (location.getType() == 1) {
                str.add("<span class='path'>" + location.getPath() + "</span><span class='value'>" + location.getRootPath() + "</span>");
                continue;
            }
            if (location.getType() == 2) {
                Upstream upstream = (Upstream)this.sqlHelper.findById(location.getUpstreamId(), Upstream.class);
                if (upstream == null) continue;
                str.add("<span class='path'>" + location.getPath() + "</span><span class='value'>http://" + upstream.getName() + (location.getUpstreamPath() != null ? location.getUpstreamPath() : "") + "</span>");
                continue;
            }
            if (location.getType() != 3) continue;
            str.add("<span class='path'>" + location.getPath() + "</span>");
        }
        return StrUtil.join((CharSequence)"<br>", (Object[])new Object[]{str});
    }

    @RequestMapping(value={"addOver"})
    @ResponseBody
    public JsonResult addOver(String serverJson, String serverParamJson, String locationJson) {
        Server server = (Server)JSONUtil.toBean((String)serverJson, Server.class);
        List locations = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)locationJson), Location.class);
        if (server.getProxyType() == 0) {
            try {
                this.serverService.addOver(server, serverParamJson, locations);
            }
            catch (Exception e) {
                return this.renderError(e.getMessage());
            }
        } else {
            this.serverService.addOverTcp(server, serverParamJson);
        }
        return this.renderSuccess();
    }

    @RequestMapping(value={"setEnable"})
    @ResponseBody
    public JsonResult setEnable(Server server) {
        this.sqlHelper.updateById((Object)server);
        return this.renderSuccess();
    }

    @RequestMapping(value={"detail"})
    @ResponseBody
    public JsonResult detail(String id) {
        Server server = (Server)this.sqlHelper.findById(id, Server.class);
        ServerExt serverExt = new ServerExt();
        serverExt.setServer(server);
        List list = this.serverService.getLocationByServerId(id);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Location location;
            String json = this.paramService.getJsonByTypeId((location = (Location)iterator.next()).getId(), "location");
            location.setLocationParamJson(json != null ? json : null);
        }
        serverExt.setLocationList(list);
        String json = this.paramService.getJsonByTypeId(server.getId(), "server");
        serverExt.setParamJson(json != null ? json : null);
        return this.renderSuccess((Object)serverExt);
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public JsonResult del(String id) {
        this.serverService.deleteById(id);
        return this.renderSuccess();
    }

    @RequestMapping(value={"clone"})
    @ResponseBody
    public JsonResult clone(String id) {
        this.serverService.clone(id);
        return this.renderSuccess();
    }

    @RequestMapping(value={"importServer"})
    @ResponseBody
    public JsonResult importServer(String nginxPath) {
        if (StrUtil.isEmpty((CharSequence)nginxPath) || !FileUtil.exist((String)nginxPath)) {
            return this.renderError(this.m.get("serverStr.fileNotExist"));
        }
        try {
            this.serverService.importServer(nginxPath);
            return this.renderSuccess((Object)this.m.get("serverStr.importSuccess"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.renderError(this.m.get("serverStr.importFail") + "\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"testPort"})
    @ResponseBody
    public JsonResult testPort() {
        List servers = this.sqlHelper.findAll(Server.class);
        ArrayList<String> ips = new ArrayList<String>();
        for (Server server : servers) {
            String ip = "";
            String port = "";
            if (server.getListen().contains(":")) {
                ip = server.getListen().split(":")[0];
                port = server.getListen().split(":")[1];
            } else {
                ip = "127.0.0.1";
                port = server.getListen();
            }
            if (!TelnetUtils.isRunning((String)ip, (int)Integer.parseInt(port)) || ips.contains(server.getListen())) continue;
            ips.add(server.getListen());
        }
        if (ips.size() == 0) {
            return this.renderSuccess();
        }
        return this.renderError(this.m.get("serverStr.portUserdList") + ": " + StrUtil.join((CharSequence)" , ", (Object[])new Object[]{ips}));
    }

    @RequestMapping(value={"editDescr"})
    @ResponseBody
    public JsonResult editDescr(String id, String descr) {
        Server server = new Server();
        server.setId(id);
        server.setDescr(descr);
        this.sqlHelper.updateById((Object)server);
        return this.renderSuccess();
    }
}

