/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.cym.ext.TemplateExt;
import com.cym.model.Param;
import com.cym.model.Template;
import com.cym.service.TemplateService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/adminPage/template"})
public class TemplateController
extends BaseController {
    @Autowired
    TemplateService templateService;

    @RequestMapping(value={""})
    public ModelAndView index(HttpSession httpSession, ModelAndView modelAndView) {
        List templateList = this.sqlHelper.findAll(Template.class);
        ArrayList<TemplateExt> extList = new ArrayList<TemplateExt>();
        for (Template template : templateList) {
            TemplateExt templateExt = new TemplateExt();
            templateExt.setTemplate(template);
            templateExt.setParamList(this.templateService.getParamList(template.getId()));
            templateExt.setCount(Integer.valueOf(templateExt.getParamList().size()));
            extList.add(templateExt);
        }
        modelAndView.addObject("templateList", extList);
        modelAndView.setViewName("/adminPage/template/index");
        return modelAndView;
    }

    @RequestMapping(value={"addOver"})
    @ResponseBody
    public JsonResult addOver(Template template, String paramJson) {
        Long count;
        if (StrUtil.isEmpty((CharSequence)template.getId()) ? (count = this.templateService.getCountByName(template.getName())) > 0L : (count = this.templateService.getCountByNameWithOutId(template.getName(), template.getId())) > 0L) {
            return this.renderError(this.m.get("templateStr.sameName"));
        }
        List params = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)paramJson), Param.class);
        this.templateService.addOver(template, params);
        return this.renderSuccess();
    }

    @RequestMapping(value={"detail"})
    @ResponseBody
    public JsonResult detail(String id) {
        Template template = (Template)this.sqlHelper.findById(id, Template.class);
        TemplateExt templateExt = new TemplateExt();
        templateExt.setTemplate(template);
        templateExt.setParamList(this.templateService.getParamList(template.getId()));
        templateExt.setCount(Integer.valueOf(templateExt.getParamList().size()));
        return this.renderSuccess((Object)templateExt);
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public JsonResult del(String id) {
        this.templateService.del(id);
        return this.renderSuccess();
    }

    @RequestMapping(value={"getTemplate"})
    @ResponseBody
    public JsonResult getTemplate() {
        return this.renderSuccess((Object)this.sqlHelper.findAll(Template.class));
    }
}

