/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.craccd.sqlHelper.bean.Page;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.cym.ext.UpstreamExt;
import com.cym.model.Upstream;
import com.cym.model.UpstreamServer;
import com.cym.service.ParamService;
import com.cym.service.SettingService;
import com.cym.service.UpstreamService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/adminPage/upstream"})
public class UpstreamController
extends BaseController {
    @Autowired
    UpstreamService upstreamService;
    @Autowired
    ParamService paramService;
    @Autowired
    SettingService settingService;

    @RequestMapping(value={""})
    public ModelAndView index(HttpSession httpSession, ModelAndView modelAndView, Page page, String keywords) {
        page = this.upstreamService.search(page, keywords);
        ArrayList<UpstreamExt> list = new ArrayList<UpstreamExt>();
        for (Upstream upstream : page.getRecords(Upstream.class)) {
            UpstreamExt upstreamExt = new UpstreamExt();
            upstreamExt.setUpstream(upstream);
            ArrayList<String> str = new ArrayList<String>();
            List servers = this.upstreamService.getUpstreamServers(upstream.getId());
            for (UpstreamServer upstreamServer : servers) {
                str.add(this.buildStr(upstreamServer, upstream.getProxyType()));
            }
            upstreamExt.setServerStr(StrUtil.join((CharSequence)"", (Object[])new Object[]{str}));
            list.add(upstreamExt);
        }
        page.setRecords(list);
        modelAndView.addObject("page", (Object)page);
        modelAndView.addObject("keywords", (Object)keywords);
        modelAndView.setViewName("/adminPage/upstream/index");
        return modelAndView;
    }

    public String buildStr(UpstreamServer upstreamServer, Integer proxyType) {
        String status = this.m.get("upstreamStr.noStatus");
        if (!"none".equals(upstreamServer.getStatus())) {
            status = upstreamServer.getStatus();
        }
        String monitorStatus = "";
        String upstreamMonitor = this.settingService.get("upstreamMonitor");
        if ("true".equals(upstreamMonitor)) {
            monitorStatus = monitorStatus + "<td>";
            monitorStatus = upstreamServer.getMonitorStatus() == 1 ? monitorStatus + "<span class='green'>" + this.m.get("upstreamStr.green") + "</span>" : monitorStatus + "<span class='red'>" + this.m.get("upstreamStr.red") + "</span>";
            monitorStatus = monitorStatus + "</td>";
        }
        System.err.println(upstreamServer.getServer() + ":" + upstreamServer.getMonitorStatus());
        return "<tr><td>" + upstreamServer.getServer() + ":" + upstreamServer.getPort() + "</td><td>weight=" + upstreamServer.getWeight() + "</td><td>fail_timeout=" + upstreamServer.getFailTimeout() + "s</td><td>max_fails=" + upstreamServer.getMaxFails() + "</td><td>" + status + "</td>" + monitorStatus + "</tr>";
    }

    @RequestMapping(value={"addOver"})
    @ResponseBody
    public JsonResult addOver(String upstreamJson, String upstreamParamJson, String upstreamServerJson) {
        Long count;
        Upstream upstream = (Upstream)JSONUtil.toBean((String)upstreamJson, Upstream.class);
        List upstreamServers = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)upstreamServerJson), UpstreamServer.class);
        if (StrUtil.isEmpty((CharSequence)upstream.getId()) ? (count = this.upstreamService.getCountByName(upstream.getName())) > 0L : (count = this.upstreamService.getCountByNameWithOutId(upstream.getName(), upstream.getId())) > 0L) {
            return this.renderError(this.m.get("upstreamStr.sameName"));
        }
        this.upstreamService.addOver(upstream, upstreamServers, upstreamParamJson);
        return this.renderSuccess();
    }

    @RequestMapping(value={"detail"})
    @ResponseBody
    public JsonResult detail(String id) {
        UpstreamExt upstreamExt = new UpstreamExt();
        upstreamExt.setUpstream((Upstream)this.sqlHelper.findById(id, Upstream.class));
        upstreamExt.setUpstreamServerList(this.upstreamService.getUpstreamServers(id));
        upstreamExt.setParamJson(this.paramService.getJsonByTypeId(upstreamExt.getUpstream().getId(), "upstream"));
        return this.renderSuccess((Object)upstreamExt);
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public JsonResult del(String id) {
        this.upstreamService.del(id);
        return this.renderSuccess();
    }

    @RequestMapping(value={"setMonitor"})
    @ResponseBody
    public JsonResult setMonitor(String id, Integer monitor) {
        Upstream upstream = new Upstream();
        upstream.setId(id);
        upstream.setMonitor(monitor);
        this.sqlHelper.updateById((Object)upstream);
        return this.renderSuccess();
    }

    @RequestMapping(value={"upstreamStatus"})
    @ResponseBody
    public JsonResult upstreamStatus(HttpSession httpSession) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mail", this.settingService.get("mail"));
        String upstreamMonitor = this.settingService.get("upstreamMonitor");
        map.put("upstreamMonitor", upstreamMonitor != null ? upstreamMonitor : "false");
        return this.renderSuccess(map);
    }

    @RequestMapping(value={"upstreamOver"})
    @ResponseBody
    public JsonResult upstreamOver(String mail, String upstreamMonitor) {
        this.settingService.set("mail", mail);
        this.settingService.set("upstreamMonitor", upstreamMonitor);
        return this.renderSuccess();
    }
}

