/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.craccd.sqlHelper.bean.Sort;
import cn.craccd.sqlHelper.utils.ConditionAndWrapper;
import cn.craccd.sqlHelper.utils.ConditionWrapper;
import cn.craccd.sqlHelper.utils.SqlHelper;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.cym.config.InitConfig;
import com.cym.ext.AsycPack;
import com.cym.ext.ConfExt;
import com.cym.ext.ConfFile;
import com.cym.model.Basic;
import com.cym.model.Http;
import com.cym.model.Location;
import com.cym.model.Param;
import com.cym.model.Server;
import com.cym.model.Stream;
import com.cym.model.Upstream;
import com.cym.model.UpstreamServer;
import com.cym.service.LocationService;
import com.cym.service.ParamService;
import com.cym.service.ServerService;
import com.cym.service.SettingService;
import com.cym.service.TemplateService;
import com.cym.service.UpstreamService;
import com.github.odiszapc.nginxparser.NgxBlock;
import com.github.odiszapc.nginxparser.NgxConfig;
import com.github.odiszapc.nginxparser.NgxDumper;
import com.github.odiszapc.nginxparser.NgxEntry;
import com.github.odiszapc.nginxparser.NgxParam;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfService {
    final UpstreamService upstreamService;
    final SettingService settingService;
    final ServerService serverService;
    final LocationService locationService;
    final ParamService paramService;
    final SqlHelper sqlHelper;
    final TemplateService templateService;

    public ConfService(TemplateService templateService, UpstreamService upstreamService, SettingService settingService, ServerService serverService, LocationService locationService, ParamService paramService, SqlHelper sqlHelper) {
        this.upstreamService = upstreamService;
        this.settingService = settingService;
        this.serverService = serverService;
        this.locationService = locationService;
        this.paramService = paramService;
        this.sqlHelper = sqlHelper;
        this.templateService = templateService;
    }

    public synchronized ConfExt buildConf(Boolean decompose) {
        ConfExt confExt = new ConfExt();
        confExt.setFileList(new ArrayList());
        String nginxPath = this.settingService.get("nginxPath");
        try {
            List paramList;
            NgxBlock ngxBlockServer;
            NgxParam ngxParam;
            NgxConfig ngxConfig = new NgxConfig();
            List basicList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Basic.class);
            for (Basic basic : basicList) {
                NgxParam ngxParam2 = new NgxParam();
                ngxParam2.addValue(basic.getName().trim() + " " + basic.getValue().trim());
                ngxConfig.addEntry((NgxEntry)ngxParam2);
            }
            List httpList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Http.class);
            boolean hasHttp = false;
            NgxBlock ngxBlockHttp = new NgxBlock();
            ngxBlockHttp.addValue("http");
            for (Http http : httpList) {
                NgxParam ngxParam3 = new NgxParam();
                ngxParam3.addValue(http.getName().trim() + " " + http.getValue().trim());
                ngxBlockHttp.addEntry((NgxEntry)ngxParam3);
                hasHttp = true;
            }
            List upstreams = this.upstreamService.getListByProxyType(Integer.valueOf(0));
            for (Object upstream : upstreams) {
                Object upstreamServer2;
                NgxBlock ngxBlockServer2 = new NgxBlock();
                ngxBlockServer2.addValue("upstream " + upstream.getName().trim());
                if (StrUtil.isNotEmpty((CharSequence)upstream.getTactics())) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue(upstream.getTactics());
                    ngxBlockServer2.addEntry((NgxEntry)ngxParam);
                }
                List upstreamServers = this.upstreamService.getUpstreamServers(upstream.getId());
                for (Object upstreamServer2 : upstreamServers) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue("server " + this.buildNodeStr((UpstreamServer)upstreamServer2, upstream.getProxyType()));
                    ngxBlockServer2.addEntry((NgxEntry)ngxParam);
                }
                List paramList2 = this.paramService.getListByTypeId(upstream.getId(), "upstream");
                upstreamServer2 = paramList2.iterator();
                while (upstreamServer2.hasNext()) {
                    Param param = (Param)upstreamServer2.next();
                    this.setSameParam(param, ngxBlockServer2);
                }
                hasHttp = true;
                if (decompose.booleanValue()) {
                    this.addConfFile(confExt, "upstreams." + upstream.getName() + ".conf", ngxBlockServer2);
                    ngxParam = new NgxParam();
                    ngxParam.addValue("include " + nginxPath.replace("nginx.conf", "conf.d/upstreams." + upstream.getName() + ".conf"));
                    ngxBlockHttp.addEntry((NgxEntry)ngxParam);
                    continue;
                }
                ngxBlockHttp.addEntry((NgxEntry)ngxBlockServer2);
            }
            List servers = this.serverService.getListByProxyType(Integer.valueOf(0));
            for (Server server : servers) {
                Object param2;
                if (server.getEnable() == null || !server.getEnable().booleanValue()) continue;
                NgxBlock ngxBlockServer3 = new NgxBlock();
                ngxBlockServer3.addValue("server");
                if (StrUtil.isNotEmpty((CharSequence)server.getServerName())) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue("server_name " + server.getServerName());
                    ngxBlockServer3.addEntry((NgxEntry)ngxParam);
                }
                ngxParam = new NgxParam();
                Object value = "listen " + server.getListen();
                if (server.getDef() == 1) {
                    value = value + " default";
                }
                if (server.getSsl() != null && server.getSsl() == 1) {
                    value = (String)value + " ssl";
                    if (server.getHttp2() != null && server.getHttp2() == 1) {
                        value = (String)value + " http2";
                    }
                }
                ngxParam.addValue(value);
                ngxBlockServer3.addEntry((NgxEntry)ngxParam);
                if (server.getSsl() == 1) {
                    if (StrUtil.isNotEmpty((CharSequence)server.getPem()) && StrUtil.isNotEmpty((CharSequence)server.getKey())) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("ssl_certificate " + server.getPem());
                        ngxBlockServer3.addEntry((NgxEntry)ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("ssl_certificate_key " + server.getKey());
                        ngxBlockServer3.addEntry((NgxEntry)ngxParam);
                        ngxParam = new NgxParam();
                        ngxParam.addValue("ssl_protocols TLSv1 TLSv1.1 TLSv1.2");
                        ngxBlockServer3.addEntry((NgxEntry)ngxParam);
                    }
                    if (server.getRewrite() == 1) {
                        ngxParam = new NgxParam();
                        ngxParam.addValue("listen 80");
                        ngxBlockServer3.addEntry((NgxEntry)ngxParam);
                        NgxBlock ngxBlock = new NgxBlock();
                        ngxBlock.addValue("if ($scheme = http)");
                        ngxParam = new NgxParam();
                        ngxParam.addValue("return 301 https://$host$request_uri");
                        ngxBlock.addEntry((NgxEntry)ngxParam);
                        ngxBlockServer3.addEntry((NgxEntry)ngxBlock);
                    }
                }
                List paramList3 = this.paramService.getListByTypeId(server.getId(), "server");
                for (Object param2 : paramList3) {
                    this.setSameParam((Param)param2, ngxBlockServer3);
                }
                List locationList = this.serverService.getLocationByServerId(server.getId());
                param2 = locationList.iterator();
                while (param2.hasNext()) {
                    Object upstream;
                    Location location = (Location)param2.next();
                    NgxBlock ngxBlockLocation = new NgxBlock();
                    if (location.getType() == 0 || location.getType() == 2) {
                        ngxBlockLocation.addValue("location");
                        ngxBlockLocation.addValue(location.getPath());
                        if (location.getType() == 0) {
                            ngxParam = new NgxParam();
                            ngxParam.addValue("proxy_pass " + location.getValue());
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                        } else if (location.getType() == 2 && (upstream = (Upstream)this.sqlHelper.findById(location.getUpstreamId(), Upstream.class)) != null) {
                            ngxParam = new NgxParam();
                            ngxParam.addValue("proxy_pass http://" + upstream.getName() + (location.getUpstreamPath() != null ? location.getUpstreamPath() : ""));
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                        }
                        if (location.getHeader() == 1) {
                            ngxParam = new NgxParam();
                            ngxParam.addValue("proxy_set_header Host $host:$server_port");
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                            ngxParam = new NgxParam();
                            ngxParam.addValue("proxy_set_header X-Real-IP $remote_addr");
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                            ngxParam = new NgxParam();
                            ngxParam.addValue("proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for");
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                            ngxParam = new NgxParam();
                            ngxParam.addValue("proxy_set_header X-Forwarded-Proto $scheme");
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                        }
                        if (server.getSsl() == 1 && server.getRewrite() == 1) {
                            ngxParam = new NgxParam();
                            ngxParam.addValue("proxy_redirect http:// https://");
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                        }
                    } else if (location.getType() == 1) {
                        ngxBlockLocation.addValue("location");
                        ngxBlockLocation.addValue(location.getPath());
                        if (location.getRootType() != null && location.getRootType().equals("alias")) {
                            ngxParam = new NgxParam();
                            ngxParam.addValue("alias " + location.getRootPath());
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                        } else {
                            ngxParam = new NgxParam();
                            ngxParam.addValue("root " + location.getRootPath());
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                        }
                        if (StrUtil.isNotEmpty((CharSequence)location.getRootPage())) {
                            ngxParam = new NgxParam();
                            ngxParam.addValue("index " + location.getRootPage());
                            ngxBlockLocation.addEntry((NgxEntry)ngxParam);
                        }
                    } else if (location.getType() == 3) {
                        ngxBlockLocation.addValue("location");
                        ngxBlockLocation.addValue(location.getPath());
                    }
                    paramList3 = this.paramService.getListByTypeId(location.getId(), "location");
                    upstream = paramList3.iterator();
                    while (upstream.hasNext()) {
                        Param param3 = (Param)upstream.next();
                        this.setSameParam(param3, ngxBlockLocation);
                    }
                    ngxBlockServer3.addEntry((NgxEntry)ngxBlockLocation);
                }
                hasHttp = true;
                if (decompose.booleanValue()) {
                    String name = "all";
                    if (StrUtil.isNotEmpty((CharSequence)server.getServerName())) {
                        name = server.getServerName();
                    }
                    this.addConfFile(confExt, name + ".conf", ngxBlockServer3);
                    ngxParam = new NgxParam();
                    ngxParam.addValue("include " + nginxPath.replace("nginx.conf", "conf.d/" + name + ".conf"));
                    ngxBlockHttp.addEntry((NgxEntry)ngxParam);
                    continue;
                }
                ngxBlockHttp.addEntry((NgxEntry)ngxBlockServer3);
            }
            if (hasHttp) {
                ngxConfig.addEntry((NgxEntry)ngxBlockHttp);
            }
            List streamList = this.sqlHelper.findAll(new Sort("seq", Sort.Direction.ASC), Stream.class);
            boolean hasStream = false;
            NgxBlock ngxBlockStream = new NgxBlock();
            ngxBlockStream.addValue("stream");
            for (Stream stream : streamList) {
                ngxParam = new NgxParam();
                ngxParam.addValue(stream.getName() + " " + stream.getValue());
                ngxBlockStream.addEntry((NgxEntry)ngxParam);
                hasStream = true;
            }
            upstreams = this.upstreamService.getListByProxyType(Integer.valueOf(1));
            for (Upstream upstream : upstreams) {
                ngxBlockServer = new NgxBlock();
                ngxBlockServer.addValue("upstream " + upstream.getName());
                if (StrUtil.isNotEmpty((CharSequence)upstream.getTactics())) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue(upstream.getTactics());
                    ngxBlockServer.addEntry((NgxEntry)ngxParam);
                }
                List upstreamServers = this.upstreamService.getUpstreamServers(upstream.getId());
                for (UpstreamServer upstreamServer : upstreamServers) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue("server " + this.buildNodeStr(upstreamServer, upstream.getProxyType()));
                    ngxBlockServer.addEntry((NgxEntry)ngxParam);
                }
                paramList = this.paramService.getListByTypeId(upstream.getId(), "upstream");
                for (Param param : paramList) {
                    this.setSameParam(param, ngxBlockServer);
                }
                if (decompose.booleanValue()) {
                    this.addConfFile(confExt, "upstreams." + upstream.getName() + ".conf", ngxBlockServer);
                    ngxParam = new NgxParam();
                    ngxParam.addValue("include " + nginxPath.replace("nginx.conf", "conf.d/upstreams." + upstream.getName() + ".conf"));
                    ngxBlockStream.addEntry((NgxEntry)ngxParam);
                } else {
                    ngxBlockStream.addEntry((NgxEntry)ngxBlockServer);
                }
                hasStream = true;
            }
            servers = this.serverService.getListByProxyType(Integer.valueOf(1));
            for (Server server : servers) {
                if (server.getEnable() == null || !server.getEnable().booleanValue()) continue;
                ngxBlockServer = new NgxBlock();
                ngxBlockServer.addValue("server");
                ngxParam = new NgxParam();
                ngxParam.addValue("listen " + server.getListen());
                ngxBlockServer.addEntry((NgxEntry)ngxParam);
                Upstream upstream = (Upstream)this.sqlHelper.findById(server.getProxyUpstreamId(), Upstream.class);
                if (upstream != null) {
                    ngxParam = new NgxParam();
                    ngxParam.addValue("proxy_pass " + upstream.getName());
                    ngxBlockServer.addEntry((NgxEntry)ngxParam);
                }
                paramList = this.paramService.getListByTypeId(server.getId(), "server");
                for (Param param : paramList) {
                    this.setSameParam(param, ngxBlockServer);
                }
                if (decompose.booleanValue()) {
                    this.addConfFile(confExt, "stream." + server.getListen() + ".conf", ngxBlockServer);
                    ngxParam = new NgxParam();
                    ngxParam.addValue("include " + nginxPath.replace("nginx.conf", "conf.d/stream." + server.getListen() + ".conf"));
                    ngxBlockStream.addEntry((NgxEntry)ngxParam);
                } else {
                    ngxBlockStream.addEntry((NgxEntry)ngxBlockServer);
                }
                hasStream = true;
            }
            if (hasStream) {
                ngxConfig.addEntry((NgxEntry)ngxBlockStream);
            }
            String conf = new NgxDumper(ngxConfig).dump().replace("};", "  }");
            confExt.setConf(conf);
            return confExt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String buildNodeStr(UpstreamServer upstreamServer, Integer proxyType) {
        String status = "";
        if (!"none".equals(upstreamServer.getStatus())) {
            status = upstreamServer.getStatus();
        }
        return upstreamServer.getServer() + ":" + upstreamServer.getPort() + " weight=" + upstreamServer.getWeight() + " fail_timeout=" + upstreamServer.getFailTimeout() + "s max_fails=" + upstreamServer.getMaxFails() + " " + status;
    }

    private void setSameParam(Param param, NgxBlock ngxBlock) {
        if (StrUtil.isEmpty((CharSequence)param.getTemplateValue())) {
            NgxParam ngxParam = new NgxParam();
            ngxParam.addValue(param.getName().trim() + " " + param.getValue().trim());
            ngxBlock.addEntry((NgxEntry)ngxParam);
        } else {
            List params = this.templateService.getParamList(param.getTemplateValue());
            for (Param paramSub : params) {
                NgxParam ngxParam = new NgxParam();
                ngxParam.addValue(paramSub.getName().trim() + " " + paramSub.getValue().trim());
                ngxBlock.addEntry((NgxEntry)ngxParam);
            }
        }
    }

    private void addConfFile(ConfExt confExt, String name, NgxBlock ngxBlockServer) {
        boolean hasSameName = false;
        for (ConfFile confFile : confExt.getFileList()) {
            if (!confFile.getName().equals(name)) continue;
            confFile.setConf(confFile.getConf() + "\n" + this.buildStr(ngxBlockServer));
            hasSameName = true;
        }
        if (!hasSameName) {
            ConfFile confFile = new ConfFile();
            confFile.setName(name);
            confFile.setConf(this.buildStr(ngxBlockServer));
            confExt.getFileList().add(confFile);
        }
    }

    private String buildStr(NgxBlock ngxBlockServer) {
        NgxConfig ngxConfig = new NgxConfig();
        ngxConfig.addEntry((NgxEntry)ngxBlockServer);
        return new NgxDumper(ngxConfig).dump().replace("};", "  }");
    }

    public void replace(String nginxPath, String nginxContent, List<String> subContent, List<String> subName) {
        String date = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd_HH-mm-ss");
        FileUtil.mkdir((String)(InitConfig.home + "bak"));
        FileUtil.copy((String)nginxPath, (String)(InitConfig.home + "bak/nginx.conf." + date + ".bak"), (boolean)true);
        String confd = nginxPath.replace("nginx.conf", "conf.d/");
        if (!FileUtil.exist((String)confd)) {
            FileUtil.mkdir((String)confd);
        }
        ZipUtil.zip((String)confd, (String)(InitConfig.home + "bak/nginx.conf." + date + ".zip"));
        FileUtil.del((String)confd);
        FileUtil.mkdir((String)confd);
        FileUtil.writeString((String)nginxContent, (String)nginxPath, (Charset)StandardCharsets.UTF_8);
        String decompose = this.settingService.get("decompose");
        if ("true".equals(decompose) && subContent != null) {
            for (int i = 0; i < subContent.size(); ++i) {
                String tagert = nginxPath.replace("nginx.conf", "conf.d/" + subName.get(i));
                FileUtil.writeString((String)subContent.get(i), (String)tagert, (Charset)StandardCharsets.UTF_8);
            }
        }
    }

    public AsycPack getAsycPack() {
        AsycPack asycPack = new AsycPack();
        asycPack.setHttpList(this.sqlHelper.findAll(Http.class));
        List serverList = this.sqlHelper.findAll(Server.class);
        for (Server server : serverList) {
            if (StrUtil.isNotEmpty((CharSequence)server.getPem()) && FileUtil.exist((String)server.getPem())) {
                server.setPemStr(FileUtil.readString((String)server.getPem(), (Charset)StandardCharsets.UTF_8));
            }
            if (!StrUtil.isNotEmpty((CharSequence)server.getKey()) || !FileUtil.exist((String)server.getKey())) continue;
            server.setKeyStr(FileUtil.readString((String)server.getKey(), (Charset)StandardCharsets.UTF_8));
        }
        asycPack.setServerList(serverList);
        asycPack.setLocationList(this.sqlHelper.findAll(Location.class));
        asycPack.setUpstreamList(this.sqlHelper.findAll(Upstream.class));
        asycPack.setUpstreamServerList(this.sqlHelper.findAll(UpstreamServer.class));
        asycPack.setStreamList(this.sqlHelper.findAll(Stream.class));
        asycPack.setParamList(this.sqlHelper.findAll(Param.class));
        String nginxPath = this.settingService.get("nginxPath");
        String decompose = this.settingService.get("decompose");
        ConfExt confExt = this.buildConf(Boolean.valueOf(StrUtil.isNotEmpty((CharSequence)decompose) && decompose.equals("true")));
        if (FileUtil.exist((String)nginxPath)) {
            String orgStr = FileUtil.readString((String)nginxPath, (Charset)StandardCharsets.UTF_8);
            confExt.setConf(orgStr);
            for (ConfFile confFile : confExt.getFileList()) {
                confFile.setConf("");
                String filePath = nginxPath.replace("nginx.conf", "conf.d/" + confFile.getName());
                if (!FileUtil.exist((String)filePath)) continue;
                confFile.setConf(FileUtil.readString((String)filePath, (Charset)StandardCharsets.UTF_8));
            }
        }
        asycPack.setDecompose(decompose);
        asycPack.setConfExt(confExt);
        return asycPack;
    }

    @Transactional
    public void setAsycPack(AsycPack asycPack) {
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper(), Http.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper(), Server.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper(), Location.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper(), Upstream.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper(), UpstreamServer.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper(), Stream.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper(), Param.class);
        this.sqlHelper.insertAll(asycPack.getHttpList());
        this.sqlHelper.insertAll(asycPack.getServerList());
        this.sqlHelper.insertAll(asycPack.getLocationList());
        this.sqlHelper.insertAll(asycPack.getUpstreamList());
        this.sqlHelper.insertAll(asycPack.getUpstreamServerList());
        this.sqlHelper.insertAll(asycPack.getStreamList());
        this.sqlHelper.insertAll(asycPack.getParamList());
        for (Server server : asycPack.getServerList()) {
            if (StrUtil.isNotEmpty((CharSequence)server.getPem()) && StrUtil.isNotEmpty((CharSequence)server.getPemStr())) {
                FileUtil.writeString((String)server.getPemStr(), (String)server.getPem(), (Charset)StandardCharsets.UTF_8);
            }
            if (!StrUtil.isNotEmpty((CharSequence)server.getKey()) || !StrUtil.isNotEmpty((CharSequence)server.getKeyStr())) continue;
            FileUtil.writeString((String)server.getKeyStr(), (String)server.getKey(), (Charset)StandardCharsets.UTF_8);
        }
        this.settingService.set("decompose", asycPack.getDecompose());
        ConfExt confExt = asycPack.getConfExt();
        String nginxPath = this.settingService.get("nginxPath");
        if (FileUtil.exist((String)nginxPath)) {
            ArrayList<String> subContent = new ArrayList<String>();
            ArrayList<String> subName = new ArrayList<String>();
            for (ConfFile confFile : confExt.getFileList()) {
                subContent.add(confFile.getConf());
                subName.add(confFile.getName());
            }
            this.replace(nginxPath, confExt.getConf(), subContent, subName);
        }
    }
}

