/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.craccd.sqlHelper.bean.Page;
import cn.craccd.sqlHelper.utils.ConditionAndWrapper;
import cn.craccd.sqlHelper.utils.ConditionWrapper;
import cn.craccd.sqlHelper.utils.SqlHelper;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.json.JSONUtil;
import com.cym.ext.DataGroup;
import com.cym.ext.KeyValue;
import com.cym.model.Log;
import com.cym.model.LogInfo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogService {
    @Autowired
    SqlHelper sqlHelper;
    @Autowired
    JdbcTemplate jdbcTemplate;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    public DataGroup buildDataGroup(String path) {
        if (!new File(path).exists()) {
            return null;
        }
        this.insertIntoDb(path);
        DataGroup dataGroup = new DataGroup();
        dataGroup.setPv(this.jdbcTemplate.query("select hour as name,count(1) as value FROM log_info group by hour order by name", (RowMapper)new BeanPropertyRowMapper(KeyValue.class)));
        dataGroup.setUv(this.jdbcTemplate.query("SELECT name, COUNT(value) as value FROM ( \tSELECT hour AS name, COUNT(remote_addr) AS value \tFROM log_info \tGROUP BY hour, remote_addr \tORDER BY name ) GROUP BY name", (RowMapper)new BeanPropertyRowMapper(KeyValue.class)));
        dataGroup.setStatus(this.jdbcTemplate.query("select status as name,count(1) as value FROM log_info group by status", (RowMapper)new BeanPropertyRowMapper(KeyValue.class)));
        dataGroup.setBrowser(new ArrayList());
        String[] browsers = new String[]{"Android", "iPhone", "Windows", "Macintosh"};
        Integer allCount = 0;
        for (String browser : browsers) {
            KeyValue keyValue = new KeyValue();
            keyValue.setName(browser);
            keyValue.setValue((Integer)this.jdbcTemplate.queryForObject("select count(1) from log_info where http_user_agent like '%" + browser + "%'", Integer.class));
            dataGroup.getBrowser().add(keyValue);
            allCount = allCount + keyValue.getValue();
        }
        KeyValue keyValue = new KeyValue();
        keyValue.setName("Other");
        keyValue.setValue(Integer.valueOf(this.sqlHelper.findCountByQuery(null, LogInfo.class).intValue() - allCount));
        dataGroup.getBrowser().add(keyValue);
        List httpReferer = this.jdbcTemplate.query("select http_host as name,count(1) as value FROM log_info group by http_host order by value DESC limit 10", (RowMapper)new BeanPropertyRowMapper(KeyValue.class));
        Collections.reverse(httpReferer);
        dataGroup.setHttpReferer(httpReferer);
        this.saveLog(dataGroup, path);
        return dataGroup;
    }

    public void clearDb() {
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper(), LogInfo.class);
        this.jdbcTemplate.execute("vacuum;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoDb(String path) {
        block8: {
            BufferedReader reader = null;
            try {
                File zipFile = new File(path);
                File outFile = new File(path.replace(".zip", "") + File.separator + zipFile.getName().replace(".zip", ".log"));
                ZipUtil.unzip((File)zipFile);
                this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper(), LogInfo.class);
                Long count = 0L;
                reader = FileUtil.getReader((File)outFile, (String)"UTF-8");
                ArrayList<LogInfo> list = new ArrayList<LogInfo>();
                while (true) {
                    String json;
                    if (StrUtil.isEmpty((CharSequence)(json = reader.readLine()))) break;
                    if (JSONUtil.isJson((String)(json = json.replace("\\x", "")))) {
                        LogInfo logInfo = (LogInfo)JSONUtil.toBean((String)json, LogInfo.class);
                        String[] str = logInfo.getTimeLocal().split(":");
                        logInfo.setHour(str[1]);
                        logInfo.setMinute(str[2]);
                        logInfo.setSecond(str[3].split(" ")[0]);
                        list.add(logInfo);
                    } else {
                        System.err.println(json);
                    }
                    if (list.size() != 1000) continue;
                    this.sqlHelper.insertAll(list);
                    count = count + (long)list.size();
                    list.clear();
                }
                this.sqlHelper.insertAll(list);
                count = count + (long)list.size();
                list.clear();
                this.logger.info("\u63d2\u5165LogInfo:" + count + "\u6761");
                IoUtil.close((Closeable)reader);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                IoUtil.close(reader);
                FileUtil.del((String)(path.replace(".zip", "") + File.separator));
            }
            FileUtil.del((String)(path.replace(".zip", "") + File.separator));
        }
    }

    private void saveLog(DataGroup dataGroup, String path) {
        Log log = new Log();
        File file = new File(path);
        log.setDate(file.getName().replace("access.", "").replace(".zip", ""));
        log.setJson(JSONUtil.toJsonStr((Object)dataGroup));
        log.setPath(path);
        Log logOrg = (Log)this.sqlHelper.findOneByQuery((ConditionWrapper)new ConditionAndWrapper().eq("date", (Object)log.getDate()), Log.class);
        if (logOrg != null) {
            DataGroup dataGroupOrg = (DataGroup)JSONUtil.toBean((String)logOrg.getJson(), DataGroup.class);
            this.sum(dataGroupOrg, dataGroup);
            logOrg.setJson(JSONUtil.toJsonStr((Object)dataGroupOrg));
            this.sqlHelper.updateById((Object)logOrg);
        } else {
            this.sqlHelper.insert((Object)log);
        }
    }

    private void sum(DataGroup dataGroupOrg, DataGroup dataGroup) {
        this.addSum(dataGroupOrg.getPv(), dataGroup.getPv());
        this.addSum(dataGroupOrg.getUv(), dataGroup.getUv());
        this.addSum(dataGroupOrg.getStatus(), dataGroup.getStatus());
        this.addSum(dataGroupOrg.getBrowser(), dataGroup.getBrowser());
        this.addSum(dataGroupOrg.getHttpReferer(), dataGroup.getHttpReferer());
    }

    private void addSum(List<KeyValue> keyValuesOrg, List<KeyValue> keyValues) {
        for (KeyValue keyValue : keyValues) {
            boolean hasSame = false;
            for (KeyValue keyValueOrg : keyValuesOrg) {
                if (!keyValueOrg.getName().equals(keyValue.getName())) continue;
                keyValueOrg.setValue(Integer.valueOf(keyValueOrg.getValue() + keyValue.getValue()));
                hasSame = true;
            }
            if (hasSame) continue;
            keyValuesOrg.add(keyValue);
        }
    }

    public Page search(Page page) {
        page = this.sqlHelper.findPage(page, Log.class);
        return page;
    }
}

