/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import com.cym.model.MonitorInfo;
import com.cym.utils.SystemTool;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class MonitorService {
    OperatingSystemMXBean osmxb;
    Double gb = 1.073741824E9;

    @PostConstruct
    private void init() {
        this.osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    public MonitorInfo getMonitorInfo() {
        Double totalMemorySize = (double)this.osmxb.getTotalPhysicalMemorySize() / this.gb;
        Long freePhysicalMemorySize = 0L;
        freePhysicalMemorySize = SystemTool.isWindows() != false ? Long.valueOf(this.osmxb.getFreePhysicalMemorySize()) : this.getLinuxFreeMem();
        Double usedMemory = (double)(this.osmxb.getTotalPhysicalMemorySize() - freePhysicalMemorySize) / this.gb;
        Double mem = usedMemory / totalMemorySize;
        Double cpu = this.osmxb.getSystemCpuLoad();
        MonitorInfo infoBean = new MonitorInfo();
        infoBean.setFreePhysicalMemorySize(NumberUtil.decimalFormat((String)"0.00GB", (Object)freePhysicalMemorySize));
        infoBean.setTotalMemorySize(NumberUtil.decimalFormat((String)"0.00GB", (Object)totalMemorySize));
        infoBean.setUsedMemory(NumberUtil.decimalFormat((String)"0.00GB", (Object)usedMemory));
        infoBean.setCpuRatio(NumberUtil.decimalFormat((String)"#.##%", (Object)cpu));
        infoBean.setMemRatio(NumberUtil.decimalFormat((String)"#.##%", (Object)mem));
        infoBean.setCpuCount(Integer.valueOf(this.osmxb.getAvailableProcessors()));
        return infoBean;
    }

    private Long getLinuxFreeMem() {
        try {
            String line = RuntimeUtil.execForStr((String[])new String[]{"cat /proc/meminfo"});
            if (StrUtil.isNotEmpty((CharSequence)line)) {
                String[] lines;
                for (String rs : lines = line.split("\n")) {
                    if (!rs.contains("MemAvailable")) continue;
                    return Long.parseLong(rs.replace("MemAvailable:", "").replace("kB", "").trim()) * 1024L;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.osmxb.getFreePhysicalMemorySize();
    }
}

