/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.craccd.sqlHelper.bean.Page;
import cn.craccd.sqlHelper.bean.Sort;
import cn.craccd.sqlHelper.utils.ConditionAndWrapper;
import cn.craccd.sqlHelper.utils.ConditionOrWrapper;
import cn.craccd.sqlHelper.utils.ConditionWrapper;
import cn.craccd.sqlHelper.utils.SqlHelper;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.cym.model.Location;
import com.cym.model.Param;
import com.cym.model.Server;
import com.github.odiszapc.nginxparser.NgxBlock;
import com.github.odiszapc.nginxparser.NgxConfig;
import com.github.odiszapc.nginxparser.NgxEntry;
import com.github.odiszapc.nginxparser.NgxParam;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServerService {
    private static final Logger log = LoggerFactory.getLogger(ServerService.class);
    @Autowired
    SqlHelper sqlHelper;

    public Page search(Page page, String sortColum, String direction, String keywords) {
        ConditionAndWrapper conditionAndWrapper = new ConditionAndWrapper();
        if (StrUtil.isNotEmpty((CharSequence)keywords)) {
            conditionAndWrapper.and((ConditionWrapper)new ConditionOrWrapper().like("descr", keywords).like("serverName", keywords.trim()).like("listen", keywords.trim()));
        }
        Sort sort = null;
        if (StrUtil.isNotEmpty((CharSequence)sortColum)) {
            sort = new Sort(sortColum, "asc".equalsIgnoreCase(direction) ? Sort.Direction.ASC : Sort.Direction.DESC);
        }
        page = this.sqlHelper.findPage((ConditionWrapper)conditionAndWrapper, sort, page, Server.class);
        return page;
    }

    @Transactional
    public void deleteById(String id) {
        this.sqlHelper.deleteById(id, Server.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("serverId", (Object)id), Location.class);
    }

    public List<Location> getLocationByServerId(String serverId) {
        return this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().eq("serverId", (Object)serverId), Location.class);
    }

    @Transactional
    public void addOver(Server server, String serverParamJson, List<Location> locations) throws Exception {
        if (server.getDef() == 1) {
            this.clearDef();
        }
        this.sqlHelper.insertOrUpdate((Object)server);
        List paramList = new ArrayList();
        if (StrUtil.isNotEmpty((CharSequence)serverParamJson) && JSONUtil.isJson((String)serverParamJson)) {
            paramList = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)serverParamJson), Param.class);
        }
        List locationIds = this.sqlHelper.findIdsByQuery((ConditionWrapper)new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionOrWrapper().eq("serverId", (Object)server.getId()).in("locationId", (Collection)locationIds), Param.class);
        Collections.reverse(paramList);
        for (Param param : paramList) {
            param.setServerId(server.getId());
            this.sqlHelper.insert((Object)param);
        }
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
        if (locations != null) {
            Collections.reverse(locations);
            for (Location location : locations) {
                location.setServerId(server.getId());
                this.sqlHelper.insert((Object)location);
                paramList = new ArrayList();
                if (StrUtil.isNotEmpty((CharSequence)location.getLocationParamJson()) && JSONUtil.isJson((String)location.getLocationParamJson())) {
                    paramList = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)location.getLocationParamJson()), Param.class);
                }
                Collections.reverse(paramList);
                for (Param param : paramList) {
                    param.setLocationId(location.getId());
                    this.sqlHelper.insert((Object)param);
                }
            }
        }
    }

    private void clearDef() {
        List servers = this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().eq("def", (Object)1), Server.class);
        for (Server server : servers) {
            server.setDef(Integer.valueOf(0));
            this.sqlHelper.updateById((Object)server);
        }
    }

    @Transactional
    public void addOverTcp(Server server, String serverParamJson) {
        this.sqlHelper.insertOrUpdate((Object)server);
        List locationIds = this.sqlHelper.findIdsByQuery((ConditionWrapper)new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionOrWrapper().eq("serverId", (Object)server.getId()).in("locationId", (Collection)locationIds), Param.class);
        List paramList = new ArrayList();
        if (StrUtil.isNotEmpty((CharSequence)serverParamJson) && JSONUtil.isJson((String)serverParamJson)) {
            paramList = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)serverParamJson), Param.class);
        }
        for (Param param : paramList) {
            param.setServerId(server.getId());
            this.sqlHelper.insert((Object)param);
        }
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
    }

    public List<Server> getListByProxyType(Integer proxyType) {
        return this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().eq("proxyType", (Object)proxyType), Server.class);
    }

    @Transactional
    public void clone(String id) {
        Server server = (Server)this.sqlHelper.findById(id, Server.class);
        List locations = this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Location.class);
        List params = this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().eq("serverId", (Object)server.getId()), Param.class);
        server.setId(null);
        this.sqlHelper.insertOrUpdate((Object)server);
        for (Param param : params) {
            param.setId(null);
            param.setServerId(server.getId());
            this.sqlHelper.insert((Object)param);
        }
        for (Location location : locations) {
            params = this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().eq("locationId", (Object)location.getId()), Param.class);
            location.setId(null);
            location.setServerId(server.getId());
            this.sqlHelper.insert((Object)location);
            for (Param param : params) {
                param.setId(null);
                param.setLocationId(location.getId());
                this.sqlHelper.insert((Object)param);
            }
        }
    }

    public void importServer(String nginxPath) throws Exception {
        String initNginxPath = this.initNginx(nginxPath);
        NgxConfig conf = null;
        try {
            conf = NgxConfig.read((String)initNginxPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
        List servers = conf.findAll(NgxConfig.BLOCK, new String[]{"server"});
        servers.addAll(conf.findAll(NgxConfig.BLOCK, new String[]{"http", "server"}));
        Collections.reverse(servers);
        for (NgxEntry ngxEntry : servers) {
            NgxBlock serverNgx = (NgxBlock)ngxEntry;
            NgxParam serverName = serverNgx.findParam(new String[]{"server_name"});
            Server server = new Server();
            if (serverName == null) {
                server.setServerName("");
            } else {
                server.setServerName(serverName.getValue());
            }
            server.setProxyType(Integer.valueOf(0));
            List listens = serverNgx.findAll(NgxConfig.PARAM, new String[]{"listen"});
            for (NgxEntry item3 : listens) {
                NgxParam param = (NgxParam)item3;
                if (server.getListen() == null) {
                    server.setListen((String)param.getValues().toArray()[0]);
                }
                if (param.getTokens().stream().anyMatch(item2 -> "ssl".equals(item2.getToken()))) {
                    server.setSsl(Integer.valueOf(1));
                    NgxParam key = serverNgx.findParam(new String[]{"ssl_certificate_key"});
                    NgxParam perm = serverNgx.findParam(new String[]{"ssl_certificate"});
                    server.setKey(key == null ? "" : key.getValue());
                    server.setPem(perm == null ? "" : perm.getValue());
                }
                if (!param.getTokens().stream().anyMatch(item2 -> "http2".equals(item2.getToken()))) continue;
                server.setHttp2(Integer.valueOf(1));
            }
            long rewriteCount = serverNgx.getEntries().stream().filter(item -> {
                if (item instanceof NgxBlock) {
                    NgxBlock itemNgx = (NgxBlock)item;
                    return itemNgx.getEntries().toString().contains("rewrite");
                }
                return false;
            }).count();
            if (rewriteCount > 0L) {
                server.setRewrite(Integer.valueOf(1));
            } else {
                server.setRewrite(Integer.valueOf(0));
            }
            ArrayList<Location> locations = new ArrayList<Location>();
            List locationBlocks = serverNgx.findAll(NgxBlock.class, new String[]{"location"});
            for (NgxEntry item4 : locationBlocks) {
                Location location = new Location();
                NgxParam proxyPassParam = ((NgxBlock)item4).findParam(new String[]{"proxy_pass"});
                location.setPath(((NgxBlock)item4).getValue());
                if (proxyPassParam != null) {
                    location.setValue(proxyPassParam.getValue());
                    location.setType(Integer.valueOf(0));
                } else {
                    NgxParam rootParam = ((NgxBlock)item4).findParam(new String[]{"root"});
                    if (rootParam == null) {
                        rootParam = ((NgxBlock)item4).findParam(new String[]{"alias"});
                    }
                    if (rootParam == null) continue;
                    location.setRootType(rootParam.getName());
                    location.setRootPath(rootParam.getValue());
                    NgxParam indexParam = ((NgxBlock)item4).findParam(new String[]{"index"});
                    if (indexParam != null) {
                        location.setRootPage(indexParam.getValue());
                    }
                    location.setType(Integer.valueOf(1));
                }
                location.setLocationParamJson(null);
                locations.add(location);
            }
            this.addOver(server, "", locations);
        }
        FileUtil.del((String)initNginxPath);
    }

    private String initNginx(String nginxPath) {
        List lines = FileUtil.readLines((String)nginxPath, (Charset)CharsetUtil.CHARSET_UTF_8);
        ArrayList<String> rs = new ArrayList<String>();
        for (String str : lines) {
            if (str.trim().indexOf("#") == 0) continue;
            rs.add(str);
        }
        String initNginxPath = FileUtil.getTmpDirPath() + UUID.randomUUID().toString();
        FileUtil.writeLines(rs, (String)initNginxPath, (Charset)CharsetUtil.CHARSET_UTF_8);
        return initNginxPath;
    }
}

