/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.craccd.sqlHelper.utils.ConditionAndWrapper;
import cn.craccd.sqlHelper.utils.ConditionWrapper;
import cn.craccd.sqlHelper.utils.SqlHelper;
import com.cym.model.Param;
import com.cym.model.Template;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateService {
    @Autowired
    SqlHelper sqlHelper;

    @Transactional
    public void addOver(Template template, List<Param> params) {
        this.sqlHelper.insertOrUpdate((Object)template);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("templateId", (Object)template.getId()), Param.class);
        Collections.reverse(params);
        for (Param param : params) {
            param.setTemplateId(template.getId());
            this.sqlHelper.insertOrUpdate((Object)param);
        }
    }

    public List<Param> getParamList(String templateId) {
        return this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().eq("templateId", (Object)templateId), Param.class);
    }

    @Transactional
    public void del(String id) {
        this.sqlHelper.deleteById(id, Template.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("templateId", (Object)id), Param.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("templateValue", (Object)id), Param.class);
    }

    public Long getCountByName(String name) {
        return this.sqlHelper.findCountByQuery((ConditionWrapper)new ConditionAndWrapper().eq("name", (Object)name), Template.class);
    }

    public Long getCountByNameWithOutId(String name, String id) {
        return this.sqlHelper.findCountByQuery((ConditionWrapper)new ConditionAndWrapper().eq("name", (Object)name).ne("id", (Object)id), Template.class);
    }
}

