/*
 * Decompiled with CFR 0.152.
 */
package com.cym.service;

import cn.craccd.sqlHelper.bean.Page;
import cn.craccd.sqlHelper.bean.Sort;
import cn.craccd.sqlHelper.utils.ConditionAndWrapper;
import cn.craccd.sqlHelper.utils.ConditionOrWrapper;
import cn.craccd.sqlHelper.utils.ConditionWrapper;
import cn.craccd.sqlHelper.utils.SqlHelper;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.cym.model.Param;
import com.cym.model.Upstream;
import com.cym.model.UpstreamServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpstreamService {
    @Autowired
    SqlHelper sqlHelper;

    public Page search(Page page, String word) {
        ConditionAndWrapper conditionAndWrapper = new ConditionAndWrapper();
        if (StrUtil.isNotEmpty((CharSequence)word)) {
            conditionAndWrapper.and((ConditionWrapper)new ConditionOrWrapper().like("name", word));
        }
        page = this.sqlHelper.findPage((ConditionWrapper)conditionAndWrapper, new Sort("id", Sort.Direction.DESC), page, Upstream.class);
        return page;
    }

    @Transactional
    public void deleteById(String id) {
        this.sqlHelper.deleteById(id, Upstream.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("upstreamId", (Object)id), UpstreamServer.class);
    }

    @Transactional
    public void addOver(Upstream upstream, List<UpstreamServer> upstreamServers, String upstreamParamJson) {
        if (upstream.getProxyType() == 1 || upstream.getTactics() == null) {
            upstream.setTactics("");
        }
        this.sqlHelper.insertOrUpdate((Object)upstream);
        List paramList = new ArrayList();
        if (StrUtil.isNotEmpty((CharSequence)upstreamParamJson) && JSONUtil.isJson((String)upstreamParamJson)) {
            paramList = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)upstreamParamJson), Param.class);
        }
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("upstreamId", (Object)upstream.getId()), Param.class);
        Collections.reverse(paramList);
        for (Param param : paramList) {
            param.setUpstreamId(upstream.getId());
            this.sqlHelper.insert((Object)param);
        }
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("upstreamId", (Object)upstream.getId()), UpstreamServer.class);
        if (upstreamServers != null) {
            Collections.reverse(upstreamServers);
            for (UpstreamServer upstreamServer : upstreamServers) {
                upstreamServer.setUpstreamId(upstream.getId());
                this.sqlHelper.insert((Object)upstreamServer);
            }
        }
    }

    public List<UpstreamServer> getUpstreamServers(String id) {
        return this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().eq("upstreamId", (Object)id), UpstreamServer.class);
    }

    @Transactional
    public void del(String id) {
        this.sqlHelper.deleteById(id, Upstream.class);
        this.sqlHelper.deleteByQuery((ConditionWrapper)new ConditionAndWrapper().eq("upstreamId", (Object)id), UpstreamServer.class);
    }

    public List<Upstream> getListByProxyType(Integer proxyType) {
        return this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().eq("proxyType", (Object)proxyType), Upstream.class);
    }

    public Long getCountByName(String name) {
        return this.sqlHelper.findCountByQuery((ConditionWrapper)new ConditionAndWrapper().eq("name", (Object)name), Upstream.class);
    }

    public Long getCountByNameWithOutId(String name, String id) {
        return this.sqlHelper.findCountByQuery((ConditionWrapper)new ConditionAndWrapper().eq("name", (Object)name).ne("id", (Object)id), Upstream.class);
    }

    public List<UpstreamServer> getServerListByMonitor(int monitor) {
        List upstreamIds = this.sqlHelper.findIdsByQuery((ConditionWrapper)new ConditionAndWrapper().eq("monitor", (Object)monitor), Upstream.class);
        return this.sqlHelper.findListByQuery((ConditionWrapper)new ConditionAndWrapper().in("upstreamId", (Collection)upstreamIds), UpstreamServer.class);
    }

    public List<UpstreamServer> getAllServer() {
        return this.sqlHelper.findAll(UpstreamServer.class);
    }
}

