/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.sqlHelper.config;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.io.InputStream;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
public class DataSourceConfig {
    @Value(value="${spring.datasource.url:}")
    String url;
    @Value(value="${spring.datasource.username:}")
    String username;
    @Value(value="${spring.datasource.password:}")
    String password;
    @Value(value="${spring.database.type}")
    String database;
    @Value(value="${spring.database.sqlite-path:}")
    String sqlitePath;

    @Bean
    public DataSource dataSource() throws Exception {
        HikariDataSource dataSource = new HikariDataSource();
        if (this.database.toLowerCase().equals("mysql")) {
            dataSource.setJdbcUrl(this.url);
            dataSource.setUsername(this.username);
            dataSource.setPassword(this.password);
            dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        } else if (this.database.toLowerCase().equals("postgresql")) {
            dataSource.setJdbcUrl(this.url);
            dataSource.setUsername(this.username);
            dataSource.setPassword(this.password);
            dataSource.setDriverClassName("org.postgresql.Driver");
        } else if (this.database.toLowerCase().equals("sqlite")) {
            if (StrUtil.isEmpty((CharSequence)this.sqlitePath)) {
                this.sqlitePath = FileUtil.getUserHomePath() + File.separator + "sqlite.db";
            }
            if (!FileUtil.exist((String)this.sqlitePath)) {
                ClassPathResource resource = new ClassPathResource("sqlite.db");
                InputStream inputStream = resource.getInputStream();
                FileUtil.writeFromStream((InputStream)inputStream, (String)this.sqlitePath);
                System.out.println("release:" + this.sqlitePath);
            }
            dataSource.setJdbcUrl("jdbc:sqlite:" + this.sqlitePath);
            dataSource.setDriverClassName("org.sqlite.JDBC");
            dataSource.setMaximumPoolSize(1);
        } else {
            throw new Exception("\u6570\u636e\u5e93\u7c7b\u578b\u914d\u7f6e\u9519\u8bef");
        }
        return dataSource;
    }
}

