/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.sqlHelper.utils;

import cn.craccd.sqlHelper.bean.Page;
import cn.craccd.sqlHelper.bean.Sort;
import cn.craccd.sqlHelper.bean.Update;
import cn.craccd.sqlHelper.config.InitValue;
import cn.craccd.sqlHelper.reflection.ReflectionUtil;
import cn.craccd.sqlHelper.reflection.SerializableFunction;
import cn.craccd.sqlHelper.utils.AsyncUtils;
import cn.craccd.sqlHelper.utils.ConditionAndWrapper;
import cn.craccd.sqlHelper.utils.ConditionWrapper;
import cn.craccd.sqlHelper.utils.SnowFlake;
import cn.craccd.sqlHelper.utils.SqlUtils;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class SqlHelper
extends SqlUtils {
    @Value(value="${spring.database.type}")
    String database;
    @Value(value="${spring.database.package}")
    String packageName;
    @Value(value="${spring.database.print:false}")
    Boolean print;
    @Autowired
    JdbcTemplate jdbcTemplate;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    SnowFlake snowFlake = new SnowFlake(1L, 1L);
    @Autowired
    AsyncUtils asyncUtils;

    @PostConstruct
    private void scan() {
        if (StrUtil.isEmpty((CharSequence)this.packageName)) {
            return;
        }
        Set set = ClassUtil.scanPackage((String)this.packageName);
        for (Class clazz : set) {
            if (this.database.equals("sqlite")) {
                this.asyncUtils.initTableSync(clazz);
                continue;
            }
            this.asyncUtils.initTable(clazz);
        }
    }

    public String insertOrUpdate(Object object) {
        Long time = System.currentTimeMillis();
        String id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
        Object objectOrg = StrUtil.isNotEmpty((CharSequence)id) ? this.findById(id, object.getClass()) : null;
        try {
            if (objectOrg == null) {
                Field[] fields;
                if (ReflectUtil.getField(object.getClass(), (String)"createTime") != null) {
                    ReflectUtil.setFieldValue((Object)object, (String)"createTime", (Object)time);
                }
                if (ReflectUtil.getField(object.getClass(), (String)"updateTime") != null) {
                    ReflectUtil.setFieldValue((Object)object, (String)"updateTime", (Object)time);
                }
                this.setDefaultVaule(object);
                ReflectUtil.setFieldValue((Object)object, (String)"id", (Object)this.snowFlake.nextId());
                String sql = "";
                ArrayList<String> fieldsPart = new ArrayList<String>();
                ArrayList<String> placeHolder = new ArrayList<String>();
                ArrayList<Object> paramValues = new ArrayList<Object>();
                for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
                    fieldsPart.add("`" + StrUtil.toUnderlineCase((CharSequence)field.getName()) + "`");
                    placeHolder.add("?");
                    paramValues.add(ReflectUtil.getFieldValue((Object)object, (Field)field));
                }
                sql = "INSERT INTO `" + StrUtil.toUnderlineCase((CharSequence)object.getClass().getSimpleName()) + "` (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{fieldsPart}) + ") VALUES (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{placeHolder}) + ")";
                this.logQuery(this.formatSql(sql), paramValues.toArray());
                this.jdbcTemplate.update(this.formatSql(sql), paramValues.toArray());
            } else {
                Field[] fields = ReflectUtil.getFields(object.getClass());
                if (ReflectUtil.getField(object.getClass(), (String)"updateTime") != null) {
                    ReflectUtil.setFieldValue((Object)object, (String)"updateTime", (Object)time);
                }
                ArrayList<String> fieldsPart = new ArrayList<String>();
                ArrayList<Object> paramValues = new ArrayList<Object>();
                for (Field field : fields) {
                    if (field.getName().equals("id") || ReflectUtil.getFieldValue((Object)object, (Field)field) == null) continue;
                    fieldsPart.add("`" + StrUtil.toUnderlineCase((CharSequence)field.getName()) + "`=?");
                    paramValues.add(ReflectUtil.getFieldValue((Object)object, (Field)field));
                }
                paramValues.add(id);
                String sql = "UPDATE `" + StrUtil.toUnderlineCase((CharSequence)object.getClass().getSimpleName()) + "` SET " + StrUtil.join((CharSequence)",", (Object[])new Object[]{fieldsPart}) + " WHERE id = ?";
                this.logQuery(this.formatSql(sql), paramValues.toArray());
                this.jdbcTemplate.update(this.formatSql(sql), paramValues.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
    }

    public String insert(Object object) {
        Object objectOrg;
        String id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
        Object v0 = objectOrg = StrUtil.isNotEmpty((CharSequence)id) ? this.findById(id, object.getClass()) : null;
        if (objectOrg != null) {
            ReflectUtil.setFieldValue((Object)object, (String)"id", (Object)this.snowFlake.nextId());
        }
        if (ReflectUtil.getFieldValue((Object)object, (String)"id") == null) {
            ReflectUtil.setFieldValue((Object)object, (String)"id", (Object)this.snowFlake.nextId());
        }
        this.insertOrUpdate(object);
        return (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
    }

    public <T> void insertAll(List<T> list) {
        Long time = System.currentTimeMillis();
        HashMap idMap = new HashMap();
        for (T object : list) {
            if (ReflectUtil.getFieldValue(object, (String)"id") == null) continue;
            String id = (String)ReflectUtil.getFieldValue(object, (String)"id");
            Object objectOrg = StrUtil.isNotEmpty((CharSequence)id) ? (Object)this.findById(id, object.getClass()) : null;
            idMap.put((String)ReflectUtil.getFieldValue(object, (String)"id"), objectOrg);
        }
        for (T object : list) {
            if (ReflectUtil.getFieldValue(object, (String)"id") != null && idMap.get((String)ReflectUtil.getFieldValue(object, (String)"id")) != null) {
                ReflectUtil.setFieldValue(object, (String)"id", (Object)this.snowFlake.nextId());
            }
            if (ReflectUtil.getFieldValue(object, (String)"id") == null) {
                ReflectUtil.setFieldValue(object, (String)"id", (Object)this.snowFlake.nextId());
            }
            if (ReflectUtil.getField(object.getClass(), (String)"createTime") != null) {
                ReflectUtil.setFieldValue(object, (String)"createTime", (Object)time);
            }
            if (ReflectUtil.getField(object.getClass(), (String)"updateTime") != null) {
                ReflectUtil.setFieldValue(object, (String)"updateTime", (Object)time);
            }
            this.setDefaultVaule(object);
        }
        ArrayList<Object[]> paramValues = new ArrayList<Object[]>();
        String sqls = null;
        for (T object : list) {
            Field[] fields = ReflectUtil.getFields(object.getClass());
            ArrayList<String> fieldsPart = new ArrayList<String>();
            ArrayList<String> placeHolder = new ArrayList<String>();
            ArrayList<Object> params = new ArrayList<Object>();
            for (Field field : fields) {
                fieldsPart.add("`" + StrUtil.toUnderlineCase((CharSequence)field.getName()) + "`");
                placeHolder.add("?");
                params.add(ReflectUtil.getFieldValue(object, (Field)field));
            }
            paramValues.add(params.toArray());
            if (sqls != null) continue;
            sqls = "INSERT INTO `" + StrUtil.toUnderlineCase((CharSequence)object.getClass().getSimpleName()) + "` (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{fieldsPart}) + ") VALUES (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{placeHolder}) + ")";
        }
        this.jdbcTemplate.batchUpdate(this.formatSql(sqls), paramValues);
    }

    public void updateById(Object object) {
        if (StrUtil.isEmpty((CharSequence)((String)ReflectUtil.getFieldValue((Object)object, (String)"id")))) {
            return;
        }
        this.insertOrUpdate(object);
    }

    public void updateMulti(ConditionWrapper conditionWrapper, Update update, Class<?> clazz) {
        if (update == null || update.getSets().size() == 0) {
            return;
        }
        ArrayList<String> fieldsPart = new ArrayList<String>();
        ArrayList<String> paramValues = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : update.getSets().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            fieldsPart.add("`" + StrUtil.toUnderlineCase((CharSequence)entry.getKey()) + "`=?");
            paramValues.add(entry.getValue().toString());
        }
        String sql = "UPDATE `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "` SET " + StrUtil.join((CharSequence)",", (Object[])new Object[]{fieldsPart});
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(paramValues);
        }
        this.logQuery(this.formatSql(sql), paramValues.toArray());
        this.jdbcTemplate.update(this.formatSql(sql), paramValues.toArray());
    }

    public void addCountById(String id, String property, Long count, Class<?> clazz) {
        String sql = "UPDATE `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "` SET `" + property + "` = CAST(`" + property + "` AS DECIMAL(30,10)) + ? WHERE `id` =  ?";
        Object[] params = new Object[]{count, id};
        this.logQuery(this.formatSql(sql), params);
        this.jdbcTemplate.update(this.formatSql(sql), params);
    }

    public <T, R> void addCountById(String id, SerializableFunction<T, R> property, Long count, Class<?> clazz) {
        this.addCountById(id, ReflectionUtil.getFieldName(property), count, clazz);
    }

    public void updateAllColumnById(Object object) {
        if (StrUtil.isEmpty((CharSequence)((String)ReflectUtil.getFieldValue((Object)object, (String)"id")))) {
            return;
        }
        Field[] fields = ReflectUtil.getFields(object.getClass());
        ArrayList<String> fieldsPart = new ArrayList<String>();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        for (Field field : fields) {
            if (field.getName().equals("id")) continue;
            fieldsPart.add("`" + StrUtil.toUnderlineCase((CharSequence)field.getName()) + "`=?");
            paramValues.add(ReflectUtil.getFieldValue((Object)object, (Field)field));
        }
        paramValues.add((String)ReflectUtil.getFieldValue((Object)object, (String)"id"));
        String sql = "UPDATE `" + StrUtil.toUnderlineCase((CharSequence)object.getClass().getSimpleName()) + "` SET " + StrUtil.join((CharSequence)",", (Object[])new Object[]{fieldsPart}) + " WHERE id = ?";
        this.logQuery(this.formatSql(sql), paramValues.toArray());
        this.jdbcTemplate.update(this.formatSql(sql), paramValues.toArray());
    }

    public void deleteById(String id, Class<?> clazz) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return;
        }
        this.deleteByQuery(new ConditionAndWrapper().eq("id", (Object)id), clazz);
    }

    public void deleteByIds(Collection<String> ids, Class<?> clazz) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.deleteByQuery(new ConditionAndWrapper().in("id", (Collection)ids), clazz);
    }

    public void deleteByIds(String[] ids, Class<?> clazz) {
        this.deleteByIds(Arrays.asList(ids), clazz);
    }

    public void deleteByQuery(ConditionWrapper conditionWrapper, Class<?> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        String sql = "DELETE FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        this.logQuery(this.formatSql(sql), values.toArray());
        this.jdbcTemplate.update(this.formatSql(sql), values.toArray());
    }

    private void setDefaultVaule(Object object) {
        Field[] fields;
        for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
            if (!field.isAnnotationPresent(InitValue.class)) continue;
            InitValue defaultValue = field.getAnnotation(InitValue.class);
            String value = defaultValue.value();
            if (ReflectUtil.getFieldValue((Object)object, (Field)field) != null) continue;
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)value);
            }
            if (type.equals(Short.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Short.parseShort(value));
            }
            if (type.equals(Integer.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Integer.parseInt(value));
            }
            if (type.equals(Long.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Long.parseLong(value));
            }
            if (type.equals(Float.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Float.valueOf(Float.parseFloat(value)));
            }
            if (type.equals(Double.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Double.parseDouble(value));
            }
            if (!type.equals(Boolean.class)) continue;
            ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Boolean.parseBoolean(value));
        }
    }

    public Page findPage(ConditionWrapper conditionWrapper, Sort sort, Page page, Class<?> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        Long count = this.findCountByQuery(conditionWrapper, clazz);
        String sql = "SELECT * FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        sql = sort != null ? sql + " " + sort.toString() : sql + " ORDER BY id DESC";
        sql = this.database.equalsIgnoreCase("mysql") || this.database.equalsIgnoreCase("sqlite") ? sql + " LIMIT " + (page.getCurr() - 1) * page.getLimit() + "," + page.getLimit() : sql + " LIMIT " + page.getLimit() + " OFFSET " + (page.getCurr() - 1) * page.getLimit();
        page.setCount(count);
        this.logQuery(this.formatSql(sql), values.toArray());
        page.setRecords(this.buildObjects(this.jdbcTemplate.queryForList(this.formatSql(sql), values.toArray()), clazz));
        return page;
    }

    public Page findPage(Sort sort, Page page, Class<?> clazz) {
        return this.findPage(null, sort, page, clazz);
    }

    public Page findPage(ConditionWrapper conditionWrapper, Page page, Class<?> clazz) {
        return this.findPage(conditionWrapper, null, page, clazz);
    }

    public Page findPage(Page page, Class<?> clazz) {
        return this.findPage(null, null, page, clazz);
    }

    public <T> T findById(String id, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return null;
        }
        return this.findOneByQuery(new ConditionAndWrapper().eq("id", (Object)id), clazz);
    }

    public <T> T findOneByQuery(ConditionWrapper conditionWrapper, Sort sort, Class<T> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        List<Object> list = new ArrayList();
        String sql = "SELECT * FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        sql = sort != null ? sql + " " + sort.toString() : sql + " ORDER BY id DESC";
        sql = sql + " limit 1";
        this.logQuery(this.formatSql(sql), values.toArray());
        list = this.buildObjects(this.jdbcTemplate.queryForList(this.formatSql(sql), values.toArray()), clazz);
        return (T)(list.size() > 0 ? list.get(0) : null);
    }

    public <T> T findOneByQuery(Sort sort, Class<T> clazz) {
        return this.findOneByQuery(null, sort, clazz);
    }

    public <T> T findOneByQuery(ConditionWrapper conditionWrapper, Class<T> clazz) {
        return this.findOneByQuery(conditionWrapper, null, clazz);
    }

    public <T> List<T> findListByQuery(ConditionWrapper conditionWrapper, Sort sort, Class<T> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        String sql = "SELECT * FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        sql = sort != null ? sql + " " + sort.toString() : sql + " ORDER BY id DESC";
        this.logQuery(this.formatSql(sql), values.toArray());
        return this.buildObjects(this.jdbcTemplate.queryForList(this.formatSql(sql), values.toArray()), clazz);
    }

    public <T> List<T> findListByQuery(ConditionWrapper conditionWrapper, Class<T> clazz) {
        return this.findListByQuery(conditionWrapper, null, clazz);
    }

    public <T> List<T> findListByQuery(Sort sort, Class<T> clazz) {
        return this.findListByQuery(null, sort, clazz);
    }

    public <T> List<T> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, String property, Class<T> propertyClass) {
        List<?> list = this.findListByQuery(conditionWrapper, documentClass);
        List<T> propertyList = this.extractProperty(list, property, propertyClass);
        return propertyList;
    }

    public <T, R> List<T> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, SerializableFunction<T, R> property, Class<T> propertyClass) {
        return this.findPropertiesByQuery(conditionWrapper, documentClass, ReflectionUtil.getFieldName(property), propertyClass);
    }

    public List<String> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, String property) {
        return this.findPropertiesByQuery(conditionWrapper, documentClass, property, String.class);
    }

    public <T, R> List<String> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, SerializableFunction<T, R> property) {
        return this.findPropertiesByQuery(conditionWrapper, documentClass, ReflectionUtil.getFieldName(property), String.class);
    }

    public List<String> findPropertiesByIds(Collection<String> ids, Class<?> documentClass, String property) {
        if (ids == null || ids.size() == 0) {
            return new ArrayList<String>();
        }
        ConditionAndWrapper ConditionAndWrapper2 = new ConditionAndWrapper();
        ConditionAndWrapper2.in("id", (Collection)ids);
        return this.findPropertiesByQuery((ConditionWrapper)ConditionAndWrapper2, documentClass, property, String.class);
    }

    public <T, R> List<String> findPropertiesByIds(Collection<String> ids, Class<?> documentClass, SerializableFunction<T, R> property) {
        return this.findPropertiesByIds(ids, documentClass, ReflectionUtil.getFieldName(property));
    }

    public List<String> findPropertiesByIds(String[] ids, Class<?> documentClass, String property) {
        return this.findPropertiesByIds(Arrays.asList(ids), documentClass, property);
    }

    public <T, R> List<String> findPropertiesByIds(String[] ids, Class<?> documentClass, SerializableFunction<T, R> property) {
        return this.findPropertiesByIds(Arrays.asList(ids), documentClass, ReflectionUtil.getFieldName(property));
    }

    public List<String> findIdsByQuery(ConditionWrapper conditionWrapper, Class<?> clazz) {
        return this.findPropertiesByQuery(conditionWrapper, clazz, "id");
    }

    public <T> List<T> findListByIds(Collection<String> ids, Class<T> clazz) {
        return this.findListByIds(ids, null, clazz);
    }

    public <T> List<T> findListByIds(String[] ids, Class<T> clazz) {
        return this.findListByIds(Arrays.asList(ids), null, clazz);
    }

    public <T> List<T> findListByIds(Collection<String> ids, Sort sort, Class<T> clazz) {
        if (ids == null || ids.size() == 0) {
            return new ArrayList();
        }
        ConditionAndWrapper ConditionAndWrapper2 = new ConditionAndWrapper();
        ConditionAndWrapper2.in("id", (Collection)ids);
        return this.findListByQuery(ConditionAndWrapper2, sort, clazz);
    }

    public <T> List<T> findListByIds(String[] ids, Sort sort, Class<T> clazz) {
        return this.findListByIds(Arrays.asList(ids), sort, clazz);
    }

    public <T> List<T> findAll(Class<T> clazz) {
        return this.findAll(null, clazz);
    }

    public <T> List<T> findAll(Sort sort, Class<T> clazz) {
        return this.findListByQuery(null, sort, clazz);
    }

    public List<String> findAllIds(Class<?> clazz) {
        return this.findIdsByQuery(null, clazz);
    }

    public Long findCountByQuery(ConditionWrapper conditionWrapper, Class<?> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        String sql = "SELECT COUNT(*) FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        this.logQuery(this.formatSql(sql), values.toArray());
        return (Long)this.jdbcTemplate.queryForObject(this.formatSql(sql), values.toArray(), Long.class);
    }

    public Long findAllCount(Class<?> clazz) {
        return this.findCountByQuery(null, clazz);
    }

    private <T> List<T> extractProperty(List<?> list, String property, Class<T> clazz) {
        HashSet<Object> rs = new HashSet<Object>();
        for (Object object : list) {
            Object value = ReflectUtil.getFieldValue(object, (String)property);
            if (value == null || !value.getClass().equals(clazz)) continue;
            rs.add(value);
        }
        return new ArrayList(rs);
    }

    private <T> List<T> buildObjects(List<Map<String, Object>> queryForList, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            Field[] fields = ReflectUtil.getFields(clazz);
            for (Map<String, Object> map : queryForList) {
                T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                block3: for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    for (Field field : fields) {
                        if (!StrUtil.toUnderlineCase((CharSequence)field.getName()).equals(mapKey)) continue;
                        ReflectUtil.setFieldValue(obj, (String)field.getName(), (Object)mapValue);
                        continue block3;
                    }
                }
                list.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

