/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.service.CollectionFormat;
import springfox.documentation.service.ParameterStyle;

public class SimpleParameterSpecification {
    private final ParameterStyle style;
    private final Boolean explode;
    private final Boolean allowReserved;
    private final ModelSpecification model;
    private final List<ElementFacet> facets = new ArrayList<ElementFacet>();
    private final Boolean allowEmptyValue;
    private final String defaultValue;
    private final CollectionFormat collectionFormat;

    public SimpleParameterSpecification(ParameterStyle style, CollectionFormat collectionFormat, Boolean explode, Boolean allowReserved, Boolean allowEmptyValue, String defaultValue, ModelSpecification model, List<ElementFacet> facets) {
        this.style = style;
        this.collectionFormat = collectionFormat;
        this.explode = explode;
        this.allowReserved = allowReserved;
        this.allowEmptyValue = allowEmptyValue;
        this.defaultValue = defaultValue;
        this.model = model;
        this.facets.addAll(facets);
    }

    public ParameterStyle getStyle() {
        return this.style;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public Boolean nullSafeIsExplode() {
        return this.explode == null ? false : this.explode;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public ModelSpecification getModel() {
        return this.model;
    }

    public CollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public List<ElementFacet> getFacets() {
        return this.facets;
    }

    public <T extends ElementFacet> Optional<T> facetOfType(Class<T> clazz) {
        return this.facets.stream().filter(f -> clazz.isAssignableFrom(f.getClass())).map(t -> t).findFirst();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleParameterSpecification that = (SimpleParameterSpecification)o;
        return this.style == that.style && Objects.equals(this.explode, that.explode) && Objects.equals(this.allowReserved, that.allowReserved) && Objects.equals(this.allowEmptyValue, that.allowEmptyValue) && Objects.equals(this.defaultValue, that.defaultValue) && this.collectionFormat == that.collectionFormat && Objects.equals(this.model, that.model) && this.facets.equals(that.facets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.style, this.explode, this.allowReserved, this.allowEmptyValue, this.defaultValue, this.collectionFormat, this.model, this.facets});
    }

    public String toString() {
        return new StringJoiner(", ", SimpleParameterSpecification.class.getSimpleName() + "[", "]").add("style=" + (Object)((Object)this.style)).add("explode=" + this.explode).add("allowReserved=" + this.allowReserved).add("allowEmptyValue=" + this.allowEmptyValue).add("defaultValue='" + this.defaultValue + "'").add("collectionFormat=" + this.collectionFormat).add("model=" + this.model).add("facets=" + this.facets).toString();
    }
}

