
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
	
	Asset( "ANIM", "anim/player_basic.zip" ),
    Asset( "ANIM", "anim/player_idles_shiver.zip" ),
    Asset( "ANIM", "anim/player_actions.zip" ),
    Asset( "ANIM", "anim/player_actions_axe.zip" ),
    Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
    Asset( "ANIM", "anim/player_actions_shovel.zip" ),
    Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
    Asset( "ANIM", "anim/player_actions_eat.zip" ),
    Asset( "ANIM", "anim/player_actions_item.zip" ),
    Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
    Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
    Asset( "ANIM", "anim/player_actions_fishing.zip" ),
    Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
    Asset( "ANIM", "anim/player_bush_hat.zip" ),
    Asset( "ANIM", "anim/player_attacks.zip" ),
    Asset( "ANIM", "anim/player_idles.zip" ),
    Asset( "ANIM", "anim/player_rebirth.zip" ),
    Asset( "ANIM", "anim/player_jump.zip" ),
    Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
    Asset( "ANIM", "anim/player_teleport.zip" ),
    Asset( "ANIM", "anim/wilson_fx.zip" ),
    Asset( "ANIM", "anim/player_one_man_band.zip" ),
    Asset( "ANIM", "anim/shadow_hands.zip" ),
    Asset( "SOUND", "sound/sfx.fsb" ),
    Asset( "SOUND", "sound/wilson.fsb" ),
    Asset( "ANIM", "anim/beard.zip" ),

    Asset( "ANIM", "anim/nicole.zip" ),
    Asset( "ANIM", "anim/ghost_nicole_build.zip" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
}

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "nicole.tex" )
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Stats	
	inst.components.health:SetMaxHealth(175)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(200)
	inst.components.locomotor.walkspeed = (5)
	inst.components.locomotor.runspeed = (8.1)

	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
    	
	-- Deal bonus damage to spiders.
	inst:ListenForEvent("onattackother", function(inst, data)
	if data.target:HasTag("spider") then -- if the target is a spider (does not count webber)
	data.target.components.health:DoDelta(-15) -- deal 15 bonus damage with any attack (even fists)
	end
	end)

	-- Every 1 second any player within a medium distance will restore 0.5 health.
	inst:DoPeriodicTask(10, function()
	if inst:HasTag("playerghost") or inst.components.health:IsDead() then -- Do not heal others if you are dead.
	return
	end

	local x, y, z = inst.Transform:GetWorldPosition()
	local players = FindPlayersInRange(x, y, z, (8), true) -- You can change "8" to any number it's the dist this code activates
	for _, v in pairs(players) do
	if (v~=inst) then
	v.components.health:DoDelta(2) -- amount of healing
	--v.components.sanity:DoDelta(.15) --if you want a tiny sanity heal too :)
	end
	end

	end)
	
end

return MakePlayerCharacter("nicole", prefabs, assets, common_postinit, master_postinit, start_inv)
