export default async ({store, redirect, $axios, $toast}) => {
  await store.dispatch('plugins/pluginPostInstall', 'Branding');
  if (window.location.search
    && /\bscope=|\bstate=/.test(window.location.search)
    && /\bcode=/.test(window.location.search)) {
    try {
      const tokenData = await $axios.create({
        baseURL: process.env.NODE_ENV === 'production' ? '../' : 'http://localhost:8080/',
      }).post(`/auth/${window.location.search.indexOf('state=github') > -1 ? 'github' : 'google'}/genTokenByCode${window.location.search}`);

      store.commit('users/MutSetToken', tokenData.data.token);
      await store.dispatch('users/ActGetUserDetails');
    } catch (e) {
      if (e.response && e.response.data && e.response.data.msg) {
        $toast.error(e.response.data.msg).goAway(3000);
      }
    }
    const newURL = window.location.href.split("?")[0];
    window.history.pushState('object', document.title, newURL);
  }


  const icons = {
    success: {
      message: ' successful',
      class: 'success',
      icon: 'check_circle'
    },
    error: {
      message: ' failed',
      class: 'error',
      icon: 'error'
    }
  };

  store.watch(
    state => {
      return state.notification.list && state.notification.list[0] && state.notification.list[0].status;
    },
    () => {
      // console.log(store.state.notification.list)
      const n = store.state.notification.list.length && store.state.notification.list[0];
      if (n && n.status !== 'pending' && n.type !== 'List') {
        const msg = `${n.type} ${n.module}.${n.title} ${icons[n.status].message}`;
        $toast[n.status](msg, {
          duration: 2000,
          icon: icons[n.status].icon
        })
      }
    }
  );

  // window.onNuxtReady(async () => {
  console.log('===== Within nuxt ready handler =====')
  await store.dispatch('project/ActLoadProjectInfo');
  console.log('==== Projectinfo ', store.state.project.projectInfo);
  if (!store.state.project.projectInfo.projectHasDb) {
    redirect('/')
  } else if (store.state.project.projectInfo.projectHasAdmin === false) {
    redirect('/')
  }
  // })


};
/**
 * @copyright Copyright (c) 2021, Xgene Cloud Ltd
 *
 * @author Naveen MR <oof1lab@gmail.com>
 * @author Pranav C Balan <pranavxc@gmail.com>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */
/**
 * @copyright Copyright (c) 2021, Xgene Cloud Ltd
 *
 * @author Naveen MR <oof1lab@gmail.com>
 * @author Pranav C Balan <pranavxc@gmail.com>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */
