import {XcPluginConfig} from "nc-plugin";
import LinodeObjectStoragePlugin from "./LinodeObjectStoragePlugin";
import {XcActionType, XcType} from "nc-common";

const config: XcPluginConfig = {
  builder: LinodeObjectStoragePlugin,
  title: 'Linode Object Storage',
  version: '0.0.1',
  logo: 'plugins/linode.svg',
  tags: 'Storage',
  description: 'S3-compatible Linode Object Storage makes it easy and more affordable to manage unstructured data such as content assets, as well as sophisticated and data-intensive storage challenges around artificial intelligence and machine learning.',
  inputs: {
    title: 'Configure Linode Object Storage',
    items: [{
      key: 'bucket',
      label: 'Bucket Name',
      placeholder: 'Bucket Name',
      type: XcType.SingleLineText,
      required: true
    }, {
      key: 'region',
      label: 'Region',
      placeholder: 'Region',
      type: XcType.SingleLineText,
      required: true
    }, {
      key: 'access_key',
      label: 'Access Key',
      placeholder: 'Access Key',
      type: XcType.SingleLineText,
      required: true
    }, {
      key: 'access_secret',
      label: 'Access Secret',
      placeholder: 'Access Secret',
      type: XcType.Password,
      required: true
    },],
    actions: [{
      label: 'Test',
      placeholder: 'Test',
      key: 'test',
      actionType: XcActionType.TEST,
      type: XcType.Button
    }, {
      label: 'Save',
      placeholder: 'Save',
      key: 'save',
      actionType: XcActionType.SUBMIT,
      type: XcType.Button
    },],
    msgOnInstall: 'Successfully installed and attachment will be stored in Linode Object Storage',
    msgOnUninstall: '',
  },
  category: 'Storage',
}

export default config;