import {XcPluginConfig} from "nc-plugin";
import S3Plugin from "./S3Plugin";
import {XcActionType, XcType} from "nc-common";

const config: XcPluginConfig = {
  builder: S3Plugin,
  title: 'S3',
  version: '0.0.1',
  logo: 'plugins/s3.png',
  description: 'Amazon Simple Storage Service (Amazon S3) is an object storage service that offers industry-leading scalability, data availability, security, and performance.',
  inputs: {
    title: 'Configure Amazon S3',
    items: [{
      key: 'bucket',
      label: 'Bucket Name',
      placeholder: 'Bucket Name',
      type: XcType.SingleLineText,
      required: true
    }, {
      key: 'region',
      label: 'Region',
      placeholder: 'Region',
      type: XcType.SingleLineText,
      required: true
    }, {
      key: 'access_key',
      label: 'Access Key',
      placeholder: 'Access Key',
      type: XcType.SingleLineText,
      required: true
    }, {
      key: 'access_secret',
      label: 'Access Secret',
      placeholder: 'Access Secret',
      type: XcType.Password,
      required: true
    },],
    actions: [{
      label: 'Test',
      placeholder: 'Test',
      key: 'test',
      actionType: XcActionType.TEST,
      type: XcType.Button
    }, {
      label: 'Save',
      placeholder: 'Save',
      key: 'save',
      actionType: XcActionType.SUBMIT,
      type: XcType.Button
    },],
    msgOnInstall: 'Successfully installed and attachment will be stored in AWS S3',
    msgOnUninstall: '',
  },
  category: 'Storage',
  tags: 'Storage',
}

export default config;