/*

Sakila for Microsoft SQL Server is a port of the Sakila example database available for MySQL, which was originally developed by Mike Hillyer of the MySQL AB documentation team. 
This project is designed to help database administrators to decide which database to use for development of new products
The user can run the same SQL against different kind of databases and compare the performance

License: BSD
Copyright DB Software Laboratory
http://www.etl-tools.com

*/
USE sakila;

-- Delete data
ALTER TABLE staff DROP CONSTRAINT fk_staff_address;
ALTER TABLE staff DROP CONSTRAINT fk_staff_store;
DELETE FROM payment ;
DELETE FROM rental ;
DELETE FROM customer ;
DELETE FROM film_category ;
DELETE FROM film_text ;
DELETE FROM film_actor ;
DELETE FROM inventory ;
DELETE FROM film ;
DELETE FROM category ;
ALTER TABLE store ALTER COLUMN manager_staff_id TINYINT NULL;
update store set manager_staff_id=null;
DELETE FROM staff ;
DELETE FROM store ;
DELETE FROM actor ;
DELETE FROM address ;
DELETE FROM city ;
DELETE FROM country ;
DELETE FROM language ;

ALTER TABLE store DROP CONSTRAINT fk_store_staff;
DROP INDEX idx_fk_address_id ON store;
ALTER TABLE store ALTER COLUMN manager_staff_id TINYINT NOT NULL;
ALTER TABLE store ADD CONSTRAINT fk_store_staff FOREIGN KEY (manager_staff_id) REFERENCES staff (staff_id);
CREATE UNIQUE NONCLUSTERED INDEX idx_fk_address_id ON store(manager_staff_id);

-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table language
-- Start of script

SET IDENTITY_INSERT language ON

Insert into language
 (language_id,name,last_update)
Values
('1','English','2006-02-15T05:02:19.000')
;
Insert into language
 (language_id,name,last_update)
Values
('2','Italian','2006-02-15T05:02:19.000')
;
Insert into language
 (language_id,name,last_update)
Values
('3','Japanese','2006-02-15T05:02:19.000')
;
Insert into language
 (language_id,name,last_update)
Values
('4','Mandarin','2006-02-15T05:02:19.000')
;
Insert into language
 (language_id,name,last_update)
Values
('5','French','2006-02-15T05:02:19.000')
;
Insert into language
 (language_id,name,last_update)
Values
('6','German','2006-02-15T05:02:19.000')
;
SET IDENTITY_INSERT language OFF

-- End of Script
--
--
-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table country
-- Start of script

SET IDENTITY_INSERT country ON

Insert into country
 (country_id,country,last_update)
Values
('1','Afghanistan','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('2','Algeria','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('3','American Samoa','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('4','Angola','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('5','Anguilla','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('6','Argentina','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('7','Armenia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('8','Australia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('9','Austria','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('10','Azerbaijan','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('11','Bahrain','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('12','Bangladesh','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('13','Belarus','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('14','Bolivia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('15','Brazil','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('16','Brunei','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('17','Bulgaria','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('18','Cambodia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('19','Cameroon','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('20','Canada','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('21','Chad','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('22','Chile','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('23','China','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('24','Colombia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('25','Congo, The Democratic Republic of the','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('26','Czech Republic','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('27','Dominican Republic','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('28','Ecuador','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('29','Egypt','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('30','Estonia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('31','Ethiopia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('32','Faroe Islands','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('33','Finland','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('34','France','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('35','French Guiana','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('36','French Polynesia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('37','Gambia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('38','Germany','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('39','Greece','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('40','Greenland','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('41','Holy See (Vatican City State)','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('42','Hong Kong','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('43','Hungary','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('44','India','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('45','Indonesia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('46','Iran','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('47','Iraq','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('48','Israel','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('49','Italy','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('50','Japan','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('51','Kazakstan','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('52','Kenya','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('53','Kuwait','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('54','Latvia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('55','Liechtenstein','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('56','Lithuania','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('57','Madagascar','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('58','Malawi','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('59','Malaysia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('60','Mexico','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('61','Moldova','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('62','Morocco','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('63','Mozambique','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('64','Myanmar','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('65','Nauru','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('66','Nepal','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('67','Netherlands','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('68','New Zealand','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('69','Nigeria','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('70','North Korea','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('71','Oman','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('72','Pakistan','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('73','Paraguay','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('74','Peru','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('75','Philippines','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('76','Poland','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('77','Puerto Rico','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('78','Romania','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('79','Runion','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('80','Russian Federation','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('81','Saint Vincent and the Grenadines','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('82','Saudi Arabia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('83','Senegal','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('84','Slovakia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('85','South Africa','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('86','South Korea','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('87','Spain','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('88','Sri Lanka','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('89','Sudan','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('90','Sweden','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('91','Switzerland','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('92','Taiwan','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('93','Tanzania','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('94','Thailand','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('95','Tonga','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('96','Tunisia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('97','Turkey','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('98','Turkmenistan','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('99','Tuvalu','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('100','Ukraine','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('101','United Arab Emirates','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('102','United Kingdom','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('103','United States','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('104','Venezuela','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('105','Vietnam','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('106','Virgin Islands, U.S.','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('107','Yemen','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('108','Yugoslavia','2006-02-15T04:44:00.000')
;
Insert into country
 (country_id,country,last_update)
Values
('109','Zambia','2006-02-15T04:44:00.000')
;

SET IDENTITY_INSERT country OFF
-- End of Script
--
--
-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table country
-- Start of script

SET IDENTITY_INSERT city ON

Insert into city
 (city_id,city,country_id,last_update)
Values
('1','A Corua (La Corua)','87','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('2','Abha','82','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('3','Abu Dhabi','101','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('4','Acua','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('5','Adana','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('6','Addis Abeba','31','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('7','Aden','107','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('8','Adoni','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('9','Ahmadnagar','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('10','Akishima','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('11','Akron','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('12','al-Ayn','101','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('13','al-Hawiya','82','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('14','al-Manama','11','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('15','al-Qadarif','89','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('16','al-Qatif','82','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('17','Alessandria','49','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('18','Allappuzha (Alleppey)','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('19','Allende','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('20','Almirante Brown','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('21','Alvorada','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('22','Ambattur','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('23','Amersfoort','67','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('24','Amroha','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('25','Angra dos Reis','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('26','Anpolis','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('27','Antofagasta','22','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('28','Aparecida de Goinia','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('29','Apeldoorn','67','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('30','Araatuba','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('31','Arak','46','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('32','Arecibo','77','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('33','Arlington','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('34','Ashdod','48','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('35','Ashgabat','98','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('36','Ashqelon','48','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('37','Asuncin','73','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('38','Athenai','39','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('39','Atinsk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('40','Atlixco','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('41','Augusta-Richmond County','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('42','Aurora','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('43','Avellaneda','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('44','Bag','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('45','Baha Blanca','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('46','Baicheng','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('47','Baiyin','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('48','Baku','10','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('49','Balaiha','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('50','Balikesir','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('51','Balurghat','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('52','Bamenda','19','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('53','Bandar Seri Begawan','16','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('54','Banjul','37','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('55','Barcelona','104','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('56','Basel','91','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('57','Bat Yam','48','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('58','Batman','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('59','Batna','2','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('60','Battambang','18','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('61','Baybay','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('62','Bayugan','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('63','Bchar','2','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('64','Beira','63','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('65','Bellevue','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('66','Belm','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('67','Benguela','4','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('68','Beni-Mellal','62','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('69','Benin City','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('70','Bergamo','49','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('71','Berhampore (Baharampur)','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('72','Bern','91','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('73','Bhavnagar','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('74','Bhilwara','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('75','Bhimavaram','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('76','Bhopal','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('77','Bhusawal','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('78','Bijapur','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('79','Bilbays','29','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('80','Binzhou','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('81','Birgunj','66','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('82','Bislig','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('83','Blumenau','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('84','Boa Vista','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('85','Boksburg','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('86','Botosani','78','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('87','Botshabelo','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('88','Bradford','102','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('89','Braslia','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('90','Bratislava','84','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('91','Brescia','49','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('92','Brest','34','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('93','Brindisi','49','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('94','Brockton','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('95','Bucuresti','78','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('96','Buenaventura','24','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('97','Bydgoszcz','76','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('98','Cabuyao','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('99','Callao','74','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('100','Cam Ranh','105','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('101','Cape Coral','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('102','Caracas','104','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('103','Carmen','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('104','Cavite','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('105','Cayenne','35','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('106','Celaya','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('107','Chandrapur','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('108','Changhwa','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('109','Changzhou','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('110','Chapra','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('111','Charlotte Amalie','106','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('112','Chatsworth','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('113','Cheju','86','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('114','Chiayi','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('115','Chisinau','61','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('116','Chungho','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('117','Cianjur','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('118','Ciomas','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('119','Ciparay','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('120','Citrus Heights','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('121','Citt del Vaticano','41','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('122','Ciudad del Este','73','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('123','Clarksville','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('124','Coacalco de Berriozbal','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('125','Coatzacoalcos','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('126','Compton','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('127','Coquimbo','22','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('128','Crdoba','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('129','Cuauhtmoc','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('130','Cuautla','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('131','Cuernavaca','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('132','Cuman','104','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('133','Czestochowa','76','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('134','Dadu','72','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('135','Dallas','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('136','Datong','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('137','Daugavpils','54','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('138','Davao','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('139','Daxian','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('140','Dayton','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('141','Deba Habe','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('142','Denizli','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('143','Dhaka','12','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('144','Dhule (Dhulia)','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('145','Dongying','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('146','Donostia-San Sebastin','87','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('147','Dos Quebradas','24','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('148','Duisburg','38','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('149','Dundee','102','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('150','Dzerzinsk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('151','Ede','67','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('152','Effon-Alaiye','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('153','El Alto','14','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('154','El Fuerte','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('155','El Monte','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('156','Elista','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('157','Emeishan','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('158','Emmen','67','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('159','Enshi','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('160','Erlangen','38','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('161','Escobar','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('162','Esfahan','46','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('163','Eskisehir','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('164','Etawah','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('165','Ezeiza','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('166','Ezhou','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('167','Faaa','36','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('168','Fengshan','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('169','Firozabad','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('170','Florencia','24','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('171','Fontana','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('172','Fukuyama','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('173','Funafuti','99','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('174','Fuyu','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('175','Fuzhou','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('176','Gandhinagar','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('177','Garden Grove','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('178','Garland','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('179','Gatineau','20','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('180','Gaziantep','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('181','Gijn','87','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('182','Gingoog','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('183','Goinia','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('184','Gorontalo','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('185','Grand Prairie','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('186','Graz','9','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('187','Greensboro','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('188','Guadalajara','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('189','Guaruj','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('190','guas Lindas de Gois','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('191','Gulbarga','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('192','Hagonoy','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('193','Haining','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('194','Haiphong','105','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('195','Haldia','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('196','Halifax','20','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('197','Halisahar','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('198','Halle/Saale','38','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('199','Hami','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('200','Hamilton','68','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('201','Hanoi','105','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('202','Hidalgo','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('203','Higashiosaka','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('204','Hino','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('205','Hiroshima','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('206','Hodeida','107','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('207','Hohhot','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('208','Hoshiarpur','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('209','Hsichuh','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('210','Huaian','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('211','Hubli-Dharwad','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('212','Huejutla de Reyes','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('213','Huixquilucan','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('214','Hunuco','74','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('215','Ibirit','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('216','Idfu','29','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('217','Ife','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('218','Ikerre','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('219','Iligan','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('220','Ilorin','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('221','Imus','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('222','Inegl','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('223','Ipoh','59','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('224','Isesaki','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('225','Ivanovo','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('226','Iwaki','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('227','Iwakuni','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('228','Iwatsuki','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('229','Izumisano','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('230','Jaffna','88','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('231','Jaipur','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('232','Jakarta','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('233','Jalib al-Shuyukh','53','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('234','Jamalpur','12','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('235','Jaroslavl','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('236','Jastrzebie-Zdrj','76','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('237','Jedda','82','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('238','Jelets','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('239','Jhansi','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('240','Jinchang','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('241','Jining','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('242','Jinzhou','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('243','Jodhpur','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('244','Johannesburg','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('245','Joliet','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('246','Jos Azueta','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('247','Juazeiro do Norte','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('248','Juiz de Fora','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('249','Junan','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('250','Jurez','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('251','Kabul','1','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('252','Kaduna','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('253','Kakamigahara','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('254','Kaliningrad','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('255','Kalisz','76','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('256','Kamakura','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('257','Kamarhati','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('258','Kamjanets-Podilskyi','100','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('259','Kamyin','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('260','Kanazawa','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('261','Kanchrapara','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('262','Kansas City','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('263','Karnal','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('264','Katihar','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('265','Kermanshah','46','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('266','Kilis','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('267','Kimberley','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('268','Kimchon','86','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('269','Kingstown','81','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('270','Kirovo-Tepetsk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('271','Kisumu','52','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('272','Kitwe','109','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('273','Klerksdorp','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('274','Kolpino','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('275','Konotop','100','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('276','Koriyama','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('277','Korla','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('278','Korolev','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('279','Kowloon and New Kowloon','42','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('280','Kragujevac','108','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('281','Ktahya','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('282','Kuching','59','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('283','Kumbakonam','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('284','Kurashiki','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('285','Kurgan','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('286','Kursk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('287','Kuwana','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('288','La Paz','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('289','La Plata','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('290','La Romana','27','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('291','Laiwu','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('292','Lancaster','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('293','Laohekou','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('294','Lapu-Lapu','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('295','Laredo','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('296','Lausanne','91','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('297','Le Mans','34','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('298','Lengshuijiang','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('299','Leshan','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('300','Lethbridge','20','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('301','Lhokseumawe','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('302','Liaocheng','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('303','Liepaja','54','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('304','Lilongwe','58','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('305','Lima','74','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('306','Lincoln','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('307','Linz','9','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('308','Lipetsk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('309','Livorno','49','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('310','Ljubertsy','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('311','Loja','28','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('312','London','102','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('313','London','20','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('314','Lublin','76','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('315','Lubumbashi','25','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('316','Lungtan','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('317','Luzinia','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('318','Madiun','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('319','Mahajanga','57','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('320','Maikop','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('321','Malm','90','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('322','Manchester','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('323','Mandaluyong','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('324','Mandi Bahauddin','72','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('325','Mannheim','38','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('326','Maracabo','104','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('327','Mardan','72','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('328','Maring','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('329','Masqat','71','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('330','Matamoros','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('331','Matsue','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('332','Meixian','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('333','Memphis','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('334','Merlo','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('335','Mexicali','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('336','Miraj','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('337','Mit Ghamr','29','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('338','Miyakonojo','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('339','Mogiljov','13','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('340','Molodetno','13','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('341','Monclova','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('342','Monywa','64','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('343','Moscow','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('344','Mosul','47','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('345','Mukateve','100','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('346','Munger (Monghyr)','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('347','Mwanza','93','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('348','Mwene-Ditu','25','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('349','Myingyan','64','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('350','Mysore','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('351','Naala-Porto','63','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('352','Nabereznyje Telny','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('353','Nador','62','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('354','Nagaon','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('355','Nagareyama','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('356','Najafabad','46','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('357','Naju','86','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('358','Nakhon Sawan','94','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('359','Nam Dinh','105','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('360','Namibe','4','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('361','Nantou','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('362','Nanyang','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('363','NDjamna','21','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('364','Newcastle','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('365','Nezahualcyotl','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('366','Nha Trang','105','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('367','Niznekamsk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('368','Novi Sad','108','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('369','Novoterkassk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('370','Nukualofa','95','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('371','Nuuk','40','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('372','Nyeri','52','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('373','Ocumare del Tuy','104','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('374','Ogbomosho','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('375','Okara','72','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('376','Okayama','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('377','Okinawa','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('378','Olomouc','26','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('379','Omdurman','89','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('380','Omiya','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('381','Ondo','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('382','Onomichi','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('383','Oshawa','20','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('384','Osmaniye','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('385','ostka','100','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('386','Otsu','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('387','Oulu','33','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('388','Ourense (Orense)','87','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('389','Owo','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('390','Oyo','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('391','Ozamis','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('392','Paarl','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('393','Pachuca de Soto','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('394','Pak Kret','94','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('395','Palghat (Palakkad)','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('396','Pangkal Pinang','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('397','Papeete','36','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('398','Parbhani','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('399','Pathankot','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('400','Patiala','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('401','Patras','39','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('402','Pavlodar','51','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('403','Pemalang','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('404','Peoria','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('405','Pereira','24','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('406','Phnom Penh','18','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('407','Pingxiang','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('408','Pjatigorsk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('409','Plock','76','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('410','Po','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('411','Ponce','77','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('412','Pontianak','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('413','Poos de Caldas','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('414','Portoviejo','28','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('415','Probolinggo','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('416','Pudukkottai','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('417','Pune','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('418','Purnea (Purnia)','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('419','Purwakarta','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('420','Pyongyang','70','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('421','Qalyub','29','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('422','Qinhuangdao','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('423','Qomsheh','46','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('424','Quilmes','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('425','Rae Bareli','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('426','Rajkot','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('427','Rampur','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('428','Rancagua','22','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('429','Ranchi','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('430','Richmond Hill','20','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('431','Rio Claro','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('432','Rizhao','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('433','Roanoke','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('434','Robamba','28','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('435','Rockford','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('436','Ruse','17','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('437','Rustenburg','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('438','s-Hertogenbosch','67','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('439','Saarbrcken','38','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('440','Sagamihara','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('441','Saint Louis','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('442','Saint-Denis','79','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('443','Sal','62','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('444','Salala','71','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('445','Salamanca','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('446','Salinas','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('447','Salzburg','9','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('448','Sambhal','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('449','San Bernardino','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('450','San Felipe de Puerto Plata','27','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('451','San Felipe del Progreso','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('452','San Juan Bautista Tuxtepec','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('453','San Lorenzo','73','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('454','San Miguel de Tucumn','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('455','Sanaa','107','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('456','Santa Brbara dOeste','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('457','Santa F','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('458','Santa Rosa','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('459','Santiago de Compostela','87','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('460','Santiago de los Caballeros','27','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('461','Santo Andr','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('462','Sanya','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('463','Sasebo','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('464','Satna','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('465','Sawhaj','29','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('466','Serpuhov','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('467','Shahr-e Kord','46','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('468','Shanwei','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('469','Shaoguan','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('470','Sharja','101','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('471','Shenzhen','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('472','Shikarpur','72','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('473','Shimoga','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('474','Shimonoseki','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('475','Shivapuri','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('476','Shubra al-Khayma','29','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('477','Siegen','38','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('478','Siliguri (Shiliguri)','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('479','Simferopol','100','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('480','Sincelejo','24','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('481','Sirjan','46','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('482','Sivas','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('483','Skikda','2','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('484','Smolensk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('485','So Bernardo do Campo','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('486','So Leopoldo','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('487','Sogamoso','24','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('488','Sokoto','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('489','Songkhla','94','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('490','Sorocaba','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('491','Soshanguve','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('492','Sousse','96','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('493','South Hill','5','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('494','Southampton','102','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('495','Southend-on-Sea','102','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('496','Southport','102','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('497','Springs','85','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('498','Stara Zagora','17','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('499','Sterling Heights','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('500','Stockport','102','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('501','Sucre','14','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('502','Suihua','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('503','Sullana','74','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('504','Sultanbeyli','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('505','Sumqayit','10','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('506','Sumy','100','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('507','Sungai Petani','59','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('508','Sunnyvale','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('509','Surakarta','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('510','Syktyvkar','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('511','Syrakusa','49','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('512','Szkesfehrvr','43','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('513','Tabora','93','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('514','Tabriz','46','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('515','Tabuk','82','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('516','Tafuna','3','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('517','Taguig','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('518','Taizz','107','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('519','Talavera','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('520','Tallahassee','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('521','Tama','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('522','Tambaram','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('523','Tanauan','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('524','Tandil','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('525','Tangail','12','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('526','Tanshui','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('527','Tanza','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('528','Tarlac','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('529','Tarsus','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('530','Tartu','30','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('531','Teboksary','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('532','Tegal','45','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('533','Tel Aviv-Jaffa','48','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('534','Tete','63','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('535','Tianjin','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('536','Tiefa','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('537','Tieli','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('538','Tokat','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('539','Tonghae','86','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('540','Tongliao','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('541','Torren','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('542','Touliu','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('543','Toulon','34','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('544','Toulouse','34','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('545','Trshavn','32','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('546','Tsaotun','92','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('547','Tsuyama','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('548','Tuguegarao','75','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('549','Tychy','76','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('550','Udaipur','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('551','Udine','49','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('552','Ueda','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('553','Uijongbu','86','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('554','Uluberia','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('555','Urawa','50','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('556','Uruapan','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('557','Usak','97','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('558','Usolje-Sibirskoje','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('559','Uttarpara-Kotrung','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('560','Vaduz','55','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('561','Valencia','104','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('562','Valle de la Pascua','104','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('563','Valle de Santiago','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('564','Valparai','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('565','Vancouver','20','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('566','Varanasi (Benares)','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('567','Vicente Lpez','6','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('568','Vijayawada','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('569','Vila Velha','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('570','Vilnius','56','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('571','Vinh','105','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('572','Vitria de Santo Anto','15','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('573','Warren','103','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('574','Weifang','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('575','Witten','38','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('576','Woodridge','8','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('577','Wroclaw','76','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('578','Xiangfan','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('579','Xiangtan','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('580','Xintai','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('581','Xinxiang','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('582','Yamuna Nagar','44','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('583','Yangor','65','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('584','Yantai','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('585','Yaound','19','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('586','Yerevan','7','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('587','Yinchuan','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('588','Yingkou','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('589','York','102','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('590','Yuncheng','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('591','Yuzhou','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('592','Zalantun','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('593','Zanzibar','93','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('594','Zaoyang','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('595','Zapopan','60','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('596','Zaria','69','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('597','Zeleznogorsk','80','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('598','Zhezqazghan','51','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('599','Zhoushan','23','2006-02-15T04:45:25.000')
;
Insert into city
 (city_id,city,country_id,last_update)
Values
('600','Ziguinchor','83','2006-02-15T04:45:25.000')
;
SET IDENTITY_INSERT city OFF

-- End of Script
--
--
-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table country
-- Start of script

SET IDENTITY_INSERT address ON

Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('1','47 MySakila Drive',NULL,' ','300',NULL,' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('2','28 MySQL Boulevard',NULL,' ','576',NULL,' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('3','23 Workhaven Lane',NULL,' ','300',NULL,' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('4','1411 Lillydale Drive',NULL,' ','576',NULL,' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('5','1913 Hanoi Way',NULL,' ','463','35200',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('6','1121 Loja Avenue',NULL,' ','449','17886',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('7','692 Joliet Street',NULL,' ','38','83579',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('8','1566 Inegl Manor',NULL,' ','349','53561',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('9','53 Idfu Parkway',NULL,' ','361','42399',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('10','1795 Santiago de Compostela Way',NULL,' ','295','18743',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('11','900 Santiago de Compostela Parkway',NULL,' ','280','93896',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('12','478 Joliet Way',NULL,' ','200','77948',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('13','613 Korolev Drive',NULL,' ','329','45844',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('14','1531 Sal Drive',NULL,' ','162','53628',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('15','1542 Tarlac Parkway',NULL,' ','440','1027',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('16','808 Bhopal Manor',NULL,' ','582','10672',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('17','270 Amroha Parkway',NULL,' ','384','29610',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('18','770 Bydgoszcz Avenue',NULL,' ','120','16266',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('19','419 Iligan Lane',NULL,' ','76','72878',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('20','360 Toulouse Parkway',NULL,' ','495','54308',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('21','270 Toulon Boulevard',NULL,' ','156','81766',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('22','320 Brest Avenue',NULL,' ','252','43331',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('23','1417 Lancaster Avenue',NULL,' ','267','72192',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('24','1688 Okara Way',NULL,' ','327','21954',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('25','262 A Corua (La Corua) Parkway',NULL,' ','525','34418',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('26','28 Charlotte Amalie Street',NULL,' ','443','37551',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('27','1780 Hino Boulevard',NULL,' ','303','7716',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('28','96 Tafuna Way',NULL,' ','128','99865',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('29','934 San Felipe de Puerto Plata Street',NULL,' ','472','99780',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('30','18 Duisburg Boulevard',NULL,' ','121','58327',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('31','217 Botshabelo Place',NULL,' ','138','49521',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('32','1425 Shikarpur Manor',NULL,' ','346','65599',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('33','786 Aurora Avenue',NULL,' ','474','65750',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('34','1668 Anpolis Street',NULL,' ','316','50199',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('35','33 Gorontalo Way',NULL,' ','257','30348',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('36','176 Mandaluyong Place',NULL,' ','239','65213',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('37','127 Purnea (Purnia) Manor',NULL,' ','17','79388',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('38','61 Tama Street',NULL,' ','284','94065',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('39','391 Callao Drive',NULL,' ','544','34021',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('40','334 Munger (Monghyr) Lane',NULL,' ','31','38145',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('41','1440 Fukuyama Loop',NULL,' ','362','47929',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('42','269 Cam Ranh Parkway',NULL,' ','115','34689',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('43','306 Antofagasta Place',NULL,' ','569','3989',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('44','671 Graz Street',NULL,' ','353','94399',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('45','42 Brindisi Place',NULL,' ','586','16744',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('46','1632 Bislig Avenue',NULL,' ','394','61117',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('47','1447 Imus Way',NULL,' ','167','48942',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('48','1998 Halifax Drive',NULL,' ','308','76022',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('49','1718 Valencia Street',NULL,' ','27','37359',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('50','46 Pjatigorsk Lane',NULL,' ','343','23616',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('51','686 Garland Manor',NULL,' ','247','52535',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('52','909 Garland Manor',NULL,' ','367','69367',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('53','725 Isesaki Place',NULL,' ','237','74428',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('54','115 Hidalgo Parkway',NULL,' ','379','80168',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('55','1135 Izumisano Parkway',NULL,' ','171','48150',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('56','939 Probolinggo Loop',NULL,' ','1','4166',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('57','17 Kabul Boulevard',NULL,' ','355','38594',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('58','1964 Allappuzha (Alleppey) Street',NULL,' ','227','48980',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('59','1697 Kowloon and New Kowloon Loop',NULL,' ','49','57807',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('60','1668 Saint Louis Place',NULL,' ','397','39072',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('61','943 Tokat Street',NULL,' ','560','45428',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('62','1114 Liepaja Street',NULL,' ','282','69226',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('63','1213 Ranchi Parkway',NULL,' ','350','94352',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('64','81 Hodeida Way',NULL,' ','231','55561',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('65','915 Ponce Place',NULL,' ','56','83980',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('66','1717 Guadalajara Lane',NULL,' ','441','85505',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('67','1214 Hanoi Way',NULL,' ','306','67055',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('68','1966 Amroha Avenue',NULL,' ','139','70385',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('69','698 Otsu Street',NULL,' ','105','71110',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('70','1150 Kimchon Manor',NULL,' ','321','96109',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('71','1586 Guaruj Place',NULL,' ','579','5135',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('72','57 Arlington Manor',NULL,' ','475','48960',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('73','1031 Daugavpils Parkway',NULL,' ','63','59025',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('74','1124 Buenaventura Drive',NULL,' ','13','6856',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('75','492 Cam Ranh Street',NULL,' ','61','50805',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('76','89 Allappuzha (Alleppey) Manor',NULL,' ','517','75444',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('77','1947 Poos de Caldas Boulevard',NULL,' ','114','60951',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('78','1206 Dos Quebradas Place',NULL,' ','431','20207',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('79','1551 Rampur Lane',NULL,' ','108','72394',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('80','602 Paarl Street',NULL,' ','402','98889',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('81','1692 Ede Loop',NULL,' ','30','9223',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('82','936 Salzburg Lane',NULL,' ','425','96709',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('83','586 Tete Way',NULL,' ','256','1079',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('84','1888 Kabul Drive',NULL,' ','217','20936',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('85','320 Baiyin Parkway',NULL,' ','319','37307',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('86','927 Baha Blanca Parkway',NULL,' ','479','9495',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('87','929 Tallahassee Loop',NULL,' ','497','74671',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('88','125 Citt del Vaticano Boulevard',NULL,' ','40','67912',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('89','1557 Ktahya Boulevard',NULL,' ','88','88002',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('90','870 Ashqelon Loop',NULL,' ','489','84931',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('91','1740 Portoviejo Avenue',NULL,' ','480','29932',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('92','1942 Ciparay Parkway',NULL,' ','113','82624',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('93','1926 El Alto Avenue',NULL,' ','289','75543',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('94','1952 Chatsworth Drive',NULL,' ','332','25958',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('95','1370 Le Mans Avenue',NULL,' ','53','52163',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('96','984 Effon-Alaiye Avenue',NULL,' ','183','17119',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('97','832 Nakhon Sawan Manor',NULL,' ','592','49021',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('98','152 Kitwe Parkway',NULL,' ','82','53182',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('99','1697 Tanauan Lane',NULL,' ','399','22870',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('100','1308 Arecibo Way',NULL,' ','41','30695',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('101','1599 Plock Drive',NULL,' ','534','71986',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('102','669 Firozabad Loop',NULL,' ','12','92265',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('103','588 Vila Velha Manor',NULL,' ','268','51540',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('104','1913 Kamakura Place',NULL,' ','238','97287',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('105','733 Mandaluyong Place',NULL,' ','2','77459',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('106','659 Vaduz Drive',NULL,' ','34','49708',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('107','1177 Jelets Way',NULL,' ','220','3305',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('108','1386 Yangor Avenue',NULL,' ','543','80720',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('109','454 Nakhon Sawan Boulevard',NULL,' ','173','76383',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('110','1867 San Juan Bautista Tuxtepec Avenue',NULL,' ','225','78311',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('111','1532 Dzerzinsk Way',NULL,' ','334','9599',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('112','1002 Ahmadnagar Manor',NULL,' ','213','93026',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('113','682 Junan Way',NULL,' ','273','30418',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('114','804 Elista Drive',NULL,' ','159','61069',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('115','1378 Alvorada Avenue',NULL,' ','102','75834',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('116','793 Cam Ranh Avenue',NULL,' ','292','87057',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('117','1079 Tel Aviv-Jaffa Boulevard',NULL,' ','132','10885',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('118','442 Rae Bareli Place',NULL,' ','148','24321',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('119','1107 Nakhon Sawan Avenue',NULL,' ','365','75149',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('120','544 Malm Parkway',NULL,' ','403','63502',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('121','1967 Sincelejo Place',NULL,' ','176','73644',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('122','333 Goinia Way',NULL,' ','185','78625',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('123','1987 Coacalco de Berriozbal Loop',NULL,' ','476','96065',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('124','241 Mosul Lane',NULL,' ','147','76157',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('125','211 Chiayi Drive',NULL,' ','164','58186',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('126','1175 Tanauan Way',NULL,' ','305','64615',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('127','117 Boa Vista Way',NULL,' ','566','6804',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('128','848 Tafuna Manor',NULL,' ','281','45142',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('129','569 Baicheng Lane',NULL,' ','85','60304',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('130','1666 Qomsheh Drive',NULL,' ','410','66255',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('131','801 Hagonoy Drive',NULL,' ','484','8439',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('132','1050 Garden Grove Avenue',NULL,' ','236','4999',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('133','1854 Tieli Street',NULL,' ','302','15819',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('134','758 Junan Lane',NULL,' ','190','82639',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('135','1752 So Leopoldo Parkway',NULL,' ','345','14014',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('136','898 Belm Manor',NULL,' ','87','49757',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('137','261 Saint Louis Way',NULL,' ','541','83401',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('138','765 Southampton Drive',NULL,' ','421','4285',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('139','943 Johannesburg Avenue',NULL,' ','417','5892',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('140','788 Atinsk Street',NULL,' ','211','81691',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('141','1749 Daxian Place',NULL,' ','29','11044',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('142','1587 Sullana Lane',NULL,' ','207','85769',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('143','1029 Dzerzinsk Manor',NULL,' ','542','57519',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('144','1666 Beni-Mellal Place',NULL,' ','123','13377',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('145','928 Jaffna Loop',NULL,' ','172','93762',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('146','483 Ljubertsy Parkway',NULL,' ','149','60562',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('147','374 Bat Yam Boulevard',NULL,' ','266','97700',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('148','1027 Songkhla Manor',NULL,' ','340','30861',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('149','999 Sanaa Loop',NULL,' ','491','3439',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('150','879 Newcastle Way',NULL,' ','499','90732',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('151','1337 Lincoln Parkway',NULL,' ','555','99457',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('152','1952 Pune Lane',NULL,' ','442','92150',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('153','782 Mosul Street',NULL,' ','94','25545',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('154','781 Shimonoseki Drive',NULL,' ','202','95444',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('155','1560 Jelets Boulevard',NULL,' ','291','77777',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('156','1963 Moscow Place',NULL,' ','354','64863',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('157','456 Escobar Way',NULL,' ','232','36061',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('158','798 Cianjur Avenue',NULL,' ','590','76990',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('159','185 Novi Sad Place',NULL,' ','72','41778',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('160','1367 Yantai Manor',NULL,' ','381','21294',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('161','1386 Nakhon Sawan Boulevard',NULL,' ','420','53502',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('162','369 Papeete Way',NULL,' ','187','66639',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('163','1440 Compton Place',NULL,' ','307','81037',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('164','1623 Baha Blanca Manor',NULL,' ','310','81511',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('165','97 Shimoga Avenue',NULL,' ','533','44660',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('166','1740 Le Mans Loop',NULL,' ','297','22853',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('167','1287 Xiangfan Boulevard',NULL,' ','253','57844',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('168','842 Salzburg Lane',NULL,' ','529','3313',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('169','154 Tallahassee Loop',NULL,' ','199','62250',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('170','710 San Felipe del Progreso Avenue',NULL,' ','304','76901',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('171','1540 Wroclaw Drive',NULL,' ','107','62686',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('172','475 Atinsk Way',NULL,' ','240','59571',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('173','1294 Firozabad Drive',NULL,' ','407','70618',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('174','1877 Ezhou Lane',NULL,' ','550','63337',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('175','316 Uruapan Street',NULL,' ','223','58194',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('176','29 Pyongyang Loop',NULL,' ','58','47753',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('177','1010 Klerksdorp Way',NULL,' ','186','6802',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('178','1848 Salala Boulevard',NULL,' ','373','25220',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('179','431 Xiangtan Avenue',NULL,' ','18','4854',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('180','757 Rustenburg Avenue',NULL,' ','483','89668',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('181','146 Johannesburg Way',NULL,' ','330','54132',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('182','1891 Rizhao Boulevard',NULL,' ','456','47288',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('183','1089 Iwatsuki Avenue',NULL,' ','270','35109',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('184','1410 Benin City Parkway',NULL,' ','405','29747',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('185','682 Garden Grove Place',NULL,' ','333','67497',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('186','533 al-Ayn Boulevard',NULL,' ','126','8862',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('187','1839 Szkesfehrvr Parkway',NULL,' ','317','55709',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('188','741 Ambattur Manor',NULL,' ','438','43310',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('189','927 Barcelona Street',NULL,' ','467','65121',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('190','435 0 Way',NULL,' ','195','74750',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('191','140 Chiayi Parkway',NULL,' ','506','38982',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('192','1166 Changhwa Street',NULL,' ','62','58852',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('193','891 Novi Sad Manor',NULL,' ','383','5379',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('194','605 Rio Claro Parkway',NULL,' ','513','49348',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('195','1077 San Felipe de Puerto Plata Place',NULL,' ','369','65387',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('196','9 San Miguel de Tucumn Manor',NULL,' ','169','90845',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('197','447 Surakarta Loop',NULL,' ','271','10428',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('198','345 Oshawa Boulevard',NULL,' ','204','32114',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('199','1792 Valle de la Pascua Place',NULL,' ','477','15540',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('200','1074 Binzhou Manor',NULL,' ','325','36490',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('201','817 Bradford Loop',NULL,' ','109','89459',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('202','955 Bamenda Way',NULL,' ','218','1545',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('203','1149 A Corua (La Corua) Boulevard',NULL,' ','194','95824',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('204','387 Mwene-Ditu Drive',NULL,' ','35','8073',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('205','68 Molodetno Manor',NULL,' ','575','4662',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('206','642 Nador Drive',NULL,' ','77','3924',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('207','1688 Nador Lane',NULL,' ','184','61613',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('208','1215 Pyongyang Parkway',NULL,' ','557','25238',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('209','1679 Antofagasta Street',NULL,' ','122','86599',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('210','1304 s-Hertogenbosch Way',NULL,' ','83','10925',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('211','850 Salala Loop',NULL,' ','371','10800',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('212','624 Oshawa Boulevard',NULL,' ','51','89959',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('213','43 Dadu Avenue',NULL,' ','74','4855',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('214','751 Lima Loop',NULL,' ','7','99405',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('215','1333 Haldia Street',NULL,' ','174','82161',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('216','660 Jedda Boulevard',NULL,' ','65','25053',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('217','1001 Miyakonojo Lane',NULL,' ','518','67924',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('218','226 Brest Manor',NULL,' ','508','2299',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('219','1229 Valencia Parkway',NULL,' ','498','99124',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('220','1201 Qomsheh Manor',NULL,' ','28','21464',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('221','866 Shivapuri Manor',NULL,' ','448','22474',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('222','1168 Najafabad Parkway',NULL,' ','251','40301',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('223','1244 Allappuzha (Alleppey) Place',NULL,' ','567','20657',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('224','1842 Luzinia Boulevard',NULL,' ','593','94420',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('225','1926 Gingoog Street',NULL,' ','511','22824',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('226','810 Palghat (Palakkad) Boulevard',NULL,' ','235','73431',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('227','1820 Maring Parkway',NULL,' ','324','88307',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('228','60 Poos de Caldas Street',NULL,' ','243','82338',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('229','1014 Loja Manor',NULL,' ','22','66851',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('230','201 Effon-Alaiye Way',NULL,' ','37','64344',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('231','430 Alessandria Loop',NULL,' ','439','47446',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('232','754 Valencia Place',NULL,' ','406','87911',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('233','356 Olomouc Manor',NULL,' ','26','93323',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('234','1256 Bislig Boulevard',NULL,' ','86','50598',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('235','954 Kimchon Place',NULL,' ','559','42420',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('236','885 Yingkou Manor',NULL,' ','596','31390',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('237','1736 Cavite Place',NULL,' ','216','98775',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('238','346 Skikda Parkway',NULL,' ','233','90628',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('239','98 Stara Zagora Boulevard',NULL,' ','96','76448',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('240','1479 Rustenburg Boulevard',NULL,' ','527','18727',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('241','647 A Corua (La Corua) Street',NULL,' ','357','36971',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('242','1964 Gijn Manor',NULL,' ','473','14408',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('243','47 Syktyvkar Lane',NULL,' ','118','22236',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('244','1148 Saarbrcken Parkway',NULL,' ','226','1921',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('245','1103 Bilbays Parkway',NULL,' ','578','87660',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('246','1246 Boksburg Parkway',NULL,' ','422','28349',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('247','1483 Pathankot Street',NULL,' ','454','37288',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('248','582 Papeete Loop',NULL,' ','294','27722',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('249','300 Junan Street',NULL,' ','553','81314',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('250','829 Grand Prairie Way',NULL,' ','328','6461',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('251','1473 Changhwa Parkway',NULL,' ','124','75933',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('252','1309 Weifang Street',NULL,' ','520','57338',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('253','1760 Oshawa Manor',NULL,' ','535','38140',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('254','786 Stara Zagora Way',NULL,' ','390','98332',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('255','1966 Tonghae Street',NULL,' ','198','36481',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('256','1497 Yuzhou Drive',NULL,' ','312','3433',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('258','752 Ondo Loop',NULL,' ','338','32474',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('259','1338 Zalantun Lane',NULL,' ','413','45403',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('260','127 Iwakuni Boulevard',NULL,' ','192','20777',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('261','51 Laredo Avenue',NULL,' ','342','68146',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('262','771 Yaound Manor',NULL,' ','64','86768',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('263','532 Toulon Street',NULL,' ','460','69517',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('264','1027 Banjul Place',NULL,' ','197','50390',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('265','1158 Mandi Bahauddin Parkway',NULL,' ','136','98484',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('266','862 Xintai Lane',NULL,' ','548','30065',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('267','816 Cayenne Parkway',NULL,' ','414','93629',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('268','1831 Nam Dinh Loop',NULL,' ','323','51990',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('269','446 Kirovo-Tepetsk Lane',NULL,' ','203','19428',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('270','682 Halisahar Place',NULL,' ','378','20536',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('271','1587 Loja Manor',NULL,' ','447','5410',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('272','1762 Paarl Parkway',NULL,' ','298','53928',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('273','1519 Ilorin Place',NULL,' ','395','49298',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('274','920 Kumbakonam Loop',NULL,' ','446','75090',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('275','906 Goinia Way',NULL,' ','255','83565',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('276','1675 Xiangfan Manor',NULL,' ','283','11763',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('277','85 San Felipe de Puerto Plata Drive',NULL,' ','584','46063',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('278','144 South Hill Loop',NULL,' ','445','2012',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('279','1884 Shikarpur Avenue',NULL,' ','263','85548',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('280','1980 Kamjanets-Podilskyi Street',NULL,' ','404','89502',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('281','1944 Bamenda Way',NULL,' ','573','24645',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('282','556 Baybay Manor',NULL,' ','374','55802',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('283','457 Tongliao Loop',NULL,' ','222','56254',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('284','600 Bradford Street',NULL,' ','514','96204',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('285','1006 Santa Brbara dOeste Manor',NULL,' ','389','36229',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('286','1308 Sumy Loop',NULL,' ','175','30657',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('287','1405 Chisinau Place',NULL,' ','411','8160',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('288','226 Halifax Street',NULL,' ','277','58492',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('289','1279 Udine Parkway',NULL,' ','69','75860',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('290','1336 Benin City Drive',NULL,' ','386','46044',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('291','1155 Liaocheng Place',NULL,' ','152','22650',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('292','1993 Tabuk Lane',NULL,' ','522','64221',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('293','86 Higashiosaka Lane',NULL,' ','563','33768',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('294','1912 Allende Manor',NULL,' ','279','58124',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('295','544 Tarsus Boulevard',NULL,' ','562','53145',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('296','1936 Cuman Avenue',NULL,' ','433','61195',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('297','1192 Tongliao Street',NULL,' ','470','19065',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('298','44 Najafabad Way',NULL,' ','146','61391',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('299','32 Pudukkottai Lane',NULL,' ','140','38834',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('300','661 Chisinau Lane',NULL,' ','274','8856',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('301','951 Stara Zagora Manor',NULL,' ','400','98573',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('302','922 Vila Velha Loop',NULL,' ','9','4085',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('303','898 Jining Lane',NULL,' ','387','40070',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('304','1635 Kuwana Boulevard',NULL,' ','205','52137',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('305','41 El Alto Parkway',NULL,' ','398','56883',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('306','1883 Maikop Lane',NULL,' ','254','68469',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('307','1908 Gaziantep Place',NULL,' ','536','58979',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('308','687 Alessandria Parkway',NULL,' ','455','57587',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('309','827 Yuncheng Drive',NULL,' ','99','79047',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('310','913 Coacalco de Berriozbal Loop',NULL,' ','33','42141',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('311','715 So Bernardo do Campo Lane',NULL,' ','507','84804',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('312','1354 Siegen Street',NULL,' ','25','80184',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('313','1191 Sungai Petani Boulevard',NULL,' ','262','9668',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('314','1224 Huejutla de Reyes Boulevard',NULL,' ','91','70923',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('315','543 Bergamo Avenue',NULL,' ','215','59686',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('316','746 Joliet Lane',NULL,' ','286','94878',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('317','780 Kimberley Way',NULL,' ','515','17032',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('318','1774 Yaound Place',NULL,' ','166','91400',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('319','1957 Yantai Lane',NULL,' ','490','59255',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('320','1542 Lubumbashi Boulevard',NULL,' ','57','62472',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('321','651 Pathankot Loop',NULL,' ','336','59811',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('322','1359 Zhoushan Parkway',NULL,' ','545','29763',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('323','1769 Iwaki Lane',NULL,' ','97','25787',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('324','1145 Vilnius Manor',NULL,' ','451','73170',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('325','1892 Nabereznyje Telny Lane',NULL,' ','516','28396',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('326','470 Boksburg Street',NULL,' ','81','97960',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('327','1427 A Corua (La Corua) Place',NULL,' ','45','85799',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('328','479 San Felipe del Progreso Avenue',NULL,' ','130','54949',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('329','867 Benin City Avenue',NULL,' ','591','78543',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('330','981 Kumbakonam Place',NULL,' ','89','87611',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('331','1016 Iwakuni Street',NULL,' ','269','49833',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('332','663 Baha Blanca Parkway',NULL,' ','5','33463',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('333','1860 Taguig Loop',NULL,' ','119','59550',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('334','1816 Bydgoszcz Loop',NULL,' ','234','64308',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('335','587 Benguela Manor',NULL,' ','42','91590',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('336','430 Kumbakonam Drive',NULL,' ','457','28814',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('337','1838 Tabriz Lane',NULL,' ','143','1195',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('338','431 Szkesfehrvr Avenue',NULL,' ','48','57828',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('339','503 Sogamoso Loop',NULL,' ','505','49812',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('340','507 Smolensk Loop',NULL,' ','492','22971',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('341','1920 Weifang Avenue',NULL,' ','427','15643',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('342','124 al-Manama Way',NULL,' ','382','52368',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('343','1443 Mardan Street',NULL,' ','392','31483',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('344','1909 Benguela Lane',NULL,' ','581','19913',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('345','68 Ponce Parkway',NULL,' ','201','85926',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('346','1217 Konotop Avenue',NULL,' ','151','504',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('347','1293 Nam Dinh Way',NULL,' ','84','71583',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('348','785 Vaduz Street',NULL,' ','335','36170',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('349','1516 Escobar Drive',NULL,' ','370','46069',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('350','1628 Nagareyama Lane',NULL,' ','453','60079',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('351','1157 Nyeri Loop',NULL,' ','320','56380',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('352','1673 Tangail Drive',NULL,' ','137','26857',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('353','381 Kabul Way',NULL,' ','209','87272',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('354','953 Hodeida Street',NULL,' ','221','18841',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('355','469 Nakhon Sawan Street',NULL,' ','531','58866',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('356','1378 Beira Loop',NULL,' ','597','40792',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('357','1641 Changhwa Place',NULL,' ','52','37636',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('358','1698 Southport Loop',NULL,' ','393','49009',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('359','519 Nyeri Manor',NULL,' ','461','37650',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('360','619 Hunuco Avenue',NULL,' ','331','81508',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('361','45 Aparecida de Goinia Place',NULL,' ','464','7431',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('362','482 Kowloon and New Kowloon Manor',NULL,' ','90','97056',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('363','604 Bern Place',NULL,' ','429','5373',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('364','1623 Kingstown Drive',NULL,' ','20','91299',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('365','1009 Zanzibar Lane',NULL,' ','32','64875',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('366','114 Jalib al-Shuyukh Manor',NULL,' ','585','60440',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('367','1163 London Parkway',NULL,' ','66','6066',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('368','1658 Jastrzebie-Zdrj Loop',NULL,' ','372','96584',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('369','817 Laredo Avenue',NULL,' ','188','77449',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('370','1565 Tangail Manor',NULL,' ','377','45750',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('371','1912 Emeishan Drive',NULL,' ','50','33050',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('372','230 Urawa Drive',NULL,' ','8','2738',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('373','1922 Miraj Way',NULL,' ','356','13203',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('374','433 Florencia Street',NULL,' ','250','91330',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('375','1049 Matamoros Parkway',NULL,' ','191','69640',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('376','1061 Ede Avenue',NULL,' ','98','57810',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('377','154 Oshawa Manor',NULL,' ','415','72771',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('378','1191 Tandil Drive',NULL,' ','523','6362',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('379','1133 Rizhao Avenue',NULL,' ','572','2800',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('380','1519 Santiago de los Caballeros Loop',NULL,' ','348','22025',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('381','1618 Olomouc Manor',NULL,' ','285','26385',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('382','220 Hidalgo Drive',NULL,' ','265','45298',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('383','686 Donostia-San Sebastin Lane',NULL,' ','471','97390',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('384','97 Mogiljov Lane',NULL,' ','73','89294',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('385','1642 Charlotte Amalie Drive',NULL,' ','549','75442',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('386','1368 Maracabo Boulevard',NULL,' ','493','32716',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('387','401 Sucre Boulevard',NULL,' ','322','25007',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('388','368 Hunuco Boulevard',NULL,' ','360','17165',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('389','500 Lincoln Parkway',NULL,' ','210','95509',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('390','102 Chapra Drive',NULL,' ','521','14073',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('391','1793 Meixian Place',NULL,' ','258','33535',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('392','514 Ife Way',NULL,' ','315','69973',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('393','717 Changzhou Lane',NULL,' ','104','21615',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('394','753 Ilorin Avenue',NULL,' ','157','3656',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('395','1337 Mit Ghamr Avenue',NULL,' ','358','29810',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('396','767 Pyongyang Drive',NULL,' ','229','83536',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('397','614 Pak Kret Street',NULL,' ','6','27796',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('398','954 Lapu-Lapu Way',NULL,' ','278','8816',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('399','331 Bydgoszcz Parkway',NULL,' ','181','966',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('400','1152 Citrus Heights Manor',NULL,' ','15','5239',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('401','168 Cianjur Manor',NULL,' ','228','73824',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('402','616 Hagonoy Avenue',NULL,' ','39','46043',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('403','1190 0 Place',NULL,' ','44','10417',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('404','734 Bchar Place',NULL,' ','375','30586',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('405','530 Lausanne Lane',NULL,' ','135','11067',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('406','454 Patiala Lane',NULL,' ','276','13496',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('407','1346 Mysore Drive',NULL,' ','92','61507',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('408','990 Etawah Loop',NULL,' ','564','79940',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('409','1266 Laredo Parkway',NULL,' ','380','7664',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('410','88 Nagaon Manor',NULL,' ','524','86868',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('411','264 Bhimavaram Manor',NULL,' ','111','54749',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('412','1639 Saarbrcken Drive',NULL,' ','437','9827',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('413','692 Amroha Drive',NULL,' ','230','35575',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('414','1936 Lapu-Lapu Parkway',NULL,' ','141','7122',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('415','432 Garden Grove Street',NULL,' ','430','65630',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('416','1445 Carmen Parkway',NULL,' ','117','70809',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('417','791 Salinas Street',NULL,' ','208','40509',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('418','126 Acua Parkway',NULL,' ','71','58888',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('419','397 Sunnyvale Avenue',NULL,' ','19','55566',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('420','992 Klerksdorp Loop',NULL,' ','23','33711',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('421','966 Arecibo Loop',NULL,' ','134','94018',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('422','289 Santo Andr Manor',NULL,' ','16','72410',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('423','437 Chungho Drive',NULL,' ','450','59489',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('424','1948 Bayugan Parkway',NULL,' ','264','60622',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('425','1866 al-Qatif Avenue',NULL,' ','155','89420',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('426','1661 Abha Drive',NULL,' ','416','14400',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('427','1557 Cape Coral Parkway',NULL,' ','293','46875',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('428','1727 Matamoros Place',NULL,' ','465','78813',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('429','1269 Botosani Manor',NULL,' ','468','47394',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('430','355 Vitria de Santo Anto Way',NULL,' ','452','81758',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('431','1596 Acua Parkway',NULL,' ','418','70425',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('432','259 Ipoh Drive',NULL,' ','189','64964',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('433','1823 Hoshiarpur Lane',NULL,' ','510','33191',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('434','1404 Taguig Drive',NULL,' ','547','87212',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('435','740 Udaipur Lane',NULL,' ','150','33505',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('436','287 Cuautla Boulevard',NULL,' ','501','72736',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('437','1766 Almirante Brown Street',NULL,' ','364','63104',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('438','596 Huixquilucan Place',NULL,' ','351','65892',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('439','1351 Aparecida de Goinia Parkway',NULL,' ','391','41775',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('440','722 Bradford Lane',NULL,' ','249','90920',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('441','983 Santa F Way',NULL,' ','565','47472',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('442','1245 Ibirit Way',NULL,' ','290','40926',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('443','1836 Korla Parkway',NULL,' ','272','55405',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('444','231 Kaliningrad Place',NULL,' ','70','57833',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('445','495 Bhimavaram Lane',NULL,' ','144','3',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('446','1924 Shimonoseki Drive',NULL,' ','59','52625',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('447','105 Dzerzinsk Manor',NULL,' ','540','48570',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('448','614 Denizli Parkway',NULL,' ','486','29444',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('449','1289 Belm Boulevard',NULL,' ','530','88306',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('450','203 Tambaram Street',NULL,' ','161','73942',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('451','1704 Tambaram Manor',NULL,' ','554','2834',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('452','207 Cuernavaca Loop',NULL,' ','352','52671',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('453','319 Springs Loop',NULL,' ','160','99552',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('454','956 Nam Dinh Manor',NULL,' ','481','21872',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('455','1947 Paarl Way',NULL,' ','509','23636',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('456','814 Simferopol Loop',NULL,' ','154','48745',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('457','535 Ahmadnagar Manor',NULL,' ','3','41136',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('458','138 Caracas Boulevard',NULL,' ','326','16790',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('459','251 Florencia Drive',NULL,' ','556','16119',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('460','659 Gatineau Boulevard',NULL,' ','153','28587',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('461','1889 Valparai Way',NULL,' ','600','75559',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('462','1485 Bratislava Place',NULL,' ','435','83183',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('463','935 Aden Boulevard',NULL,' ','532','64709',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('464','76 Kermanshah Manor',NULL,' ','423','23343',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('465','734 Tanshui Avenue',NULL,' ','170','70664',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('466','118 Jaffna Loop',NULL,' ','182','10447',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('467','1621 Tongliao Avenue',NULL,' ','558','22173',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('468','1844 Usak Avenue',NULL,' ','196','84461',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('469','1872 Toulon Loop',NULL,' ','428','7939',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('470','1088 Ibirit Place',NULL,' ','595','88502',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('471','1322 Mosul Parkway',NULL,' ','145','95400',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('472','1447 Chatsworth Place',NULL,' ','129','41545',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('473','1257 Guadalajara Street',NULL,' ','78','33599',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('474','1469 Plock Lane',NULL,' ','388','95835',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('475','434 Ourense (Orense) Manor',NULL,' ','206','14122',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('476','270 Tambaram Parkway',NULL,' ','244','9668',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('477','1786 Salinas Place',NULL,' ','359','66546',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('478','1078 Stara Zagora Drive',NULL,' ','301','69221',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('479','1854 Okara Boulevard',NULL,' ','158','42123',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('480','421 Yaound Street',NULL,' ','385','11363',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('481','1153 Allende Way',NULL,' ','179','20336',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('482','808 Naala-Porto Parkway',NULL,' ','500','41060',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('483','632 Usolje-Sibirskoje Parkway',NULL,' ','36','73085',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('484','98 Pyongyang Boulevard',NULL,' ','11','88749',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('485','984 Novoterkassk Loop',NULL,' ','180','28165',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('486','64 Korla Street',NULL,' ','347','25145',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('487','1785 So Bernardo do Campo Street',NULL,' ','125','71182',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('488','698 Jelets Boulevard',NULL,' ','142','2596',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('489','1297 Alvorada Parkway',NULL,' ','587','11839',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('490','1909 Dayton Avenue',NULL,' ','469','88513',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('491','1789 Saint-Denis Parkway',NULL,' ','4','8268',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('492','185 Mannheim Lane',NULL,' ','408','23661',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('493','184 Mandaluyong Street',NULL,' ','288','94239',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('494','591 Sungai Petani Drive',NULL,' ','376','46400',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('495','656 Matamoros Drive',NULL,' ','487','19489',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('496','775 ostka Drive',NULL,' ','337','22358',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('497','1013 Tabuk Boulevard',NULL,' ','261','96203',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('498','319 Plock Parkway',NULL,' ','504','26101',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('499','1954 Kowloon and New Kowloon Way',NULL,' ','434','63667',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('500','362 Rajkot Lane',NULL,' ','47','98030',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('501','1060 Tandil Lane',NULL,' ','432','72349',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('502','1515 Korla Way',NULL,' ','589','57197',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('503','1416 San Juan Bautista Tuxtepec Avenue',NULL,' ','444','50592',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('504','1 Valle de Santiago Avenue',NULL,' ','93','86208',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('505','519 Brescia Parkway',NULL,' ','318','69504',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('506','414 Mandaluyong Street',NULL,' ','314','16370',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('507','1197 Sokoto Boulevard',NULL,' ','478','87687',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('508','496 Celaya Drive',NULL,' ','552','90797',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('509','786 Matsue Way',NULL,' ','245','37469',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('510','48 Maracabo Place',NULL,' ','519','1570',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('511','1152 al-Qatif Lane',NULL,' ','412','44816',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('512','1269 Ipoh Avenue',NULL,' ','163','54674',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('513','758 Korolev Parkway',NULL,' ','568','75474',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('514','1747 Rustenburg Place',NULL,' ','110','51369',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('515','886 Tonghae Place',NULL,' ','259','19450',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('516','1574 Goinia Boulevard',NULL,' ','502','39529',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('517','548 Uruapan Street',NULL,' ','312','35653',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('519','962 Tama Loop',NULL,' ','583','65952',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('520','1778 Gijn Manor',NULL,' ','594','35156',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('521','568 Dhule (Dhulia) Loop',NULL,' ','127','92568',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('522','1768 Udine Loop',NULL,' ','60','32347',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('523','608 Birgunj Parkway',NULL,' ','116','400',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('524','680 A Corua (La Corua) Manor',NULL,' ','482','49806',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('525','1949 Sanya Street',NULL,' ','224','61244',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('526','617 Klerksdorp Place',NULL,' ','366','94707',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('527','1993 0 Loop',NULL,' ','588','41214',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('528','1176 Southend-on-Sea Manor',NULL,' ','458','81651',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('529','600 Purnea (Purnia) Avenue',NULL,' ','571','18043',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('530','1003 Qinhuangdao Street',NULL,' ','419','25972',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('531','1986 Sivas Place',NULL,' ','551','95775',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('532','1427 Tabuk Place',NULL,' ','101','31342',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('533','556 Asuncin Way',NULL,' ','339','35364',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('534','486 Ondo Parkway',NULL,' ','67','35202',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('535','635 Brest Manor',NULL,' ','75','40899',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('536','166 Jinchang Street',NULL,' ','165','86760',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('537','958 Sagamihara Lane',NULL,' ','287','88408',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('538','1817 Livorno Way',NULL,' ','100','79401',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('539','1332 Gaziantep Lane',NULL,' ','80','22813',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('540','949 Allende Lane',NULL,' ','24','67521',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('541','195 Ilorin Street',NULL,' ','363','49250',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('542','193 Bhusawal Place',NULL,' ','539','9750',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('543','43 Vilnius Manor',NULL,' ','42','79814',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('544','183 Haiphong Street',NULL,' ','46','69953',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('545','163 Augusta-Richmond County Loop',NULL,' ','561','33030',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('546','191 Jos Azueta Parkway',NULL,' ','436','13629',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('547','379 Lublin Parkway',NULL,' ','309','74568',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('548','1658 Cuman Loop',NULL,' ','396','51309',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('549','454 Qinhuangdao Drive',NULL,' ','68','25866',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('550','1715 Okayama Street',NULL,' ','485','55676',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('551','182 Nukualofa Drive',NULL,' ','275','15414',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('552','390 Wroclaw Way',NULL,' ','462','5753',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('553','1421 Quilmes Lane',NULL,' ','260','19151',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('554','947 Trshavn Place',NULL,' ','528','841',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('555','1764 Jalib al-Shuyukh Parkway',NULL,' ','459','77642',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('556','346 Cam Ranh Avenue',NULL,' ','599','39976',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('557','1407 Pachuca de Soto Place',NULL,' ','21','26284',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('558','904 Clarksville Drive',NULL,' ','193','52234',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('559','1917 Kumbakonam Parkway',NULL,' ','368','11892',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('560','1447 Imus Place',NULL,' ','426','12905',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('561','1497 Fengshan Drive',NULL,' ','112','63022',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('562','869 Shikarpur Way',NULL,' ','496','57380',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('563','1059 Yuncheng Avenue',NULL,' ','570','47498',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('564','505 Madiun Boulevard',NULL,' ','577','97271',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('565','1741 Hoshiarpur Boulevard',NULL,' ','79','22372',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('566','1229 Varanasi (Benares) Manor',NULL,' ','43','40195',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('567','1894 Boa Vista Way',NULL,' ','178','77464',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('568','1342 Sharja Way',NULL,' ','488','93655',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('569','1342 Abha Boulevard',NULL,' ','95','10714',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('570','415 Pune Avenue',NULL,' ','580','44274',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('571','1746 Faaa Way',NULL,' ','214','32515',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('572','539 Hami Way',NULL,' ','538','52196',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('573','1407 Surakarta Manor',NULL,' ','466','33224',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('574','502 Mandi Bahauddin Parkway',NULL,' ','55','15992',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('575','1052 Pathankot Avenue',NULL,' ','299','77397',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('576','1351 Sousse Lane',NULL,' ','341','37815',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('577','1501 Pangkal Pinang Avenue',NULL,' ','409','943',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('578','1405 Hagonoy Avenue',NULL,' ','133','86587',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('579','521 San Juan Bautista Tuxtepec Place',NULL,' ','598','95093',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('580','923 Tangail Boulevard',NULL,' ','10','33384',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('581','186 Skikda Lane',NULL,' ','131','89422',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('582','1568 Celaya Parkway',NULL,' ','168','34750',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('583','1489 Kakamigahara Lane',NULL,' ','526','98883',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('584','1819 Alessandria Loop',NULL,' ','103','53829',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('585','1208 Tama Loop',NULL,' ','344','73605',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('586','951 Springs Lane',NULL,' ','219','96115',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('587','760 Miyakonojo Drive',NULL,' ','246','64682',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('588','966 Asuncin Way',NULL,' ','212','62703',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('589','1584 Ljubertsy Lane',NULL,' ','494','22954',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('590','247 Jining Parkway',NULL,' ','54','53446',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('591','773 Dallas Manor',NULL,' ','424','12664',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('592','1923 Stara Zagora Lane',NULL,' ','546','95179',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('593','1402 Zanzibar Boulevard',NULL,' ','106','71102',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('594','1464 Kursk Parkway',NULL,' ','574','17381',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('595','1074 Sanaa Parkway',NULL,' ','311','22474',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('596','1759 Niznekamsk Avenue',NULL,' ','14','39414',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('597','32 Liaocheng Way',NULL,' ','248','1944',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('598','42 Fontana Avenue',NULL,' ','512','14684',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('599','1895 Zhezqazghan Drive',NULL,' ','177','36693',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('600','1837 Kaduna Parkway',NULL,' ','241','82580',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('601','844 Bucuresti Place',NULL,' ','242','36603',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('602','1101 Bucuresti Boulevard',NULL,' ','401','97661',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('603','1103 Quilmes Boulevard',NULL,' ','503','52137',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('604','1331 Usak Boulevard',NULL,' ','296','61960',' ','2006-02-15T04:45:30.000')
;
Insert into address
 (address_id,address,address2,district,city_id,postal_code,phone,last_update)
Values
 ('605','1325 Fukuyama Street',NULL,' ','537','27107',' ','2006-02-15T04:45:30.000')
;
SET IDENTITY_INSERT address OFF

-- End of Script
--
--
-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table country
-- Start of script

SET IDENTITY_INSERT actor ON

Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('1','PENELOPE','GUINESS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('2','NICK','WAHLBERG','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('3','ED','CHASE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('4','JENNIFER','DAVIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('5','JOHNNY','LOLLOBRIGIDA','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('6','BETTE','NICHOLSON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('7','GRACE','MOSTEL','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('8','MATTHEW','JOHANSSON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('9','JOE','SWANK','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('10','CHRISTIAN','GABLE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('11','ZERO','CAGE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('12','KARL','BERRY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('13','UMA','WOOD','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('14','VIVIEN','BERGEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('15','CUBA','OLIVIER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('16','FRED','COSTNER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('17','HELEN','VOIGHT','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('18','DAN','TORN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('19','BOB','FAWCETT','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('20','LUCILLE','TRACY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('21','KIRSTEN','PALTROW','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('22','ELVIS','MARX','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('23','SANDRA','KILMER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('24','CAMERON','STREEP','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('25','KEVIN','BLOOM','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('26','RIP','CRAWFORD','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('27','JULIA','MCQUEEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('28','WOODY','HOFFMAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('29','ALEC','WAYNE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('30','SANDRA','PECK','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('31','SISSY','SOBIESKI','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('32','TIM','HACKMAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('33','MILLA','PECK','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('34','AUDREY','OLIVIER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('35','JUDY','DEAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('36','BURT','DUKAKIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('37','VAL','BOLGER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('38','TOM','MCKELLEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('39','GOLDIE','BRODY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('40','JOHNNY','CAGE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('41','JODIE','DEGENERES','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('42','TOM','MIRANDA','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('43','KIRK','JOVOVICH','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('44','NICK','STALLONE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('45','REESE','KILMER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('46','PARKER','GOLDBERG','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('47','JULIA','BARRYMORE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('48','FRANCES','DAY-LEWIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('49','ANNE','CRONYN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('50','NATALIE','HOPKINS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('51','GARY','PHOENIX','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('52','CARMEN','HUNT','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('53','MENA','TEMPLE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('54','PENELOPE','PINKETT','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('55','FAY','KILMER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('56','DAN','HARRIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('57','JUDE','CRUISE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('58','CHRISTIAN','AKROYD','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('59','DUSTIN','TAUTOU','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('60','HENRY','BERRY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('61','CHRISTIAN','NEESON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('62','JAYNE','NEESON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('63','CAMERON','WRAY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('64','RAY','JOHANSSON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('65','ANGELA','HUDSON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('66','MARY','TANDY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('67','JESSICA','BAILEY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('68','RIP','WINSLET','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('69','KENNETH','PALTROW','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('70','MICHELLE','MCCONAUGHEY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('71','ADAM','GRANT','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('72','SEAN','WILLIAMS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('73','GARY','PENN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('74','MILLA','KEITEL','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('75','BURT','POSEY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('76','ANGELINA','ASTAIRE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('77','CARY','MCCONAUGHEY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('78','GROUCHO','SINATRA','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('79','MAE','HOFFMAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('80','RALPH','CRUZ','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('81','SCARLETT','DAMON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('82','WOODY','JOLIE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('83','BEN','WILLIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('84','JAMES','PITT','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('85','MINNIE','ZELLWEGER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('86','GREG','CHAPLIN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('87','SPENCER','PECK','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('88','KENNETH','PESCI','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('89','CHARLIZE','DENCH','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('90','SEAN','GUINESS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('91','CHRISTOPHER','BERRY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('92','KIRSTEN','AKROYD','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('93','ELLEN','PRESLEY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('94','KENNETH','TORN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('95','DARYL','WAHLBERG','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('96','GENE','WILLIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('97','MEG','HAWKE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('98','CHRIS','BRIDGES','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('99','JIM','MOSTEL','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('100','SPENCER','DEPP','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('101','SUSAN','DAVIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('102','WALTER','TORN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('103','MATTHEW','LEIGH','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('104','PENELOPE','CRONYN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('105','SIDNEY','CROWE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('106','GROUCHO','DUNST','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('107','GINA','DEGENERES','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('108','WARREN','NOLTE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('109','SYLVESTER','DERN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('110','SUSAN','DAVIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('111','CAMERON','ZELLWEGER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('112','RUSSELL','BACALL','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('113','MORGAN','HOPKINS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('114','MORGAN','MCDORMAND','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('115','HARRISON','BALE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('116','DAN','STREEP','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('117','RENEE','TRACY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('118','CUBA','ALLEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('119','WARREN','JACKMAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('120','PENELOPE','MONROE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('121','LIZA','BERGMAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('122','SALMA','NOLTE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('123','JULIANNE','DENCH','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('124','SCARLETT','BENING','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('125','ALBERT','NOLTE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('126','FRANCES','TOMEI','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('127','KEVIN','GARLAND','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('128','CATE','MCQUEEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('129','DARYL','CRAWFORD','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('130','GRETA','KEITEL','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('131','JANE','JACKMAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('132','ADAM','HOPPER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('133','RICHARD','PENN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('134','GENE','HOPKINS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('135','RITA','REYNOLDS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('136','ED','MANSFIELD','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('137','MORGAN','WILLIAMS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('138','LUCILLE','DEE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('139','EWAN','GOODING','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('140','WHOOPI','HURT','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('141','CATE','HARRIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('142','JADA','RYDER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('143','RIVER','DEAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('144','ANGELA','WITHERSPOON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('145','KIM','ALLEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('146','ALBERT','JOHANSSON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('147','FAY','WINSLET','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('148','EMILY','DEE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('149','RUSSELL','TEMPLE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('150','JAYNE','NOLTE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('151','GEOFFREY','HESTON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('152','BEN','HARRIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('153','MINNIE','KILMER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('154','MERYL','GIBSON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('155','IAN','TANDY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('156','FAY','WOOD','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('157','GRETA','MALDEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('158','VIVIEN','BASINGER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('159','LAURA','BRODY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('160','CHRIS','DEPP','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('161','HARVEY','HOPE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('162','OPRAH','KILMER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('163','CHRISTOPHER','WEST','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('164','HUMPHREY','WILLIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('165','AL','GARLAND','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('166','NICK','DEGENERES','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('167','LAURENCE','BULLOCK','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('168','WILL','WILSON','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('169','KENNETH','HOFFMAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('170','MENA','HOPPER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('171','OLYMPIA','PFEIFFER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('172','GROUCHO','WILLIAMS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('173','ALAN','DREYFUSS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('174','MICHAEL','BENING','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('175','WILLIAM','HACKMAN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('176','JON','CHASE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('177','GENE','MCKELLEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('178','LISA','MONROE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('179','ED','GUINESS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('180','JEFF','SILVERSTONE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('181','MATTHEW','CARREY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('182','DEBBIE','AKROYD','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('183','RUSSELL','CLOSE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('184','HUMPHREY','GARLAND','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('185','MICHAEL','BOLGER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('186','JULIA','ZELLWEGER','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('187','RENEE','BALL','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('188','ROCK','DUKAKIS','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('189','CUBA','BIRCH','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('190','AUDREY','BAILEY','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('191','GREGORY','GOODING','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('192','JOHN','SUVARI','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('193','BURT','TEMPLE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('194','MERYL','ALLEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('195','JAYNE','SILVERSTONE','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('196','BELA','WALKEN','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('197','REESE','WEST','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('198','MARY','KEITEL','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('199','JULIA','FAWCETT','2006-02-15T04:34:33.000')
;
Insert into actor
 (actor_id,first_name,last_name,last_update)
Values
('200','THORA','TEMPLE','2006-02-15T04:34:33.000')
;
SET IDENTITY_INSERT actor OFF

-- End of Script
--
--
-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table country
-- Start of script

SET IDENTITY_INSERT staff ON

Insert into staff
 (staff_id,first_name,last_name,address_id,picture,email,store_id,active,username,password,last_update)
Values
 ('1','Mike','Hillyer','3',NULL,'Mike.Hillyer@sakilastaff.com','1','1','Mike','8cb2237d0679ca88db6464eac60da96345513964','2006-02-15T04:57:16.000')
;
Insert into staff
 (staff_id,first_name,last_name,address_id,picture,email,store_id,active,username,password,last_update)
Values
 ('2','Jon','Stephens','4',NULL,'Jon.Stephens@sakilastaff.com','2','1','Jon','8cb2237d0679ca88db6464eac60da96345513964','2006-02-15T04:57:16.000')
;
SET IDENTITY_INSERT staff OFF

-- End of Script
--
--
-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table country
-- Start of script

SET IDENTITY_INSERT store ON

Insert into store
 (store_id,manager_staff_id,address_id,last_update)
Values
('1','1','1','2006-02-15T04:57:12.000')
;
Insert into store
 (store_id,manager_staff_id,address_id,last_update)
Values
('2','2','2','2006-02-15T04:57:12.000')
;
SET IDENTITY_INSERT store OFF

-- End of Script
--
--
-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table country
-- Start of script

SET IDENTITY_INSERT category ON

Insert into category
 (category_id,name,last_update)
Values
('1','Action','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('2','Animation','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('3','Children','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('4','Classics','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('5','Comedy','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('6','Documentary','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('7','Drama','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('8','Family','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('9','Foreign','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('10','Games','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('11','Horror','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('12','Music','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('13','New','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('14','Sci-Fi','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('15','Sports','2006-02-15T04:46:27.000')
;
Insert into category
 (category_id,name,last_update)
Values
('16','Travel','2006-02-15T04:46:27.000')
;
SET IDENTITY_INSERT category OFF

-- End of Script
--
--
-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table country
-- Start of script

SET IDENTITY_INSERT film ON

Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('1','ACADEMY DINOSAUR','A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies','2006','1',NULL,'6','0.99','86','20.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('2','ACE GOLDFINGER','A Astounding Epistle of a Database Administrator And a Explorer who must Find a Car in Ancient China','2006','1',NULL,'3','4.99','48','12.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('3','ADAPTATION HOLES','A Astounding Reflection of a Lumberjack And a Car who must Sink a Lumberjack in A Baloon Factory','2006','1',NULL,'7','2.99','50','18.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('4','AFFAIR PREJUDICE','A Fanciful Documentary of a Frisbee And a Lumberjack who must Chase a Monkey in A Shark Tank','2006','1',NULL,'5','2.99','117','26.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('5','AFRICAN EGG','A Fast-Paced Documentary of a Pastry Chef And a Dentist who must Pursue a Forensic Psychologist in The Gulf of Mexico','2006','1',NULL,'6','2.99','130','22.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('6','AGENT TRUMAN','A Intrepid Panorama of a Robot And a Boy who must Escape a Sumo Wrestler in Ancient China','2006','1',NULL,'3','2.99','169','17.99','PG','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('7','AIRPLANE SIERRA','A Touching Saga of a Hunter And a Butler who must Discover a Butler in A Jet Boat','2006','1',NULL,'6','4.99','62','28.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('8','AIRPORT POLLOCK','A Epic Tale of a Moose And a Girl who must Confront a Monkey in Ancient India','2006','1',NULL,'6','4.99','54','15.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('9','ALABAMA DEVIL','A Thoughtful Panorama of a Database Administrator And a Mad Scientist who must Outgun a Mad Scientist in A Jet Boat','2006','1',NULL,'3','2.99','114','21.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('10','ALADDIN CALENDAR','A Action-Packed Tale of a Man And a Lumberjack who must Reach a Feminist in Ancient China','2006','1',NULL,'6','4.99','63','24.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('11','ALAMO VIDEOTAPE','A Boring Epistle of a Butler And a Cat who must Fight a Pastry Chef in A MySQL Convention','2006','1',NULL,'6','0.99','126','16.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('12','ALASKA PHANTOM','A Fanciful Saga of a Hunter And a Pastry Chef who must Vanquish a Boy in Australia','2006','1',NULL,'6','0.99','136','22.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('13','ALI FOREVER','A Action-Packed Drama of a Dentist And a Crocodile who must Battle a Feminist in The Canadian Rockies','2006','1',NULL,'4','4.99','150','21.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('14','ALICE FANTASIA','A Emotional Drama of a A Shark And a Database Administrator who must Vanquish a Pioneer in Soviet Georgia','2006','1',NULL,'6','0.99','94','23.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('15','ALIEN CENTER','A Brilliant Drama of a Cat And a Mad Scientist who must Battle a Feminist in A MySQL Convention','2006','1',NULL,'5','2.99','46','10.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('16','ALLEY EVOLUTION','A Fast-Paced Drama of a Robot And a Composer who must Battle a Astronaut in New Orleans','2006','1',NULL,'6','2.99','180','23.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('17','ALONE TRIP','A Fast-Paced Character Study of a Composer And a Dog who must Outgun a Boat in An Abandoned Fun House','2006','1',NULL,'3','0.99','82','14.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('18','ALTER VICTORY','A Thoughtful Drama of a Composer And a Feminist who must Meet a Secret Agent in The Canadian Rockies','2006','1',NULL,'6','0.99','57','27.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('19','AMADEUS HOLY','A Emotional Display of a Pioneer And a Technical Writer who must Battle a Man in A Baloon','2006','1',NULL,'6','0.99','113','20.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('20','AMELIE HELLFIGHTERS','A Boring Drama of a Woman And a Squirrel who must Conquer a Student in A Baloon','2006','1',NULL,'4','4.99','79','23.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('21','AMERICAN CIRCUS','A Insightful Drama of a Girl And a Astronaut who must Face a Database Administrator in A Shark Tank','2006','1',NULL,'3','4.99','129','17.99','R','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('22','AMISTAD MIDSUMMER','A Emotional Character Study of a Dentist And a Crocodile who must Meet a Sumo Wrestler in California','2006','1',NULL,'6','2.99','85','10.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('23','ANACONDA CONFESSIONS','A Lacklusture Display of a Dentist And a Dentist who must Fight a Girl in Australia','2006','1',NULL,'3','0.99','92','9.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('24','ANALYZE HOOSIERS','A Thoughtful Display of a Explorer And a Pastry Chef who must Overcome a Feminist in The Sahara Desert','2006','1',NULL,'6','2.99','181','19.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('25','ANGELS LIFE','A Thoughtful Display of a Woman And a Astronaut who must Battle a Robot in Berlin','2006','1',NULL,'3','2.99','74','15.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('26','ANNIE IDENTITY','A Amazing Panorama of a Pastry Chef And a Boat who must Escape a Woman in An Abandoned Amusement Park','2006','1',NULL,'3','0.99','86','15.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('27','ANONYMOUS HUMAN','A Amazing Reflection of a Database Administrator And a Astronaut who must Outrace a Database Administrator in A Shark Tank','2006','1',NULL,'7','0.99','179','12.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('28','ANTHEM LUKE','A Touching Panorama of a Waitress And a Woman who must Outrace a Dog in An Abandoned Amusement Park','2006','1',NULL,'5','4.99','91','16.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('29','ANTITRUST TOMATOES','A Fateful Yarn of a Womanizer And a Feminist who must Succumb a Database Administrator in Ancient India','2006','1',NULL,'5','2.99','168','11.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('30','ANYTHING SAVANNAH','A Epic Story of a Pastry Chef And a Woman who must Chase a Feminist in An Abandoned Fun House','2006','1',NULL,'4','2.99','82','27.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('31','APACHE DIVINE','A Awe-Inspiring Reflection of a Pastry Chef And a Teacher who must Overcome a Sumo Wrestler in A U-Boat','2006','1',NULL,'5','4.99','92','16.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('32','APOCALYPSE FLAMINGOS','A Astounding Story of a Dog And a Squirrel who must Defeat a Woman in An Abandoned Amusement Park','2006','1',NULL,'6','4.99','119','11.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('33','APOLLO TEEN','A Action-Packed Reflection of a Crocodile And a Explorer who must Find a Sumo Wrestler in An Abandoned Mine Shaft','2006','1',NULL,'5','2.99','153','15.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('34','ARABIA DOGMA','A Touching Epistle of a Madman And a Mad Cow who must Defeat a Student in Nigeria','2006','1',NULL,'6','0.99','62','29.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('35','ARACHNOPHOBIA ROLLERCOASTER','A Action-Packed Reflection of a Pastry Chef And a Composer who must Discover a Mad Scientist in The First Manned Space Station','2006','1',NULL,'4','2.99','147','24.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('36','ARGONAUTS TOWN','A Emotional Epistle of a Forensic Psychologist And a Butler who must Challenge a Waitress in An Abandoned Mine Shaft','2006','1',NULL,'7','0.99','127','12.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('37','ARIZONA BANG','A Brilliant Panorama of a Mad Scientist And a Mad Cow who must Meet a Pioneer in A Monastery','2006','1',NULL,'3','2.99','121','28.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('38','ARK RIDGEMONT','A Beautiful Yarn of a Pioneer And a Monkey who must Pursue a Explorer in The Sahara Desert','2006','1',NULL,'6','0.99','68','25.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('39','ARMAGEDDON LOST','A Fast-Paced Tale of a Boat And a Teacher who must Succumb a Composer in An Abandoned Mine Shaft','2006','1',NULL,'5','0.99','99','10.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('40','ARMY FLINTSTONES','A Boring Saga of a Database Administrator And a Womanizer who must Battle a Waitress in Nigeria','2006','1',NULL,'4','0.99','148','22.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('41','ARSENIC INDEPENDENCE','A Fanciful Documentary of a Mad Cow And a Womanizer who must Find a Dentist in Berlin','2006','1',NULL,'4','0.99','137','17.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('42','ARTIST COLDBLOODED','A Stunning Reflection of a Robot And a Moose who must Challenge a Woman in California','2006','1',NULL,'5','2.99','170','10.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('43','ATLANTIS CAUSE','A Thrilling Yarn of a Feminist And a Hunter who must Fight a Technical Writer in A Shark Tank','2006','1',NULL,'6','2.99','170','15.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('44','ATTACKS HATE','A Fast-Paced Panorama of a Technical Writer And a Mad Scientist who must Find a Feminist in An Abandoned Mine Shaft','2006','1',NULL,'5','4.99','113','21.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('45','ATTRACTION NEWTON','A Astounding Panorama of a Composer And a Frisbee who must Reach a Husband in Ancient Japan','2006','1',NULL,'5','4.99','83','14.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('46','AUTUMN CROW','A Beautiful Tale of a Dentist And a Mad Cow who must Battle a Moose in The Sahara Desert','2006','1',NULL,'3','4.99','108','13.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('47','BABY HALL','A Boring Character Study of a A Shark And a Girl who must Outrace a Feminist in An Abandoned Mine Shaft','2006','1',NULL,'5','4.99','153','23.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('48','BACKLASH UNDEFEATED','A Stunning Character Study of a Mad Scientist And a Mad Cow who must Kill a Car in A Monastery','2006','1',NULL,'3','4.99','118','24.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('49','BADMAN DAWN','A Emotional Panorama of a Pioneer And a Composer who must Escape a Mad Scientist in A Jet Boat','2006','1',NULL,'6','2.99','162','22.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('50','BAKED CLEOPATRA','A Stunning Drama of a Forensic Psychologist And a Husband who must Overcome a Waitress in A Monastery','2006','1',NULL,'3','2.99','182','20.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('51','BALLOON HOMEWARD','A Insightful Panorama of a Forensic Psychologist And a Mad Cow who must Build a Mad Scientist in The First Manned Space Station','2006','1',NULL,'5','2.99','75','10.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('52','BALLROOM MOCKINGBIRD','A Thrilling Documentary of a Composer And a Monkey who must Find a Feminist in California','2006','1',NULL,'6','0.99','173','29.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('53','BANG KWAI','A Epic Drama of a Madman And a Cat who must Face a A Shark in An Abandoned Amusement Park','2006','1',NULL,'5','2.99','87','25.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('54','BANGER PINOCCHIO','A Awe-Inspiring Drama of a Car And a Pastry Chef who must Chase a Crocodile in The First Manned Space Station','2006','1',NULL,'5','0.99','113','15.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('55','BARBARELLA STREETCAR','A Awe-Inspiring Story of a Feminist And a Cat who must Conquer a Dog in A Monastery','2006','1',NULL,'6','2.99','65','27.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('56','BAREFOOT MANCHURIAN','A Intrepid Story of a Cat And a Student who must Vanquish a Girl in An Abandoned Amusement Park','2006','1',NULL,'6','2.99','129','15.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('57','BASIC EASY','A Stunning Epistle of a Man And a Husband who must Reach a Mad Scientist in A Jet Boat','2006','1',NULL,'4','2.99','90','18.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('58','BEACH HEARTBREAKERS','A Fateful Display of a Womanizer And a Mad Scientist who must Outgun a A Shark in Soviet Georgia','2006','1',NULL,'6','2.99','122','16.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('59','BEAR GRACELAND','A Astounding Saga of a Dog And a Boy who must Kill a Teacher in The First Manned Space Station','2006','1',NULL,'4','2.99','160','20.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('60','BEAST HUNCHBACK','A Awe-Inspiring Epistle of a Student And a Squirrel who must Defeat a Boy in Ancient China','2006','1',NULL,'3','4.99','89','22.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('61','BEAUTY GREASE','A Fast-Paced Display of a Composer And a Moose who must Sink a Robot in An Abandoned Mine Shaft','2006','1',NULL,'5','4.99','175','28.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('62','BED HIGHBALL','A Astounding Panorama of a Lumberjack And a Dog who must Redeem a Woman in An Abandoned Fun House','2006','1',NULL,'5','2.99','106','23.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('63','BEDAZZLED MARRIED','A Astounding Character Study of a Madman And a Robot who must Meet a Mad Scientist in An Abandoned Fun House','2006','1',NULL,'6','0.99','73','21.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('64','BEETHOVEN EXORCIST','A Epic Display of a Pioneer And a Student who must Challenge a Butler in The Gulf of Mexico','2006','1',NULL,'6','0.99','151','26.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('65','BEHAVIOR RUNAWAY','A Unbelieveable Drama of a Student And a Husband who must Outrace a Sumo Wrestler in Berlin','2006','1',NULL,'3','4.99','100','20.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('66','BENEATH RUSH','A Astounding Panorama of a Man And a Monkey who must Discover a Man in The First Manned Space Station','2006','1',NULL,'6','0.99','53','27.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('67','BERETS AGENT','A Taut Saga of a Crocodile And a Boy who must Overcome a Technical Writer in Ancient China','2006','1',NULL,'5','2.99','77','24.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('68','BETRAYED REAR','A Emotional Character Study of a Boat And a Pioneer who must Find a Explorer in A Shark Tank','2006','1',NULL,'5','4.99','122','26.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('69','BEVERLY OUTLAW','A Fanciful Documentary of a Womanizer And a Boat who must Defeat a Madman in The First Manned Space Station','2006','1',NULL,'3','2.99','85','21.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('70','BIKINI BORROWERS','A Astounding Drama of a Astronaut And a Cat who must Discover a Woman in The First Manned Space Station','2006','1',NULL,'7','4.99','142','26.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('71','BILKO ANONYMOUS','A Emotional Reflection of a Teacher And a Man who must Meet a Cat in The First Manned Space Station','2006','1',NULL,'3','4.99','100','25.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('72','BILL OTHERS','A Stunning Saga of a Mad Scientist And a Forensic Psychologist who must Challenge a Squirrel in A MySQL Convention','2006','1',NULL,'6','2.99','93','12.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('73','BINGO TALENTED','A Touching Tale of a Girl And a Crocodile who must Discover a Waitress in Nigeria','2006','1',NULL,'5','2.99','150','22.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('74','BIRCH ANTITRUST','A Fanciful Panorama of a Husband And a Pioneer who must Outgun a Dog in A Baloon','2006','1',NULL,'4','4.99','162','18.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('75','BIRD INDEPENDENCE','A Thrilling Documentary of a Car And a Student who must Sink a Hunter in The Canadian Rockies','2006','1',NULL,'6','4.99','163','14.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('76','BIRDCAGE CASPER','A Fast-Paced Saga of a Frisbee And a Astronaut who must Overcome a Feminist in Ancient India','2006','1',NULL,'4','0.99','103','23.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('77','BIRDS PERDITION','A Boring Story of a Womanizer And a Pioneer who must Face a Dog in California','2006','1',NULL,'5','4.99','61','15.99','G','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('78','BLACKOUT PRIVATE','A Intrepid Yarn of a Pastry Chef And a Mad Scientist who must Challenge a Secret Agent in Ancient Japan','2006','1',NULL,'7','2.99','85','12.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('79','BLADE POLISH','A Thoughtful Character Study of a Frisbee And a Pastry Chef who must Fight a Dentist in The First Manned Space Station','2006','1',NULL,'5','0.99','114','10.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('80','BLANKET BEVERLY','A Emotional Documentary of a Student And a Girl who must Build a Boat in Nigeria','2006','1',NULL,'7','2.99','148','21.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('81','BLINDNESS GUN','A Touching Drama of a Robot And a Dentist who must Meet a Hunter in A Jet Boat','2006','1',NULL,'6','4.99','103','29.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('82','BLOOD ARGONAUTS','A Boring Drama of a Explorer And a Man who must Kill a Lumberjack in A Manhattan Penthouse','2006','1',NULL,'3','0.99','71','13.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('83','BLUES INSTINCT','A Insightful Documentary of a Boat And a Composer who must Meet a Forensic Psychologist in An Abandoned Fun House','2006','1',NULL,'5','2.99','50','18.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('84','BOILED DARES','A Awe-Inspiring Story of a Waitress And a Dog who must Discover a Dentist in Ancient Japan','2006','1',NULL,'7','4.99','102','13.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('85','BONNIE HOLOCAUST','A Fast-Paced Story of a Crocodile And a Robot who must Find a Moose in Ancient Japan','2006','1',NULL,'4','0.99','63','29.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('86','BOOGIE AMELIE','A Lacklusture Character Study of a Husband And a Sumo Wrestler who must Succumb a Technical Writer in The Gulf of Mexico','2006','1',NULL,'6','4.99','121','11.99','R','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('87','BOONDOCK BALLROOM','A Fateful Panorama of a Crocodile And a Boy who must Defeat a Monkey in The Gulf of Mexico','2006','1',NULL,'7','0.99','76','14.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('88','BORN SPINAL','A Touching Epistle of a Frisbee And a Husband who must Pursue a Student in Nigeria','2006','1',NULL,'7','4.99','179','17.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('89','BORROWERS BEDAZZLED','A Brilliant Epistle of a Teacher And a Sumo Wrestler who must Defeat a Man in An Abandoned Fun House','2006','1',NULL,'7','0.99','63','22.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('90','BOULEVARD MOB','A Fateful Epistle of a Moose And a Monkey who must Confront a Lumberjack in Ancient China','2006','1',NULL,'3','0.99','63','11.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('91','BOUND CHEAPER','A Thrilling Panorama of a Database Administrator And a Astronaut who must Challenge a Lumberjack in A Baloon','2006','1',NULL,'5','0.99','98','17.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('92','BOWFINGER GABLES','A Fast-Paced Yarn of a Waitress And a Composer who must Outgun a Dentist in California','2006','1',NULL,'7','4.99','72','19.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('93','BRANNIGAN SUNRISE','A Amazing Epistle of a Moose And a Crocodile who must Outrace a Dog in Berlin','2006','1',NULL,'4','4.99','121','27.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('94','BRAVEHEART HUMAN','A Insightful Story of a Dog And a Pastry Chef who must Battle a Girl in Berlin','2006','1',NULL,'7','2.99','176','14.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('95','BREAKFAST GOLDFINGER','A Beautiful Reflection of a Student And a Student who must Fight a Moose in Berlin','2006','1',NULL,'5','4.99','123','18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('96','BREAKING HOME','A Beautiful Display of a Secret Agent And a Monkey who must Battle a Sumo Wrestler in An Abandoned Mine Shaft','2006','1',NULL,'4','2.99','169','21.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('97','BRIDE INTRIGUE','A Epic Tale of a Robot And a Monkey who must Vanquish a Man in New Orleans','2006','1',NULL,'7','0.99','56','24.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('98','BRIGHT ENCOUNTERS','A Fateful Yarn of a Lumberjack And a Feminist who must Conquer a Student in A Jet Boat','2006','1',NULL,'4','4.99','73','12.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('99','BRINGING HYSTERICAL','A Fateful Saga of a A Shark And a Technical Writer who must Find a Woman in A Jet Boat','2006','1',NULL,'7','2.99','136','14.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('100','BROOKLYN DESERT','A Beautiful Drama of a Dentist And a Composer who must Battle a Sumo Wrestler in The First Manned Space Station','2006','1',NULL,'7','4.99','161','21.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('101','BROTHERHOOD BLANKET','A Fateful Character Study of a Butler And a Technical Writer who must Sink a Astronaut in Ancient Japan','2006','1',NULL,'3','0.99','73','26.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('102','BUBBLE GROSSE','A Awe-Inspiring Panorama of a Crocodile And a Moose who must Confront a Girl in A Baloon','2006','1',NULL,'4','4.99','60','20.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('103','BUCKET BROTHERHOOD','A Amazing Display of a Girl And a Womanizer who must Succumb a Lumberjack in A Baloon Factory','2006','1',NULL,'7','4.99','133','27.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('104','BUGSY SONG','A Awe-Inspiring Character Study of a Secret Agent And a Boat who must Find a Squirrel in The First Manned Space Station','2006','1',NULL,'4','2.99','119','17.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('105','BULL SHAWSHANK','A Fanciful Drama of a Moose And a Squirrel who must Conquer a Pioneer in The Canadian Rockies','2006','1',NULL,'6','0.99','125','21.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('106','BULWORTH COMMANDMENTS','A Amazing Display of a Mad Cow And a Pioneer who must Redeem a Sumo Wrestler in The Outback','2006','1',NULL,'4','2.99','61','14.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('107','BUNCH MINDS','A Emotional Story of a Feminist And a Feminist who must Escape a Pastry Chef in A MySQL Convention','2006','1',NULL,'4','2.99','63','13.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('108','BUTCH PANTHER','A Lacklusture Yarn of a Feminist And a Database Administrator who must Face a Hunter in New Orleans','2006','1',NULL,'6','0.99','67','19.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('109','BUTTERFLY CHOCOLAT','A Fateful Story of a Girl And a Composer who must Conquer a Husband in A Shark Tank','2006','1',NULL,'3','0.99','89','17.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('110','CABIN FLASH','A Stunning Epistle of a Boat And a Man who must Challenge a A Shark in A Baloon Factory','2006','1',NULL,'4','0.99','53','25.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('111','CADDYSHACK JEDI','A Awe-Inspiring Epistle of a Woman And a Madman who must Fight a Robot in Soviet Georgia','2006','1',NULL,'3','0.99','52','17.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('112','CALENDAR GUNFIGHT','A Thrilling Drama of a Frisbee And a Lumberjack who must Sink a Man in Nigeria','2006','1',NULL,'4','4.99','120','22.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('113','CALIFORNIA BIRDS','A Thrilling Yarn of a Database Administrator And a Robot who must Battle a Database Administrator in Ancient India','2006','1',NULL,'4','4.99','75','19.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('114','CAMELOT VACATION','A Touching Character Study of a Woman And a Waitress who must Battle a Pastry Chef in A MySQL Convention','2006','1',NULL,'3','0.99','61','26.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('115','CAMPUS REMEMBER','A Astounding Drama of a Crocodile And a Mad Cow who must Build a Robot in A Jet Boat','2006','1',NULL,'5','2.99','167','27.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('116','CANDIDATE PERDITION','A Brilliant Epistle of a Composer And a Database Administrator who must Vanquish a Mad Scientist in The First Manned Space Station','2006','1',NULL,'4','2.99','70','10.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('117','CANDLES GRAPES','A Fanciful Character Study of a Monkey And a Explorer who must Build a Astronaut in An Abandoned Fun House','2006','1',NULL,'6','4.99','135','15.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('118','CANYON STOCK','A Thoughtful Reflection of a Waitress And a Feminist who must Escape a Squirrel in A Manhattan Penthouse','2006','1',NULL,'7','0.99','85','26.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('119','CAPER MOTIONS','A Fateful Saga of a Moose And a Car who must Pursue a Woman in A MySQL Convention','2006','1',NULL,'6','0.99','176','22.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('120','CARIBBEAN LIBERTY','A Fanciful Tale of a Pioneer And a Technical Writer who must Outgun a Pioneer in A Shark Tank','2006','1',NULL,'3','4.99','92','16.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('121','CAROL TEXAS','A Astounding Character Study of a Composer And a Student who must Overcome a Composer in A Monastery','2006','1',NULL,'4','2.99','151','15.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('122','CARRIE BUNCH','A Amazing Epistle of a Student And a Astronaut who must Discover a Frisbee in The Canadian Rockies','2006','1',NULL,'7','0.99','114','11.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('123','CASABLANCA SUPER','A Amazing Panorama of a Crocodile And a Forensic Psychologist who must Pursue a Secret Agent in The First Manned Space Station','2006','1',NULL,'6','4.99','85','22.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('124','CASPER DRAGONFLY','A Intrepid Documentary of a Boat And a Crocodile who must Chase a Robot in The Sahara Desert','2006','1',NULL,'3','4.99','163','16.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('125','CASSIDY WYOMING','A Intrepid Drama of a Frisbee And a Hunter who must Kill a Secret Agent in New Orleans','2006','1',NULL,'5','2.99','61','19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('126','CASUALTIES ENCINO','A Insightful Yarn of a A Shark And a Pastry Chef who must Face a Boy in A Monastery','2006','1',NULL,'3','4.99','179','16.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('127','CAT CONEHEADS','A Fast-Paced Panorama of a Girl And a A Shark who must Confront a Boy in Ancient India','2006','1',NULL,'5','4.99','112','14.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('128','CATCH AMISTAD','A Boring Reflection of a Lumberjack And a Feminist who must Discover a Woman in Nigeria','2006','1',NULL,'7','0.99','183','10.99','G','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('129','CAUSE DATE','A Taut Tale of a Explorer And a Pastry Chef who must Conquer a Hunter in A MySQL Convention','2006','1',NULL,'3','2.99','179','16.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('130','CELEBRITY HORN','A Amazing Documentary of a Secret Agent And a Astronaut who must Vanquish a Hunter in A Shark Tank','2006','1',NULL,'7','0.99','110','24.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('131','CENTER DINOSAUR','A Beautiful Character Study of a Sumo Wrestler And a Dentist who must Find a Dog in California','2006','1',NULL,'5','4.99','152','12.99','PG','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('132','CHAINSAW UPTOWN','A Beautiful Documentary of a Boy And a Robot who must Discover a Squirrel in Australia','2006','1',NULL,'6','0.99','114','25.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('133','CHAMBER ITALIAN','A Fateful Reflection of a Moose And a Husband who must Overcome a Monkey in Nigeria','2006','1',NULL,'7','4.99','117','14.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('134','CHAMPION FLATLINERS','A Amazing Story of a Mad Cow And a Dog who must Kill a Husband in A Monastery','2006','1',NULL,'4','4.99','51','21.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('135','CHANCE RESURRECTION','A Astounding Story of a Forensic Psychologist And a Forensic Psychologist who must Overcome a Moose in Ancient China','2006','1',NULL,'3','2.99','70','22.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('136','CHAPLIN LICENSE','A Boring Drama of a Dog And a Forensic Psychologist who must Outrace a Explorer in Ancient India','2006','1',NULL,'7','2.99','146','26.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('137','CHARADE DUFFEL','A Action-Packed Display of a Man And a Waitress who must Build a Dog in A MySQL Convention','2006','1',NULL,'3','2.99','66','21.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('138','CHARIOTS CONSPIRACY','A Unbelieveable Epistle of a Robot And a Husband who must Chase a Robot in The First Manned Space Station','2006','1',NULL,'5','2.99','71','29.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('139','CHASING FIGHT','A Astounding Saga of a Technical Writer And a Butler who must Battle a Butler in A Shark Tank','2006','1',NULL,'7','4.99','114','21.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('140','CHEAPER CLYDE','A Emotional Character Study of a Pioneer And a Girl who must Discover a Dog in Ancient Japan','2006','1',NULL,'6','0.99','87','23.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('141','CHICAGO NORTH','A Fateful Yarn of a Mad Cow And a Waitress who must Battle a Student in California','2006','1',NULL,'6','4.99','185','11.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('142','CHICKEN HELLFIGHTERS','A Emotional Drama of a Dog And a Explorer who must Outrace a Technical Writer in Australia','2006','1',NULL,'3','0.99','122','24.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('143','CHILL LUCK','A Lacklusture Epistle of a Boat And a Technical Writer who must Fight a A Shark in The Canadian Rockies','2006','1',NULL,'6','0.99','142','17.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('144','CHINATOWN GLADIATOR','A Brilliant Panorama of a Technical Writer And a Lumberjack who must Escape a Butler in Ancient India','2006','1',NULL,'7','4.99','61','24.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('145','CHISUM BEHAVIOR','A Epic Documentary of a Sumo Wrestler And a Butler who must Kill a Car in Ancient India','2006','1',NULL,'5','4.99','124','25.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('146','CHITTY LOCK','A Boring Epistle of a Boat And a Database Administrator who must Kill a Sumo Wrestler in The First Manned Space Station','2006','1',NULL,'6','2.99','107','24.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('147','CHOCOLAT HARRY','A Action-Packed Epistle of a Dentist And a Moose who must Meet a Mad Cow in Ancient Japan','2006','1',NULL,'5','0.99','101','16.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('148','CHOCOLATE DUCK','A Unbelieveable Story of a Mad Scientist And a Technical Writer who must Discover a Composer in Ancient China','2006','1',NULL,'3','2.99','132','13.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('149','CHRISTMAS MOONSHINE','A Action-Packed Epistle of a Feminist And a Astronaut who must Conquer a Boat in A Manhattan Penthouse','2006','1',NULL,'7','0.99','150','21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('150','CIDER DESIRE','A Stunning Character Study of a Composer And a Mad Cow who must Succumb a Cat in Soviet Georgia','2006','1',NULL,'7','2.99','101','9.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('151','CINCINATTI WHISPERER','A Brilliant Saga of a Pastry Chef And a Hunter who must Confront a Butler in Berlin','2006','1',NULL,'5','4.99','143','26.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('152','CIRCUS YOUTH','A Thoughtful Drama of a Pastry Chef And a Dentist who must Pursue a Girl in A Baloon','2006','1',NULL,'5','2.99','90','13.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('153','CITIZEN SHREK','A Fanciful Character Study of a Technical Writer And a Husband who must Redeem a Robot in The Outback','2006','1',NULL,'7','0.99','165','18.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('154','CLASH FREDDY','A Amazing Yarn of a Composer And a Squirrel who must Escape a Astronaut in Australia','2006','1',NULL,'6','2.99','81','12.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('155','CLEOPATRA DEVIL','A Fanciful Documentary of a Crocodile And a Technical Writer who must Fight a A Shark in A Baloon','2006','1',NULL,'6','0.99','150','26.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('156','CLERKS ANGELS','A Thrilling Display of a Sumo Wrestler And a Girl who must Confront a Man in A Baloon','2006','1',NULL,'3','4.99','164','15.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('157','CLOCKWORK PARADISE','A Insightful Documentary of a Technical Writer And a Feminist who must Challenge a Cat in A Baloon','2006','1',NULL,'7','0.99','143','29.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('158','CLONES PINOCCHIO','A Amazing Drama of a Car And a Robot who must Pursue a Dentist in New Orleans','2006','1',NULL,'6','2.99','124','16.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('159','CLOSER BANG','A Unbelieveable Panorama of a Frisbee And a Hunter who must Vanquish a Monkey in Ancient India','2006','1',NULL,'5','4.99','58','12.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('160','CLUB GRAFFITI','A Epic Tale of a Pioneer And a Hunter who must Escape a Girl in A U-Boat','2006','1',NULL,'4','0.99','65','12.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('161','CLUE GRAIL','A Taut Tale of a Butler And a Mad Scientist who must Build a Crocodile in Ancient China','2006','1',NULL,'6','4.99','70','27.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('162','CLUELESS BUCKET','A Taut Tale of a Car And a Pioneer who must Conquer a Sumo Wrestler in An Abandoned Fun House','2006','1',NULL,'4','2.99','95','13.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('163','CLYDE THEORY','A Beautiful Yarn of a Astronaut And a Frisbee who must Overcome a Explorer in A Jet Boat','2006','1',NULL,'4','0.99','139','29.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('164','COAST RAINBOW','A Astounding Documentary of a Mad Cow And a Pioneer who must Challenge a Butler in The Sahara Desert','2006','1',NULL,'4','0.99','55','20.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('165','COLDBLOODED DARLING','A Brilliant Panorama of a Dentist And a Moose who must Find a Student in The Gulf of Mexico','2006','1',NULL,'7','4.99','70','27.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('166','COLOR PHILADELPHIA','A Thoughtful Panorama of a Car And a Crocodile who must Sink a Monkey in The Sahara Desert','2006','1',NULL,'6','2.99','149','19.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('167','COMA HEAD','A Awe-Inspiring Drama of a Boy And a Frisbee who must Escape a Pastry Chef in California','2006','1',NULL,'6','4.99','109','10.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('168','COMANCHEROS ENEMY','A Boring Saga of a Lumberjack And a Monkey who must Find a Monkey in The Gulf of Mexico','2006','1',NULL,'5','0.99','67','23.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('169','COMFORTS RUSH','A Unbelieveable Panorama of a Pioneer And a Husband who must Meet a Mad Cow in An Abandoned Mine Shaft','2006','1',NULL,'3','2.99','76','19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('170','COMMAND DARLING','A Awe-Inspiring Tale of a Forensic Psychologist And a Woman who must Challenge a Database Administrator in Ancient Japan','2006','1',NULL,'5','4.99','120','28.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('171','COMMANDMENTS EXPRESS','A Fanciful Saga of a Student And a Mad Scientist who must Battle a Hunter in An Abandoned Mine Shaft','2006','1',NULL,'6','4.99','59','13.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('172','CONEHEADS SMOOCHY','A Touching Story of a Womanizer And a Composer who must Pursue a Husband in Nigeria','2006','1',NULL,'7','4.99','112','12.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('173','CONFESSIONS MAGUIRE','A Insightful Story of a Car And a Boy who must Battle a Technical Writer in A Baloon','2006','1',NULL,'7','4.99','65','25.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('174','CONFIDENTIAL INTERVIEW','A Stunning Reflection of a Cat And a Woman who must Find a Astronaut in Ancient Japan','2006','1',NULL,'6','4.99','180','13.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('175','CONFUSED CANDLES','A Stunning Epistle of a Cat And a Forensic Psychologist who must Confront a Pioneer in A Baloon','2006','1',NULL,'3','2.99','122','27.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('176','CONGENIALITY QUEST','A Touching Documentary of a Cat And a Pastry Chef who must Find a Lumberjack in A Baloon','2006','1',NULL,'6','0.99','87','21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('177','CONNECTICUT TRAMP','A Unbelieveable Drama of a Crocodile And a Mad Cow who must Reach a Dentist in A Shark Tank','2006','1',NULL,'4','4.99','172','20.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('178','CONNECTION MICROCOSMOS','A Fateful Documentary of a Crocodile And a Husband who must Face a Husband in The First Manned Space Station','2006','1',NULL,'6','0.99','115','25.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('179','CONQUERER NUTS','A Taut Drama of a Mad Scientist And a Man who must Escape a Pioneer in An Abandoned Mine Shaft','2006','1',NULL,'4','4.99','173','14.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('180','CONSPIRACY SPIRIT','A Awe-Inspiring Story of a Student And a Frisbee who must Conquer a Crocodile in An Abandoned Mine Shaft','2006','1',NULL,'4','2.99','184','27.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('181','CONTACT ANONYMOUS','A Insightful Display of a A Shark And a Monkey who must Face a Database Administrator in Ancient India','2006','1',NULL,'7','2.99','166','10.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('182','CONTROL ANTHEM','A Fateful Documentary of a Robot And a Student who must Battle a Cat in A Monastery','2006','1',NULL,'7','4.99','185','9.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('183','CONVERSATION DOWNHILL','A Taut Character Study of a Husband And a Waitress who must Sink a Squirrel in A MySQL Convention','2006','1',NULL,'4','4.99','112','14.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('184','CORE SUIT','A Unbelieveable Tale of a Car And a Explorer who must Confront a Boat in A Manhattan Penthouse','2006','1',NULL,'3','2.99','92','24.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('185','COWBOY DOOM','A Astounding Drama of a Boy And a Lumberjack who must Fight a Butler in A Baloon','2006','1',NULL,'3','2.99','146','10.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('186','CRAFT OUTFIELD','A Lacklusture Display of a Explorer And a Hunter who must Succumb a Database Administrator in A Baloon Factory','2006','1',NULL,'6','0.99','64','17.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('187','CRANES RESERVOIR','A Fanciful Documentary of a Teacher And a Dog who must Outgun a Forensic Psychologist in A Baloon Factory','2006','1',NULL,'5','2.99','57','12.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('188','CRAZY HOME','A Fanciful Panorama of a Boy And a Woman who must Vanquish a Database Administrator in The Outback','2006','1',NULL,'7','2.99','136','24.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('189','CREATURES SHAKESPEARE','A Emotional Drama of a Womanizer And a Squirrel who must Vanquish a Crocodile in Ancient India','2006','1',NULL,'3','0.99','139','23.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('190','CREEPERS KANE','A Awe-Inspiring Reflection of a Squirrel And a Boat who must Outrace a Car in A Jet Boat','2006','1',NULL,'5','4.99','172','23.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('191','CROOKED FROGMEN','A Unbelieveable Drama of a Hunter And a Database Administrator who must Battle a Crocodile in An Abandoned Amusement Park','2006','1',NULL,'6','0.99','143','27.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('192','CROSSING DIVORCE','A Beautiful Documentary of a Dog And a Robot who must Redeem a Womanizer in Berlin','2006','1',NULL,'4','4.99','50','19.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('193','CROSSROADS CASUALTIES','A Intrepid Documentary of a Sumo Wrestler And a Astronaut who must Battle a Composer in The Outback','2006','1',NULL,'5','2.99','153','20.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('194','CROW GREASE','A Awe-Inspiring Documentary of a Woman And a Husband who must Sink a Database Administrator in The First Manned Space Station','2006','1',NULL,'6','0.99','104','22.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('195','CROWDS TELEMARK','A Intrepid Documentary of a Astronaut And a Forensic Psychologist who must Find a Frisbee in An Abandoned Fun House','2006','1',NULL,'3','4.99','112','16.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('196','CRUELTY UNFORGIVEN','A Brilliant Tale of a Car And a Moose who must Battle a Dentist in Nigeria','2006','1',NULL,'7','0.99','69','29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('197','CRUSADE HONEY','A Fast-Paced Reflection of a Explorer And a Butler who must Battle a Madman in An Abandoned Amusement Park','2006','1',NULL,'4','2.99','112','27.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('198','CRYSTAL BREAKING','A Fast-Paced Character Study of a Feminist And a Explorer who must Face a Pastry Chef in Ancient Japan','2006','1',NULL,'6','2.99','184','22.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('199','CUPBOARD SINNERS','A Emotional Reflection of a Frisbee And a Boat who must Reach a Pastry Chef in An Abandoned Amusement Park','2006','1',NULL,'4','2.99','56','29.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('200','CURTAIN VIDEOTAPE','A Boring Reflection of a Dentist And a Mad Cow who must Chase a Secret Agent in A Shark Tank','2006','1',NULL,'7','0.99','133','27.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('201','CYCLONE FAMILY','A Lacklusture Drama of a Student And a Monkey who must Sink a Womanizer in A MySQL Convention','2006','1',NULL,'7','2.99','176','18.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('202','DADDY PITTSBURGH','A Epic Story of a A Shark And a Student who must Confront a Explorer in The Gulf of Mexico','2006','1',NULL,'5','4.99','161','26.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('203','DAISY MENAGERIE','A Fast-Paced Saga of a Pastry Chef And a Monkey who must Sink a Composer in Ancient India','2006','1',NULL,'5','4.99','84','9.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('204','DALMATIONS SWEDEN','A Emotional Epistle of a Moose And a Hunter who must Overcome a Robot in A Manhattan Penthouse','2006','1',NULL,'4','0.99','106','25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('205','DANCES NONE','A Insightful Reflection of a A Shark And a Dog who must Kill a Butler in An Abandoned Amusement Park','2006','1',NULL,'3','0.99','58','22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('206','DANCING FEVER','A Stunning Story of a Explorer And a Forensic Psychologist who must Face a Crocodile in A Shark Tank','2006','1',NULL,'6','0.99','144','25.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('207','DANGEROUS UPTOWN','A Unbelieveable Story of a Mad Scientist And a Woman who must Overcome a Dog in California','2006','1',NULL,'7','4.99','121','26.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('208','DARES PLUTO','A Fateful Story of a Robot And a Dentist who must Defeat a Astronaut in New Orleans','2006','1',NULL,'7','2.99','89','16.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('209','DARKNESS WAR','A Touching Documentary of a Husband And a Hunter who must Escape a Boy in The Sahara Desert','2006','1',NULL,'6','2.99','99','24.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('210','DARKO DORADO','A Stunning Reflection of a Frisbee And a Husband who must Redeem a Dog in New Orleans','2006','1',NULL,'3','4.99','130','13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('211','DARLING BREAKING','A Brilliant Documentary of a Astronaut And a Squirrel who must Succumb a Student in The Gulf of Mexico','2006','1',NULL,'7','4.99','165','20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('212','DARN FORRESTER','A Fateful Story of a A Shark And a Explorer who must Succumb a Technical Writer in A Jet Boat','2006','1',NULL,'7','4.99','185','14.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('213','DATE SPEED','A Touching Saga of a Composer And a Moose who must Discover a Dentist in A MySQL Convention','2006','1',NULL,'4','0.99','104','19.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('214','DAUGHTER MADIGAN','A Beautiful Tale of a Hunter And a Mad Scientist who must Confront a Squirrel in The First Manned Space Station','2006','1',NULL,'3','4.99','59','13.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('215','DAWN POND','A Thoughtful Documentary of a Dentist And a Forensic Psychologist who must Defeat a Waitress in Berlin','2006','1',NULL,'4','4.99','57','27.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('216','DAY UNFAITHFUL','A Stunning Documentary of a Composer And a Mad Scientist who must Find a Technical Writer in A U-Boat','2006','1',NULL,'3','4.99','113','16.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('217','DAZED PUNK','A Action-Packed Story of a Pioneer And a Technical Writer who must Discover a Forensic Psychologist in An Abandoned Amusement Park','2006','1',NULL,'6','4.99','120','20.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('218','DECEIVER BETRAYED','A Taut Story of a Moose And a Squirrel who must Build a Husband in Ancient India','2006','1',NULL,'7','0.99','122','22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('219','DEEP CRUSADE','A Amazing Tale of a Crocodile And a Squirrel who must Discover a Composer in Australia','2006','1',NULL,'6','4.99','51','20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('220','DEER VIRGINIAN','A Thoughtful Story of a Mad Cow And a Womanizer who must Overcome a Mad Scientist in Soviet Georgia','2006','1',NULL,'7','2.99','106','13.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('221','DELIVERANCE MULHOLLAND','A Astounding Saga of a Monkey And a Moose who must Conquer a Butler in A Shark Tank','2006','1',NULL,'4','0.99','100','9.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('222','DESERT POSEIDON','A Brilliant Documentary of a Butler And a Frisbee who must Build a Astronaut in New Orleans','2006','1',NULL,'4','4.99','64','27.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('223','DESIRE ALIEN','A Fast-Paced Tale of a Dog And a Forensic Psychologist who must Meet a Astronaut in The First Manned Space Station','2006','1',NULL,'7','2.99','76','24.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('224','DESPERATE TRAINSPOTTING','A Epic Yarn of a Forensic Psychologist And a Teacher who must Face a Lumberjack in California','2006','1',NULL,'7','4.99','81','29.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('225','DESTINATION JERK','A Beautiful Yarn of a Teacher And a Cat who must Build a Car in A U-Boat','2006','1',NULL,'3','0.99','76','19.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('226','DESTINY SATURDAY','A Touching Drama of a Crocodile And a Crocodile who must Conquer a Explorer in Soviet Georgia','2006','1',NULL,'4','4.99','56','20.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('227','DETAILS PACKER','A Epic Saga of a Waitress And a Composer who must Face a Boat in A U-Boat','2006','1',NULL,'4','4.99','88','17.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('228','DETECTIVE VISION','A Fanciful Documentary of a Pioneer And a Woman who must Redeem a Hunter in Ancient Japan','2006','1',NULL,'4','0.99','143','16.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('229','DEVIL DESIRE','A Beautiful Reflection of a Monkey And a Dentist who must Face a Database Administrator in Ancient Japan','2006','1',NULL,'6','4.99','87','12.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('230','DIARY PANIC','A Thoughtful Character Study of a Frisbee And a Mad Cow who must Outgun a Man in Ancient India','2006','1',NULL,'7','2.99','107','20.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('231','DINOSAUR SECRETARY','A Action-Packed Drama of a Feminist And a Girl who must Reach a Robot in The Canadian Rockies','2006','1',NULL,'7','2.99','63','27.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('232','DIRTY ACE','A Action-Packed Character Study of a Forensic Psychologist And a Girl who must Build a Dentist in The Outback','2006','1',NULL,'7','2.99','147','29.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('233','DISCIPLE MOTHER','A Touching Reflection of a Mad Scientist And a Boat who must Face a Moose in A Shark Tank','2006','1',NULL,'3','0.99','141','17.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('234','DISTURBING SCARFACE','A Lacklusture Display of a Crocodile And a Butler who must Overcome a Monkey in A U-Boat','2006','1',NULL,'6','2.99','94','27.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('235','DIVIDE MONSTER','A Intrepid Saga of a Man And a Forensic Psychologist who must Reach a Squirrel in A Monastery','2006','1',NULL,'6','2.99','68','13.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('236','DIVINE RESURRECTION','A Boring Character Study of a Man And a Womanizer who must Succumb a Teacher in An Abandoned Amusement Park','2006','1',NULL,'4','2.99','100','19.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('237','DIVORCE SHINING','A Unbelieveable Saga of a Crocodile And a Student who must Discover a Cat in Ancient India','2006','1',NULL,'3','2.99','47','21.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('238','DOCTOR GRAIL','A Insightful Drama of a Womanizer And a Waitress who must Reach a Forensic Psychologist in The Outback','2006','1',NULL,'4','2.99','57','29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('239','DOGMA FAMILY','A Brilliant Character Study of a Database Administrator And a Monkey who must Succumb a Astronaut in New Orleans','2006','1',NULL,'5','4.99','122','16.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('240','DOLLS RAGE','A Thrilling Display of a Pioneer And a Frisbee who must Escape a Teacher in The Outback','2006','1',NULL,'7','2.99','120','10.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('241','DONNIE ALLEY','A Awe-Inspiring Tale of a Butler And a Frisbee who must Vanquish a Teacher in Ancient Japan','2006','1',NULL,'4','0.99','125','20.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('242','DOOM DANCING','A Astounding Panorama of a Car And a Mad Scientist who must Battle a Lumberjack in A MySQL Convention','2006','1',NULL,'4','0.99','68','13.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('243','DOORS PRESIDENT','A Awe-Inspiring Display of a Squirrel And a Woman who must Overcome a Boy in The Gulf of Mexico','2006','1',NULL,'3','4.99','49','22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('244','DORADO NOTTING','A Action-Packed Tale of a Sumo Wrestler And a A Shark who must Meet a Frisbee in California','2006','1',NULL,'5','4.99','139','26.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('245','DOUBLE WRATH','A Thoughtful Yarn of a Womanizer And a Dog who must Challenge a Madman in The Gulf of Mexico','2006','1',NULL,'4','0.99','177','28.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('246','DOUBTFIRE LABYRINTH','A Intrepid Panorama of a Butler And a Composer who must Meet a Mad Cow in The Sahara Desert','2006','1',NULL,'5','4.99','154','16.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('247','DOWNHILL ENOUGH','A Emotional Tale of a Pastry Chef And a Forensic Psychologist who must Succumb a Monkey in The Sahara Desert','2006','1',NULL,'3','0.99','47','19.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('248','DOZEN LION','A Taut Drama of a Cat And a Girl who must Defeat a Frisbee in The Canadian Rockies','2006','1',NULL,'6','4.99','177','20.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('249','DRACULA CRYSTAL','A Thrilling Reflection of a Feminist And a Cat who must Find a Frisbee in An Abandoned Fun House','2006','1',NULL,'7','0.99','176','26.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('250','DRAGON SQUAD','A Taut Reflection of a Boy And a Waitress who must Outgun a Teacher in Ancient China','2006','1',NULL,'4','0.99','170','26.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('251','DRAGONFLY STRANGERS','A Boring Documentary of a Pioneer And a Man who must Vanquish a Man in Nigeria','2006','1',NULL,'6','4.99','133','19.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('252','DREAM PICKUP','A Epic Display of a Car And a Composer who must Overcome a Forensic Psychologist in The Gulf of Mexico','2006','1',NULL,'6','2.99','135','18.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('253','DRIFTER COMMANDMENTS','A Epic Reflection of a Womanizer And a Squirrel who must Discover a Husband in A Jet Boat','2006','1',NULL,'5','4.99','61','18.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('254','DRIVER ANNIE','A Lacklusture Character Study of a Butler And a Car who must Redeem a Boat in An Abandoned Fun House','2006','1',NULL,'4','2.99','159','11.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('255','DRIVING POLISH','A Action-Packed Yarn of a Feminist And a Technical Writer who must Sink a Boat in An Abandoned Mine Shaft','2006','1',NULL,'6','4.99','175','21.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('256','DROP WATERFRONT','A Fanciful Documentary of a Husband And a Explorer who must Reach a Madman in Ancient China','2006','1',NULL,'6','4.99','178','20.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('257','DRUMLINE CYCLONE','A Insightful Panorama of a Monkey And a Sumo Wrestler who must Outrace a Mad Scientist in The Canadian Rockies','2006','1',NULL,'3','0.99','110','14.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('258','DRUMS DYNAMITE','A Epic Display of a Crocodile And a Crocodile who must Confront a Dog in An Abandoned Amusement Park','2006','1',NULL,'6','0.99','96','11.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('259','DUCK RACER','A Lacklusture Yarn of a Teacher And a Squirrel who must Overcome a Dog in A Shark Tank','2006','1',NULL,'4','2.99','116','15.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('260','DUDE BLINDNESS','A Stunning Reflection of a Husband And a Lumberjack who must Face a Frisbee in An Abandoned Fun House','2006','1',NULL,'3','4.99','132','9.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('261','DUFFEL APOCALYPSE','A Emotional Display of a Boat And a Explorer who must Challenge a Madman in A MySQL Convention','2006','1',NULL,'5','0.99','171','13.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('262','DUMBO LUST','A Touching Display of a Feminist And a Dentist who must Conquer a Husband in The Gulf of Mexico','2006','1',NULL,'5','0.99','119','17.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('263','DURHAM PANKY','A Brilliant Panorama of a Girl And a Boy who must Face a Mad Scientist in An Abandoned Mine Shaft','2006','1',NULL,'6','4.99','154','14.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('264','DWARFS ALTER','A Emotional Yarn of a Girl And a Dog who must Challenge a Composer in Ancient Japan','2006','1',NULL,'6','2.99','101','13.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('265','DYING MAKER','A Intrepid Tale of a Boat And a Monkey who must Kill a Cat in California','2006','1',NULL,'5','4.99','168','28.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('266','DYNAMITE TARZAN','A Intrepid Documentary of a Forensic Psychologist And a Mad Scientist who must Face a Explorer in A U-Boat','2006','1',NULL,'4','0.99','141','27.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('267','EAGLES PANKY','A Thoughtful Story of a Car And a Boy who must Find a A Shark in The Sahara Desert','2006','1',NULL,'4','4.99','140','14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('268','EARLY HOME','A Amazing Panorama of a Mad Scientist And a Husband who must Meet a Woman in The Outback','2006','1',NULL,'6','4.99','96','27.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('269','EARRING INSTINCT','A Stunning Character Study of a Dentist And a Mad Cow who must Find a Teacher in Nigeria','2006','1',NULL,'3','0.99','98','22.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('270','EARTH VISION','A Stunning Drama of a Butler And a Madman who must Outrace a Womanizer in Ancient India','2006','1',NULL,'7','0.99','85','29.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('271','EASY GLADIATOR','A Fateful Story of a Monkey And a Girl who must Overcome a Pastry Chef in Ancient India','2006','1',NULL,'5','4.99','148','12.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('272','EDGE KISSING','A Beautiful Yarn of a Composer And a Mad Cow who must Redeem a Mad Scientist in A Jet Boat','2006','1',NULL,'5','4.99','153','9.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('273','EFFECT GLADIATOR','A Beautiful Display of a Pastry Chef And a Pastry Chef who must Outgun a Forensic Psychologist in A Manhattan Penthouse','2006','1',NULL,'6','0.99','107','14.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('274','EGG IGBY','A Beautiful Documentary of a Boat And a Sumo Wrestler who must Succumb a Database Administrator in The First Manned Space Station','2006','1',NULL,'4','2.99','67','20.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('275','EGYPT TENENBAUMS','A Intrepid Story of a Madman And a Secret Agent who must Outrace a Astronaut in An Abandoned Amusement Park','2006','1',NULL,'3','0.99','85','11.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('276','ELEMENT FREDDY','A Awe-Inspiring Reflection of a Waitress And a Squirrel who must Kill a Mad Cow in A Jet Boat','2006','1',NULL,'6','4.99','115','28.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('277','ELEPHANT TROJAN','A Beautiful Panorama of a Lumberjack And a Forensic Psychologist who must Overcome a Frisbee in A Baloon','2006','1',NULL,'4','4.99','126','24.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('278','ELF MURDER','A Action-Packed Story of a Frisbee And a Woman who must Reach a Girl in An Abandoned Mine Shaft','2006','1',NULL,'4','4.99','155','19.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('279','ELIZABETH SHANE','A Lacklusture Display of a Womanizer And a Dog who must Face a Sumo Wrestler in Ancient Japan','2006','1',NULL,'7','4.99','152','11.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('280','EMPIRE MALKOVICH','A Amazing Story of a Feminist And a Cat who must Face a Car in An Abandoned Fun House','2006','1',NULL,'7','0.99','177','26.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('281','ENCINO ELF','A Astounding Drama of a Feminist And a Teacher who must Confront a Husband in A Baloon','2006','1',NULL,'6','0.99','143','9.99','G','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('282','ENCOUNTERS CURTAIN','A Insightful Epistle of a Pastry Chef And a Womanizer who must Build a Boat in New Orleans','2006','1',NULL,'5','0.99','92','20.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('283','ENDING CROWDS','A Unbelieveable Display of a Dentist And a Madman who must Vanquish a Squirrel in Berlin','2006','1',NULL,'6','0.99','85','10.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('284','ENEMY ODDS','A Fanciful Panorama of a Mad Scientist And a Woman who must Pursue a Astronaut in Ancient India','2006','1',NULL,'5','4.99','77','23.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('285','ENGLISH BULWORTH','A Intrepid Epistle of a Pastry Chef And a Pastry Chef who must Pursue a Crocodile in Ancient China','2006','1',NULL,'3','0.99','51','18.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('286','ENOUGH RAGING','A Astounding Character Study of a Boat And a Secret Agent who must Find a Mad Cow in The Sahara Desert','2006','1',NULL,'7','2.99','158','16.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('287','ENTRAPMENT SATISFACTION','A Thoughtful Panorama of a Hunter And a Teacher who must Reach a Mad Cow in A U-Boat','2006','1',NULL,'5','0.99','176','19.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('288','ESCAPE METROPOLIS','A Taut Yarn of a Astronaut And a Technical Writer who must Outgun a Boat in New Orleans','2006','1',NULL,'7','2.99','167','20.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('289','EVE RESURRECTION','A Awe-Inspiring Yarn of a Pastry Chef And a Database Administrator who must Challenge a Teacher in A Baloon','2006','1',NULL,'5','4.99','66','25.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('290','EVERYONE CRAFT','A Fateful Display of a Waitress And a Dentist who must Reach a Butler in Nigeria','2006','1',NULL,'4','0.99','163','29.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('291','EVOLUTION ALTER','A Fanciful Character Study of a Feminist And a Madman who must Find a Explorer in A Baloon Factory','2006','1',NULL,'5','0.99','174','10.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('292','EXCITEMENT EVE','A Brilliant Documentary of a Monkey And a Car who must Conquer a Crocodile in A Shark Tank','2006','1',NULL,'3','0.99','51','20.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('293','EXORCIST STING','A Touching Drama of a Dog And a Sumo Wrestler who must Conquer a Mad Scientist in Berlin','2006','1',NULL,'6','2.99','167','17.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('294','EXPECATIONS NATURAL','A Amazing Drama of a Butler And a Husband who must Reach a A Shark in A U-Boat','2006','1',NULL,'5','4.99','138','26.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('295','EXPENDABLE STALLION','A Amazing Character Study of a Mad Cow And a Squirrel who must Discover a Hunter in A U-Boat','2006','1',NULL,'3','0.99','97','14.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('296','EXPRESS LONELY','A Boring Drama of a Astronaut And a Boat who must Face a Boat in California','2006','1',NULL,'5','2.99','178','23.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('297','EXTRAORDINARY CONQUERER','A Stunning Story of a Dog And a Feminist who must Face a Forensic Psychologist in Berlin','2006','1',NULL,'6','2.99','122','29.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('298','EYES DRIVING','A Thrilling Story of a Cat And a Waitress who must Fight a Explorer in The Outback','2006','1',NULL,'4','2.99','172','13.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('299','FACTORY DRAGON','A Action-Packed Saga of a Teacher And a Frisbee who must Escape a Lumberjack in The Sahara Desert','2006','1',NULL,'4','0.99','144','9.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('300','FALCON VOLUME','A Fateful Saga of a Sumo Wrestler And a Hunter who must Redeem a A Shark in New Orleans','2006','1',NULL,'5','4.99','102','21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('301','FAMILY SWEET','A Epic Documentary of a Teacher And a Boy who must Escape a Woman in Berlin','2006','1',NULL,'4','0.99','155','24.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('302','FANTASIA PARK','A Thoughtful Documentary of a Mad Scientist And a A Shark who must Outrace a Feminist in Australia','2006','1',NULL,'5','2.99','131','29.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('303','FANTASY TROOPERS','A Touching Saga of a Teacher And a Monkey who must Overcome a Secret Agent in A MySQL Convention','2006','1',NULL,'6','0.99','58','27.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('304','FARGO GANDHI','A Thrilling Reflection of a Pastry Chef And a Crocodile who must Reach a Teacher in The Outback','2006','1',NULL,'3','2.99','130','28.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('305','FATAL HAUNTED','A Beautiful Drama of a Student And a Secret Agent who must Confront a Dentist in Ancient Japan','2006','1',NULL,'6','2.99','91','24.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('306','FEATHERS METAL','A Thoughtful Yarn of a Monkey And a Teacher who must Find a Dog in Australia','2006','1',NULL,'3','0.99','104','12.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('307','FELLOWSHIP AUTUMN','A Lacklusture Reflection of a Dentist And a Hunter who must Meet a Teacher in A Baloon','2006','1',NULL,'6','4.99','77','9.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('308','FERRIS MOTHER','A Touching Display of a Frisbee And a Frisbee who must Kill a Girl in The Gulf of Mexico','2006','1',NULL,'3','2.99','142','13.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('309','FEUD FROGMEN','A Brilliant Reflection of a Database Administrator And a Mad Cow who must Chase a Woman in The Canadian Rockies','2006','1',NULL,'6','0.99','98','29.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('310','FEVER EMPIRE','A Insightful Panorama of a Cat And a Boat who must Defeat a Boat in The Gulf of Mexico','2006','1',NULL,'5','4.99','158','20.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('311','FICTION CHRISTMAS','A Emotional Yarn of a A Shark And a Student who must Battle a Robot in An Abandoned Mine Shaft','2006','1',NULL,'4','0.99','72','14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('312','FIDDLER LOST','A Boring Tale of a Squirrel And a Dog who must Challenge a Madman in The Gulf of Mexico','2006','1',NULL,'4','4.99','75','20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('313','FIDELITY DEVIL','A Awe-Inspiring Drama of a Technical Writer And a Composer who must Reach a Pastry Chef in A U-Boat','2006','1',NULL,'5','4.99','118','11.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('314','FIGHT JAWBREAKER','A Intrepid Panorama of a Womanizer And a Girl who must Escape a Girl in A Manhattan Penthouse','2006','1',NULL,'3','0.99','91','13.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('315','FINDING ANACONDA','A Fateful Tale of a Database Administrator And a Girl who must Battle a Squirrel in New Orleans','2006','1',NULL,'4','0.99','156','10.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('316','FIRE WOLVES','A Intrepid Documentary of a Frisbee And a Dog who must Outrace a Lumberjack in Nigeria','2006','1',NULL,'5','4.99','173','18.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('317','FIREBALL PHILADELPHIA','A Amazing Yarn of a Dentist And a A Shark who must Vanquish a Madman in An Abandoned Mine Shaft','2006','1',NULL,'4','0.99','148','25.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('318','FIREHOUSE VIETNAM','A Awe-Inspiring Character Study of a Boat And a Boy who must Kill a Pastry Chef in The Sahara Desert','2006','1',NULL,'7','0.99','103','14.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('319','FISH OPUS','A Touching Display of a Feminist And a Girl who must Confront a Astronaut in Australia','2006','1',NULL,'4','2.99','125','22.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('320','FLAMINGOS CONNECTICUT','A Fast-Paced Reflection of a Composer And a Composer who must Meet a Cat in The Sahara Desert','2006','1',NULL,'4','4.99','80','28.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('321','FLASH WARS','A Astounding Saga of a Moose And a Pastry Chef who must Chase a Student in The Gulf of Mexico','2006','1',NULL,'3','4.99','123','21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('322','FLATLINERS KILLER','A Taut Display of a Secret Agent And a Waitress who must Sink a Robot in An Abandoned Mine Shaft','2006','1',NULL,'5','2.99','100','29.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('323','FLIGHT LIES','A Stunning Character Study of a Crocodile And a Pioneer who must Pursue a Teacher in New Orleans','2006','1',NULL,'7','4.99','179','22.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('324','FLINTSTONES HAPPINESS','A Fateful Story of a Husband And a Moose who must Vanquish a Boy in California','2006','1',NULL,'3','4.99','148','11.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('325','FLOATS GARDEN','A Action-Packed Epistle of a Robot And a Car who must Chase a Boat in Ancient Japan','2006','1',NULL,'6','2.99','145','29.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('326','FLYING HOOK','A Thrilling Display of a Mad Cow And a Dog who must Challenge a Frisbee in Nigeria','2006','1',NULL,'6','2.99','69','18.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('327','FOOL MOCKINGBIRD','A Lacklusture Tale of a Crocodile And a Composer who must Defeat a Madman in A U-Boat','2006','1',NULL,'3','4.99','158','24.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('328','FOREVER CANDIDATE','A Unbelieveable Panorama of a Technical Writer And a Man who must Pursue a Frisbee in A U-Boat','2006','1',NULL,'7','2.99','131','28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('329','FORREST SONS','A Thrilling Documentary of a Forensic Psychologist And a Butler who must Defeat a Explorer in A Jet Boat','2006','1',NULL,'4','2.99','63','15.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('330','FORRESTER COMANCHEROS','A Fateful Tale of a Squirrel And a Forensic Psychologist who must Redeem a Man in Nigeria','2006','1',NULL,'7','4.99','112','22.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('331','FORWARD TEMPLE','A Astounding Display of a Forensic Psychologist And a Mad Scientist who must Challenge a Girl in New Orleans','2006','1',NULL,'6','2.99','90','25.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('332','FRANKENSTEIN STRANGER','A Insightful Character Study of a Feminist And a Pioneer who must Pursue a Pastry Chef in Nigeria','2006','1',NULL,'7','0.99','159','16.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('333','FREAKY POCUS','A Fast-Paced Documentary of a Pastry Chef And a Crocodile who must Chase a Squirrel in The Gulf of Mexico','2006','1',NULL,'7','2.99','126','16.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('334','FREDDY STORM','A Intrepid Saga of a Man And a Lumberjack who must Vanquish a Husband in The Outback','2006','1',NULL,'6','4.99','65','21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('335','FREEDOM CLEOPATRA','A Emotional Reflection of a Dentist And a Mad Cow who must Face a Squirrel in A Baloon','2006','1',NULL,'5','0.99','133','23.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('336','FRENCH HOLIDAY','A Thrilling Epistle of a Dog And a Feminist who must Kill a Madman in Berlin','2006','1',NULL,'5','4.99','99','22.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('337','FRIDA SLIPPER','A Fateful Story of a Lumberjack And a Car who must Escape a Boat in An Abandoned Mine Shaft','2006','1',NULL,'6','2.99','73','11.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('338','FRISCO FORREST','A Beautiful Documentary of a Woman And a Pioneer who must Pursue a Mad Scientist in A Shark Tank','2006','1',NULL,'6','4.99','51','23.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('339','FROGMEN BREAKING','A Unbelieveable Yarn of a Mad Scientist And a Cat who must Chase a Lumberjack in Australia','2006','1',NULL,'5','0.99','111','17.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('340','FRONTIER CABIN','A Emotional Story of a Madman And a Waitress who must Battle a Teacher in An Abandoned Fun House','2006','1',NULL,'6','4.99','183','14.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('341','FROST HEAD','A Amazing Reflection of a Lumberjack And a Cat who must Discover a Husband in A MySQL Convention','2006','1',NULL,'5','0.99','82','13.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('342','FUGITIVE MAGUIRE','A Taut Epistle of a Feminist And a Sumo Wrestler who must Battle a Crocodile in Australia','2006','1',NULL,'7','4.99','83','28.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('343','FULL FLATLINERS','A Beautiful Documentary of a Astronaut And a Moose who must Pursue a Monkey in A Shark Tank','2006','1',NULL,'6','2.99','94','14.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('344','FURY MURDER','A Lacklusture Reflection of a Boat And a Forensic Psychologist who must Fight a Waitress in A Monastery','2006','1',NULL,'3','0.99','178','28.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('345','GABLES METROPOLIS','A Fateful Display of a Cat And a Pioneer who must Challenge a Pastry Chef in A Baloon Factory','2006','1',NULL,'3','0.99','161','17.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('346','GALAXY SWEETHEARTS','A Emotional Reflection of a Womanizer And a Pioneer who must Face a Squirrel in Berlin','2006','1',NULL,'4','4.99','128','13.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('347','GAMES BOWFINGER','A Astounding Documentary of a Butler And a Explorer who must Challenge a Butler in A Monastery','2006','1',NULL,'7','4.99','119','17.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('348','GANDHI KWAI','A Thoughtful Display of a Mad Scientist And a Secret Agent who must Chase a Boat in Berlin','2006','1',NULL,'7','0.99','86','9.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('349','GANGS PRIDE','A Taut Character Study of a Woman And a A Shark who must Confront a Frisbee in Berlin','2006','1',NULL,'4','2.99','185','27.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('350','GARDEN ISLAND','A Unbelieveable Character Study of a Womanizer And a Madman who must Reach a Man in The Outback','2006','1',NULL,'3','4.99','80','21.99','G','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('351','GASLIGHT CRUSADE','A Amazing Epistle of a Boy And a Astronaut who must Redeem a Man in The Gulf of Mexico','2006','1',NULL,'4','2.99','106','10.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('352','GATHERING CALENDAR','A Intrepid Tale of a Pioneer And a Moose who must Conquer a Frisbee in A MySQL Convention','2006','1',NULL,'4','0.99','176','22.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('353','GENTLEMEN STAGE','A Awe-Inspiring Reflection of a Monkey And a Student who must Overcome a Dentist in The First Manned Space Station','2006','1',NULL,'6','2.99','125','22.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('354','GHOST GROUNDHOG','A Brilliant Panorama of a Madman And a Composer who must Succumb a Car in Ancient India','2006','1',NULL,'6','4.99','85','18.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('355','GHOSTBUSTERS ELF','A Thoughtful Epistle of a Dog And a Feminist who must Chase a Composer in Berlin','2006','1',NULL,'7','0.99','101','18.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('356','GIANT TROOPERS','A Fateful Display of a Feminist And a Monkey who must Vanquish a Monkey in The Canadian Rockies','2006','1',NULL,'5','2.99','102','10.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('357','GILBERT PELICAN','A Fateful Tale of a Man And a Feminist who must Conquer a Crocodile in A Manhattan Penthouse','2006','1',NULL,'7','0.99','114','13.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('358','GILMORE BOILED','A Unbelieveable Documentary of a Boat And a Husband who must Succumb a Student in A U-Boat','2006','1',NULL,'5','0.99','163','29.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('359','GLADIATOR WESTWARD','A Astounding Reflection of a Squirrel And a Sumo Wrestler who must Sink a Dentist in Ancient Japan','2006','1',NULL,'6','4.99','173','20.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('360','GLASS DYING','A Astounding Drama of a Frisbee And a Astronaut who must Fight a Dog in Ancient Japan','2006','1',NULL,'4','0.99','103','24.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('361','GLEAMING JAWBREAKER','A Amazing Display of a Composer And a Forensic Psychologist who must Discover a Car in The Canadian Rockies','2006','1',NULL,'5','2.99','89','25.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('362','GLORY TRACY','A Amazing Saga of a Woman And a Womanizer who must Discover a Cat in The First Manned Space Station','2006','1',NULL,'7','2.99','115','13.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('363','GO PURPLE','A Fast-Paced Display of a Car And a Database Administrator who must Battle a Woman in A Baloon','2006','1',NULL,'3','0.99','54','12.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('364','GODFATHER DIARY','A Stunning Saga of a Lumberjack And a Squirrel who must Chase a Car in The Outback','2006','1',NULL,'3','2.99','73','14.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('365','GOLD RIVER','A Taut Documentary of a Database Administrator And a Waitress who must Reach a Mad Scientist in A Baloon Factory','2006','1',NULL,'4','4.99','154','21.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('366','GOLDFINGER SENSIBILITY','A Insightful Drama of a Mad Scientist And a Hunter who must Defeat a Pastry Chef in New Orleans','2006','1',NULL,'3','0.99','93','29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('367','GOLDMINE TYCOON','A Brilliant Epistle of a Composer And a Frisbee who must Conquer a Husband in The Outback','2006','1',NULL,'6','0.99','153','20.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('368','GONE TROUBLE','A Insightful Character Study of a Mad Cow And a Forensic Psychologist who must Conquer a A Shark in A Manhattan Penthouse','2006','1',NULL,'7','2.99','84','20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('369','GOODFELLAS SALUTE','A Unbelieveable Tale of a Dog And a Explorer who must Sink a Mad Cow in A Baloon Factory','2006','1',NULL,'4','4.99','56','22.99','PG','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('370','GORGEOUS BINGO','A Action-Packed Display of a Sumo Wrestler And a Car who must Overcome a Waitress in A Baloon Factory','2006','1',NULL,'4','2.99','108','26.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('371','GOSFORD DONNIE','A Epic Panorama of a Mad Scientist And a Monkey who must Redeem a Secret Agent in Berlin','2006','1',NULL,'5','4.99','129','17.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('372','GRACELAND DYNAMITE','A Taut Display of a Cat And a Girl who must Overcome a Database Administrator in New Orleans','2006','1',NULL,'5','4.99','140','26.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('373','GRADUATE LORD','A Lacklusture Epistle of a Girl And a A Shark who must Meet a Mad Scientist in Ancient China','2006','1',NULL,'7','2.99','156','14.99','G','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('374','GRAFFITI LOVE','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Build a Composer in Berlin','2006','1',NULL,'3','0.99','117','29.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('375','GRAIL FRANKENSTEIN','A Unbelieveable Saga of a Teacher And a Monkey who must Fight a Girl in An Abandoned Mine Shaft','2006','1',NULL,'4','2.99','85','17.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('376','GRAPES FURY','A Boring Yarn of a Mad Cow And a Sumo Wrestler who must Meet a Robot in Australia','2006','1',NULL,'4','0.99','155','20.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('377','GREASE YOUTH','A Emotional Panorama of a Secret Agent And a Waitress who must Escape a Composer in Soviet Georgia','2006','1',NULL,'7','0.99','135','20.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('378','GREATEST NORTH','A Astounding Character Study of a Secret Agent And a Robot who must Build a A Shark in Berlin','2006','1',NULL,'5','2.99','93','24.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('379','GREEDY ROOTS','A Amazing Reflection of a A Shark And a Butler who must Chase a Hunter in The Canadian Rockies','2006','1',NULL,'7','0.99','166','14.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('380','GREEK EVERYONE','A Stunning Display of a Butler And a Teacher who must Confront a A Shark in The First Manned Space Station','2006','1',NULL,'7','2.99','176','11.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('381','GRINCH MASSAGE','A Intrepid Display of a Madman And a Feminist who must Pursue a Pioneer in The First Manned Space Station','2006','1',NULL,'7','4.99','150','25.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('382','GRIT CLOCKWORK','A Thoughtful Display of a Dentist And a Squirrel who must Confront a Lumberjack in A Shark Tank','2006','1',NULL,'3','0.99','137','21.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('383','GROOVE FICTION','A Unbelieveable Reflection of a Moose And a A Shark who must Defeat a Lumberjack in An Abandoned Mine Shaft','2006','1',NULL,'6','0.99','111','13.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('384','GROSSE WONDERFUL','A Epic Drama of a Cat And a Explorer who must Redeem a Moose in Australia','2006','1',NULL,'5','4.99','49','19.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('385','GROUNDHOG UNCUT','A Brilliant Panorama of a Astronaut And a Technical Writer who must Discover a Butler in A Manhattan Penthouse','2006','1',NULL,'6','4.99','139','26.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('386','GUMP DATE','A Intrepid Yarn of a Explorer And a Student who must Kill a Husband in An Abandoned Mine Shaft','2006','1',NULL,'3','4.99','53','12.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('387','GUN BONNIE','A Boring Display of a Sumo Wrestler And a Husband who must Build a Waitress in The Gulf of Mexico','2006','1',NULL,'7','0.99','100','27.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('388','GUNFIGHT MOON','A Epic Reflection of a Pastry Chef And a Explorer who must Reach a Dentist in The Sahara Desert','2006','1',NULL,'5','0.99','70','16.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('389','GUNFIGHTER MUSSOLINI','A Touching Saga of a Robot And a Boy who must Kill a Man in Ancient Japan','2006','1',NULL,'3','2.99','127','9.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('390','GUYS FALCON','A Boring Story of a Woman And a Feminist who must Redeem a Squirrel in A U-Boat','2006','1',NULL,'4','4.99','84','20.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('391','HALF OUTFIELD','A Epic Epistle of a Database Administrator And a Crocodile who must Face a Madman in A Jet Boat','2006','1',NULL,'6','2.99','146','25.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('392','HALL CASSIDY','A Beautiful Panorama of a Pastry Chef And a A Shark who must Battle a Pioneer in Soviet Georgia','2006','1',NULL,'5','4.99','51','13.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('393','HALLOWEEN NUTS','A Amazing Panorama of a Forensic Psychologist And a Technical Writer who must Fight a Dentist in A U-Boat','2006','1',NULL,'6','2.99','47','19.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('394','HAMLET WISDOM','A Touching Reflection of a Man And a Man who must Sink a Robot in The Outback','2006','1',NULL,'7','2.99','146','21.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('395','HANDICAP BOONDOCK','A Beautiful Display of a Pioneer And a Squirrel who must Vanquish a Sumo Wrestler in Soviet Georgia','2006','1',NULL,'4','0.99','108','28.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('396','HANGING DEEP','A Action-Packed Yarn of a Boat And a Crocodile who must Build a Monkey in Berlin','2006','1',NULL,'5','4.99','62','18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('397','HANKY OCTOBER','A Boring Epistle of a Database Administrator And a Explorer who must Pursue a Madman in Soviet Georgia','2006','1',NULL,'5','2.99','107','26.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('398','HANOVER GALAXY','A Stunning Reflection of a Girl And a Secret Agent who must Succumb a Boy in A MySQL Convention','2006','1',NULL,'5','4.99','47','21.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('399','HAPPINESS UNITED','A Action-Packed Panorama of a Husband And a Feminist who must Meet a Forensic Psychologist in Ancient Japan','2006','1',NULL,'6','2.99','100','23.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('400','HARDLY ROBBERS','A Emotional Character Study of a Hunter And a Car who must Kill a Woman in Berlin','2006','1',NULL,'7','2.99','72','15.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('401','HAROLD FRENCH','A Stunning Saga of a Sumo Wrestler And a Student who must Outrace a Moose in The Sahara Desert','2006','1',NULL,'6','0.99','168','10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('402','HARPER DYING','A Awe-Inspiring Reflection of a Woman And a Cat who must Confront a Feminist in The Sahara Desert','2006','1',NULL,'3','0.99','52','15.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('403','HARRY IDAHO','A Taut Yarn of a Technical Writer And a Feminist who must Outrace a Dog in California','2006','1',NULL,'5','4.99','121','18.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('404','HATE HANDICAP','A Intrepid Reflection of a Mad Scientist And a Pioneer who must Overcome a Hunter in The First Manned Space Station','2006','1',NULL,'4','0.99','107','26.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('405','HAUNTED ANTITRUST','A Amazing Saga of a Man And a Dentist who must Reach a Technical Writer in Ancient India','2006','1',NULL,'6','4.99','76','13.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('406','HAUNTING PIANIST','A Fast-Paced Story of a Database Administrator And a Composer who must Defeat a Squirrel in An Abandoned Amusement Park','2006','1',NULL,'5','0.99','181','22.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('407','HAWK CHILL','A Action-Packed Drama of a Mad Scientist And a Composer who must Outgun a Car in Australia','2006','1',NULL,'5','0.99','47','12.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('408','HEAD STRANGER','A Thoughtful Saga of a Hunter And a Crocodile who must Confront a Dog in The Gulf of Mexico','2006','1',NULL,'4','4.99','69','28.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('409','HEARTBREAKERS BRIGHT','A Awe-Inspiring Documentary of a A Shark And a Dentist who must Outrace a Pastry Chef in The Canadian Rockies','2006','1',NULL,'3','4.99','59','9.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('410','HEAVEN FREEDOM','A Intrepid Story of a Butler And a Car who must Vanquish a Man in New Orleans','2006','1',NULL,'7','2.99','48','19.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('411','HEAVENLY GUN','A Beautiful Yarn of a Forensic Psychologist And a Frisbee who must Battle a Moose in A Jet Boat','2006','1',NULL,'5','4.99','49','13.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('412','HEAVYWEIGHTS BEAST','A Unbelieveable Story of a Composer And a Dog who must Overcome a Womanizer in An Abandoned Amusement Park','2006','1',NULL,'6','4.99','102','25.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('413','HEDWIG ALTER','A Action-Packed Yarn of a Womanizer And a Lumberjack who must Chase a Sumo Wrestler in A Monastery','2006','1',NULL,'7','2.99','169','16.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('414','HELLFIGHTERS SIERRA','A Taut Reflection of a A Shark And a Dentist who must Battle a Boat in Soviet Georgia','2006','1',NULL,'3','2.99','75','23.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('415','HIGH ENCINO','A Fateful Saga of a Waitress And a Hunter who must Outrace a Sumo Wrestler in Australia','2006','1',NULL,'3','2.99','84','23.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('416','HIGHBALL POTTER','A Action-Packed Saga of a Husband And a Dog who must Redeem a Database Administrator in The Sahara Desert','2006','1',NULL,'6','0.99','110','10.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('417','HILLS NEIGHBORS','A Epic Display of a Hunter And a Feminist who must Sink a Car in A U-Boat','2006','1',NULL,'5','0.99','93','29.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('418','HOBBIT ALIEN','A Emotional Drama of a Husband And a Girl who must Outgun a Composer in The First Manned Space Station','2006','1',NULL,'5','0.99','157','27.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('419','HOCUS FRIDA','A Awe-Inspiring Tale of a Girl And a Madman who must Outgun a Student in A Shark Tank','2006','1',NULL,'4','2.99','141','19.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('420','HOLES BRANNIGAN','A Fast-Paced Reflection of a Technical Writer And a Student who must Fight a Boy in The Canadian Rockies','2006','1',NULL,'7','4.99','128','27.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('421','HOLIDAY GAMES','A Insightful Reflection of a Waitress And a Madman who must Pursue a Boy in Ancient Japan','2006','1',NULL,'7','4.99','78','10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('422','HOLLOW JEOPARDY','A Beautiful Character Study of a Robot And a Astronaut who must Overcome a Boat in A Monastery','2006','1',NULL,'7','4.99','136','25.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('423','HOLLYWOOD ANONYMOUS','A Fast-Paced Epistle of a Boy And a Explorer who must Escape a Dog in A U-Boat','2006','1',NULL,'7','0.99','69','29.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('424','HOLOCAUST HIGHBALL','A Awe-Inspiring Yarn of a Composer And a Man who must Find a Robot in Soviet Georgia','2006','1',NULL,'6','0.99','149','12.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('425','HOLY TADPOLE','A Action-Packed Display of a Feminist And a Pioneer who must Pursue a Dog in A Baloon Factory','2006','1',NULL,'6','0.99','88','20.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('426','HOME PITY','A Touching Panorama of a Man And a Secret Agent who must Challenge a Teacher in A MySQL Convention','2006','1',NULL,'7','4.99','185','15.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('427','HOMEWARD CIDER','A Taut Reflection of a Astronaut And a Squirrel who must Fight a Squirrel in A Manhattan Penthouse','2006','1',NULL,'5','0.99','103','19.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('428','HOMICIDE PEACH','A Astounding Documentary of a Hunter And a Boy who must Confront a Boy in A MySQL Convention','2006','1',NULL,'6','2.99','141','21.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('429','HONEY TIES','A Taut Story of a Waitress And a Crocodile who must Outrace a Lumberjack in A Shark Tank','2006','1',NULL,'3','0.99','84','29.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('430','HOOK CHARIOTS','A Insightful Story of a Boy And a Dog who must Redeem a Boy in Australia','2006','1',NULL,'7','0.99','49','23.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('431','HOOSIERS BIRDCAGE','A Astounding Display of a Explorer And a Boat who must Vanquish a Car in The First Manned Space Station','2006','1',NULL,'3','2.99','176','12.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('432','HOPE TOOTSIE','A Amazing Documentary of a Student And a Sumo Wrestler who must Outgun a A Shark in A Shark Tank','2006','1',NULL,'4','2.99','139','22.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('433','HORN WORKING','A Stunning Display of a Mad Scientist And a Technical Writer who must Succumb a Monkey in A Shark Tank','2006','1',NULL,'4','2.99','95','23.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('434','HORROR REIGN','A Touching Documentary of a A Shark And a Car who must Build a Husband in Nigeria','2006','1',NULL,'3','0.99','139','25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('435','HOTEL HAPPINESS','A Thrilling Yarn of a Pastry Chef And a A Shark who must Challenge a Mad Scientist in The Outback','2006','1',NULL,'6','4.99','181','28.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('436','HOURS RAGE','A Fateful Story of a Explorer And a Feminist who must Meet a Technical Writer in Soviet Georgia','2006','1',NULL,'4','0.99','122','14.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('437','HOUSE DYNAMITE','A Taut Story of a Pioneer And a Squirrel who must Battle a Student in Soviet Georgia','2006','1',NULL,'7','2.99','109','13.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('438','HUMAN GRAFFITI','A Beautiful Reflection of a Womanizer And a Sumo Wrestler who must Chase a Database Administrator in The Gulf of Mexico','2006','1',NULL,'3','2.99','68','22.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('439','HUNCHBACK IMPOSSIBLE','A Touching Yarn of a Frisbee And a Dentist who must Fight a Composer in Ancient Japan','2006','1',NULL,'4','4.99','151','28.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('440','HUNGER ROOF','A Unbelieveable Yarn of a Student And a Database Administrator who must Outgun a Husband in An Abandoned Mine Shaft','2006','1',NULL,'6','0.99','105','21.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('441','HUNTER ALTER','A Emotional Drama of a Mad Cow And a Boat who must Redeem a Secret Agent in A Shark Tank','2006','1',NULL,'5','2.99','125','21.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('442','HUNTING MUSKETEERS','A Thrilling Reflection of a Pioneer And a Dentist who must Outrace a Womanizer in An Abandoned Mine Shaft','2006','1',NULL,'6','2.99','65','24.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('443','HURRICANE AFFAIR','A Lacklusture Epistle of a Database Administrator And a Woman who must Meet a Hunter in An Abandoned Mine Shaft','2006','1',NULL,'6','2.99','49','11.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('444','HUSTLER PARTY','A Emotional Reflection of a Sumo Wrestler And a Monkey who must Conquer a Robot in The Sahara Desert','2006','1',NULL,'3','4.99','83','22.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('445','HYDE DOCTOR','A Fanciful Documentary of a Boy And a Woman who must Redeem a Womanizer in A Jet Boat','2006','1',NULL,'5','2.99','100','11.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('446','HYSTERICAL GRAIL','A Amazing Saga of a Madman And a Dentist who must Build a Car in A Manhattan Penthouse','2006','1',NULL,'5','4.99','150','19.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('447','ICE CROSSING','A Fast-Paced Tale of a Butler And a Moose who must Overcome a Pioneer in A Manhattan Penthouse','2006','1',NULL,'5','2.99','131','28.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('448','IDAHO LOVE','A Fast-Paced Drama of a Student And a Crocodile who must Meet a Database Administrator in The Outback','2006','1',NULL,'3','2.99','172','25.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('449','IDENTITY LOVER','A Boring Tale of a Composer And a Mad Cow who must Defeat a Car in The Outback','2006','1',NULL,'4','2.99','119','12.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('450','IDOLS SNATCHERS','A Insightful Drama of a Car And a Composer who must Fight a Man in A Monastery','2006','1',NULL,'5','2.99','84','29.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('451','IGBY MAKER','A Epic Documentary of a Hunter And a Dog who must Outgun a Dog in A Baloon Factory','2006','1',NULL,'7','4.99','160','12.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('452','ILLUSION AMELIE','A Emotional Epistle of a Boat And a Mad Scientist who must Outrace a Robot in An Abandoned Mine Shaft','2006','1',NULL,'4','0.99','122','15.99','R','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('453','IMAGE PRINCESS','A Lacklusture Panorama of a Secret Agent And a Crocodile who must Discover a Madman in The Canadian Rockies','2006','1',NULL,'3','2.99','178','17.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('454','IMPACT ALADDIN','A Epic Character Study of a Frisbee And a Moose who must Outgun a Technical Writer in A Shark Tank','2006','1',NULL,'6','0.99','180','20.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('455','IMPOSSIBLE PREJUDICE','A Awe-Inspiring Yarn of a Monkey And a Hunter who must Chase a Teacher in Ancient China','2006','1',NULL,'7','4.99','103','11.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('456','INCH JET','A Fateful Saga of a Womanizer And a Student who must Defeat a Butler in A Monastery','2006','1',NULL,'6','4.99','167','18.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('457','INDEPENDENCE HOTEL','A Thrilling Tale of a Technical Writer And a Boy who must Face a Pioneer in A Monastery','2006','1',NULL,'5','0.99','157','21.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('458','INDIAN LOVE','A Insightful Saga of a Mad Scientist And a Mad Scientist who must Kill a Astronaut in An Abandoned Fun House','2006','1',NULL,'4','0.99','135','26.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('459','INFORMER DOUBLE','A Action-Packed Display of a Woman And a Dentist who must Redeem a Forensic Psychologist in The Canadian Rockies','2006','1',NULL,'4','4.99','74','23.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('460','INNOCENT USUAL','A Beautiful Drama of a Pioneer And a Crocodile who must Challenge a Student in The Outback','2006','1',NULL,'3','4.99','178','26.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('461','INSECTS STONE','A Epic Display of a Butler And a Dog who must Vanquish a Crocodile in A Manhattan Penthouse','2006','1',NULL,'3','0.99','123','14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('462','INSIDER ARIZONA','A Astounding Saga of a Mad Scientist And a Hunter who must Pursue a Robot in A Baloon Factory','2006','1',NULL,'5','2.99','78','17.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('463','INSTINCT AIRPORT','A Touching Documentary of a Mad Cow And a Explorer who must Confront a Butler in A Manhattan Penthouse','2006','1',NULL,'4','2.99','116','21.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('464','INTENTIONS EMPIRE','A Astounding Epistle of a Cat And a Cat who must Conquer a Mad Cow in A U-Boat','2006','1',NULL,'3','2.99','107','13.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('465','INTERVIEW LIAISONS','A Action-Packed Reflection of a Student And a Butler who must Discover a Database Administrator in A Manhattan Penthouse','2006','1',NULL,'4','4.99','59','17.99','R','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('466','INTOLERABLE INTENTIONS','A Awe-Inspiring Story of a Monkey And a Pastry Chef who must Succumb a Womanizer in A MySQL Convention','2006','1',NULL,'6','4.99','63','20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('467','INTRIGUE WORST','A Fanciful Character Study of a Explorer And a Mad Scientist who must Vanquish a Squirrel in A Jet Boat','2006','1',NULL,'6','0.99','181','10.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('468','INVASION CYCLONE','A Lacklusture Character Study of a Mad Scientist And a Womanizer who must Outrace a Explorer in A Monastery','2006','1',NULL,'5','2.99','97','12.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('469','IRON MOON','A Fast-Paced Documentary of a Mad Cow And a Boy who must Pursue a Dentist in A Baloon','2006','1',NULL,'7','4.99','46','27.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('470','ISHTAR ROCKETEER','A Astounding Saga of a Dog And a Squirrel who must Conquer a Dog in An Abandoned Fun House','2006','1',NULL,'4','4.99','79','24.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('471','ISLAND EXORCIST','A Fanciful Panorama of a Technical Writer And a Boy who must Find a Dentist in An Abandoned Fun House','2006','1',NULL,'7','2.99','84','23.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('472','ITALIAN AFRICAN','A Astounding Character Study of a Monkey And a Moose who must Outgun a Cat in A U-Boat','2006','1',NULL,'3','4.99','174','24.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('473','JACKET FRISCO','A Insightful Reflection of a Womanizer And a Husband who must Conquer a Pastry Chef in A Baloon','2006','1',NULL,'5','2.99','181','16.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('474','JADE BUNCH','A Insightful Panorama of a Squirrel And a Mad Cow who must Confront a Student in The First Manned Space Station','2006','1',NULL,'6','2.99','174','21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('475','JAPANESE RUN','A Awe-Inspiring Epistle of a Feminist And a Girl who must Sink a Girl in The Outback','2006','1',NULL,'6','0.99','135','29.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('476','JASON TRAP','A Thoughtful Tale of a Woman And a A Shark who must Conquer a Dog in A Monastery','2006','1',NULL,'5','2.99','130','9.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('477','JAWBREAKER BROOKLYN','A Stunning Reflection of a Boat And a Pastry Chef who must Succumb a A Shark in A Jet Boat','2006','1',NULL,'5','0.99','118','15.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('478','JAWS HARRY','A Thrilling Display of a Database Administrator And a Monkey who must Overcome a Dog in An Abandoned Fun House','2006','1',NULL,'4','2.99','112','10.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('479','JEDI BENEATH','A Astounding Reflection of a Explorer And a Dentist who must Pursue a Student in Nigeria','2006','1',NULL,'7','0.99','128','12.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('480','JEEPERS WEDDING','A Astounding Display of a Composer And a Dog who must Kill a Pastry Chef in Soviet Georgia','2006','1',NULL,'3','2.99','84','29.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('481','JEKYLL FROGMEN','A Fanciful Epistle of a Student And a Astronaut who must Kill a Waitress in A Shark Tank','2006','1',NULL,'4','2.99','58','22.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('482','JEOPARDY ENCINO','A Boring Panorama of a Man And a Mad Cow who must Face a Explorer in Ancient India','2006','1',NULL,'3','0.99','102','12.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('483','JERICHO MULAN','A Amazing Yarn of a Hunter And a Butler who must Defeat a Boy in A Jet Boat','2006','1',NULL,'3','2.99','171','29.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('484','JERK PAYCHECK','A Touching Character Study of a Pastry Chef And a Database Administrator who must Reach a A Shark in Ancient Japan','2006','1',NULL,'3','2.99','172','13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('485','JERSEY SASSY','A Lacklusture Documentary of a Madman And a Mad Cow who must Find a Feminist in Ancient Japan','2006','1',NULL,'6','4.99','60','16.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('486','JET NEIGHBORS','A Amazing Display of a Lumberjack And a Teacher who must Outrace a Woman in A U-Boat','2006','1',NULL,'7','4.99','59','14.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('487','JINGLE SAGEBRUSH','A Epic Character Study of a Feminist And a Student who must Meet a Woman in A Baloon','2006','1',NULL,'6','4.99','124','29.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('488','JOON NORTHWEST','A Thrilling Panorama of a Technical Writer And a Car who must Discover a Forensic Psychologist in A Shark Tank','2006','1',NULL,'3','0.99','105','23.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('489','JUGGLER HARDLY','A Epic Story of a Mad Cow And a Astronaut who must Challenge a Car in California','2006','1',NULL,'4','0.99','54','14.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('490','JUMANJI BLADE','A Intrepid Yarn of a Husband And a Womanizer who must Pursue a Mad Scientist in New Orleans','2006','1',NULL,'4','2.99','121','13.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('491','JUMPING WRATH','A Touching Epistle of a Monkey And a Feminist who must Discover a Boat in Berlin','2006','1',NULL,'4','0.99','74','18.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('492','JUNGLE CLOSER','A Boring Character Study of a Boy And a Woman who must Battle a Astronaut in Australia','2006','1',NULL,'6','0.99','134','11.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('493','KANE EXORCIST','A Epic Documentary of a Composer And a Robot who must Overcome a Car in Berlin','2006','1',NULL,'5','0.99','92','18.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('494','KARATE MOON','A Astounding Yarn of a Womanizer And a Dog who must Reach a Waitress in A MySQL Convention','2006','1',NULL,'4','0.99','120','21.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('495','KENTUCKIAN GIANT','A Stunning Yarn of a Woman And a Frisbee who must Escape a Waitress in A U-Boat','2006','1',NULL,'5','2.99','169','10.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('496','KICK SAVANNAH','A Emotional Drama of a Monkey And a Robot who must Defeat a Monkey in New Orleans','2006','1',NULL,'3','0.99','179','10.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('497','KILL BROTHERHOOD','A Touching Display of a Hunter And a Secret Agent who must Redeem a Husband in The Outback','2006','1',NULL,'4','0.99','54','15.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('498','KILLER INNOCENT','A Fanciful Character Study of a Student And a Explorer who must Succumb a Composer in An Abandoned Mine Shaft','2006','1',NULL,'7','2.99','161','11.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('499','KING EVOLUTION','A Action-Packed Tale of a Boy And a Lumberjack who must Chase a Madman in A Baloon','2006','1',NULL,'3','4.99','184','24.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('500','KISS GLORY','A Lacklusture Reflection of a Girl And a Husband who must Find a Robot in The Canadian Rockies','2006','1',NULL,'5','4.99','163','11.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('501','KISSING DOLLS','A Insightful Reflection of a Pioneer And a Teacher who must Build a Composer in The First Manned Space Station','2006','1',NULL,'3','4.99','141','9.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('502','KNOCK WARLOCK','A Unbelieveable Story of a Teacher And a Boat who must Confront a Moose in A Baloon','2006','1',NULL,'4','2.99','71','21.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('503','KRAMER CHOCOLATE','A Amazing Yarn of a Robot And a Pastry Chef who must Redeem a Mad Scientist in The Outback','2006','1',NULL,'3','2.99','171','24.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('504','KWAI HOMEWARD','A Amazing Drama of a Car And a Squirrel who must Pursue a Car in Soviet Georgia','2006','1',NULL,'5','0.99','46','25.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('505','LABYRINTH LEAGUE','A Awe-Inspiring Saga of a Composer And a Frisbee who must Succumb a Pioneer in The Sahara Desert','2006','1',NULL,'6','2.99','46','24.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('506','LADY STAGE','A Beautiful Character Study of a Woman And a Man who must Pursue a Explorer in A U-Boat','2006','1',NULL,'4','4.99','67','14.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('507','LADYBUGS ARMAGEDDON','A Fateful Reflection of a Dog And a Mad Scientist who must Meet a Mad Scientist in New Orleans','2006','1',NULL,'4','0.99','113','13.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('508','LAMBS CINCINATTI','A Insightful Story of a Man And a Feminist who must Fight a Composer in Australia','2006','1',NULL,'6','4.99','144','18.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('509','LANGUAGE COWBOY','A Epic Yarn of a Cat And a Madman who must Vanquish a Dentist in An Abandoned Amusement Park','2006','1',NULL,'5','0.99','78','26.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('510','LAWLESS VISION','A Insightful Yarn of a Boy And a Sumo Wrestler who must Outgun a Car in The Outback','2006','1',NULL,'6','4.99','181','29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('511','LAWRENCE LOVE','A Fanciful Yarn of a Database Administrator And a Mad Cow who must Pursue a Womanizer in Berlin','2006','1',NULL,'7','0.99','175','23.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('512','LEAGUE HELLFIGHTERS','A Thoughtful Saga of a A Shark And a Monkey who must Outgun a Student in Ancient China','2006','1',NULL,'5','4.99','110','25.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('513','LEATHERNECKS DWARFS','A Fateful Reflection of a Dog And a Mad Cow who must Outrace a Teacher in An Abandoned Mine Shaft','2006','1',NULL,'6','2.99','153','21.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('514','LEBOWSKI SOLDIERS','A Beautiful Epistle of a Secret Agent And a Pioneer who must Chase a Astronaut in Ancient China','2006','1',NULL,'6','2.99','69','17.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('515','LEGALLY SECRETARY','A Astounding Tale of a A Shark And a Moose who must Meet a Womanizer in The Sahara Desert','2006','1',NULL,'7','4.99','113','14.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('516','LEGEND JEDI','A Awe-Inspiring Epistle of a Pioneer And a Student who must Outgun a Crocodile in The Outback','2006','1',NULL,'7','0.99','59','18.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('517','LESSON CLEOPATRA','A Emotional Display of a Man And a Explorer who must Build a Boy in A Manhattan Penthouse','2006','1',NULL,'3','0.99','167','28.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('518','LIAISONS SWEET','A Boring Drama of a A Shark And a Explorer who must Redeem a Waitress in The Canadian Rockies','2006','1',NULL,'5','4.99','140','15.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('519','LIBERTY MAGNIFICENT','A Boring Drama of a Student And a Cat who must Sink a Technical Writer in A Baloon','2006','1',NULL,'3','2.99','138','27.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('520','LICENSE WEEKEND','A Insightful Story of a Man And a Husband who must Overcome a Madman in A Monastery','2006','1',NULL,'7','2.99','91','28.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('521','LIES TREATMENT','A Fast-Paced Character Study of a Dentist And a Moose who must Defeat a Composer in The First Manned Space Station','2006','1',NULL,'7','4.99','147','28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('522','LIFE TWISTED','A Thrilling Reflection of a Teacher And a Composer who must Find a Man in The First Manned Space Station','2006','1',NULL,'4','2.99','137','9.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('523','LIGHTS DEER','A Unbelieveable Epistle of a Dog And a Woman who must Confront a Moose in The Gulf of Mexico','2006','1',NULL,'7','0.99','174','21.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('524','LION UNCUT','A Intrepid Display of a Pastry Chef And a Cat who must Kill a A Shark in Ancient China','2006','1',NULL,'6','0.99','50','13.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('525','LOATHING LEGALLY','A Boring Epistle of a Pioneer And a Mad Scientist who must Escape a Frisbee in The Gulf of Mexico','2006','1',NULL,'4','0.99','140','29.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('526','LOCK REAR','A Thoughtful Character Study of a Squirrel And a Technical Writer who must Outrace a Student in Ancient Japan','2006','1',NULL,'7','2.99','120','10.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('527','LOLA AGENT','A Astounding Tale of a Mad Scientist And a Husband who must Redeem a Database Administrator in Ancient Japan','2006','1',NULL,'4','4.99','85','24.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('528','LOLITA WORLD','A Thrilling Drama of a Girl And a Robot who must Redeem a Waitress in An Abandoned Mine Shaft','2006','1',NULL,'4','2.99','155','25.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('529','LONELY ELEPHANT','A Intrepid Story of a Student And a Dog who must Challenge a Explorer in Soviet Georgia','2006','1',NULL,'3','2.99','67','12.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('530','LORD ARIZONA','A Action-Packed Display of a Frisbee And a Pastry Chef who must Pursue a Crocodile in A Jet Boat','2006','1',NULL,'5','2.99','108','27.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('531','LOSE INCH','A Stunning Reflection of a Student And a Technical Writer who must Battle a Butler in The First Manned Space Station','2006','1',NULL,'3','0.99','137','18.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('532','LOSER HUSTLER','A Stunning Drama of a Robot And a Feminist who must Outgun a Butler in Nigeria','2006','1',NULL,'5','4.99','80','28.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('533','LOST BIRD','A Emotional Character Study of a Robot And a A Shark who must Defeat a Technical Writer in A Manhattan Penthouse','2006','1',NULL,'4','2.99','98','21.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('534','LOUISIANA HARRY','A Lacklusture Drama of a Girl And a Technical Writer who must Redeem a Monkey in A Shark Tank','2006','1',NULL,'5','0.99','70','18.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('535','LOVE SUICIDES','A Brilliant Panorama of a Hunter And a Explorer who must Pursue a Dentist in An Abandoned Fun House','2006','1',NULL,'6','0.99','181','21.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('536','LOVELY JINGLE','A Fanciful Yarn of a Crocodile And a Forensic Psychologist who must Discover a Crocodile in The Outback','2006','1',NULL,'3','2.99','65','18.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('537','LOVER TRUMAN','A Emotional Yarn of a Robot And a Boy who must Outgun a Technical Writer in A U-Boat','2006','1',NULL,'3','2.99','75','29.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('538','LOVERBOY ATTACKS','A Boring Story of a Car And a Butler who must Build a Girl in Soviet Georgia','2006','1',NULL,'7','0.99','162','19.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('539','LUCK OPUS','A Boring Display of a Moose And a Squirrel who must Outrace a Teacher in A Shark Tank','2006','1',NULL,'7','2.99','152','21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('540','LUCKY FLYING','A Lacklusture Character Study of a A Shark And a Man who must Find a Forensic Psychologist in A U-Boat','2006','1',NULL,'7','2.99','97','10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('541','LUKE MUMMY','A Taut Character Study of a Boy And a Robot who must Redeem a Mad Scientist in Ancient India','2006','1',NULL,'5','2.99','74','21.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('542','LUST LOCK','A Fanciful Panorama of a Hunter And a Dentist who must Meet a Secret Agent in The Sahara Desert','2006','1',NULL,'3','2.99','52','28.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('543','MADIGAN DORADO','A Astounding Character Study of a A Shark And a A Shark who must Discover a Crocodile in The Outback','2006','1',NULL,'5','4.99','116','20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('544','MADISON TRAP','A Awe-Inspiring Reflection of a Monkey And a Dentist who must Overcome a Pioneer in A U-Boat','2006','1',NULL,'4','2.99','147','11.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('545','MADNESS ATTACKS','A Fanciful Tale of a Squirrel And a Boat who must Defeat a Crocodile in The Gulf of Mexico','2006','1',NULL,'4','0.99','178','14.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('546','MADRE GABLES','A Intrepid Panorama of a Sumo Wrestler And a Forensic Psychologist who must Discover a Moose in The First Manned Space Station','2006','1',NULL,'7','2.99','98','27.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('547','MAGIC MALLRATS','A Touching Documentary of a Pastry Chef And a Pastry Chef who must Build a Mad Scientist in California','2006','1',NULL,'3','0.99','117','19.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('548','MAGNIFICENT CHITTY','A Insightful Story of a Teacher And a Hunter who must Face a Mad Cow in California','2006','1',NULL,'3','2.99','53','27.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('549','MAGNOLIA FORRESTER','A Thoughtful Documentary of a Composer And a Explorer who must Conquer a Dentist in New Orleans','2006','1',NULL,'4','0.99','171','28.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('550','MAGUIRE APACHE','A Fast-Paced Reflection of a Waitress And a Hunter who must Defeat a Forensic Psychologist in A Baloon','2006','1',NULL,'6','2.99','74','22.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('551','MAIDEN HOME','A Lacklusture Saga of a Moose And a Teacher who must Kill a Forensic Psychologist in A MySQL Convention','2006','1',NULL,'3','4.99','138','9.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('552','MAJESTIC FLOATS','A Thrilling Character Study of a Moose And a Student who must Escape a Butler in The First Manned Space Station','2006','1',NULL,'5','0.99','130','15.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('553','MAKER GABLES','A Stunning Display of a Moose And a Database Administrator who must Pursue a Composer in A Jet Boat','2006','1',NULL,'4','0.99','136','12.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('554','MALKOVICH PET','A Intrepid Reflection of a Waitress And a A Shark who must Kill a Squirrel in The Outback','2006','1',NULL,'6','2.99','159','22.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('555','MALLRATS UNITED','A Thrilling Yarn of a Waitress And a Dentist who must Find a Hunter in A Monastery','2006','1',NULL,'4','0.99','133','25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('556','MALTESE HOPE','A Fast-Paced Documentary of a Crocodile And a Sumo Wrestler who must Conquer a Explorer in California','2006','1',NULL,'6','4.99','127','26.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('557','MANCHURIAN CURTAIN','A Stunning Tale of a Mad Cow And a Boy who must Battle a Boy in Berlin','2006','1',NULL,'5','2.99','177','27.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('558','MANNEQUIN WORST','A Astounding Saga of a Mad Cow And a Pastry Chef who must Discover a Husband in Ancient India','2006','1',NULL,'3','2.99','71','18.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('559','MARRIED GO','A Fanciful Story of a Womanizer And a Dog who must Face a Forensic Psychologist in The Sahara Desert','2006','1',NULL,'7','2.99','114','22.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('560','MARS ROMAN','A Boring Drama of a Car And a Dog who must Succumb a Madman in Soviet Georgia','2006','1',NULL,'6','0.99','62','21.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('561','MASK PEACH','A Boring Character Study of a Student And a Robot who must Meet a Woman in California','2006','1',NULL,'6','2.99','123','26.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('562','MASKED BUBBLE','A Fanciful Documentary of a Pioneer And a Boat who must Pursue a Pioneer in An Abandoned Mine Shaft','2006','1',NULL,'6','0.99','151','12.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('563','MASSACRE USUAL','A Fateful Reflection of a Waitress And a Crocodile who must Challenge a Forensic Psychologist in California','2006','1',NULL,'6','4.99','165','16.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('564','MASSAGE IMAGE','A Fateful Drama of a Frisbee And a Crocodile who must Vanquish a Dog in The First Manned Space Station','2006','1',NULL,'4','2.99','161','11.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('565','MATRIX SNOWMAN','A Action-Packed Saga of a Womanizer And a Woman who must Overcome a Student in California','2006','1',NULL,'6','4.99','56','9.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('566','MAUDE MOD','A Beautiful Documentary of a Forensic Psychologist And a Cat who must Reach a Astronaut in Nigeria','2006','1',NULL,'6','0.99','72','20.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('567','MEET CHOCOLATE','A Boring Documentary of a Dentist And a Butler who must Confront a Monkey in A MySQL Convention','2006','1',NULL,'3','2.99','80','26.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('568','MEMENTO ZOOLANDER','A Touching Epistle of a Squirrel And a Explorer who must Redeem a Pastry Chef in The Sahara Desert','2006','1',NULL,'4','4.99','77','11.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('569','MENAGERIE RUSHMORE','A Unbelieveable Panorama of a Composer And a Butler who must Overcome a Database Administrator in The First Manned Space Station','2006','1',NULL,'7','2.99','147','18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('570','MERMAID INSECTS','A Lacklusture Drama of a Waitress And a Husband who must Fight a Husband in California','2006','1',NULL,'5','4.99','104','20.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('571','METAL ARMAGEDDON','A Thrilling Display of a Lumberjack And a Crocodile who must Meet a Monkey in A Baloon Factory','2006','1',NULL,'6','2.99','161','26.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('572','METROPOLIS COMA','A Emotional Saga of a Database Administrator And a Pastry Chef who must Confront a Teacher in A Baloon Factory','2006','1',NULL,'4','2.99','64','9.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('573','MICROCOSMOS PARADISE','A Touching Character Study of a Boat And a Student who must Sink a A Shark in Nigeria','2006','1',NULL,'6','2.99','105','22.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('574','MIDNIGHT WESTWARD','A Taut Reflection of a Husband And a A Shark who must Redeem a Pastry Chef in A Monastery','2006','1',NULL,'3','0.99','86','19.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('575','MIDSUMMER GROUNDHOG','A Fateful Panorama of a Moose And a Dog who must Chase a Crocodile in Ancient Japan','2006','1',NULL,'3','4.99','48','27.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('576','MIGHTY LUCK','A Astounding Epistle of a Mad Scientist And a Pioneer who must Escape a Database Administrator in A MySQL Convention','2006','1',NULL,'7','2.99','122','13.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('577','MILE MULAN','A Lacklusture Epistle of a Cat And a Husband who must Confront a Boy in A MySQL Convention','2006','1',NULL,'4','0.99','64','10.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('578','MILLION ACE','A Brilliant Documentary of a Womanizer And a Squirrel who must Find a Technical Writer in The Sahara Desert','2006','1',NULL,'4','4.99','142','16.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('579','MINDS TRUMAN','A Taut Yarn of a Mad Scientist And a Crocodile who must Outgun a Database Administrator in A Monastery','2006','1',NULL,'3','4.99','149','22.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('580','MINE TITANS','A Amazing Yarn of a Robot And a Womanizer who must Discover a Forensic Psychologist in Berlin','2006','1',NULL,'3','4.99','166','12.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('581','MINORITY KISS','A Insightful Display of a Lumberjack And a Sumo Wrestler who must Meet a Man in The Outback','2006','1',NULL,'4','0.99','59','16.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('582','MIRACLE VIRTUAL','A Touching Epistle of a Butler And a Boy who must Find a Mad Scientist in The Sahara Desert','2006','1',NULL,'3','2.99','162','19.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('583','MISSION ZOOLANDER','A Intrepid Story of a Sumo Wrestler And a Teacher who must Meet a A Shark in An Abandoned Fun House','2006','1',NULL,'3','4.99','164','26.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('584','MIXED DOORS','A Taut Drama of a Womanizer And a Lumberjack who must Succumb a Pioneer in Ancient India','2006','1',NULL,'6','2.99','180','26.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('585','MOB DUFFEL','A Unbelieveable Documentary of a Frisbee And a Boat who must Meet a Boy in The Canadian Rockies','2006','1',NULL,'4','0.99','105','25.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('586','MOCKINGBIRD HOLLYWOOD','A Thoughtful Panorama of a Man And a Car who must Sink a Composer in Berlin','2006','1',NULL,'4','0.99','60','27.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('587','MOD SECRETARY','A Boring Documentary of a Mad Cow And a Cat who must Build a Lumberjack in New Orleans','2006','1',NULL,'6','4.99','77','20.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('588','MODEL FISH','A Beautiful Panorama of a Boat And a Crocodile who must Outrace a Dog in Australia','2006','1',NULL,'4','4.99','175','11.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('589','MODERN DORADO','A Awe-Inspiring Story of a Butler And a Sumo Wrestler who must Redeem a Boy in New Orleans','2006','1',NULL,'3','0.99','74','20.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('590','MONEY HAROLD','A Touching Tale of a Explorer And a Boat who must Defeat a Robot in Australia','2006','1',NULL,'3','2.99','135','17.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('591','MONSOON CAUSE','A Astounding Tale of a Crocodile And a Car who must Outrace a Squirrel in A U-Boat','2006','1',NULL,'6','4.99','182','20.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('592','MONSTER SPARTACUS','A Fast-Paced Story of a Waitress And a Cat who must Fight a Girl in Australia','2006','1',NULL,'6','2.99','107','28.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('593','MONTEREY LABYRINTH','A Awe-Inspiring Drama of a Monkey And a Composer who must Escape a Feminist in A U-Boat','2006','1',NULL,'6','0.99','158','13.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('594','MONTEZUMA COMMAND','A Thrilling Reflection of a Waitress And a Butler who must Battle a Butler in A Jet Boat','2006','1',NULL,'6','0.99','126','22.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('595','MOON BUNCH','A Beautiful Tale of a Astronaut And a Mad Cow who must Challenge a Cat in A Baloon Factory','2006','1',NULL,'7','0.99','83','20.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('596','MOONSHINE CABIN','A Thoughtful Display of a Astronaut And a Feminist who must Chase a Frisbee in A Jet Boat','2006','1',NULL,'4','4.99','171','25.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('597','MOONWALKER FOOL','A Epic Drama of a Feminist And a Pioneer who must Sink a Composer in New Orleans','2006','1',NULL,'5','4.99','184','12.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('598','MOSQUITO ARMAGEDDON','A Thoughtful Character Study of a Waitress And a Feminist who must Build a Teacher in Ancient Japan','2006','1',NULL,'6','0.99','57','22.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('599','MOTHER OLEANDER','A Boring Tale of a Husband And a Boy who must Fight a Squirrel in Ancient China','2006','1',NULL,'3','0.99','103','20.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('600','MOTIONS DETAILS','A Awe-Inspiring Reflection of a Dog And a Student who must Kill a Car in An Abandoned Fun House','2006','1',NULL,'5','0.99','166','16.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('601','MOULIN WAKE','A Astounding Story of a Forensic Psychologist And a Cat who must Battle a Teacher in An Abandoned Mine Shaft','2006','1',NULL,'4','0.99','79','20.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('602','MOURNING PURPLE','A Lacklusture Display of a Waitress And a Lumberjack who must Chase a Pioneer in New Orleans','2006','1',NULL,'5','0.99','146','14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('603','MOVIE SHAKESPEARE','A Insightful Display of a Database Administrator And a Student who must Build a Hunter in Berlin','2006','1',NULL,'6','4.99','53','27.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('604','MULAN MOON','A Emotional Saga of a Womanizer And a Pioneer who must Overcome a Dentist in A Baloon','2006','1',NULL,'4','0.99','160','10.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('605','MULHOLLAND BEAST','A Awe-Inspiring Display of a Husband And a Squirrel who must Battle a Sumo Wrestler in A Jet Boat','2006','1',NULL,'7','2.99','157','13.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('606','MUMMY CREATURES','A Fateful Character Study of a Crocodile And a Monkey who must Meet a Dentist in Australia','2006','1',NULL,'3','0.99','160','15.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('607','MUPPET MILE','A Lacklusture Story of a Madman And a Teacher who must Kill a Frisbee in The Gulf of Mexico','2006','1',NULL,'5','4.99','50','18.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('608','MURDER ANTITRUST','A Brilliant Yarn of a Car And a Database Administrator who must Escape a Boy in A MySQL Convention','2006','1',NULL,'6','2.99','166','11.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('609','MUSCLE BRIGHT','A Stunning Panorama of a Sumo Wrestler And a Husband who must Redeem a Madman in Ancient India','2006','1',NULL,'7','2.99','185','23.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('610','MUSIC BOONDOCK','A Thrilling Tale of a Butler And a Astronaut who must Battle a Explorer in The First Manned Space Station','2006','1',NULL,'7','0.99','129','17.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('611','MUSKETEERS WAIT','A Touching Yarn of a Student And a Moose who must Fight a Mad Cow in Australia','2006','1',NULL,'7','4.99','73','17.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('612','MUSSOLINI SPOILERS','A Thrilling Display of a Boat And a Monkey who must Meet a Composer in Ancient China','2006','1',NULL,'6','2.99','180','10.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('613','MYSTIC TRUMAN','A Epic Yarn of a Teacher And a Hunter who must Outgun a Explorer in Soviet Georgia','2006','1',NULL,'5','0.99','92','19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('614','NAME DETECTIVE','A Touching Saga of a Sumo Wrestler And a Cat who must Pursue a Mad Scientist in Nigeria','2006','1',NULL,'5','4.99','178','11.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('615','NASH CHOCOLAT','A Epic Reflection of a Monkey And a Mad Cow who must Kill a Forensic Psychologist in An Abandoned Mine Shaft','2006','1',NULL,'6','2.99','180','21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('616','NATIONAL STORY','A Taut Epistle of a Mad Scientist And a Girl who must Escape a Monkey in California','2006','1',NULL,'4','2.99','92','19.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('617','NATURAL STOCK','A Fast-Paced Story of a Sumo Wrestler And a Girl who must Defeat a Car in A Baloon Factory','2006','1',NULL,'4','0.99','50','24.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('618','NECKLACE OUTBREAK','A Astounding Epistle of a Database Administrator And a Mad Scientist who must Pursue a Cat in California','2006','1',NULL,'3','0.99','132','21.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('619','NEIGHBORS CHARADE','A Fanciful Reflection of a Crocodile And a Astronaut who must Outrace a Feminist in An Abandoned Amusement Park','2006','1',NULL,'3','0.99','161','20.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('620','NEMO CAMPUS','A Lacklusture Reflection of a Monkey And a Squirrel who must Outrace a Womanizer in A Manhattan Penthouse','2006','1',NULL,'5','2.99','131','23.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('621','NETWORK PEAK','A Unbelieveable Reflection of a Butler And a Boat who must Outgun a Mad Scientist in California','2006','1',NULL,'5','2.99','75','23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('622','NEWSIES STORY','A Action-Packed Character Study of a Dog And a Lumberjack who must Outrace a Moose in The Gulf of Mexico','2006','1',NULL,'4','0.99','159','25.99','G','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('623','NEWTON LABYRINTH','A Intrepid Character Study of a Moose And a Waitress who must Find a A Shark in Ancient India','2006','1',NULL,'4','0.99','75','9.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('624','NIGHTMARE CHILL','A Brilliant Display of a Robot And a Butler who must Fight a Waitress in An Abandoned Mine Shaft','2006','1',NULL,'3','4.99','149','25.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('625','NONE SPIKING','A Boring Reflection of a Secret Agent And a Astronaut who must Face a Composer in A Manhattan Penthouse','2006','1',NULL,'3','0.99','83','18.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('626','NOON PAPI','A Unbelieveable Character Study of a Mad Scientist And a Astronaut who must Find a Pioneer in A Manhattan Penthouse','2006','1',NULL,'5','2.99','57','12.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('627','NORTH TEQUILA','A Beautiful Character Study of a Mad Cow And a Robot who must Reach a Womanizer in New Orleans','2006','1',NULL,'4','4.99','67','9.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('628','NORTHWEST POLISH','A Boring Character Study of a Boy And a A Shark who must Outrace a Womanizer in The Outback','2006','1',NULL,'5','2.99','172','24.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('629','NOTORIOUS REUNION','A Amazing Epistle of a Woman And a Squirrel who must Fight a Hunter in A Baloon','2006','1',NULL,'7','0.99','128','9.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('630','NOTTING SPEAKEASY','A Thoughtful Display of a Butler And a Womanizer who must Find a Waitress in The Canadian Rockies','2006','1',NULL,'7','0.99','48','19.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('631','NOVOCAINE FLIGHT','A Fanciful Display of a Student And a Teacher who must Outgun a Crocodile in Nigeria','2006','1',NULL,'4','0.99','64','11.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('632','NUTS TIES','A Thoughtful Drama of a Explorer And a Womanizer who must Meet a Teacher in California','2006','1',NULL,'5','4.99','145','10.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('633','OCTOBER SUBMARINE','A Taut Epistle of a Monkey And a Boy who must Confront a Husband in A Jet Boat','2006','1',NULL,'6','4.99','54','10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('634','ODDS BOOGIE','A Thrilling Yarn of a Feminist And a Madman who must Battle a Hunter in Berlin','2006','1',NULL,'6','0.99','48','14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('635','OKLAHOMA JUMANJI','A Thoughtful Drama of a Dentist And a Womanizer who must Meet a Husband in The Sahara Desert','2006','1',NULL,'7','0.99','58','15.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('636','OLEANDER CLUE','A Boring Story of a Teacher And a Monkey who must Succumb a Forensic Psychologist in A Jet Boat','2006','1',NULL,'5','0.99','161','12.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('637','OPEN AFRICAN','A Lacklusture Drama of a Secret Agent And a Explorer who must Discover a Car in A U-Boat','2006','1',NULL,'7','4.99','131','16.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('638','OPERATION OPERATION','A Intrepid Character Study of a Man And a Frisbee who must Overcome a Madman in Ancient China','2006','1',NULL,'7','2.99','156','23.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('639','OPPOSITE NECKLACE','A Fateful Epistle of a Crocodile And a Moose who must Kill a Explorer in Nigeria','2006','1',NULL,'7','4.99','92','9.99','PG','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('640','OPUS ICE','A Fast-Paced Drama of a Hunter And a Boy who must Discover a Feminist in The Sahara Desert','2006','1',NULL,'5','4.99','102','21.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('641','ORANGE GRAPES','A Astounding Documentary of a Butler And a Womanizer who must Face a Dog in A U-Boat','2006','1',NULL,'4','0.99','76','21.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('642','ORDER BETRAYED','A Amazing Saga of a Dog And a A Shark who must Challenge a Cat in The Sahara Desert','2006','1',NULL,'7','2.99','120','13.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('643','ORIENT CLOSER','A Astounding Epistle of a Technical Writer And a Teacher who must Fight a Squirrel in The Sahara Desert','2006','1',NULL,'3','2.99','118','22.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('644','OSCAR GOLD','A Insightful Tale of a Database Administrator And a Dog who must Face a Madman in Soviet Georgia','2006','1',NULL,'7','2.99','115','29.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('645','OTHERS SOUP','A Lacklusture Documentary of a Mad Cow And a Madman who must Sink a Moose in The Gulf of Mexico','2006','1',NULL,'7','2.99','118','18.99','PG','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('646','OUTBREAK DIVINE','A Unbelieveable Yarn of a Database Administrator And a Woman who must Succumb a A Shark in A U-Boat','2006','1',NULL,'6','0.99','169','12.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('647','OUTFIELD MASSACRE','A Thoughtful Drama of a Husband And a Secret Agent who must Pursue a Database Administrator in Ancient India','2006','1',NULL,'4','0.99','129','18.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('648','OUTLAW HANKY','A Thoughtful Story of a Astronaut And a Composer who must Conquer a Dog in The Sahara Desert','2006','1',NULL,'7','4.99','148','17.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('649','OZ LIAISONS','A Epic Yarn of a Mad Scientist And a Cat who must Confront a Womanizer in A Baloon Factory','2006','1',NULL,'4','2.99','85','14.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('650','PACIFIC AMISTAD','A Thrilling Yarn of a Dog And a Moose who must Kill a Pastry Chef in A Manhattan Penthouse','2006','1',NULL,'3','0.99','144','27.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('651','PACKER MADIGAN','A Epic Display of a Sumo Wrestler And a Forensic Psychologist who must Build a Woman in An Abandoned Amusement Park','2006','1',NULL,'3','0.99','84','20.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('652','PAJAMA JAWBREAKER','A Emotional Drama of a Boy And a Technical Writer who must Redeem a Sumo Wrestler in California','2006','1',NULL,'3','0.99','126','14.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('653','PANIC CLUB','A Fanciful Display of a Teacher And a Crocodile who must Succumb a Girl in A Baloon','2006','1',NULL,'3','4.99','102','15.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('654','PANKY SUBMARINE','A Touching Documentary of a Dentist And a Sumo Wrestler who must Overcome a Boy in The Gulf of Mexico','2006','1',NULL,'4','4.99','93','19.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('655','PANTHER REDS','A Brilliant Panorama of a Moose And a Man who must Reach a Teacher in The Gulf of Mexico','2006','1',NULL,'5','4.99','109','22.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('656','PAPI NECKLACE','A Fanciful Display of a Car And a Monkey who must Escape a Squirrel in Ancient Japan','2006','1',NULL,'3','0.99','128','9.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('657','PARADISE SABRINA','A Intrepid Yarn of a Car And a Moose who must Outrace a Crocodile in A Manhattan Penthouse','2006','1',NULL,'5','2.99','48','12.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('658','PARIS WEEKEND','A Intrepid Story of a Squirrel And a Crocodile who must Defeat a Monkey in The Outback','2006','1',NULL,'7','2.99','121','19.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('659','PARK CITIZEN','A Taut Epistle of a Sumo Wrestler And a Girl who must Face a Husband in Ancient Japan','2006','1',NULL,'3','4.99','109','14.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('660','PARTY KNOCK','A Fateful Display of a Technical Writer And a Butler who must Battle a Sumo Wrestler in An Abandoned Mine Shaft','2006','1',NULL,'7','2.99','107','11.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('661','PAST SUICIDES','A Intrepid Tale of a Madman And a Astronaut who must Challenge a Hunter in A Monastery','2006','1',NULL,'5','4.99','157','17.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('662','PATHS CONTROL','A Astounding Documentary of a Butler And a Cat who must Find a Frisbee in Ancient China','2006','1',NULL,'3','4.99','118','9.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('663','PATIENT SISTER','A Emotional Epistle of a Squirrel And a Robot who must Confront a Lumberjack in Soviet Georgia','2006','1',NULL,'7','0.99','99','29.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('664','PATRIOT ROMAN','A Taut Saga of a Robot And a Database Administrator who must Challenge a Astronaut in California','2006','1',NULL,'6','2.99','65','12.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('665','PATTON INTERVIEW','A Thrilling Documentary of a Composer And a Secret Agent who must Succumb a Cat in Berlin','2006','1',NULL,'4','2.99','175','22.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('666','PAYCHECK WAIT','A Awe-Inspiring Reflection of a Boy And a Man who must Discover a Moose in The Sahara Desert','2006','1',NULL,'4','4.99','145','27.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('667','PEACH INNOCENT','A Action-Packed Drama of a Monkey And a Dentist who must Chase a Butler in Berlin','2006','1',NULL,'3','2.99','160','20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('668','PEAK FOREVER','A Insightful Reflection of a Boat And a Secret Agent who must Vanquish a Astronaut in An Abandoned Mine Shaft','2006','1',NULL,'7','4.99','80','25.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('669','PEARL DESTINY','A Lacklusture Yarn of a Astronaut And a Pastry Chef who must Sink a Dog in A U-Boat','2006','1',NULL,'3','2.99','74','10.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('670','PELICAN COMFORTS','A Epic Documentary of a Boy And a Monkey who must Pursue a Astronaut in Berlin','2006','1',NULL,'4','4.99','48','17.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('671','PERDITION FARGO','A Fast-Paced Story of a Car And a Cat who must Outgun a Hunter in Berlin','2006','1',NULL,'7','4.99','99','27.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('672','PERFECT GROOVE','A Thrilling Yarn of a Dog And a Dog who must Build a Husband in A Baloon','2006','1',NULL,'7','2.99','82','17.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('673','PERSONAL LADYBUGS','A Epic Saga of a Hunter And a Technical Writer who must Conquer a Cat in Ancient Japan','2006','1',NULL,'3','0.99','118','19.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('674','PET HAUNTING','A Unbelieveable Reflection of a Explorer And a Boat who must Conquer a Woman in California','2006','1',NULL,'3','0.99','99','11.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('675','PHANTOM GLORY','A Beautiful Documentary of a Astronaut And a Crocodile who must Discover a Madman in A Monastery','2006','1',NULL,'6','2.99','60','17.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('676','PHILADELPHIA WIFE','A Taut Yarn of a Hunter And a Astronaut who must Conquer a Database Administrator in The Sahara Desert','2006','1',NULL,'7','4.99','137','16.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('677','PIANIST OUTFIELD','A Intrepid Story of a Boy And a Technical Writer who must Pursue a Lumberjack in A Monastery','2006','1',NULL,'6','0.99','136','25.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('678','PICKUP DRIVING','A Touching Documentary of a Husband And a Boat who must Meet a Pastry Chef in A Baloon Factory','2006','1',NULL,'3','2.99','77','23.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('679','PILOT HOOSIERS','A Awe-Inspiring Reflection of a Crocodile And a Sumo Wrestler who must Meet a Forensic Psychologist in An Abandoned Mine Shaft','2006','1',NULL,'6','2.99','50','17.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('680','PINOCCHIO SIMON','A Action-Packed Reflection of a Mad Scientist And a A Shark who must Find a Feminist in California','2006','1',NULL,'4','4.99','103','21.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('681','PIRATES ROXANNE','A Stunning Drama of a Woman And a Lumberjack who must Overcome a A Shark in The Canadian Rockies','2006','1',NULL,'4','0.99','100','20.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('682','PITTSBURGH HUNCHBACK','A Thrilling Epistle of a Boy And a Boat who must Find a Student in Soviet Georgia','2006','1',NULL,'4','4.99','134','17.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('683','PITY BOUND','A Boring Panorama of a Feminist And a Moose who must Defeat a Database Administrator in Nigeria','2006','1',NULL,'5','4.99','60','19.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('684','PIZZA JUMANJI','A Epic Saga of a Cat And a Squirrel who must Outgun a Robot in A U-Boat','2006','1',NULL,'4','2.99','173','11.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('685','PLATOON INSTINCT','A Thrilling Panorama of a Man And a Woman who must Reach a Woman in Australia','2006','1',NULL,'6','4.99','132','10.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('686','PLUTO OLEANDER','A Action-Packed Reflection of a Car And a Moose who must Outgun a Car in A Shark Tank','2006','1',NULL,'5','4.99','84','9.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('687','POCUS PULP','A Intrepid Yarn of a Frisbee And a Dog who must Build a Astronaut in A Baloon Factory','2006','1',NULL,'6','0.99','138','15.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('688','POLISH BROOKLYN','A Boring Character Study of a Database Administrator And a Lumberjack who must Reach a Madman in The Outback','2006','1',NULL,'6','0.99','61','12.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('689','POLLOCK DELIVERANCE','A Intrepid Story of a Madman And a Frisbee who must Outgun a Boat in The Sahara Desert','2006','1',NULL,'5','2.99','137','14.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('690','POND SEATTLE','A Stunning Drama of a Teacher And a Boat who must Battle a Feminist in Ancient China','2006','1',NULL,'7','2.99','185','25.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('691','POSEIDON FOREVER','A Thoughtful Epistle of a Womanizer And a Monkey who must Vanquish a Dentist in A Monastery','2006','1',NULL,'6','4.99','159','29.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('692','POTLUCK MIXED','A Beautiful Story of a Dog And a Technical Writer who must Outgun a Student in A Baloon','2006','1',NULL,'3','2.99','179','10.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('693','POTTER CONNECTICUT','A Thrilling Epistle of a Frisbee And a Cat who must Fight a Technical Writer in Berlin','2006','1',NULL,'5','2.99','115','16.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('694','PREJUDICE OLEANDER','A Epic Saga of a Boy And a Dentist who must Outrace a Madman in A U-Boat','2006','1',NULL,'6','4.99','98','15.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('695','PRESIDENT BANG','A Fateful Panorama of a Technical Writer And a Moose who must Battle a Robot in Soviet Georgia','2006','1',NULL,'6','4.99','144','12.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('696','PRIDE ALAMO','A Thoughtful Drama of a A Shark And a Forensic Psychologist who must Vanquish a Student in Ancient India','2006','1',NULL,'6','0.99','114','20.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('697','PRIMARY GLASS','A Fateful Documentary of a Pastry Chef And a Butler who must Build a Dog in The Canadian Rockies','2006','1',NULL,'7','0.99','53','16.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('698','PRINCESS GIANT','A Thrilling Yarn of a Pastry Chef And a Monkey who must Battle a Monkey in A Shark Tank','2006','1',NULL,'3','2.99','71','29.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('699','PRIVATE DROP','A Stunning Story of a Technical Writer And a Hunter who must Succumb a Secret Agent in A Baloon','2006','1',NULL,'7','4.99','106','26.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('700','PRIX UNDEFEATED','A Stunning Saga of a Mad Scientist And a Boat who must Overcome a Dentist in Ancient China','2006','1',NULL,'4','2.99','115','13.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('701','PSYCHO SHRUNK','A Amazing Panorama of a Crocodile And a Explorer who must Fight a Husband in Nigeria','2006','1',NULL,'5','2.99','155','11.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('702','PULP BEVERLY','A Unbelieveable Display of a Dog And a Crocodile who must Outrace a Man in Nigeria','2006','1',NULL,'4','2.99','89','12.99','G','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('703','PUNK DIVORCE','A Fast-Paced Tale of a Pastry Chef And a Boat who must Face a Frisbee in The Canadian Rockies','2006','1',NULL,'6','4.99','100','18.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('704','PURE RUNNER','A Thoughtful Documentary of a Student And a Madman who must Challenge a Squirrel in A Manhattan Penthouse','2006','1',NULL,'3','2.99','121','25.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('705','PURPLE MOVIE','A Boring Display of a Pastry Chef And a Sumo Wrestler who must Discover a Frisbee in An Abandoned Amusement Park','2006','1',NULL,'4','2.99','88','9.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('706','QUEEN LUKE','A Astounding Story of a Girl And a Boy who must Challenge a Composer in New Orleans','2006','1',NULL,'5','4.99','163','22.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('707','QUEST MUSSOLINI','A Fateful Drama of a Husband And a Sumo Wrestler who must Battle a Pastry Chef in A Baloon Factory','2006','1',NULL,'5','2.99','177','29.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('708','QUILLS BULL','A Thoughtful Story of a Pioneer And a Woman who must Reach a Moose in Australia','2006','1',NULL,'4','4.99','112','19.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('709','RACER EGG','A Emotional Display of a Monkey And a Waitress who must Reach a Secret Agent in California','2006','1',NULL,'7','2.99','147','19.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('710','RAGE GAMES','A Fast-Paced Saga of a Astronaut And a Secret Agent who must Escape a Hunter in An Abandoned Amusement Park','2006','1',NULL,'4','4.99','120','18.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('711','RAGING AIRPLANE','A Astounding Display of a Secret Agent And a Technical Writer who must Escape a Mad Scientist in A Jet Boat','2006','1',NULL,'4','4.99','154','18.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('712','RAIDERS ANTITRUST','A Amazing Drama of a Teacher And a Feminist who must Meet a Woman in The First Manned Space Station','2006','1',NULL,'4','0.99','82','11.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('713','RAINBOW SHOCK','A Action-Packed Story of a Hunter And a Boy who must Discover a Lumberjack in Ancient India','2006','1',NULL,'3','4.99','74','14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('714','RANDOM GO','A Fateful Drama of a Frisbee And a Student who must Confront a Cat in A Shark Tank','2006','1',NULL,'6','2.99','73','29.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('715','RANGE MOONWALKER','A Insightful Documentary of a Hunter And a Dentist who must Confront a Crocodile in A Baloon','2006','1',NULL,'3','4.99','147','25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('716','REAP UNFAITHFUL','A Thrilling Epistle of a Composer And a Sumo Wrestler who must Challenge a Mad Cow in A MySQL Convention','2006','1',NULL,'6','2.99','136','26.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('717','REAR TRADING','A Awe-Inspiring Reflection of a Forensic Psychologist And a Secret Agent who must Succumb a Pastry Chef in Soviet Georgia','2006','1',NULL,'6','0.99','97','23.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('718','REBEL AIRPORT','A Intrepid Yarn of a Database Administrator And a Boat who must Outrace a Husband in Ancient India','2006','1',NULL,'7','0.99','73','24.99','G','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('719','RECORDS ZORRO','A Amazing Drama of a Mad Scientist And a Composer who must Build a Husband in The Outback','2006','1',NULL,'7','4.99','182','11.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('720','REDEMPTION COMFORTS','A Emotional Documentary of a Dentist And a Woman who must Battle a Mad Scientist in Ancient China','2006','1',NULL,'3','2.99','179','20.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('721','REDS POCUS','A Lacklusture Yarn of a Sumo Wrestler And a Squirrel who must Redeem a Monkey in Soviet Georgia','2006','1',NULL,'7','4.99','182','23.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('722','REEF SALUTE','A Action-Packed Saga of a Teacher And a Lumberjack who must Battle a Dentist in A Baloon','2006','1',NULL,'5','0.99','123','26.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('723','REIGN GENTLEMEN','A Emotional Yarn of a Composer And a Man who must Escape a Butler in The Gulf of Mexico','2006','1',NULL,'3','2.99','82','29.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('724','REMEMBER DIARY','A Insightful Tale of a Technical Writer And a Waitress who must Conquer a Monkey in Ancient India','2006','1',NULL,'5','2.99','110','15.99','R','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('725','REQUIEM TYCOON','A Unbelieveable Character Study of a Cat And a Database Administrator who must Pursue a Teacher in A Monastery','2006','1',NULL,'6','4.99','167','25.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('726','RESERVOIR ADAPTATION','A Intrepid Drama of a Teacher And a Moose who must Kill a Car in California','2006','1',NULL,'7','2.99','61','29.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('727','RESURRECTION SILVERADO','A Epic Yarn of a Robot And a Explorer who must Challenge a Girl in A MySQL Convention','2006','1',NULL,'6','0.99','117','12.99','PG','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('728','REUNION WITCHES','A Unbelieveable Documentary of a Database Administrator And a Frisbee who must Redeem a Mad Scientist in A Baloon Factory','2006','1',NULL,'3','0.99','63','26.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('729','RIDER CADDYSHACK','A Taut Reflection of a Monkey And a Womanizer who must Chase a Moose in Nigeria','2006','1',NULL,'5','2.99','177','28.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('730','RIDGEMONT SUBMARINE','A Unbelieveable Drama of a Waitress And a Composer who must Sink a Mad Cow in Ancient Japan','2006','1',NULL,'3','0.99','46','28.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('731','RIGHT CRANES','A Fateful Character Study of a Boat And a Cat who must Find a Database Administrator in A Jet Boat','2006','1',NULL,'7','4.99','153','29.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('732','RINGS HEARTBREAKERS','A Amazing Yarn of a Sumo Wrestler And a Boat who must Conquer a Waitress in New Orleans','2006','1',NULL,'5','0.99','58','17.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('733','RIVER OUTLAW','A Thrilling Character Study of a Squirrel And a Lumberjack who must Face a Hunter in A MySQL Convention','2006','1',NULL,'4','0.99','149','29.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('734','ROAD ROXANNE','A Boring Character Study of a Waitress And a Astronaut who must Fight a Crocodile in Ancient Japan','2006','1',NULL,'4','4.99','158','12.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('735','ROBBERS JOON','A Thoughtful Story of a Mad Scientist And a Waitress who must Confront a Forensic Psychologist in Soviet Georgia','2006','1',NULL,'7','2.99','102','26.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('736','ROBBERY BRIGHT','A Taut Reflection of a Robot And a Squirrel who must Fight a Boat in Ancient Japan','2006','1',NULL,'4','0.99','134','21.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('737','ROCK INSTINCT','A Astounding Character Study of a Robot And a Moose who must Overcome a Astronaut in Ancient India','2006','1',NULL,'4','0.99','102','28.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('738','ROCKETEER MOTHER','A Awe-Inspiring Character Study of a Robot And a Sumo Wrestler who must Discover a Womanizer in A Shark Tank','2006','1',NULL,'3','0.99','178','27.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('739','ROCKY WAR','A Fast-Paced Display of a Squirrel And a Explorer who must Outgun a Mad Scientist in Nigeria','2006','1',NULL,'4','4.99','145','17.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('740','ROLLERCOASTER BRINGING','A Beautiful Drama of a Robot And a Lumberjack who must Discover a Technical Writer in A Shark Tank','2006','1',NULL,'5','2.99','153','13.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('741','ROMAN PUNK','A Thoughtful Panorama of a Mad Cow And a Student who must Battle a Forensic Psychologist in Berlin','2006','1',NULL,'7','0.99','81','28.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('742','ROOF CHAMPION','A Lacklusture Reflection of a Car And a Explorer who must Find a Monkey in A Baloon','2006','1',NULL,'7','0.99','101','25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('743','ROOM ROMAN','A Awe-Inspiring Panorama of a Composer And a Secret Agent who must Sink a Composer in A Shark Tank','2006','1',NULL,'7','0.99','60','27.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('744','ROOTS REMEMBER','A Brilliant Drama of a Mad Cow And a Hunter who must Escape a Hunter in Berlin','2006','1',NULL,'4','0.99','89','23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('745','ROSES TREASURE','A Astounding Panorama of a Monkey And a Secret Agent who must Defeat a Woman in The First Manned Space Station','2006','1',NULL,'5','4.99','162','23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('746','ROUGE SQUAD','A Awe-Inspiring Drama of a Astronaut And a Frisbee who must Conquer a Mad Scientist in Australia','2006','1',NULL,'3','0.99','118','10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('747','ROXANNE REBEL','A Astounding Story of a Pastry Chef And a Database Administrator who must Fight a Man in The Outback','2006','1',NULL,'5','0.99','171','9.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('748','RUGRATS SHAKESPEARE','A Touching Saga of a Crocodile And a Crocodile who must Discover a Technical Writer in Nigeria','2006','1',NULL,'4','0.99','109','16.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('749','RULES HUMAN','A Beautiful Epistle of a Astronaut And a Student who must Confront a Monkey in An Abandoned Fun House','2006','1',NULL,'6','4.99','153','19.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('750','RUN PACIFIC','A Touching Tale of a Cat And a Pastry Chef who must Conquer a Pastry Chef in A MySQL Convention','2006','1',NULL,'3','0.99','145','25.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('751','RUNAWAY TENENBAUMS','A Thoughtful Documentary of a Boat And a Man who must Meet a Boat in An Abandoned Fun House','2006','1',NULL,'6','0.99','181','17.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('752','RUNNER MADIGAN','A Thoughtful Documentary of a Crocodile And a Robot who must Outrace a Womanizer in The Outback','2006','1',NULL,'6','0.99','101','27.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('753','RUSH GOODFELLAS','A Emotional Display of a Man And a Dentist who must Challenge a Squirrel in Australia','2006','1',NULL,'3','0.99','48','20.99','PG','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('754','RUSHMORE MERMAID','A Boring Story of a Woman And a Moose who must Reach a Husband in A Shark Tank','2006','1',NULL,'6','2.99','150','17.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('755','SABRINA MIDNIGHT','A Emotional Story of a Squirrel And a Crocodile who must Succumb a Husband in The Sahara Desert','2006','1',NULL,'5','4.99','99','11.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('756','SADDLE ANTITRUST','A Stunning Epistle of a Feminist And a A Shark who must Battle a Woman in An Abandoned Fun House','2006','1',NULL,'7','2.99','80','10.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('757','SAGEBRUSH CLUELESS','A Insightful Story of a Lumberjack And a Hunter who must Kill a Boy in Ancient Japan','2006','1',NULL,'4','2.99','106','28.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('758','SAINTS BRIDE','A Fateful Tale of a Technical Writer And a Composer who must Pursue a Explorer in The Gulf of Mexico','2006','1',NULL,'5','2.99','125','11.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('759','SALUTE APOLLO','A Awe-Inspiring Character Study of a Boy And a Feminist who must Sink a Crocodile in Ancient China','2006','1',NULL,'4','2.99','73','29.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('760','SAMURAI LION','A Fast-Paced Story of a Pioneer And a Astronaut who must Reach a Boat in A Baloon','2006','1',NULL,'5','2.99','110','21.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('761','SANTA PARIS','A Emotional Documentary of a Moose And a Car who must Redeem a Mad Cow in A Baloon Factory','2006','1',NULL,'7','2.99','154','23.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('762','SASSY PACKER','A Fast-Paced Documentary of a Dog And a Teacher who must Find a Moose in A Manhattan Penthouse','2006','1',NULL,'6','0.99','154','29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('763','SATISFACTION CONFIDENTIAL','A Lacklusture Yarn of a Dentist And a Butler who must Meet a Secret Agent in Ancient China','2006','1',NULL,'3','4.99','75','26.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('764','SATURDAY LAMBS','A Thoughtful Reflection of a Mad Scientist And a Moose who must Kill a Husband in A Baloon','2006','1',NULL,'3','4.99','150','28.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('765','SATURN NAME','A Fateful Epistle of a Butler And a Boy who must Redeem a Teacher in Berlin','2006','1',NULL,'7','4.99','182','18.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('766','SAVANNAH TOWN','A Awe-Inspiring Tale of a Astronaut And a Database Administrator who must Chase a Secret Agent in The Gulf of Mexico','2006','1',NULL,'5','0.99','84','25.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('767','SCALAWAG DUCK','A Fateful Reflection of a Car And a Teacher who must Confront a Waitress in A Monastery','2006','1',NULL,'6','4.99','183','13.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('768','SCARFACE BANG','A Emotional Yarn of a Teacher And a Girl who must Find a Teacher in A Baloon Factory','2006','1',NULL,'3','4.99','102','11.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('769','SCHOOL JACKET','A Intrepid Yarn of a Monkey And a Boy who must Fight a Composer in A Manhattan Penthouse','2006','1',NULL,'5','4.99','151','21.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('770','SCISSORHANDS SLUMS','A Awe-Inspiring Drama of a Girl And a Technical Writer who must Meet a Feminist in The Canadian Rockies','2006','1',NULL,'5','2.99','147','13.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('771','SCORPION APOLLO','A Awe-Inspiring Documentary of a Technical Writer And a Husband who must Meet a Monkey in An Abandoned Fun House','2006','1',NULL,'3','4.99','137','23.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('772','SEA VIRGIN','A Fast-Paced Documentary of a Technical Writer And a Pastry Chef who must Escape a Moose in A U-Boat','2006','1',NULL,'4','2.99','80','24.99','PG','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('773','SEABISCUIT PUNK','A Insightful Saga of a Man And a Forensic Psychologist who must Discover a Mad Cow in A MySQL Convention','2006','1',NULL,'6','2.99','112','28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('774','SEARCHERS WAIT','A Fast-Paced Tale of a Car And a Mad Scientist who must Kill a Womanizer in Ancient Japan','2006','1',NULL,'3','2.99','182','22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('775','SEATTLE EXPECATIONS','A Insightful Reflection of a Crocodile And a Sumo Wrestler who must Meet a Technical Writer in The Sahara Desert','2006','1',NULL,'4','4.99','110','18.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('776','SECRET GROUNDHOG','A Astounding Story of a Cat And a Database Administrator who must Build a Technical Writer in New Orleans','2006','1',NULL,'6','4.99','90','11.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('777','SECRETARY ROUGE','A Action-Packed Panorama of a Mad Cow And a Composer who must Discover a Robot in A Baloon Factory','2006','1',NULL,'5','4.99','158','10.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('778','SECRETS PARADISE','A Fateful Saga of a Cat And a Frisbee who must Kill a Girl in A Manhattan Penthouse','2006','1',NULL,'3','4.99','109','24.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('779','SENSE GREEK','A Taut Saga of a Lumberjack And a Pastry Chef who must Escape a Sumo Wrestler in An Abandoned Fun House','2006','1',NULL,'4','4.99','54','23.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('780','SENSIBILITY REAR','A Emotional Tale of a Robot And a Sumo Wrestler who must Redeem a Pastry Chef in A Baloon Factory','2006','1',NULL,'7','4.99','98','15.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('781','SEVEN SWARM','A Unbelieveable Character Study of a Dog And a Mad Cow who must Kill a Monkey in Berlin','2006','1',NULL,'4','4.99','127','15.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('782','SHAKESPEARE SADDLE','A Fast-Paced Panorama of a Lumberjack And a Database Administrator who must Defeat a Madman in A MySQL Convention','2006','1',NULL,'6','2.99','60','26.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('783','SHANE DARKNESS','A Action-Packed Saga of a Moose And a Lumberjack who must Find a Woman in Berlin','2006','1',NULL,'5','2.99','93','22.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('784','SHANGHAI TYCOON','A Fast-Paced Character Study of a Crocodile And a Lumberjack who must Build a Husband in An Abandoned Fun House','2006','1',NULL,'7','2.99','47','20.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('785','SHAWSHANK BUBBLE','A Lacklusture Story of a Moose And a Monkey who must Confront a Butler in An Abandoned Amusement Park','2006','1',NULL,'6','4.99','80','20.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('786','SHEPHERD MIDSUMMER','A Thoughtful Drama of a Robot And a Womanizer who must Kill a Lumberjack in A Baloon','2006','1',NULL,'7','0.99','113','14.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('787','SHINING ROSES','A Awe-Inspiring Character Study of a Astronaut And a Forensic Psychologist who must Challenge a Madman in Ancient India','2006','1',NULL,'4','0.99','125','12.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('788','SHIP WONDERLAND','A Thrilling Saga of a Monkey And a Frisbee who must Escape a Explorer in The Outback','2006','1',NULL,'5','2.99','104','15.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('789','SHOCK CABIN','A Fateful Tale of a Mad Cow And a Crocodile who must Meet a Husband in New Orleans','2006','1',NULL,'7','2.99','79','15.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('790','SHOOTIST SUPERFLY','A Fast-Paced Story of a Crocodile And a A Shark who must Sink a Pioneer in Berlin','2006','1',NULL,'6','0.99','67','22.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('791','SHOW LORD','A Fanciful Saga of a Student And a Girl who must Find a Butler in Ancient Japan','2006','1',NULL,'3','4.99','167','24.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('792','SHREK LICENSE','A Fateful Yarn of a Secret Agent And a Feminist who must Find a Feminist in A Jet Boat','2006','1',NULL,'7','2.99','154','15.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('793','SHRUNK DIVINE','A Fateful Character Study of a Waitress And a Technical Writer who must Battle a Hunter in A Baloon','2006','1',NULL,'6','2.99','139','14.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('794','SIDE ARK','A Stunning Panorama of a Crocodile And a Womanizer who must Meet a Feminist in The Canadian Rockies','2006','1',NULL,'5','0.99','52','28.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('795','SIEGE MADRE','A Boring Tale of a Frisbee And a Crocodile who must Vanquish a Moose in An Abandoned Mine Shaft','2006','1',NULL,'7','0.99','111','23.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('796','SIERRA DIVIDE','A Emotional Character Study of a Frisbee And a Mad Scientist who must Build a Madman in California','2006','1',NULL,'3','0.99','135','12.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('797','SILENCE KANE','A Emotional Drama of a Sumo Wrestler And a Dentist who must Confront a Sumo Wrestler in A Baloon','2006','1',NULL,'7','0.99','67','23.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('798','SILVERADO GOLDFINGER','A Stunning Epistle of a Sumo Wrestler And a Man who must Challenge a Waitress in Ancient India','2006','1',NULL,'4','4.99','74','11.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('799','SIMON NORTH','A Thrilling Documentary of a Technical Writer And a A Shark who must Face a Pioneer in A Shark Tank','2006','1',NULL,'3','0.99','51','26.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('800','SINNERS ATLANTIS','A Epic Display of a Dog And a Boat who must Succumb a Mad Scientist in An Abandoned Mine Shaft','2006','1',NULL,'7','2.99','126','19.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('801','SISTER FREDDY','A Stunning Saga of a Butler And a Woman who must Pursue a Explorer in Australia','2006','1',NULL,'5','4.99','152','19.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('802','SKY MIRACLE','A Epic Drama of a Mad Scientist And a Explorer who must Succumb a Waitress in An Abandoned Fun House','2006','1',NULL,'7','2.99','132','15.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('803','SLACKER LIAISONS','A Fast-Paced Tale of a A Shark And a Student who must Meet a Crocodile in Ancient China','2006','1',NULL,'7','4.99','179','29.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('804','SLEEPING SUSPECTS','A Stunning Reflection of a Sumo Wrestler And a Explorer who must Sink a Frisbee in A MySQL Convention','2006','1',NULL,'7','4.99','129','13.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('805','SLEEPLESS MONSOON','A Amazing Saga of a Moose And a Pastry Chef who must Escape a Butler in Australia','2006','1',NULL,'5','4.99','64','12.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('806','SLEEPY JAPANESE','A Emotional Epistle of a Moose And a Composer who must Fight a Technical Writer in The Outback','2006','1',NULL,'4','2.99','137','25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('807','SLEUTH ORIENT','A Fateful Character Study of a Husband And a Dog who must Find a Feminist in Ancient India','2006','1',NULL,'4','0.99','87','25.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('808','SLING LUKE','A Intrepid Character Study of a Robot And a Monkey who must Reach a Secret Agent in An Abandoned Amusement Park','2006','1',NULL,'5','0.99','84','10.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('809','SLIPPER FIDELITY','A Taut Reflection of a Secret Agent And a Man who must Redeem a Explorer in A MySQL Convention','2006','1',NULL,'5','0.99','156','14.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('810','SLUMS DUCK','A Amazing Character Study of a Teacher And a Database Administrator who must Defeat a Waitress in A Jet Boat','2006','1',NULL,'5','0.99','147','21.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('811','SMILE EARRING','A Intrepid Drama of a Teacher And a Butler who must Build a Pastry Chef in Berlin','2006','1',NULL,'4','2.99','60','29.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('812','SMOKING BARBARELLA','A Lacklusture Saga of a Mad Cow And a Mad Scientist who must Sink a Cat in A MySQL Convention','2006','1',NULL,'7','0.99','50','13.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('813','SMOOCHY CONTROL','A Thrilling Documentary of a Husband And a Feminist who must Face a Mad Scientist in Ancient China','2006','1',NULL,'7','0.99','184','18.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('814','SNATCH SLIPPER','A Insightful Panorama of a Woman And a Feminist who must Defeat a Forensic Psychologist in Berlin','2006','1',NULL,'6','4.99','110','15.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('815','SNATCHERS MONTEZUMA','A Boring Epistle of a Sumo Wrestler And a Woman who must Escape a Man in The Canadian Rockies','2006','1',NULL,'4','2.99','74','14.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('816','SNOWMAN ROLLERCOASTER','A Fateful Display of a Lumberjack And a Girl who must Succumb a Mad Cow in A Manhattan Penthouse','2006','1',NULL,'3','0.99','62','27.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('817','SOLDIERS EVOLUTION','A Lacklusture Panorama of a A Shark And a Pioneer who must Confront a Student in The First Manned Space Station','2006','1',NULL,'7','4.99','185','27.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('818','SOMETHING DUCK','A Boring Character Study of a Car And a Husband who must Outgun a Frisbee in The First Manned Space Station','2006','1',NULL,'4','4.99','180','17.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('819','SONG HEDWIG','A Amazing Documentary of a Man And a Husband who must Confront a Squirrel in A MySQL Convention','2006','1',NULL,'3','0.99','165','29.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('820','SONS INTERVIEW','A Taut Character Study of a Explorer And a Mad Cow who must Battle a Hunter in Ancient China','2006','1',NULL,'3','2.99','184','11.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('821','SORORITY QUEEN','A Fast-Paced Display of a Squirrel And a Composer who must Fight a Forensic Psychologist in A Jet Boat','2006','1',NULL,'6','0.99','184','17.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('822','SOUP WISDOM','A Fast-Paced Display of a Robot And a Butler who must Defeat a Butler in A MySQL Convention','2006','1',NULL,'6','0.99','169','12.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('823','SOUTH WAIT','A Amazing Documentary of a Car And a Robot who must Escape a Lumberjack in An Abandoned Amusement Park','2006','1',NULL,'4','2.99','143','21.99','R','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('824','SPARTACUS CHEAPER','A Thrilling Panorama of a Pastry Chef And a Secret Agent who must Overcome a Student in A Manhattan Penthouse','2006','1',NULL,'4','4.99','52','19.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('825','SPEAKEASY DATE','A Lacklusture Drama of a Forensic Psychologist And a Car who must Redeem a Man in A Manhattan Penthouse','2006','1',NULL,'6','2.99','165','22.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('826','SPEED SUIT','A Brilliant Display of a Frisbee And a Mad Scientist who must Succumb a Robot in Ancient China','2006','1',NULL,'7','4.99','124','19.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('827','SPICE SORORITY','A Fateful Display of a Pioneer And a Hunter who must Defeat a Husband in An Abandoned Mine Shaft','2006','1',NULL,'5','4.99','141','22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('828','SPIKING ELEMENT','A Lacklusture Epistle of a Dentist And a Technical Writer who must Find a Dog in A Monastery','2006','1',NULL,'7','2.99','79','12.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('829','SPINAL ROCKY','A Lacklusture Epistle of a Sumo Wrestler And a Squirrel who must Defeat a Explorer in California','2006','1',NULL,'7','2.99','138','12.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('830','SPIRIT FLINTSTONES','A Brilliant Yarn of a Cat And a Car who must Confront a Explorer in Ancient Japan','2006','1',NULL,'7','0.99','149','23.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('831','SPIRITED CASUALTIES','A Taut Story of a Waitress And a Man who must Face a Car in A Baloon Factory','2006','1',NULL,'5','0.99','138','20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('832','SPLASH GUMP','A Taut Saga of a Crocodile And a Boat who must Conquer a Hunter in A Shark Tank','2006','1',NULL,'5','0.99','175','16.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('833','SPLENDOR PATTON','A Taut Story of a Dog And a Explorer who must Find a Astronaut in Berlin','2006','1',NULL,'5','0.99','134','20.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('834','SPOILERS HELLFIGHTERS','A Fanciful Story of a Technical Writer And a Squirrel who must Defeat a Dog in The Gulf of Mexico','2006','1',NULL,'4','0.99','151','26.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('835','SPY MILE','A Thrilling Documentary of a Feminist And a Feminist who must Confront a Feminist in A Baloon','2006','1',NULL,'6','2.99','112','13.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('836','SQUAD FISH','A Fast-Paced Display of a Pastry Chef And a Dog who must Kill a Teacher in Berlin','2006','1',NULL,'3','2.99','136','14.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('837','STAGE WORLD','A Lacklusture Panorama of a Woman And a Frisbee who must Chase a Crocodile in A Jet Boat','2006','1',NULL,'4','2.99','85','19.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('838','STAGECOACH ARMAGEDDON','A Touching Display of a Pioneer And a Butler who must Chase a Car in California','2006','1',NULL,'5','4.99','112','25.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('839','STALLION SUNDANCE','A Fast-Paced Tale of a Car And a Dog who must Outgun a A Shark in Australia','2006','1',NULL,'5','0.99','130','23.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('840','STAMPEDE DISTURBING','A Unbelieveable Tale of a Woman And a Lumberjack who must Fight a Frisbee in A U-Boat','2006','1',NULL,'5','0.99','75','26.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('841','STAR OPERATION','A Insightful Character Study of a Girl And a Car who must Pursue a Mad Cow in A Shark Tank','2006','1',NULL,'5','2.99','181','9.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('842','STATE WASTELAND','A Beautiful Display of a Cat And a Pastry Chef who must Outrace a Mad Cow in A Jet Boat','2006','1',NULL,'4','2.99','113','13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('843','STEEL SANTA','A Fast-Paced Yarn of a Composer And a Frisbee who must Face a Moose in Nigeria','2006','1',NULL,'4','4.99','143','15.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('844','STEERS ARMAGEDDON','A Stunning Character Study of a Car And a Girl who must Succumb a Car in A MySQL Convention','2006','1',NULL,'6','4.99','140','16.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('845','STEPMOM DREAM','A Touching Epistle of a Crocodile And a Teacher who must Build a Forensic Psychologist in A MySQL Convention','2006','1',NULL,'7','4.99','48','9.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('846','STING PERSONAL','A Fanciful Drama of a Frisbee And a Dog who must Fight a Madman in A Jet Boat','2006','1',NULL,'3','4.99','93','9.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('847','STOCK GLASS','A Boring Epistle of a Crocodile And a Lumberjack who must Outgun a Moose in Ancient China','2006','1',NULL,'7','2.99','160','10.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('848','STONE FIRE','A Intrepid Drama of a Astronaut And a Crocodile who must Find a Boat in Soviet Georgia','2006','1',NULL,'3','0.99','94','19.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('849','STORM HAPPINESS','A Insightful Drama of a Feminist And a A Shark who must Vanquish a Boat in A Shark Tank','2006','1',NULL,'6','0.99','57','28.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('850','STORY SIDE','A Lacklusture Saga of a Boy And a Cat who must Sink a Dentist in An Abandoned Mine Shaft','2006','1',NULL,'7','0.99','163','27.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('851','STRAIGHT HOURS','A Boring Panorama of a Secret Agent And a Girl who must Sink a Waitress in The Outback','2006','1',NULL,'3','0.99','151','19.99','R','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('852','STRANGELOVE DESIRE','A Awe-Inspiring Panorama of a Lumberjack And a Waitress who must Defeat a Crocodile in An Abandoned Amusement Park','2006','1',NULL,'4','0.99','103','27.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('853','STRANGER STRANGERS','A Awe-Inspiring Yarn of a Womanizer And a Explorer who must Fight a Woman in The First Manned Space Station','2006','1',NULL,'3','4.99','139','12.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('854','STRANGERS GRAFFITI','A Brilliant Character Study of a Secret Agent And a Man who must Find a Cat in The Gulf of Mexico','2006','1',NULL,'4','4.99','119','22.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('855','STREAK RIDGEMONT','A Astounding Character Study of a Hunter And a Waitress who must Sink a Man in New Orleans','2006','1',NULL,'7','0.99','132','28.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('856','STREETCAR INTENTIONS','A Insightful Character Study of a Waitress And a Crocodile who must Sink a Waitress in The Gulf of Mexico','2006','1',NULL,'5','4.99','73','11.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('857','STRICTLY SCARFACE','A Touching Reflection of a Crocodile And a Dog who must Chase a Hunter in An Abandoned Fun House','2006','1',NULL,'3','2.99','144','24.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('858','SUBMARINE BED','A Amazing Display of a Car And a Monkey who must Fight a Teacher in Soviet Georgia','2006','1',NULL,'5','4.99','127','21.99','R','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('859','SUGAR WONKA','A Touching Story of a Dentist And a Database Administrator who must Conquer a Astronaut in An Abandoned Amusement Park','2006','1',NULL,'3','4.99','114','20.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('860','SUICIDES SILENCE','A Emotional Character Study of a Car And a Girl who must Face a Composer in A U-Boat','2006','1',NULL,'4','4.99','93','13.99','G','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('861','SUIT WALLS','A Touching Panorama of a Lumberjack And a Frisbee who must Build a Dog in Australia','2006','1',NULL,'3','4.99','111','12.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('862','SUMMER SCARFACE','A Emotional Panorama of a Lumberjack And a Hunter who must Meet a Girl in A Shark Tank','2006','1',NULL,'5','0.99','53','25.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('863','SUN CONFESSIONS','A Beautiful Display of a Mad Cow And a Dog who must Redeem a Waitress in An Abandoned Amusement Park','2006','1',NULL,'5','0.99','141','9.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('864','SUNDANCE INVASION','A Epic Drama of a Lumberjack And a Explorer who must Confront a Hunter in A Baloon Factory','2006','1',NULL,'5','0.99','92','21.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('865','SUNRISE LEAGUE','A Beautiful Epistle of a Madman And a Butler who must Face a Crocodile in A Manhattan Penthouse','2006','1',NULL,'3','4.99','135','19.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('866','SUNSET RACER','A Awe-Inspiring Reflection of a Astronaut And a A Shark who must Defeat a Forensic Psychologist in California','2006','1',NULL,'6','0.99','48','28.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('867','SUPER WYOMING','A Action-Packed Saga of a Pastry Chef And a Explorer who must Discover a A Shark in The Outback','2006','1',NULL,'5','4.99','58','10.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('868','SUPERFLY TRIP','A Beautiful Saga of a Lumberjack And a Teacher who must Build a Technical Writer in An Abandoned Fun House','2006','1',NULL,'5','0.99','114','27.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('869','SUSPECTS QUILLS','A Emotional Epistle of a Pioneer And a Crocodile who must Battle a Man in A Manhattan Penthouse','2006','1',NULL,'4','2.99','47','22.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('870','SWARM GOLD','A Insightful Panorama of a Crocodile And a Boat who must Conquer a Sumo Wrestler in A MySQL Convention','2006','1',NULL,'4','0.99','123','12.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('871','SWEDEN SHINING','A Taut Documentary of a Car And a Robot who must Conquer a Boy in The Canadian Rockies','2006','1',NULL,'6','4.99','176','19.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('872','SWEET BROTHERHOOD','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Chase a Forensic Psychologist in A Baloon','2006','1',NULL,'3','2.99','185','27.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('873','SWEETHEARTS SUSPECTS','A Brilliant Character Study of a Frisbee And a Sumo Wrestler who must Confront a Woman in The Gulf of Mexico','2006','1',NULL,'3','0.99','108','13.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('874','TADPOLE PARK','A Beautiful Tale of a Frisbee And a Moose who must Vanquish a Dog in An Abandoned Amusement Park','2006','1',NULL,'6','2.99','155','13.99','PG','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('875','TALENTED HOMICIDE','A Lacklusture Panorama of a Dentist And a Forensic Psychologist who must Outrace a Pioneer in A U-Boat','2006','1',NULL,'6','0.99','173','9.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('876','TARZAN VIDEOTAPE','A Fast-Paced Display of a Lumberjack And a Mad Scientist who must Succumb a Sumo Wrestler in The Sahara Desert','2006','1',NULL,'3','2.99','91','11.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('877','TAXI KICK','A Amazing Epistle of a Girl And a Woman who must Outrace a Waitress in Soviet Georgia','2006','1',NULL,'4','0.99','64','23.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('878','TEEN APOLLO','A Awe-Inspiring Drama of a Dog And a Man who must Escape a Robot in A Shark Tank','2006','1',NULL,'3','4.99','74','25.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('879','TELEGRAPH VOYAGE','A Fateful Yarn of a Husband And a Dog who must Battle a Waitress in A Jet Boat','2006','1',NULL,'3','4.99','148','20.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('880','TELEMARK HEARTBREAKERS','A Action-Packed Panorama of a Technical Writer And a Man who must Build a Forensic Psychologist in A Manhattan Penthouse','2006','1',NULL,'6','2.99','152','9.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('881','TEMPLE ATTRACTION','A Action-Packed Saga of a Forensic Psychologist And a Woman who must Battle a Womanizer in Soviet Georgia','2006','1',NULL,'5','4.99','71','13.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('882','TENENBAUMS COMMAND','A Taut Display of a Pioneer And a Man who must Reach a Girl in The Gulf of Mexico','2006','1',NULL,'4','0.99','99','24.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('883','TEQUILA PAST','A Action-Packed Panorama of a Mad Scientist And a Robot who must Challenge a Student in Nigeria','2006','1',NULL,'6','4.99','53','17.99','PG','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('884','TERMINATOR CLUB','A Touching Story of a Crocodile And a Girl who must Sink a Man in The Gulf of Mexico','2006','1',NULL,'5','4.99','88','11.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('885','TEXAS WATCH','A Awe-Inspiring Yarn of a Student And a Teacher who must Fight a Teacher in An Abandoned Amusement Park','2006','1',NULL,'7','0.99','179','22.99','NC-17','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('886','THEORY MERMAID','A Fateful Yarn of a Composer And a Monkey who must Vanquish a Womanizer in The First Manned Space Station','2006','1',NULL,'5','0.99','184','9.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('887','THIEF PELICAN','A Touching Documentary of a Madman And a Mad Scientist who must Outrace a Feminist in An Abandoned Mine Shaft','2006','1',NULL,'5','4.99','135','28.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('888','THIN SAGEBRUSH','A Emotional Drama of a Husband And a Lumberjack who must Build a Cat in Ancient India','2006','1',NULL,'5','4.99','53','9.99','PG-13','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('889','TIES HUNGER','A Insightful Saga of a Astronaut And a Explorer who must Pursue a Mad Scientist in A U-Boat','2006','1',NULL,'3','4.99','111','28.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('890','TIGHTS DAWN','A Thrilling Epistle of a Boat And a Secret Agent who must Face a Boy in A Baloon','2006','1',NULL,'5','0.99','172','14.99','R','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('891','TIMBERLAND SKY','A Boring Display of a Man And a Dog who must Redeem a Girl in A U-Boat','2006','1',NULL,'3','0.99','69','13.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('892','TITANIC BOONDOCK','A Brilliant Reflection of a Feminist And a Dog who must Fight a Boy in A Baloon Factory','2006','1',NULL,'3','4.99','104','18.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('893','TITANS JERK','A Unbelieveable Panorama of a Feminist And a Sumo Wrestler who must Challenge a Technical Writer in Ancient China','2006','1',NULL,'4','4.99','91','11.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('894','TOMATOES HELLFIGHTERS','A Thoughtful Epistle of a Madman And a Astronaut who must Overcome a Monkey in A Shark Tank','2006','1',NULL,'6','0.99','68','23.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('895','TOMORROW HUSTLER','A Thoughtful Story of a Moose And a Husband who must Face a Secret Agent in The Sahara Desert','2006','1',NULL,'3','2.99','142','21.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('896','TOOTSIE PILOT','A Awe-Inspiring Documentary of a Womanizer And a Pastry Chef who must Kill a Lumberjack in Berlin','2006','1',NULL,'3','0.99','157','10.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('897','TORQUE BOUND','A Emotional Display of a Crocodile And a Husband who must Reach a Man in Ancient Japan','2006','1',NULL,'3','4.99','179','27.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('898','TOURIST PELICAN','A Boring Story of a Butler And a Astronaut who must Outrace a Pioneer in Australia','2006','1',NULL,'4','4.99','152','18.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('899','TOWERS HURRICANE','A Fateful Display of a Monkey And a Car who must Sink a Husband in A MySQL Convention','2006','1',NULL,'7','0.99','144','14.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('900','TOWN ARK','A Awe-Inspiring Documentary of a Moose And a Madman who must Meet a Dog in An Abandoned Mine Shaft','2006','1',NULL,'6','2.99','136','17.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('901','TRACY CIDER','A Touching Reflection of a Database Administrator And a Madman who must Build a Lumberjack in Nigeria','2006','1',NULL,'3','0.99','142','29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('902','TRADING PINOCCHIO','A Emotional Character Study of a Student And a Explorer who must Discover a Frisbee in The First Manned Space Station','2006','1',NULL,'6','4.99','170','22.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('903','TRAFFIC HOBBIT','A Amazing Epistle of a Squirrel And a Lumberjack who must Succumb a Database Administrator in A U-Boat','2006','1',NULL,'5','4.99','139','13.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('904','TRAIN BUNCH','A Thrilling Character Study of a Robot And a Squirrel who must Face a Dog in Ancient India','2006','1',NULL,'3','4.99','71','26.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('905','TRAINSPOTTING STRANGERS','A Fast-Paced Drama of a Pioneer And a Mad Cow who must Challenge a Madman in Ancient Japan','2006','1',NULL,'7','4.99','132','10.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('906','TRAMP OTHERS','A Brilliant Display of a Composer And a Cat who must Succumb a A Shark in Ancient India','2006','1',NULL,'4','0.99','171','27.99','PG','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('907','TRANSLATION SUMMER','A Touching Reflection of a Man And a Monkey who must Pursue a Womanizer in A MySQL Convention','2006','1',NULL,'4','0.99','168','10.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('908','TRAP GUYS','A Unbelieveable Story of a Boy And a Mad Cow who must Challenge a Database Administrator in The Sahara Desert','2006','1',NULL,'3','4.99','110','11.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('909','TREASURE COMMAND','A Emotional Saga of a Car And a Madman who must Discover a Pioneer in California','2006','1',NULL,'3','0.99','102','28.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('910','TREATMENT JEKYLL','A Boring Story of a Teacher And a Student who must Outgun a Cat in An Abandoned Mine Shaft','2006','1',NULL,'3','0.99','87','19.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('911','TRIP NEWTON','A Fanciful Character Study of a Lumberjack And a Car who must Discover a Cat in An Abandoned Amusement Park','2006','1',NULL,'7','4.99','64','14.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('912','TROJAN TOMORROW','A Astounding Panorama of a Husband And a Sumo Wrestler who must Pursue a Boat in Ancient India','2006','1',NULL,'3','2.99','52','9.99','PG','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('913','TROOPERS METAL','A Fanciful Drama of a Monkey And a Feminist who must Sink a Man in Berlin','2006','1',NULL,'3','0.99','115','20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('914','TROUBLE DATE','A Lacklusture Panorama of a Forensic Psychologist And a Woman who must Kill a Explorer in Ancient Japan','2006','1',NULL,'6','2.99','61','13.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('915','TRUMAN CRAZY','A Thrilling Epistle of a Moose And a Boy who must Meet a Database Administrator in A Monastery','2006','1',NULL,'7','4.99','92','9.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('916','TURN STAR','A Stunning Tale of a Man And a Monkey who must Chase a Student in New Orleans','2006','1',NULL,'3','2.99','80','10.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('917','TUXEDO MILE','A Boring Drama of a Man And a Forensic Psychologist who must Face a Frisbee in Ancient India','2006','1',NULL,'3','2.99','152','24.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('918','TWISTED PIRATES','A Touching Display of a Frisbee And a Boat who must Kill a Girl in A MySQL Convention','2006','1',NULL,'4','4.99','152','23.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('919','TYCOON GATHERING','A Emotional Display of a Husband And a A Shark who must Succumb a Madman in A Manhattan Penthouse','2006','1',NULL,'3','4.99','82','17.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('920','UNBREAKABLE KARATE','A Amazing Character Study of a Robot And a Student who must Chase a Robot in Australia','2006','1',NULL,'3','0.99','62','16.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('921','UNCUT SUICIDES','A Intrepid Yarn of a Explorer And a Pastry Chef who must Pursue a Mad Cow in A U-Boat','2006','1',NULL,'7','2.99','172','29.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('922','UNDEFEATED DALMATIONS','A Unbelieveable Display of a Crocodile And a Feminist who must Overcome a Moose in An Abandoned Amusement Park','2006','1',NULL,'7','4.99','107','22.99','PG-13','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('923','UNFAITHFUL KILL','A Taut Documentary of a Waitress And a Mad Scientist who must Battle a Technical Writer in New Orleans','2006','1',NULL,'7','2.99','78','12.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('924','UNFORGIVEN ZOOLANDER','A Taut Epistle of a Monkey And a Sumo Wrestler who must Vanquish a A Shark in A Baloon Factory','2006','1',NULL,'7','0.99','129','15.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('925','UNITED PILOT','A Fast-Paced Reflection of a Cat And a Mad Cow who must Fight a Car in The Sahara Desert','2006','1',NULL,'3','0.99','164','27.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('926','UNTOUCHABLES SUNRISE','A Amazing Documentary of a Woman And a Astronaut who must Outrace a Teacher in An Abandoned Fun House','2006','1',NULL,'5','2.99','120','11.99','NC-17','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('927','UPRISING UPTOWN','A Fanciful Reflection of a Boy And a Butler who must Pursue a Woman in Berlin','2006','1',NULL,'6','2.99','174','16.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('928','UPTOWN YOUNG','A Fateful Documentary of a Dog And a Hunter who must Pursue a Teacher in An Abandoned Amusement Park','2006','1',NULL,'5','2.99','84','16.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('929','USUAL UNTOUCHABLES','A Touching Display of a Explorer And a Lumberjack who must Fight a Forensic Psychologist in A Shark Tank','2006','1',NULL,'5','4.99','128','21.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('930','VACATION BOONDOCK','A Fanciful Character Study of a Secret Agent And a Mad Scientist who must Reach a Teacher in Australia','2006','1',NULL,'4','2.99','145','23.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('931','VALENTINE VANISHING','A Thrilling Display of a Husband And a Butler who must Reach a Pastry Chef in California','2006','1',NULL,'7','0.99','48','9.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('932','VALLEY PACKER','A Astounding Documentary of a Astronaut And a Boy who must Outrace a Sumo Wrestler in Berlin','2006','1',NULL,'3','0.99','73','21.99','G','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('933','VAMPIRE WHALE','A Epic Story of a Lumberjack And a Monkey who must Confront a Pioneer in A MySQL Convention','2006','1',NULL,'4','4.99','126','11.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('934','VANILLA DAY','A Fast-Paced Saga of a Girl And a Forensic Psychologist who must Redeem a Girl in Nigeria','2006','1',NULL,'7','4.99','122','20.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('935','VANISHED GARDEN','A Intrepid Character Study of a Squirrel And a A Shark who must Kill a Lumberjack in California','2006','1',NULL,'5','0.99','142','17.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('936','VANISHING ROCKY','A Brilliant Reflection of a Man And a Woman who must Conquer a Pioneer in A MySQL Convention','2006','1',NULL,'3','2.99','123','21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('937','VARSITY TRIP','A Action-Packed Character Study of a Astronaut And a Explorer who must Reach a Monkey in A MySQL Convention','2006','1',NULL,'7','2.99','85','14.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('938','VELVET TERMINATOR','A Lacklusture Tale of a Pastry Chef And a Technical Writer who must Confront a Crocodile in An Abandoned Amusement Park','2006','1',NULL,'3','4.99','173','14.99','R','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('939','VERTIGO NORTHWEST','A Unbelieveable Display of a Mad Scientist And a Mad Scientist who must Outgun a Mad Cow in Ancient Japan','2006','1',NULL,'4','2.99','90','17.99','R','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('940','VICTORY ACADEMY','A Insightful Epistle of a Mad Scientist And a Explorer who must Challenge a Cat in The Sahara Desert','2006','1',NULL,'6','0.99','64','19.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('941','VIDEOTAPE ARSENIC','A Lacklusture Display of a Girl And a Astronaut who must Succumb a Student in Australia','2006','1',NULL,'4','4.99','145','10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('942','VIETNAM SMOOCHY','A Lacklusture Display of a Butler And a Man who must Sink a Explorer in Soviet Georgia','2006','1',NULL,'7','0.99','174','27.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('943','VILLAIN DESPERATE','A Boring Yarn of a Pioneer And a Feminist who must Redeem a Cat in An Abandoned Amusement Park','2006','1',NULL,'4','4.99','76','27.99','PG-13','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('944','VIRGIN DAISY','A Awe-Inspiring Documentary of a Robot And a Mad Scientist who must Reach a Database Administrator in A Shark Tank','2006','1',NULL,'6','4.99','179','29.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('945','VIRGINIAN PLUTO','A Emotional Panorama of a Dentist And a Crocodile who must Meet a Boy in Berlin','2006','1',NULL,'5','0.99','164','22.99','R','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('946','VIRTUAL SPOILERS','A Fateful Tale of a Database Administrator And a Squirrel who must Discover a Student in Soviet Georgia','2006','1',NULL,'3','4.99','144','14.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('947','VISION TORQUE','A Thoughtful Documentary of a Dog And a Man who must Sink a Man in A Shark Tank','2006','1',NULL,'5','0.99','59','16.99','PG-13','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('948','VOICE PEACH','A Amazing Panorama of a Pioneer And a Student who must Overcome a Mad Scientist in A Manhattan Penthouse','2006','1',NULL,'6','0.99','139','22.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('949','VOLCANO TEXAS','A Awe-Inspiring Yarn of a Hunter And a Feminist who must Challenge a Dentist in The Outback','2006','1',NULL,'6','0.99','157','27.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('950','VOLUME HOUSE','A Boring Tale of a Dog And a Woman who must Meet a Dentist in California','2006','1',NULL,'7','4.99','132','12.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('951','VOYAGE LEGALLY','A Epic Tale of a Squirrel And a Hunter who must Conquer a Boy in An Abandoned Mine Shaft','2006','1',NULL,'6','0.99','78','28.99','PG-13','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('952','WAGON JAWS','A Intrepid Drama of a Moose And a Boat who must Kill a Explorer in A Manhattan Penthouse','2006','1',NULL,'7','2.99','152','17.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('953','WAIT CIDER','A Intrepid Epistle of a Woman And a Forensic Psychologist who must Succumb a Astronaut in A Manhattan Penthouse','2006','1',NULL,'3','0.99','112','9.99','PG-13','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('954','WAKE JAWS','A Beautiful Saga of a Feminist And a Composer who must Challenge a Moose in Berlin','2006','1',NULL,'7','4.99','73','18.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('955','WALLS ARTIST','A Insightful Panorama of a Teacher And a Teacher who must Overcome a Mad Cow in An Abandoned Fun House','2006','1',NULL,'7','4.99','135','19.99','PG','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('956','WANDA CHAMBER','A Insightful Drama of a A Shark And a Pioneer who must Find a Womanizer in The Outback','2006','1',NULL,'7','4.99','107','23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('957','WAR NOTTING','A Boring Drama of a Teacher And a Sumo Wrestler who must Challenge a Secret Agent in The Canadian Rockies','2006','1',NULL,'7','4.99','80','26.99','G','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('958','WARDROBE PHANTOM','A Action-Packed Display of a Mad Cow And a Astronaut who must Kill a Car in Ancient India','2006','1',NULL,'6','2.99','178','19.99','G','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('959','WARLOCK WEREWOLF','A Astounding Yarn of a Pioneer And a Crocodile who must Defeat a A Shark in The Outback','2006','1',NULL,'6','2.99','83','10.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('960','WARS PLUTO','A Taut Reflection of a Teacher And a Database Administrator who must Chase a Madman in The Sahara Desert','2006','1',NULL,'5','2.99','128','15.99','G','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('961','WASH HEAVENLY','A Awe-Inspiring Reflection of a Cat And a Pioneer who must Escape a Hunter in Ancient China','2006','1',NULL,'7','4.99','161','22.99','R','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('962','WASTELAND DIVINE','A Fanciful Story of a Database Administrator And a Womanizer who must Fight a Database Administrator in Ancient China','2006','1',NULL,'7','2.99','85','18.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('963','WATCH TRACY','A Fast-Paced Yarn of a Dog And a Frisbee who must Conquer a Hunter in Nigeria','2006','1',NULL,'5','0.99','78','12.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('964','WATERFRONT DELIVERANCE','A Unbelieveable Documentary of a Dentist And a Technical Writer who must Build a Womanizer in Nigeria','2006','1',NULL,'4','4.99','61','17.99','G','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('965','WATERSHIP FRONTIER','A Emotional Yarn of a Boat And a Crocodile who must Meet a Moose in Soviet Georgia','2006','1',NULL,'6','0.99','112','28.99','G','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('966','WEDDING APOLLO','A Action-Packed Tale of a Student And a Waitress who must Conquer a Lumberjack in An Abandoned Mine Shaft','2006','1',NULL,'3','0.99','70','14.99','PG','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('967','WEEKEND PERSONAL','A Fast-Paced Documentary of a Car And a Butler who must Find a Frisbee in A Jet Boat','2006','1',NULL,'5','2.99','134','26.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('968','WEREWOLF LOLA','A Fanciful Story of a Man And a Sumo Wrestler who must Outrace a Student in A Monastery','2006','1',NULL,'6','4.99','79','19.99','G','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('969','WEST LION','A Intrepid Drama of a Butler And a Lumberjack who must Challenge a Database Administrator in A Manhattan Penthouse','2006','1',NULL,'4','4.99','159','29.99','G','Trailers','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('970','WESTWARD SEABISCUIT','A Lacklusture Tale of a Butler And a Husband who must Face a Boy in Ancient China','2006','1',NULL,'7','0.99','52','11.99','NC-17','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('971','WHALE BIKINI','A Intrepid Story of a Pastry Chef And a Database Administrator who must Kill a Feminist in A MySQL Convention','2006','1',NULL,'4','4.99','109','11.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('972','WHISPERER GIANT','A Intrepid Story of a Dentist And a Hunter who must Confront a Monkey in Ancient Japan','2006','1',NULL,'4','4.99','59','24.99','PG-13','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('973','WIFE TURN','A Awe-Inspiring Epistle of a Teacher And a Feminist who must Confront a Pioneer in Ancient Japan','2006','1',NULL,'3','4.99','183','27.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('974','WILD APOLLO','A Beautiful Story of a Monkey And a Sumo Wrestler who must Conquer a A Shark in A MySQL Convention','2006','1',NULL,'4','0.99','181','24.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('975','WILLOW TRACY','A Brilliant Panorama of a Boat And a Astronaut who must Challenge a Teacher in A Manhattan Penthouse','2006','1',NULL,'6','2.99','137','22.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('976','WIND PHANTOM','A Touching Saga of a Madman And a Forensic Psychologist who must Build a Sumo Wrestler in An Abandoned Mine Shaft','2006','1',NULL,'6','0.99','111','12.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('977','WINDOW SIDE','A Astounding Character Study of a Womanizer And a Hunter who must Escape a Robot in A Monastery','2006','1',NULL,'3','2.99','85','25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('978','WISDOM WORKER','A Unbelieveable Saga of a Forensic Psychologist And a Student who must Face a Squirrel in The First Manned Space Station','2006','1',NULL,'3','0.99','98','12.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('979','WITCHES PANIC','A Awe-Inspiring Drama of a Secret Agent And a Hunter who must Fight a Moose in Nigeria','2006','1',NULL,'6','4.99','100','10.99','NC-17','Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('980','WIZARD COLDBLOODED','A Lacklusture Display of a Robot And a Girl who must Defeat a Sumo Wrestler in A MySQL Convention','2006','1',NULL,'4','4.99','75','12.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('981','WOLVES DESIRE','A Fast-Paced Drama of a Squirrel And a Robot who must Succumb a Technical Writer in A Manhattan Penthouse','2006','1',NULL,'7','0.99','55','13.99','NC-17','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('982','WOMEN DORADO','A Insightful Documentary of a Waitress And a Butler who must Vanquish a Composer in Australia','2006','1',NULL,'4','0.99','126','23.99','R','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('983','WON DARES','A Unbelieveable Documentary of a Teacher And a Monkey who must Defeat a Explorer in A U-Boat','2006','1',NULL,'7','2.99','105','18.99','PG','Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('984','WONDERFUL DROP','A Boring Panorama of a Woman And a Madman who must Overcome a Butler in A U-Boat','2006','1',NULL,'3','2.99','126','20.99','NC-17','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('985','WONDERLAND CHRISTMAS','A Awe-Inspiring Character Study of a Waitress And a Car who must Pursue a Mad Scientist in The First Manned Space Station','2006','1',NULL,'4','4.99','111','19.99','PG','Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('986','WONKA SEA','A Brilliant Saga of a Boat And a Mad Scientist who must Meet a Moose in Ancient India','2006','1',NULL,'6','2.99','85','24.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('987','WORDS HUNTER','A Action-Packed Reflection of a Composer And a Mad Scientist who must Face a Pioneer in A MySQL Convention','2006','1',NULL,'3','2.99','116','13.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('988','WORKER TARZAN','A Action-Packed Yarn of a Secret Agent And a Technical Writer who must Battle a Sumo Wrestler in The First Manned Space Station','2006','1',NULL,'7','2.99','139','26.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('989','WORKING MICROCOSMOS','A Stunning Epistle of a Dentist And a Dog who must Kill a Madman in Ancient China','2006','1',NULL,'4','4.99','74','22.99','R','Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('990','WORLD LEATHERNECKS','A Unbelieveable Tale of a Pioneer And a Astronaut who must Overcome a Robot in An Abandoned Amusement Park','2006','1',NULL,'3','0.99','171','13.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('991','WORST BANGER','A Thrilling Drama of a Madman And a Dentist who must Conquer a Boy in The Outback','2006','1',NULL,'4','2.99','185','26.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('992','WRATH MILE','A Intrepid Reflection of a Technical Writer And a Hunter who must Defeat a Sumo Wrestler in A Monastery','2006','1',NULL,'5','0.99','176','17.99','NC-17','Trailers,Commentaries','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('993','WRONG BEHAVIOR','A Emotional Saga of a Crocodile And a Sumo Wrestler who must Discover a Mad Cow in New Orleans','2006','1',NULL,'6','2.99','178','10.99','PG-13','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('994','WYOMING STORM','A Awe-Inspiring Panorama of a Robot And a Boat who must Overcome a Feminist in A U-Boat','2006','1',NULL,'6','4.99','100','29.99','PG-13','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('995','YENTL IDAHO','A Amazing Display of a Robot And a Astronaut who must Fight a Womanizer in Berlin','2006','1',NULL,'5','4.99','86','11.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('996','YOUNG LANGUAGE','A Unbelieveable Yarn of a Boat And a Database Administrator who must Meet a Boy in The First Manned Space Station','2006','1',NULL,'6','0.99','183','9.99','G','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('997','YOUTH KICK','A Touching Drama of a Teacher And a Cat who must Challenge a Technical Writer in A U-Boat','2006','1',NULL,'4','0.99','179','14.99','NC-17','Trailers,Behind the Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('998','ZHIVAGO CORE','A Fateful Yarn of a Composer And a Man who must Face a Boy in The Canadian Rockies','2006','1',NULL,'6','0.99','105','10.99','NC-17','Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('999','ZOOLANDER FICTION','A Fateful Reflection of a Waitress And a Boat who must Discover a Sumo Wrestler in Ancient China','2006','1',NULL,'5','2.99','101','28.99','R','Trailers,Deleted Scenes','2006-02-15T05:03:42.000')
;
Insert into film
 (film_id,title,description,release_year,language_id,original_language_id,rental_duration,rental_rate,length,replacement_cost,rating,special_features,last_update)
Values
('1000','ZORRO ARK','A Intrepid Panorama of a Mad Scientist And a Boy who must Redeem a Boy in A Monastery','2006','1',NULL,'3','4.99','50','18.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15T05:03:42.000')
;
SET IDENTITY_INSERT film OFF

-- End of Script
--
--
-- Automatically generated by Advanced ETl Processor
-- http://www.etl-tools.com/
-- table country
-- Start of script

SET IDENTITY_INSERT inventory ON

Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1','1','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2','1','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('3','1','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('4','1','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('5','1','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('6','1','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('7','1','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('8','1','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('9','2','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('10','2','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('11','2','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('12','3','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('13','3','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('14','3','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('15','3','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('16','4','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('17','4','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('18','4','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('19','4','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('20','4','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('21','4','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('22','4','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('23','5','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('24','5','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('25','5','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('26','6','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('27','6','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('28','6','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('29','6','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('30','6','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('31','6','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('32','7','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('33','7','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('34','7','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('35','7','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('36','7','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('37','8','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('38','8','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('39','8','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('40','8','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('41','9','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('42','9','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('43','9','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('44','9','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('45','9','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('46','10','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('47','10','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('48','10','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('49','10','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('50','10','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('51','10','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('52','10','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('53','11','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('54','11','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('55','11','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('56','11','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('57','11','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('58','11','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('59','11','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('60','12','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('61','12','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('62','12','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('63','12','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('64','12','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('65','12','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('66','12','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('67','13','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('68','13','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('69','13','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('70','13','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('71','15','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('72','15','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('73','15','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('74','15','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('75','15','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('76','15','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('77','16','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('78','16','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('79','16','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('80','16','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('81','17','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('82','17','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('83','17','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('84','17','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('85','17','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('86','17','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('87','18','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('88','18','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('89','18','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('90','18','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('91','18','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('92','18','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('93','19','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('94','19','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('95','19','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('96','19','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('97','19','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('98','19','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('99','20','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('100','20','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('101','20','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('102','21','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('103','21','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('104','21','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('105','21','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('106','21','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('107','21','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('108','22','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('109','22','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('110','22','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('111','22','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('112','22','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('113','22','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('114','22','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('115','23','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('116','23','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('117','23','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('118','23','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('119','23','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('120','24','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('121','24','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('122','24','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('123','24','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('124','25','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('125','25','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('126','25','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('127','25','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('128','25','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('129','25','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('130','26','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('131','26','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('132','26','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('133','26','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('134','26','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('135','27','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('136','27','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('137','27','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('138','27','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('139','28','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('140','28','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('141','28','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('142','29','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('143','29','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('144','30','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('145','30','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('146','31','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('147','31','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('148','31','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('149','31','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('150','31','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('151','31','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('152','31','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('153','31','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('154','32','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('155','32','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('156','34','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('157','34','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('158','34','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('159','34','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('160','35','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('161','35','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('162','35','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('163','35','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('164','35','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('165','35','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('166','35','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('167','37','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('168','37','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('169','37','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('170','37','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('171','37','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('172','37','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('173','37','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('174','39','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('175','39','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('176','39','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('177','39','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('178','39','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('179','39','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('180','39','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('181','40','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('182','40','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('183','40','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('184','40','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('185','42','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('186','42','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('187','42','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('188','42','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('189','43','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('190','43','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('191','43','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('192','43','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('193','43','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('194','43','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('195','43','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('196','44','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('197','44','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('198','44','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('199','44','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('200','44','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('201','45','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('202','45','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('203','45','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('204','45','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('205','45','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('206','45','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('207','46','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('208','46','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('209','46','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('210','47','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('211','47','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('212','48','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('213','48','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('214','48','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('215','48','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('216','49','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('217','49','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('218','49','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('219','49','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('220','49','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('221','49','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('222','50','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('223','50','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('224','50','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('225','50','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('226','50','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('227','51','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('228','51','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('229','51','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('230','51','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('231','51','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('232','51','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('233','52','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('234','52','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('235','53','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('236','53','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('237','54','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('238','54','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('239','54','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('240','54','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('241','54','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('242','55','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('243','55','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('244','55','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('245','55','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('246','55','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('247','55','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('248','56','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('249','56','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('250','56','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('251','56','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('252','56','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('253','57','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('254','57','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('255','57','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('256','57','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('257','57','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('258','57','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('259','57','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('260','58','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('261','58','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('262','58','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('263','58','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('264','59','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('265','59','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('266','59','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('267','59','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('268','59','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('269','60','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('270','60','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('271','60','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('272','61','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('273','61','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('274','61','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('275','61','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('276','61','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('277','61','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('278','62','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('279','62','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('280','63','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('281','63','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('282','63','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('283','63','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('284','64','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('285','64','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('286','64','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('287','65','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('288','65','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('289','65','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('290','65','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('291','66','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('292','66','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('293','66','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('294','67','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('295','67','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('296','67','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('297','67','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('298','67','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('299','67','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('300','68','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('301','68','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('302','68','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('303','68','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('304','69','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('305','69','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('306','69','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('307','69','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('308','69','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('309','69','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('310','69','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('311','69','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('312','70','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('313','70','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('314','70','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('315','70','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('316','71','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('317','71','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('318','71','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('319','71','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('320','72','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('321','72','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('322','72','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('323','72','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('324','72','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('325','72','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('326','73','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('327','73','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('328','73','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('329','73','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('330','73','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('331','73','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('332','73','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('333','73','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('334','74','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('335','74','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('336','74','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('337','74','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('338','74','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('339','75','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('340','75','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('341','75','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('342','76','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('343','76','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('344','76','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('345','77','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('346','77','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('347','77','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('348','77','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('349','77','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('350','77','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('351','78','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('352','78','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('353','78','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('354','78','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('355','78','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('356','78','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('357','78','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('358','79','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('359','79','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('360','79','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('361','79','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('362','79','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('363','79','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('364','80','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('365','80','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('366','80','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('367','80','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('368','81','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('369','81','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('370','81','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('371','81','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('372','82','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('373','82','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('374','83','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('375','83','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('376','83','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('377','83','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('378','83','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('379','84','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('380','84','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('381','84','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('382','84','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('383','85','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('384','85','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('385','85','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('386','85','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('387','86','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('388','86','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('389','86','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('390','86','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('391','86','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('392','86','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('393','86','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('394','86','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('395','88','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('396','88','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('397','88','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('398','88','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('399','89','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('400','89','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('401','89','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('402','89','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('403','89','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('404','89','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('405','90','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('406','90','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('407','90','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('408','90','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('409','90','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('410','90','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('411','91','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('412','91','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('413','91','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('414','91','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('415','91','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('416','91','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('417','91','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('418','91','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('419','92','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('420','92','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('421','92','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('422','92','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('423','93','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('424','93','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('425','93','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('426','94','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('427','94','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('428','95','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('429','95','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('430','95','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('431','95','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('432','95','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('433','96','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('434','96','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('435','96','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('436','97','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('437','97','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('438','97','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('439','97','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('440','97','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('441','97','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('442','98','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('443','98','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('444','98','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('445','99','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('446','99','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('447','99','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('448','99','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('449','99','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('450','99','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('451','100','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('452','100','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('453','100','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('454','100','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('455','100','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('456','100','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('457','101','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('458','101','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('459','101','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('460','101','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('461','101','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('462','101','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('463','102','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('464','102','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('465','103','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('466','103','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('467','103','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('468','103','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('469','103','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('470','103','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('471','103','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('472','103','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('473','104','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('474','104','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('475','104','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('476','105','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('477','105','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('478','105','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('479','105','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('480','105','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('481','106','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('482','106','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('483','107','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('484','107','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('485','109','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('486','109','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('487','109','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('488','109','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('489','109','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('490','109','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('491','109','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('492','109','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('493','110','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('494','110','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('495','110','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('496','110','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('497','111','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('498','111','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('499','111','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('500','111','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('501','112','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('502','112','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('503','112','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('504','112','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('505','112','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('506','112','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('507','112','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('508','113','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('509','113','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('510','113','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('511','113','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('512','114','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('513','114','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('514','114','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('515','114','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('516','114','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('517','114','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('518','114','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('519','115','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('520','115','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('521','115','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('522','115','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('523','115','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('524','115','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('525','115','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('526','116','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('527','116','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('528','116','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('529','116','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('530','116','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('531','116','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('532','117','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('533','117','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('534','117','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('535','117','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('536','117','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('537','117','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('538','118','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('539','118','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('540','118','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('541','118','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('542','118','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('543','118','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('544','119','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('545','119','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('546','119','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('547','119','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('548','119','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('549','119','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('550','119','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('551','120','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('552','120','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('553','120','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('554','121','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('555','121','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('556','121','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('557','121','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('558','121','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('559','121','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('560','122','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('561','122','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('562','122','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('563','122','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('564','122','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('565','122','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('566','122','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('567','123','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('568','123','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('569','123','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('570','123','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('571','123','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('572','124','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('573','124','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('574','124','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('575','125','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('576','125','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('577','126','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('578','126','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('579','126','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('580','127','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('581','127','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('582','127','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('583','127','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('584','127','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('585','127','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('586','127','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('587','127','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('588','129','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('589','129','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('590','129','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('591','129','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('592','129','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('593','129','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('594','130','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('595','130','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('596','130','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('597','130','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('598','130','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('599','130','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('600','131','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('601','131','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('602','131','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('603','131','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('604','131','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('605','131','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('606','132','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('607','132','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('608','132','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('609','132','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('610','132','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('611','132','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('612','133','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('613','133','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('614','133','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('615','133','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('616','134','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('617','134','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('618','134','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('619','135','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('620','135','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('621','135','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('622','135','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('623','135','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('624','135','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('625','135','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('626','136','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('627','136','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('628','136','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('629','137','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('630','137','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('631','137','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('632','137','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('633','138','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('634','138','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('635','138','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('636','138','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('637','138','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('638','139','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('639','139','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('640','139','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('641','139','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('642','139','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('643','139','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('644','140','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('645','140','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('646','140','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('647','140','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('648','140','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('649','141','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('650','141','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('651','141','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('652','141','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('653','141','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('654','142','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('655','142','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('656','142','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('657','142','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('658','142','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('659','143','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('660','143','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('661','143','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('662','143','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('663','143','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('664','143','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('665','143','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('666','145','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('667','145','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('668','145','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('669','146','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('670','146','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('671','146','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('672','147','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('673','147','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('674','147','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('675','147','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('676','147','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('677','147','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('678','149','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('679','149','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('680','149','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('681','149','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('682','149','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('683','149','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('684','150','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('685','150','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('686','150','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('687','150','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('688','150','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('689','150','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('690','151','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('691','151','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('692','151','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('693','151','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('694','152','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('695','152','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('696','152','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('697','152','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('698','153','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('699','153','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('700','153','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('701','153','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('702','154','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('703','154','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('704','154','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('705','154','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('706','154','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('707','154','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('708','154','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('709','155','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('710','155','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('711','155','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('712','155','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('713','155','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('714','156','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('715','156','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('716','157','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('717','157','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('718','157','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('719','158','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('720','158','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('721','158','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('722','158','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('723','158','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('724','159','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('725','159','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('726','159','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('727','159','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('728','159','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('729','159','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('730','159','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('731','160','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('732','160','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('733','160','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('734','160','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('735','160','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('736','161','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('737','161','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('738','162','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('739','162','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('740','162','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('741','162','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('742','162','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('743','162','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('744','162','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('745','163','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('746','163','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('747','163','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('748','164','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('749','164','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('750','164','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('751','164','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('752','164','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('753','165','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('754','165','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('755','165','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('756','165','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('757','165','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('758','166','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('759','166','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('760','166','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('761','166','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('762','166','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('763','166','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('764','167','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('765','167','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('766','167','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('767','167','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('768','167','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('769','167','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('770','167','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('771','168','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('772','168','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('773','169','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('774','169','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('775','169','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('776','169','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('777','170','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('778','170','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('779','170','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('780','170','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('781','170','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('782','170','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('783','172','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('784','172','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('785','172','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('786','172','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('787','172','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('788','172','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('789','172','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('790','173','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('791','173','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('792','173','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('793','173','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('794','173','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('795','174','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('796','174','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('797','174','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('798','174','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('799','174','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('800','174','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('801','174','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('802','174','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('803','175','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('804','175','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('805','175','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('806','175','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('807','175','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('808','176','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('809','176','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('810','176','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('811','176','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('812','176','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('813','176','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('814','177','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('815','177','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('816','177','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('817','178','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('818','178','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('819','179','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('820','179','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('821','179','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('822','179','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('823','180','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('824','180','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('825','181','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('826','181','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('827','181','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('828','181','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('829','181','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('830','181','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('831','181','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('832','182','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('833','182','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('834','183','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('835','183','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('836','183','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('837','183','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('838','183','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('839','183','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('840','184','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('841','184','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('842','184','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('843','184','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('844','184','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('845','185','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('846','185','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('847','186','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('848','186','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('849','186','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('850','186','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('851','187','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('852','187','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('853','187','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('854','188','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('855','188','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('856','188','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('857','189','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('858','189','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('859','189','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('860','189','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('861','189','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('862','189','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('863','190','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('864','190','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('865','190','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('866','190','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('867','191','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('868','191','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('869','191','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('870','191','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('871','191','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('872','191','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('873','193','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('874','193','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('875','193','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('876','193','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('877','193','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('878','193','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('879','193','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('880','193','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('881','194','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('882','194','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('883','194','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('884','194','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('885','196','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('886','196','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('887','197','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('888','197','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('889','199','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('890','199','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('891','199','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('892','199','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('893','199','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('894','199','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('895','199','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('896','199','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('897','200','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('898','200','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('899','200','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('900','200','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('901','200','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('902','200','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('903','200','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('904','200','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('905','201','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('906','201','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('907','201','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('908','201','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('909','202','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('910','202','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('911','202','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('912','203','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('913','203','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('914','203','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('915','203','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('916','204','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('917','204','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('918','204','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('919','204','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('920','204','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('921','204','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('922','205','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('923','205','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('924','205','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('925','205','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('926','206','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('927','206','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('928','206','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('929','206','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('930','206','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('931','206','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('932','206','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('933','206','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('934','207','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('935','207','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('936','207','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('937','207','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('938','208','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('939','208','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('940','208','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('941','209','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('942','209','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('943','209','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('944','209','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('945','210','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('946','210','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('947','210','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('948','211','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('949','211','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('950','212','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('951','212','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('952','212','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('953','212','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('954','212','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('955','213','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('956','213','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('957','213','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('958','213','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('959','214','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('960','214','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('961','214','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('962','214','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('963','215','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('964','215','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('965','215','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('966','215','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('967','215','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('968','215','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('969','216','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('970','216','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('971','216','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('972','216','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('973','216','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('974','218','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('975','218','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('976','218','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('977','218','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('978','218','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('979','218','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('980','218','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('981','219','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('982','219','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('983','219','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('984','219','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('985','220','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('986','220','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('987','220','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('988','220','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('989','220','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('990','220','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('991','220','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('992','220','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('993','222','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('994','222','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('995','222','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('996','222','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('997','222','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('998','222','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('999','223','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1000','223','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1001','224','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1002','224','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1003','225','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1004','225','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1005','225','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1006','226','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1007','226','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1008','226','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1009','226','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1010','226','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1011','227','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1012','227','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1013','227','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1014','227','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1015','227','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1016','228','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1017','228','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1018','228','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1019','228','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1020','228','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1021','228','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1022','228','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1023','229','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1024','229','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1025','229','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1026','229','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1027','230','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1028','230','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1029','231','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1030','231','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1031','231','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1032','231','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1033','231','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1034','231','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1035','231','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1036','231','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1037','232','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1038','232','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1039','232','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1040','232','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1041','232','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1042','233','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1043','233','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1044','233','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1045','233','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1046','233','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1047','233','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1048','234','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1049','234','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1050','234','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1051','234','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1052','234','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1053','234','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1054','234','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1055','235','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1056','235','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1057','235','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1058','235','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1059','235','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1060','235','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1061','236','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1062','236','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1063','236','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1064','236','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1065','237','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1066','237','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1067','238','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1068','238','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1069','239','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1070','239','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1071','239','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1072','239','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1073','239','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1074','239','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1075','239','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1076','239','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1077','240','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1078','240','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1079','240','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1080','241','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1081','241','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1082','241','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1083','241','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1084','242','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1085','242','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1086','242','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1087','242','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1088','242','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1089','243','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1090','243','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1091','243','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1092','243','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1093','243','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1094','243','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1095','244','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1096','244','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1097','244','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1098','244','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1099','244','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1100','244','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1101','244','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1102','245','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1103','245','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1104','245','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1105','245','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1106','245','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1107','245','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1108','245','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1109','246','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1110','246','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1111','246','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1112','247','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1113','247','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1114','247','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1115','247','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1116','247','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1117','247','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1118','247','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1119','248','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1120','248','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1121','249','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1122','249','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1123','249','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1124','249','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1125','249','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1126','249','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1127','250','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1128','250','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1129','250','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1130','250','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1131','251','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1132','251','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1133','251','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1134','251','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1135','251','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1136','252','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1137','252','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1138','252','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1139','252','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1140','252','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1141','252','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1142','253','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1143','253','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1144','253','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1145','253','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1146','253','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1147','253','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1148','254','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1149','254','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1150','254','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1151','254','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1152','254','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1153','255','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1154','255','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1155','255','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1156','255','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1157','255','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1158','255','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1159','256','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1160','256','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1161','256','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1162','257','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1163','257','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1164','257','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1165','258','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1166','258','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1167','258','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1168','258','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1169','259','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1170','259','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1171','260','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1172','260','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1173','260','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1174','260','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1175','261','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1176','261','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1177','262','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1178','262','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1179','263','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1180','263','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1181','263','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1182','263','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1183','263','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1184','263','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1185','263','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1186','264','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1187','264','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1188','265','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1189','265','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1190','265','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1191','265','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1192','266','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1193','266','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1194','266','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1195','266','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1196','266','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1197','266','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1198','266','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1199','266','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1200','267','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1201','267','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1202','267','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1203','267','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1204','267','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1205','267','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1206','268','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1207','268','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1208','269','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1209','269','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1210','269','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1211','269','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1212','269','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1213','269','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1214','270','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1215','270','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1216','270','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1217','270','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1218','270','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1219','270','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1220','270','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1221','271','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1222','271','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1223','271','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1224','271','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1225','271','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1226','272','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1227','272','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1228','272','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1229','272','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1230','273','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1231','273','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1232','273','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1233','273','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1234','273','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1235','273','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1236','273','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1237','274','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1238','274','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1239','274','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1240','274','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1241','274','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1242','274','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1243','274','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1244','275','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1245','275','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1246','275','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1247','275','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1248','275','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1249','276','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1250','276','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1251','276','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1252','276','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1253','277','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1254','277','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1255','277','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1256','278','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1257','278','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1258','279','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1259','279','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1260','280','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1261','280','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1262','280','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1263','280','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1264','280','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1265','280','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1266','281','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1267','281','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1268','281','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1269','281','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1270','281','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1271','281','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1272','282','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1273','282','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1274','282','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1275','282','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1276','282','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1277','282','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1278','283','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1279','283','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1280','283','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1281','284','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1282','284','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1283','284','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1284','284','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1285','284','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1286','284','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1287','284','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1288','285','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1289','285','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1290','285','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1291','285','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1292','285','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1293','285','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1294','285','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1295','286','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1296','286','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1297','286','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1298','286','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1299','286','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1300','287','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1301','287','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1302','287','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1303','287','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1304','288','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1305','288','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1306','288','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1307','288','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1308','288','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1309','288','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1310','289','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1311','289','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1312','290','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1313','290','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1314','290','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1315','291','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1316','291','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1317','291','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1318','291','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1319','292','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1320','292','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1321','292','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1322','292','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1323','292','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1324','292','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1325','293','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1326','293','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1327','293','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1328','293','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1329','293','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1330','294','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1331','294','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1332','294','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1333','294','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1334','294','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1335','295','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1336','295','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1337','295','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1338','295','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1339','295','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1340','295','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1341','295','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1342','295','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1343','296','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1344','296','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1345','296','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1346','296','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1347','297','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1348','297','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1349','298','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1350','298','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1351','298','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1352','298','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1353','298','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1354','299','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1355','299','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1356','299','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1357','299','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1358','300','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1359','300','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1360','300','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1361','300','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1362','300','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1363','300','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1364','301','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1365','301','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1366','301','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1367','301','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1368','301','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1369','301','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1370','301','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1371','301','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1372','302','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1373','302','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1374','302','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1375','302','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1376','302','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1377','302','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1378','303','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1379','303','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1380','303','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1381','303','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1382','303','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1383','303','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1384','304','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1385','304','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1386','304','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1387','304','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1388','304','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1389','304','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1390','305','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1391','305','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1392','305','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1393','305','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1394','305','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1395','305','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1396','305','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1397','306','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1398','306','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1399','306','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1400','307','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1401','307','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1402','307','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1403','307','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1404','307','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1405','307','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1406','308','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1407','308','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1408','308','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1409','308','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1410','309','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1411','309','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1412','309','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1413','309','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1414','309','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1415','309','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1416','310','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1417','310','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1418','311','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1419','311','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1420','311','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1421','311','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1422','311','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1423','311','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1424','311','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1425','312','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1426','312','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1427','312','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1428','313','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1429','313','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1430','313','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1431','313','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1432','313','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1433','313','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1434','314','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1435','314','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1436','314','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1437','314','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1438','314','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1439','314','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1440','315','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1441','315','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1442','315','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1443','316','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1444','316','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1445','317','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1446','317','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1447','317','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1448','317','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1449','317','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1450','317','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1451','317','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1452','319','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1453','319','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1454','319','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1455','319','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1456','319','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1457','319','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1458','319','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1459','320','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1460','320','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1461','320','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1462','320','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1463','320','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1464','320','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1465','320','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1466','321','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1467','321','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1468','321','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1469','321','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1470','322','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1471','322','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1472','322','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1473','322','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1474','322','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1475','322','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1476','323','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1477','323','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1478','323','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1479','323','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1480','324','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1481','324','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1482','324','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1483','324','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1484','324','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1485','326','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1486','326','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1487','326','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1488','326','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1489','326','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1490','326','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1491','327','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1492','327','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1493','327','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1494','327','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1495','327','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1496','327','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1497','328','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1498','328','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1499','328','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1500','328','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1501','329','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1502','329','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1503','329','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1504','329','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1505','329','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1506','329','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1507','330','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1508','330','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1509','330','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1510','330','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1511','330','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1512','330','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1513','330','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1514','331','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1515','331','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1516','331','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1517','331','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1518','331','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1519','331','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1520','331','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1521','331','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1522','333','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1523','333','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1524','333','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1525','333','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1526','334','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1527','334','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1528','334','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1529','334','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1530','334','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1531','334','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1532','335','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1533','335','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1534','336','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1535','336','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1536','336','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1537','336','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1538','336','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1539','337','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1540','337','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1541','337','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1542','337','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1543','338','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1544','338','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1545','338','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1546','339','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1547','339','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1548','339','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1549','340','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1550','340','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1551','341','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1552','341','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1553','341','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1554','341','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1555','341','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1556','341','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1557','341','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1558','341','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1559','342','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1560','342','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1561','342','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1562','342','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1563','343','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1564','343','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1565','344','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1566','344','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1567','344','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1568','344','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1569','344','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1570','345','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1571','345','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1572','345','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1573','345','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1574','345','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1575','346','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1576','346','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1577','346','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1578','346','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1579','346','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1580','346','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1581','347','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1582','347','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1583','347','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1584','347','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1585','348','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1586','348','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1587','348','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1588','348','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1589','349','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1590','349','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1591','349','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1592','349','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1593','349','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1594','349','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1595','349','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1596','350','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1597','350','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1598','350','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1599','350','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1600','350','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1601','350','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1602','350','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1603','350','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1604','351','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1605','351','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1606','351','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1607','351','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1608','351','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1609','351','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1610','352','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1611','352','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1612','352','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1613','352','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1614','353','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1615','353','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1616','353','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1617','353','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1618','353','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1619','353','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1620','354','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1621','354','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1622','354','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1623','354','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1624','354','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1625','355','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1626','355','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1627','356','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1628','356','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1629','356','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1630','356','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1631','356','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1632','356','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1633','356','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1634','356','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1635','357','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1636','357','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1637','357','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1638','357','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1639','358','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1640','358','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1641','358','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1642','358','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1643','358','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1644','358','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1645','358','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1646','358','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1647','360','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1648','360','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1649','360','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1650','360','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1651','361','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1652','361','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1653','361','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1654','361','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1655','361','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1656','361','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1657','361','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1658','361','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1659','362','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1660','362','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1661','363','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1662','363','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1663','363','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1664','363','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1665','363','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1666','363','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1667','364','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1668','364','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1669','364','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1670','365','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1671','365','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1672','365','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1673','365','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1674','366','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1675','366','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1676','366','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1677','366','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1678','366','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1679','366','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1680','366','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1681','367','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1682','367','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1683','367','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1684','367','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1685','367','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1686','367','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1687','367','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1688','368','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1689','368','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1690','369','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1691','369','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1692','369','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1693','369','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1694','369','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1695','369','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1696','369','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1697','369','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1698','370','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1699','370','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1700','370','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1701','370','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1702','370','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1703','371','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1704','371','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1705','371','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1706','372','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1707','372','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1708','373','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1709','373','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1710','373','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1711','373','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1712','373','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1713','374','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1714','374','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1715','374','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1716','374','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1717','374','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1718','374','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1719','374','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1720','375','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1721','375','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1722','376','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1723','376','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1724','376','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1725','376','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1726','376','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1727','376','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1728','376','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1729','377','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1730','377','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1731','377','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1732','377','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1733','377','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1734','377','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1735','378','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1736','378','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1737','378','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1738','378','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1739','378','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1740','378','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1741','378','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1742','378','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1743','379','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1744','379','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1745','379','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1746','379','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1747','380','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1748','380','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1749','380','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1750','380','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1751','380','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1752','381','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1753','381','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1754','381','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1755','381','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1756','381','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1757','382','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1758','382','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1759','382','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1760','382','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1761','382','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1762','382','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1763','382','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1764','382','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1765','383','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1766','383','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1767','383','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1768','383','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1769','383','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1770','384','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1771','384','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1772','384','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1773','385','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1774','385','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1775','385','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1776','385','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1777','385','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1778','387','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1779','387','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1780','387','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1781','387','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1782','387','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1783','387','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1784','388','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1785','388','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1786','388','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1787','388','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1788','388','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1789','388','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1790','389','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1791','389','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1792','389','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1793','389','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1794','390','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1795','390','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1796','390','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1797','391','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1798','391','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1799','391','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1800','391','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1801','391','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1802','391','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1803','391','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1804','392','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1805','392','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1806','392','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1807','392','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1808','392','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1809','392','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1810','393','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1811','393','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1812','394','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1813','394','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1814','394','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1815','394','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1816','395','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1817','395','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1818','395','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1819','395','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1820','395','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1821','395','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1822','396','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1823','396','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1824','396','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1825','396','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1826','397','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1827','397','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1828','397','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1829','397','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1830','397','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1831','397','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1832','397','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1833','398','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1834','398','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1835','398','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1836','398','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1837','399','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1838','399','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1839','400','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1840','400','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1841','401','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1842','401','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1843','402','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1844','402','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1845','402','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1846','402','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1847','402','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1848','402','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1849','403','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1850','403','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1851','403','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1852','403','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1853','403','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1854','403','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1855','403','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1856','403','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1857','405','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1858','405','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1859','406','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1860','406','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1861','406','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1862','406','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1863','406','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1864','406','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1865','407','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1866','407','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1867','408','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1868','408','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1869','408','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1870','408','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1871','408','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1872','408','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1873','408','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1874','409','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1875','409','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1876','409','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1877','409','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1878','409','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1879','409','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1880','409','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1881','410','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1882','410','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1883','410','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1884','410','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1885','410','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1886','411','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1887','411','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1888','412','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1889','412','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1890','412','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1891','412','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1892','412','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1893','412','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1894','412','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1895','412','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1896','413','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1897','413','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1898','413','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1899','414','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1900','414','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1901','414','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1902','414','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1903','414','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1904','414','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1905','415','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1906','415','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1907','415','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1908','415','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1909','415','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1910','415','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1911','416','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1912','416','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1913','416','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1914','416','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1915','416','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1916','416','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1917','417','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1918','417','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1919','417','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1920','417','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1921','417','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1922','417','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1923','418','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1924','418','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1925','418','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1926','418','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1927','418','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1928','418','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1929','418','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1930','418','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1931','420','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1932','420','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1933','420','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1934','420','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1935','420','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1936','421','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1937','421','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1938','421','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1939','421','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1940','422','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1941','422','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1942','423','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1943','423','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1944','423','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1945','423','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1946','424','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1947','424','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1948','424','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1949','424','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1950','424','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1951','425','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1952','425','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1953','426','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1954','426','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1955','426','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1956','427','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1957','427','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1958','427','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1959','427','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1960','428','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1961','428','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1962','428','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1963','428','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1964','428','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1965','428','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1966','429','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1967','429','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1968','429','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1969','429','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1970','429','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1971','429','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1972','430','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1973','430','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1974','430','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1975','430','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1976','431','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1977','431','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1978','431','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1979','432','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1980','432','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1981','432','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1982','432','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1983','432','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1984','433','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1985','433','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1986','433','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1987','433','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1988','433','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1989','433','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1990','434','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1991','434','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1992','434','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1993','434','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1994','434','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1995','434','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1996','434','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1997','434','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1998','435','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('1999','435','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2000','436','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2001','436','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2002','436','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2003','436','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2004','436','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2005','436','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2006','437','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2007','437','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2008','437','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2009','437','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2010','437','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2011','437','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2012','438','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2013','438','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2014','438','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2015','438','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2016','438','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2017','439','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2018','439','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2019','439','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2020','439','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2021','439','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2022','439','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2023','440','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2024','440','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2025','440','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2026','440','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2027','441','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2028','441','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2029','442','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2030','442','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2031','442','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2032','443','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2033','443','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2034','443','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2035','443','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2036','443','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2037','443','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2038','443','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2039','444','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2040','444','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2041','444','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2042','444','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2043','444','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2044','444','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2045','444','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2046','444','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2047','445','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2048','445','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2049','445','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2050','445','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2051','445','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2052','445','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2053','446','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2054','446','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2055','446','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2056','446','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2057','447','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2058','447','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2059','447','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2060','447','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2061','447','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2062','447','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2063','447','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2064','448','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2065','448','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2066','448','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2067','448','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2068','448','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2069','449','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2070','449','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2071','449','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2072','449','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2073','450','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2074','450','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2075','450','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2076','450','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2077','450','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2078','450','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2079','450','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2080','451','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2081','451','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2082','451','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2083','451','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2084','451','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2085','452','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2086','452','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2087','452','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2088','452','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2089','453','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2090','453','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2091','453','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2092','453','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2093','453','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2094','454','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2095','454','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2096','455','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2097','455','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2098','455','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2099','455','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2100','456','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2101','456','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2102','456','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2103','456','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2104','456','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2105','456','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2106','457','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2107','457','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2108','457','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2109','457','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2110','457','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2111','457','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2112','458','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2113','458','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2114','458','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2115','458','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2116','458','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2117','458','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2118','459','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2119','459','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2120','460','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2121','460','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2122','460','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2123','460','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2124','460','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2125','460','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2126','460','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2127','460','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2128','461','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2129','461','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2130','461','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2131','461','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2132','461','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2133','461','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2134','462','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2135','462','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2136','462','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2137','462','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2138','462','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2139','463','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2140','463','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2141','463','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2142','463','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2143','463','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2144','464','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2145','464','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2146','464','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2147','464','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2148','464','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2149','464','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2150','464','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2151','465','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2152','465','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2153','465','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2154','465','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2155','465','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2156','466','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2157','466','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2158','467','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2159','467','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2160','467','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2161','467','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2162','467','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2163','467','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2164','467','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2165','468','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2166','468','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2167','468','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2168','468','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2169','468','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2170','468','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2171','468','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2172','468','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2173','469','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2174','469','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2175','469','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2176','470','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2177','470','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2178','471','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2179','471','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2180','471','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2181','471','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2182','471','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2183','471','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2184','471','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2185','472','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2186','472','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2187','473','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2188','473','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2189','473','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2190','473','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2191','473','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2192','474','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2193','474','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2194','474','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2195','474','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2196','475','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2197','475','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2198','476','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2199','476','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2200','476','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2201','476','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2202','476','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2203','476','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2204','476','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2205','477','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2206','477','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2207','477','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2208','478','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2209','478','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2210','478','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2211','478','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2212','478','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2213','479','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2214','479','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2215','479','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2216','479','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2217','479','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2218','480','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2219','480','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2220','480','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2221','480','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2222','481','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2223','481','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2224','481','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2225','481','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2226','481','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2227','481','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2228','482','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2229','482','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2230','482','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2231','483','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2232','483','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2233','483','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2234','483','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2235','483','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2236','484','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2237','484','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2238','484','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2239','484','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2240','484','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2241','484','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2242','484','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2243','485','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2244','485','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2245','485','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2246','486','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2247','486','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2248','486','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2249','486','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2250','486','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2251','486','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2252','487','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2253','487','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2254','487','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2255','488','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2256','488','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2257','488','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2258','488','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2259','488','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2260','489','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2261','489','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2262','489','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2263','489','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2264','489','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2265','489','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2266','489','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2267','489','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2268','490','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2269','490','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2270','491','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2271','491','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2272','491','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2273','491','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2274','491','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2275','491','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2276','492','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2277','492','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2278','493','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2279','493','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2280','493','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2281','494','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2282','494','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2283','494','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2284','494','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2285','494','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2286','494','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2287','496','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2288','496','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2289','496','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2290','496','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2291','496','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2292','498','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2293','498','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2294','499','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2295','499','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2296','500','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2297','500','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2298','500','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2299','500','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2300','500','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2301','500','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2302','500','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2303','500','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2304','501','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2305','501','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2306','501','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2307','501','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2308','501','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2309','502','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2310','502','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2311','502','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2312','502','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2313','502','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2314','502','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2315','502','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2316','503','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2317','503','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2318','503','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2319','504','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2320','504','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2321','504','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2322','504','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2323','504','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2324','504','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2325','505','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2326','505','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2327','505','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2328','505','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2329','506','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2330','506','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2331','506','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2332','506','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2333','506','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2334','506','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2335','507','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2336','507','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2337','508','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2338','508','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2339','508','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2340','509','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2341','509','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2342','509','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2343','510','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2344','510','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2345','510','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2346','510','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2347','511','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2348','511','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2349','511','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2350','511','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2351','511','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2352','512','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2353','512','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2354','512','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2355','512','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2356','512','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2357','512','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2358','513','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2359','513','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2360','514','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2361','514','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2362','514','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2363','514','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2364','514','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2365','514','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2366','515','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2367','515','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2368','516','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2369','516','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2370','516','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2371','517','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2372','517','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2373','518','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2374','518','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2375','518','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2376','518','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2377','518','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2378','518','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2379','519','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2380','519','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2381','519','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2382','519','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2383','520','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2384','520','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2385','521','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2386','521','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2387','521','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2388','521','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2389','521','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2390','521','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2391','521','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2392','522','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2393','522','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2394','523','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2395','523','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2396','524','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2397','524','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2398','524','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2399','524','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2400','524','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2401','524','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2402','525','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2403','525','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2404','525','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2405','525','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2406','525','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2407','525','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2408','525','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2409','525','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2410','526','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2411','526','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2412','526','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2413','526','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2414','527','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2415','527','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2416','527','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2417','527','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2418','527','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2419','527','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2420','528','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2421','528','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2422','528','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2423','529','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2424','529','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2425','529','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2426','529','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2427','530','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2428','530','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2429','530','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2430','531','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2431','531','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2432','531','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2433','531','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2434','531','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2435','531','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2436','531','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2437','531','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2438','532','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2439','532','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2440','532','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2441','532','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2442','533','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2443','533','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2444','533','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2445','534','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2446','534','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2447','534','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2448','534','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2449','534','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2450','535','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2451','535','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2452','535','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2453','535','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2454','536','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2455','536','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2456','536','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2457','536','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2458','536','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2459','537','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2460','537','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2461','537','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2462','538','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2463','538','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2464','538','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2465','539','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2466','539','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2467','540','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2468','540','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2469','540','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2470','541','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2471','541','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2472','542','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2473','542','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2474','542','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2475','542','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2476','542','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2477','542','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2478','543','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2479','543','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2480','544','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2481','544','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2482','544','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2483','544','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2484','545','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2485','545','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2486','545','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2487','545','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2488','545','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2489','545','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2490','546','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2491','546','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2492','546','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2493','546','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2494','547','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2495','547','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2496','548','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2497','548','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2498','549','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2499','549','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2500','549','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2501','549','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2502','550','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2503','550','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2504','550','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2505','551','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2506','551','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2507','551','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2508','551','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2509','551','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2510','551','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2511','552','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2512','552','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2513','552','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2514','552','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2515','553','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2516','553','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2517','553','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2518','554','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2519','554','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2520','554','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2521','554','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2522','554','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2523','554','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2524','554','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2525','555','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2526','555','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2527','555','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2528','555','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2529','555','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2530','555','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2531','555','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2532','556','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2533','556','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2534','556','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2535','556','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2536','556','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2537','556','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2538','556','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2539','557','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2540','557','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2541','557','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2542','557','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2543','557','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2544','558','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2545','558','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2546','559','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2547','559','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2548','559','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2549','559','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2550','559','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2551','559','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2552','559','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2553','559','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2554','560','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2555','560','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2556','560','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2557','560','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2558','560','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2559','561','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2560','561','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2561','561','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2562','561','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2563','562','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2564','562','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2565','562','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2566','562','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2567','562','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2568','562','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2569','563','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2570','563','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2571','563','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2572','563','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2573','563','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2574','563','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2575','563','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2576','564','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2577','564','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2578','564','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2579','565','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2580','565','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2581','566','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2582','566','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2583','567','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2584','567','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2585','567','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2586','567','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2587','568','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2588','568','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2589','568','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2590','568','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2591','569','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2592','569','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2593','570','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2594','570','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2595','570','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2596','570','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2597','570','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2598','571','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2599','571','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2600','571','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2601','571','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2602','571','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2603','571','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2604','572','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2605','572','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2606','572','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2607','572','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2608','572','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2609','572','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2610','572','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2611','572','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2612','573','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2613','573','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2614','573','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2615','573','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2616','574','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2617','574','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2618','574','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2619','574','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2620','574','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2621','575','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2622','575','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2623','575','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2624','575','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2625','575','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2626','575','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2627','576','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2628','576','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2629','576','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2630','577','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2631','577','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2632','577','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2633','578','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2634','578','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2635','578','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2636','578','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2637','578','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2638','579','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2639','579','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2640','579','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2641','579','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2642','579','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2643','579','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2644','579','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2645','580','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2646','580','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2647','580','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2648','580','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2649','580','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2650','580','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2651','581','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2652','581','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2653','581','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2654','582','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2655','582','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2656','583','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2657','583','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2658','583','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2659','583','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2660','583','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2661','584','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2662','584','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2663','585','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2664','585','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2665','585','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2666','585','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2667','586','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2668','586','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2669','586','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2670','586','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2671','586','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2672','586','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2673','586','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2674','586','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2675','587','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2676','587','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2677','587','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2678','588','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2679','588','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2680','588','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2681','588','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2682','589','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2683','589','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2684','589','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2685','589','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2686','590','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2687','590','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2688','590','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2689','590','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2690','590','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2691','590','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2692','590','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2693','591','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2694','591','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2695','591','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2696','592','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2697','592','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2698','592','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2699','592','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2700','593','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2701','593','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2702','593','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2703','593','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2704','594','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2705','594','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2706','594','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2707','595','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2708','595','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2709','595','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2710','595','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2711','595','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2712','595','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2713','595','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2714','595','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2715','596','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2716','596','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2717','596','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2718','596','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2719','596','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2720','596','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2721','597','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2722','597','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2723','597','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2724','597','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2725','598','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2726','598','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2727','598','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2728','598','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2729','599','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2730','599','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2731','599','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2732','599','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2733','599','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2734','600','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2735','600','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2736','600','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2737','600','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2738','601','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2739','601','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2740','601','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2741','601','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2742','601','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2743','602','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2744','602','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2745','602','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2746','602','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2747','602','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2748','603','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2749','603','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2750','603','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2751','603','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2752','603','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2753','603','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2754','604','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2755','604','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2756','604','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2757','605','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2758','605','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2759','606','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2760','606','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2761','606','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2762','606','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2763','606','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2764','606','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2765','608','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2766','608','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2767','608','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2768','608','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2769','608','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2770','608','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2771','609','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2772','609','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2773','609','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2774','609','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2775','609','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2776','609','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2777','609','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2778','609','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2779','610','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2780','610','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2781','610','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2782','610','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2783','610','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2784','611','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2785','611','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2786','611','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2787','611','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2788','611','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2789','611','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2790','612','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2791','612','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2792','613','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2793','613','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2794','614','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2795','614','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2796','614','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2797','614','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2798','614','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2799','614','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2800','615','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2801','615','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2802','615','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2803','615','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2804','616','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2805','616','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2806','616','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2807','616','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2808','616','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2809','616','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2810','617','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2811','617','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2812','617','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2813','618','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2814','618','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2815','618','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2816','618','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2817','619','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2818','619','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2819','619','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2820','619','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2821','619','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2822','619','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2823','620','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2824','620','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2825','620','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2826','620','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2827','620','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2828','621','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2829','621','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2830','621','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2831','621','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2832','621','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2833','621','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2834','621','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2835','621','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2836','622','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2837','622','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2838','623','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2839','623','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2840','623','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2841','623','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2842','623','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2843','624','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2844','624','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2845','624','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2846','624','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2847','624','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2848','624','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2849','624','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2850','625','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2851','625','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2852','625','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2853','625','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2854','625','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2855','625','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2856','625','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2857','626','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2858','626','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2859','626','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2860','626','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2861','627','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2862','627','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2863','627','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2864','628','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2865','628','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2866','628','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2867','628','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2868','628','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2869','629','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2870','629','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2871','629','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2872','629','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2873','630','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2874','630','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2875','630','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2876','631','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2877','631','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2878','631','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2879','631','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2880','631','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2881','632','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2882','632','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2883','632','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2884','633','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2885','633','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2886','633','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2887','634','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2888','634','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2889','634','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2890','634','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2891','635','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2892','635','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2893','636','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2894','636','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2895','636','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2896','637','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2897','637','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2898','637','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2899','637','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2900','637','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2901','638','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2902','638','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2903','638','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2904','638','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2905','638','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2906','638','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2907','638','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2908','638','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2909','639','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2910','639','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2911','639','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2912','640','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2913','640','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2914','640','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2915','641','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2916','641','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2917','641','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2918','641','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2919','641','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2920','641','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2921','641','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2922','643','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2923','643','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2924','643','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2925','643','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2926','643','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2927','643','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2928','644','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2929','644','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2930','644','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2931','644','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2932','644','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2933','644','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2934','644','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2935','645','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2936','645','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2937','645','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2938','645','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2939','645','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2940','645','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2941','646','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2942','646','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2943','646','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2944','646','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2945','646','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2946','647','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2947','647','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2948','647','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2949','647','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2950','647','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2951','647','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2952','648','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2953','648','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2954','648','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2955','648','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2956','648','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2957','648','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2958','649','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2959','649','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2960','649','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2961','649','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2962','649','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2963','649','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2964','650','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2965','650','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2966','650','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2967','650','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2968','650','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2969','650','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2970','651','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2971','651','1','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2972','651','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2973','651','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_update)
Values
('2974','651','2','2006-02-15T05:09:17.000')
;
Insert into inventory
 (inventory_id,film_id,store_id,last_updat