﻿using RimWorld;
using Verse;
using UnityEngine;
using HugsLib;
using HugsLib.Settings;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection.Emit;

namespace NoMote
{
	public class NoMoteHL : ModBase
	{
		SettingHandle<bool> NoMoteRestart;
		Dictionary<ThingDef, float[]> NoMoteRef = new Dictionary<ThingDef, float[]>();
		Dictionary<ThingDef, SettingHandle<bool>> NoMoteList = new Dictionary<ThingDef, SettingHandle<bool>>();

		public override string ModIdentifier
		{
			get
			{
				return "NoMote";
			}
		}

		public override void DefsLoaded()
		{
			NoMoteRestart = Settings.GetHandle<bool>("restart", "NoMote_restart_name".Translate(), "NoMote_restart_tip".Translate(), false);
			foreach (ThingDef thingDef in DefDatabase<ThingDef>.AllDefs)
			{
				if (thingDef.defName.Length > 5)
				{
					if (thingDef.defName.Substring(0, 5).ToLower() == "mote_")
					{
						NoMoteRef.Add(thingDef, new float[3] { thingDef.mote.fadeInTime, thingDef.mote.solidTime, thingDef.mote.fadeOutTime });
						NoMoteList.Add(thingDef, Settings.GetHandle<bool>(thingDef.defName, (thingDef.defName.Substring(5)).Translate(), "", true));
					}
				}
			}
			ChangeXML();
			Log.Message("NoMote loaded : " + NoMoteList.Keys.Count + " values found");
			base.DefsLoaded();
		}

		public override void SettingsChanged()
		{
			ChangeXML();
			Log.Message("NoMote's settings updated");
			base.SettingsChanged();
		}

		public void ChangeXML()
		{
			foreach (KeyValuePair<ThingDef, SettingHandle<bool>> item in NoMoteList)
			{
				if (item.Value.Value)
				{
					item.Key.mote.fadeInTime = NoMoteRef[item.Key][0];
					item.Key.mote.solidTime = NoMoteRef[item.Key][1];
					item.Key.mote.fadeOutTime = NoMoteRef[item.Key][2];
				}
				else
				{
					item.Key.mote.fadeInTime = 0;
					item.Key.mote.solidTime = 0;
					item.Key.mote.fadeOutTime = 0;
					if (NoMoteRestart.Value)
					{
						item.Key.graphicData = new GraphicData();
					}
				}
			}
		}
	}
}