SpecializationUtil.registerSpecialization("repairVehicles", "repairVehicles", g_currentModDirectory.."repairVehicles.lua")

RV_Register = {};

g_i18n.globalI18N.texts["repairVehicles"] = g_i18n:getText("repairVehicles"); 

local version = SpecializationUtil.getSpecialization("repairVehicles").Version;


function RV_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		print("--- loading repairVehicles mod V"..string.format("%1.2f",version).." (by Rival)---")
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					--if vs ~= nil and vs == SpecializationUtil.getSpecialization("steerable") then
					if vs ~= nil and (vs == SpecializationUtil.getSpecialization("drivable") or vs == SpecializationUtil.getSpecialization("attachable")) then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.repairVehicles", _name)) ~= nil then
								allowInsertion = false;								
							end;							
						end;
						if allowInsertion then	
							table.insert(v.specializations, SpecializationUtil.getSpecialization("repairVehicles"));
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function RV_Register:deleteMap()
  
end;

function RV_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function RV_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function RV_Register:update(dt)
	
end;

function RV_Register:draw()
  
end;

addModEventListener(RV_Register);