----------------------
--  repairVehicles  --
--     by Rival     --
--   Version 1.1    --
----------------------

repairVehicles = {};
repairVehicles.Version = 1.1;

function repairVehicles:prerequisitesPresent(specializations)
    return true;
end;
function repairVehicles:load(savegame)
	self.rvPIR = false;
	self.rvLastOperatingTime = 0;
end;
function repairVehicles:postLoad(savegame)
	if savegame ~= nil and not savegame.resetVehicles then
		self.rvLastOperatingTime = Utils.getNoNil(getXMLFloat(savegame.xmlFile, savegame.key .. "#repairOperatingTime"), 0)*1000;
	end;
end;
function repairVehicles:delete()
end;
function repairVehicles:mouseEvent(posX, posY, isDown, isUp, button)
end;
function repairVehicles:keyEvent(unicode, sym, modifier, isDown)
end;
function repairVehicles:getSaveAttributesAndNodes(nodeIdent)
    local attributes = '';
    if self.rvLastOperatingTime ~= nil then
        attributes = attributes .. ' repairOperatingTime="' .. (self.rvLastOperatingTime/1000) .. '"';
    end;
    return attributes, nil;
end;
function repairVehicles:updateTick(dt)
	if g_currentMission.player ~= nil then
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local sx, sy, sz = getWorldTranslation(self.rootNode); 
		local distance = Utils.vector3Length(sx-vx, sy-vy, sz-vz);
		if distance < 3.5 then
			self.rvPIR = true; 
		else
			self.rvPIR = false; 
		end;
	end;
end;
function repairVehicles:update(dt)
	if self.rvPIR then
		local newOpTime = self.operatingTime-self.rvLastOperatingTime;
		if newOpTime > 100 then
			local costs = self:getPrice()*0.08*(newOpTime/100000000);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("REPAIR_VEHICLE_COST"), costs), InputBinding.REPAIR_VEHICLE);
			if InputBinding.hasEvent(InputBinding.REPAIR_VEHICLE) then
				if g_currentMission:getTotalMoney() > costs then
					self.rvLastOperatingTime = self.operatingTime;
					--self:setOperatingTime(0); -- operating time will not be set to 0 anymore - V1.1
					g_currentMission:addSharedMoney(-costs);
					g_currentMission:showBlinkingWarning(string.format(g_i18n:getText("VEHICLE_REPAIRED"), costs), 2000);
				else
					g_currentMission:showBlinkingWarning(g_i18n:getText("NOT_ENOUGH_MONEY"), 2000);
				end;
			end;
		end;
	end;
end;
function repairVehicles:draw()
end;
function repairVehicles:getDailyUpKeep()
    local storeItem = StoreItemsUtil.storeItemsByXMLFilename[self.configFileName:lower()]
    local multiplier = 1
    if storeItem.lifetime ~= nil and storeItem.lifetime ~= 0 then
        local ageMultiplier = 0.3 * math.min(self.age/storeItem.lifetime, 1)
        local operatingTime = (self.operatingTime-self.rvLastOperatingTime) / (1000*60*60)
        local operatingTimeMultiplier =  0.7 * math.min(operatingTime / (storeItem.lifetime*EconomyManager.LIFETIME_OPERATINGTIME_RATIO), 1)
        multiplier = 1 + EconomyManager.MAX_DAILYUPKEEP_MULTIPLIER * (ageMultiplier+operatingTimeMultiplier)
    end
    return StoreItemsUtil.getDailyUpkeep(storeItem, self.configurations) * multiplier
end;
function repairVehicles:getSellPrice()
    local priceMultiplier = 0.75
    local maxVehicleAge = StoreItemsUtil.storeItemsByXMLFilename[self.configFileName:lower()].lifetime;
    if maxVehicleAge ~= nil and maxVehicleAge ~= 0 then
        local ageMultiplier = 0.5 * math.min(self.age/maxVehicleAge, 1)
        local operatingTime = (self.operatingTime-self.rvLastOperatingTime/2) / (1000*60*60)
        local operatingTimeMultiplier =  0.5 * math.min(operatingTime / (maxVehicleAge*EconomyManager.LIFETIME_OPERATINGTIME_RATIO), 1)
        priceMultiplier = priceMultiplier * math.exp(-3.5 * (ageMultiplier+operatingTimeMultiplier))
    end
    return math.floor(self:getPrice() * math.max(priceMultiplier, 0.05));
end
Vehicle.getDailyUpKeep = Utils.overwrittenFunction(Vehicle.getDailyUpKeep, repairVehicles.getDailyUpKeep)
Vehicle.getSellPrice = Utils.overwrittenFunction(Vehicle.getSellPrice, repairVehicles.getSellPrice)