/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.npcvariety.api;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Rarity<T> {
    private final List<T> values;
    private RarityType type;

    @SafeVarargs
    public Rarity(T ... rarieties) {
        this.values = Arrays.asList(rarieties);
    }

    Rarity<T> setType(RarityType type) {
        this.type = type;
        return this;
    }

    public RarityType getType() {
        return this.type;
    }

    public List<T> getValues() {
        return this.values;
    }

    public static enum RarityType {
        ABUNDANT(50),
        COMMON(30),
        REGULAR(10),
        UNCOMMON(7),
        RARE(3);

        private final int probability;

        private RarityType(int probability) {
            this.probability = probability;
        }

        public boolean test(Random random) {
            return this.probability >= random.nextInt(100) + 1;
        }
    }
}

