/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.npcvariety.mixin;

import io.github.overlordsiii.npcvariety.api.EyeVariantManager;
import io.github.overlordsiii.npcvariety.api.SkinVariantManager;
import io.github.overlordsiii.npcvariety.api.TextureIdList;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3988;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3988.class})
public abstract class MerchantEntityMixin
extends class_1296
implements SkinVariantManager,
EyeVariantManager {
    private static final TextureIdList SKIN_TEXTURE_ID_LIST = new TextureIdList("textures/entity/villager/", 10, "skin");
    private static final TextureIdList EYE_TEXTURE_ID_LIST = new TextureIdList("textures/entity/villager/eyes", 4, "eye");
    private static final class_2940<Integer> SKIN_INDEX = class_2945.method_12791(class_3988.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> EYE_INDEX = class_2945.method_12791(class_3988.class, (class_2941)class_2943.field_13327);

    public MerchantEntityMixin(class_1299<? extends class_3988> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void setIndexes(CallbackInfo ci) {
        this.field_6011.method_12784(SKIN_INDEX, (Object)this.field_5974.nextInt(8));
        this.field_6011.method_12784(EYE_INDEX, (Object)this.getRandomEyeIndex());
    }

    private int getRandomEyeIndex() {
        if (this.field_5974.nextBoolean()) {
            return 3;
        }
        return this.field_5974.nextInt(5);
    }

    @Inject(method={"writeCustomDataToTag"}, at={@At(value="TAIL")})
    private void addSkinDataToTag(class_2487 tag, CallbackInfo ci) {
        tag.method_10569("skinIndex", this.getSkinIndex());
        tag.method_10569("eyeIndex", this.getEyeIndex());
    }

    @Inject(method={"readCustomDataFromTag"}, at={@At(value="TAIL")})
    private void readSkinDataFromTag(class_2487 tag, CallbackInfo ci) {
        if (tag.method_10545("skinIndex")) {
            this.setSkinIndex(tag.method_10550("skinIndex"));
        }
        if (tag.method_10545("eyeIndex")) {
            this.setEyeIndex(tag.method_10550("eyeIndex"));
        }
    }

    @Override
    public class_2960 getSkinVariant() {
        return (class_2960)SKIN_TEXTURE_ID_LIST.get(this.getSkinIndex());
    }

    @Override
    public void setSkinIndex(int index) {
        this.field_6011.method_12778(SKIN_INDEX, (Object)index);
    }

    @Override
    public int getSkinIndex() {
        return (Integer)this.field_6011.method_12789(SKIN_INDEX);
    }

    @Override
    public class_2960 getEyeVariant() {
        if (this.getEyeIndex() == 5) {
            return new class_2960("npcvariety:textures/entity/villager/eyes/eye5.png");
        }
        return (class_2960)EYE_TEXTURE_ID_LIST.get(this.getEyeIndex());
    }

    @Override
    public int getEyeIndex() {
        return (Integer)this.field_6011.method_12789(EYE_INDEX);
    }

    @Override
    public void setEyeIndex(int index) {
        this.field_6011.method_12778(EYE_INDEX, (Object)index);
    }
}

