/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.npcvariety.mixin;

import io.github.overlordsiii.npcvariety.api.BiomeSpawnRate;
import io.github.overlordsiii.npcvariety.api.EyeVariantManager;
import io.github.overlordsiii.npcvariety.api.Rarity;
import io.github.overlordsiii.npcvariety.api.SkinVariantManager;
import net.minecraft.class_1266;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3850;
import net.minecraft.class_3854;
import net.minecraft.class_3988;
import net.minecraft.class_5425;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1646.class})
public abstract class VillagerEntityMixin
extends class_3988 {
    @Shadow
    public abstract class_3850 method_7231();

    public VillagerEntityMixin(class_1299<? extends class_3988> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"createChild"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/passive/VillagerEntity;initialize(Lnet/minecraft/world/ServerWorldAccess;Lnet/minecraft/world/LocalDifficulty;Lnet/minecraft/entity/SpawnReason;Lnet/minecraft/entity/EntityData;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/entity/EntityData;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void inheritTraits(class_3218 serverWorld, class_1296 passiveEntity, CallbackInfoReturnable<class_1646> cir, class_3854 villagerType3, class_1646 villagerEntity) {
        if (passiveEntity instanceof class_1646) {
            class_1646 dad = (class_1646)passiveEntity;
            boolean dadInheritSkin = this.field_5974.nextBoolean();
            if (dadInheritSkin) {
                ((SkinVariantManager)villagerEntity).setSkinIndex(((SkinVariantManager)dad).getSkinIndex());
            } else {
                ((SkinVariantManager)villagerEntity).setSkinIndex(((SkinVariantManager)((Object)this)).getSkinIndex());
            }
            boolean dadInheritEyes = this.field_5974.nextBoolean();
            if (dadInheritEyes) {
                ((EyeVariantManager)villagerEntity).setEyeIndex(((EyeVariantManager)dad).getEyeIndex());
            } else {
                ((EyeVariantManager)villagerEntity).setEyeIndex(((EyeVariantManager)((Object)this)).getEyeIndex());
            }
        }
    }

    @Inject(method={"initialize"}, at={@At(value="TAIL")})
    private void resetSkinIndexBasedOnBiome(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, class_2487 entityTag, CallbackInfoReturnable<class_1315> cir) {
        if (spawnReason == class_3730.field_16474) {
            BiomeSpawnRate rate = VillagerEntityMixin.getRateFromType(this.method_7231());
            Rarity<Integer> numbers = VillagerEntityMixin.getRandomRarity(rate, (class_1646)this);
            int index = this.field_5974.nextInt(numbers.getValues().size());
            int val = numbers.getValues().get(index);
            ((SkinVariantManager)((Object)this)).setSkinIndex(val);
        }
    }

    private static Rarity<Integer> getRandomRarity(BiomeSpawnRate rate, class_1646 entity) {
        Rarity<Integer> rarity = rate.getRandom(entity, entity.method_6051());
        if (rarity == null) {
            return VillagerEntityMixin.getRandomRarity(rate, entity);
        }
        if (rarity.getValues().isEmpty()) {
            return VillagerEntityMixin.getRandomRarity(rate, entity);
        }
        return rarity;
    }

    private static BiomeSpawnRate getRateFromType(class_3850 data) {
        class_3854 type = data.method_16919();
        if (type == class_3854.field_17071) {
            return BiomeSpawnRate.DESERT;
        }
        if (type == class_3854.field_17075) {
            return BiomeSpawnRate.SNOWY;
        }
        if (type == class_3854.field_17073) {
            return BiomeSpawnRate.PLAINS;
        }
        if (type == class_3854.field_17072) {
            return BiomeSpawnRate.JUNGLE;
        }
        if (type == class_3854.field_17074) {
            return BiomeSpawnRate.SAVANNA;
        }
        if (type == class_3854.field_17076) {
            return BiomeSpawnRate.SWAMP;
        }
        return BiomeSpawnRate.TAIGA;
    }
}

