Scriptname _SparScript extends ReferenceAlias  

Actor property Target auto
Faction property targetFaction auto

Float property targetConfidence auto
Float property targetAggression auto

Bool property AllowFollowerHelp auto

Keyword property WeaponTypeBow auto

Perk Property lootPerk  Auto  

bool ranOnce
float startHealth

float melee
Weapon bow

float lastHealth

Quest property FollowerQuest auto
Quest property SparAliases auto

function StartCombat()
	;utility.wait(0.5)	

	;target = hostile.getactorref()

	registerforsingleupdate(0.5)

	sparAliases.Start()

	startHealth = target.getav("health")

	if(!AllowFollowerHelp)
		FollowerQuest.Start()
	endif

endfunction

event onupdate()
	
	if(game.getplayer().GetAvpercentage("health")< 0.2 ||  game.getplayer().isbleedingout()) ;if the target hit me
		;game.getplayer().SetActorValue("Paralysis",1)
		;target.PushActorAway(game.getplayer(), 0.0)
		utility.wait(1.0);
		target.stopcombat()
		target.removefromfaction(targetFaction)
		target.stopcombat()
		registerforsingleupdate(5.0)
		utility.wait(5.0)
		;game.getplayer().SetActorValue("Paralysis",0)
		;game.getplayer().SetNoBleedoutRecovery(false)
		target.SetActorValue("confidence",targetConfidence)
		target.SetActorValue("aggression",targetAggression)
		target.setav("meleedamage", melee)
		if(target.getitemcount(bow) == 0)
			target.additem(bow,1)
		endif

		game.getplayer().restoreav("health", 10000)
		target.restoreav("health", 10000)

		sparAliases.stop()
		FollowerQuest.Stop()
		target = none
		ranOnce = false
		lastHealth = 0
	endif


	if(!AllowFollowerHelp && target.GetCombatTarget() != game.getplayer())
		target.stopcombat()
		target.startcombat(game.getplayer())
	elseif(AllowFollowerHelp )
		FollowerQuest.Stop()
		Actor randomActor = Game.FindRandomActorFromRef(game.getplayer(), 500.0)

		if(randomActor.isplayerteammate())
			randomActor.EvaluatePackage()
			randomActor.startcombat(target)
		endif
	endif


		if(game.getplayer().GetEquippedWeapon() == none)
		if(target.GetEquippedWeapon() != none)
			melee = 0
			
			if(target.GetEquippedWeapon().HasKeyword(WeaponTypeBow))	
				bow = target.GetEquippedWeapon()
				target.removeitem(bow, 1)
			endif			

			target.setav("meleedamage", -1000)
			target.unequipitem(target.GetEquippedWeapon())
			target.damageav("magicka", 10000)
		endif
	else
		if(target.GetEquippedWeapon() == none)
			target.setav("meleedamage", melee)
			if(target.getitemcount(bow) == 0)
				target.additem(bow,1)
			endif
		endif
	endif


	if((target.getavpercentage("Health")< 0.2) && ranOnce == false && target.getav("health") < startHealth )
		target.SetActorValue("Paralysis",1)
		game.getplayer().PushActorAway(target, 1.0)
		ranOnce = true
	endif

	if(target.IsDead() == 1 || (target.GetActorValue("Paralysis") == 1 && game.getplayer().IsWeaponDrawn() == false) || target.isbleedingout()  && game.getplayer().IsWeaponDrawn() == false)
		target.removefromfaction(targetFaction)
		target.stopcombat()
		utility.wait(5.0)
		target.SetActorValue("Paralysis",0)
		target.SetActorValue("confidence",targetConfidence)
		target.SetActorValue("aggression",targetAggression)
		target.setav("meleedamage", melee)
		if(target.getitemcount(bow) == 0)
			target.additem(bow,1)
		endif

		game.getplayer().restoreav("health", 10000)
		target.restoreav("health", 10000)

		sparAliases.stop()
		FollowerQuest.Stop()
		target = none
		ranOnce = false
		lastHealth = 0
	endif

	lastHealth = target.getav("health")

	if(target != none)
		registerforsingleupdate(0.5)
	endif
endevent




ReferenceAlias Property hostile  Auto  
