/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import info.monitorenter.cpdetector.io.AbstractCodepageDetector;
import info.monitorenter.cpdetector.io.UnknownCharset;
import info.monitorenter.cpdetector.io.UnsupportedCharset;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public final class JChardetFacade
extends AbstractCodepageDetector
implements nsICharsetDetectionObserver {
    private static JChardetFacade instance = null;
    private static nsDetector det;
    private byte[] buf = new byte[4096];
    private Charset codpage = null;
    private boolean m_guessing = true;
    private int amountOfVerifiers = 0;

    private JChardetFacade() {
        det = new nsDetector(0);
        det.Init((nsICharsetDetectionObserver)this);
        this.amountOfVerifiers = det.getProbableCharsets().length;
    }

    public static JChardetFacade getInstance() {
        if (instance == null) {
            instance = new JChardetFacade();
        }
        return instance;
    }

    public synchronized Charset detectCodepage(InputStream in, int length) throws IOException {
        int len;
        this.Reset();
        int read = 0;
        boolean done = false;
        boolean isAscii = true;
        Charset ret = null;
        do {
            if ((len = in.read(this.buf, 0, Math.min(this.buf.length, length - read))) > 0) {
                read += len;
            }
            if (done) continue;
            done = det.DoIt(this.buf, len, false);
        } while (len > 0 && !done);
        det.DataEnd();
        ret = this.codpage == null ? (this.m_guessing ? this.guess() : UnknownCharset.getInstance()) : this.codpage;
        return ret;
    }

    private Charset guess() {
        Charset ret = null;
        String[] possibilities = det.getProbableCharsets();
        if (possibilities.length == this.amountOfVerifiers) {
            ret = Charset.forName("US-ASCII");
        } else {
            String check = possibilities[0];
            if (check.equalsIgnoreCase("nomatch")) {
                ret = UnknownCharset.getInstance();
            } else {
                int i = 0;
                while (ret == null && i < possibilities.length) {
                    try {
                        ret = Charset.forName(possibilities[i]);
                    }
                    catch (UnsupportedCharsetException uce) {
                        ret = UnsupportedCharset.forName(possibilities[i]);
                    }
                    ++i;
                }
            }
        }
        return ret;
    }

    public void Notify(String charset) {
        this.codpage = Charset.forName(charset);
    }

    public void Reset() {
        det.Reset();
        this.codpage = null;
    }

    public boolean isGuessing() {
        return this.m_guessing;
    }

    public synchronized void setGuessing(boolean guessing) {
        this.m_guessing = guessing;
    }
}

