/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeng.io.util.IOUtil;
import org.zeng.util.StringUtil;

public class Property {
    private static final Logger a = LoggerFactory.getLogger(Property.class);
    private Properties b = new Properties();
    private File c = null;
    private static long d = 0L;

    public Property(String string) {
        this(new File(string));
    }

    public Property(File object) {
        this.c = object;
        object = this;
        this.b = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = super.a();
            if (inputStream != null) {
                ((Property)object).b.load(inputStream);
            }
            d = ((Property)object).c.lastModified();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            a.error("load properties is error!" + fileNotFoundException);
            throw new RuntimeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            a.error("load properties is error!" + iOException);
            throw new RuntimeException(iOException);
        }
        finally {
            IOUtil.close(inputStream);
        }
    }

    public File getFile() {
        return this.c;
    }

    public synchronized boolean checkModify() {
        boolean bl = false;
        InputStream inputStream = null;
        try {
            if (d != this.c.lastModified()) {
                bl = true;
                inputStream = this.a();
                this.b.clear();
                this.b.load(inputStream);
                d = this.c.lastModified();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            IOUtil.close(inputStream);
        }
        return bl;
    }

    private InputStream a() throws FileNotFoundException {
        InputStream inputStream = null;
        String string = StringUtil.addLocaleSuffix(this.c.getName());
        File file = new File(string);
        if (file.exists()) {
            inputStream = new FileInputStream(file);
            this.c = file;
        } else if (this.c.exists()) {
            inputStream = new FileInputStream(this.c);
        }
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            if (inputStream != null) {
                this.c = file;
            } else {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(this.c.getName());
            }
        }
        return inputStream;
    }

    public List<String> getKeys() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.b.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public String getProperty(String string) {
        return this.b.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.b.getProperty(string, string2);
    }

    public int getIntProperty(String string) {
        return this.getIntProperty(string, 0);
    }

    public int getIntProperty(String string, int n) {
        try {
            n = Integer.parseInt(this.b.getProperty(string));
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public boolean getBooleanProperty(String string) {
        boolean bl = Boolean.parseBoolean(this.b.getProperty(string));
        return bl;
    }

    public List<String> getListProperty(String stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        stringArray = this.b.getProperty((String)stringArray);
        for (String string : stringArray.split(",")) {
            arrayList.add(string.trim());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setProperty(String string, String string2) {
        this.b.setProperty(string, string2);
    }

    public void setProperty(String string, Boolean bl) {
        this.b.setProperty(string, bl.toString());
    }

    public void setProperty(String string, Integer n) {
        this.b.setProperty(string, n.toString());
    }

    public void store() throws IOException {
        File file = this.c;
        Property property = this;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            property.b.store(fileOutputStream, "");
        }
        catch (IOException iOException) {
            try {
                a.error("", (Throwable)iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                IOUtil.close(fileOutputStream);
                throw throwable;
            }
        }
        IOUtil.close(fileOutputStream);
        return;
    }
}

