/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeng.util.StringUtil;
import org.zeng.util.math.CountUtil;

public class NioFileUtil {
    private static final Logger a = LoggerFactory.getLogger(NioFileUtil.class);

    public static ByteBuffer readFile(String object) throws IOException {
        object = new File((String)object);
        return NioFileUtil.readFile((File)object);
    }

    public static ByteBuffer readFile(File object) throws IOException {
        a.info("File:" + ((File)object).getAbsolutePath() + "file.length()=" + ((File)object).length());
        object = new FileInputStream((File)object).getChannel();
        MappedByteBuffer mappedByteBuffer = ((FileChannel)object).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)object).size());
        ((AbstractInterruptibleChannel)object).close();
        return mappedByteBuffer;
    }

    public static void saveFile(ByteBuffer byteBuffer, String object) throws IOException {
        object = new File((String)object);
        NioFileUtil.saveFile(byteBuffer, (File)object);
    }

    public static void saveFile(ByteBuffer byteBuffer, File object) throws IOException {
        if (!((File)object).exists() && ((File)object).getParentFile() != null) {
            ((File)object).getParentFile().mkdirs();
        }
        object = new FileOutputStream((File)object).getChannel();
        int n = ((FileChannel)object).write(byteBuffer);
        if (CountUtil.isMonitor()) {
            CountUtil.add(n);
        }
        ((AbstractInterruptibleChannel)object).close();
    }

    public static void copyFile(File comparable, File file) throws IOException {
        comparable = NioFileUtil.readFile((File)comparable);
        NioFileUtil.saveFile((ByteBuffer)comparable, file);
        ((ByteBuffer)comparable).clear();
    }

    public static void deepCopyFiles(File fileArray, File file) throws IOException {
        if (fileArray.isDirectory()) {
            file = new File(file, fileArray.getName());
            if ((fileArray = fileArray.listFiles()) != null) {
                for (File file2 : fileArray) {
                    if (file2.isDirectory()) {
                        NioFileUtil.deepCopyFiles(file2, file);
                        continue;
                    }
                    File file3 = new File(file, file2.getName());
                    NioFileUtil.copyFile(file2, file3);
                }
            }
            return;
        }
        NioFileUtil.copyFile((File)fileArray, file);
    }

    public static void toZip(File file) throws IOException {
        NioFileUtil.toZip(file, file);
    }

    public static void toZip(File file, File file2) throws IOException {
        NioFileUtil.toZip(file, file2, "");
    }

    public static void toZip(File file, File file2, String string) throws IOException {
        String string2 = StringUtil.getSystemEncoding();
        NioFileUtil.toZip(file, file2, string, string2);
    }

    public static void toZip(File file, File file2, String string, String string2) throws IOException {
        if (file2.isDirectory() && !file2.exists()) {
            file2.mkdirs();
        }
        file2 = new File(file2, file.getName() + string + ".zip");
        file2 = new ZipArchiveOutputStream(file2);
        file2.setEncoding(string2);
        string = file.getAbsoluteFile().getParent();
        if (file.isDirectory()) {
            NioFileUtil.b((ZipArchiveOutputStream)file2, string, file);
        } else {
            NioFileUtil.a((ZipArchiveOutputStream)file2, string, file);
        }
        file2.finish();
        file2.close();
    }

    private static void a(ZipArchiveOutputStream zipArchiveOutputStream, String object, File comparable) throws IOException {
        long l;
        object = NioFileUtil.a((File)comparable, (String)object);
        object = new ZipArchiveEntry((File)comparable, (String)object);
        comparable = NioFileUtil.readFile((File)comparable);
        object.setSize(l);
        zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)object);
        object = new byte[1024];
        for (l = (long)((Buffer)((Object)comparable)).remaining(); l > 0L; l -= (long)((Object)object).length) {
            int n = l >= (long)((Object)object).length ? ((Object)object).length : (int)l;
            ((ByteBuffer)comparable).get((byte[])object, 0, n);
            zipArchiveOutputStream.write((byte[])object, 0, n);
            if (!CountUtil.isMonitor()) continue;
            CountUtil.add(n);
        }
        zipArchiveOutputStream.flush();
        zipArchiveOutputStream.closeArchiveEntry();
    }

    private static void b(ZipArchiveOutputStream zipArchiveOutputStream, String string, File fileArray) throws IOException {
        String string2 = NioFileUtil.a((File)fileArray, string);
        string2 = new ZipArchiveEntry((File)fileArray, string2);
        zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)string2);
        zipArchiveOutputStream.flush();
        zipArchiveOutputStream.closeArchiveEntry();
        fileArray = fileArray.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    NioFileUtil.b(zipArchiveOutputStream, string, file);
                    continue;
                }
                NioFileUtil.a(zipArchiveOutputStream, string, file);
            }
        }
    }

    private static String a(File object, String string) {
        String string2 = ((File)object).getAbsolutePath();
        object = ((File)object).getName();
        if (!string.equals(string2)) {
            object = string2.substring(string.length() + 1);
            ((String)object).replace("\\", "/");
        }
        return object;
    }
}

