/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.io.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeng.constant.Symbol;

public class IOUtil {
    private static Logger a = LoggerFactory.getLogger(IOUtil.class);

    public static String getResourceText(String object, String charSequence) throws IOException {
        InputStream inputStream = IOUtil.class.getResourceAsStream((String)object);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, (String)charSequence));
            charSequence = new StringBuilder();
            while ((object = bufferedReader.readLine()) != null) {
                ((StringBuilder)charSequence).append((String)object);
                ((StringBuilder)charSequence).append(Symbol.ENTER);
            }
            object = ((StringBuilder)charSequence).toString();
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                IOUtil.close(bufferedReader);
                IOUtil.close(inputStream);
                throw throwable;
            }
        }
        IOUtil.close(bufferedReader);
        IOUtil.close(inputStream);
        return object;
    }

    public static void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            return;
        }
        catch (IOException iOException) {
            a.error("", (Throwable)iOException);
            return;
        }
    }

    public static void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            return;
        }
        catch (IOException iOException) {
            a.error("", (Throwable)iOException);
            return;
        }
    }

    public static void close(BufferedReader bufferedReader) {
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            return;
        }
        catch (IOException iOException) {
            a.error("", (Throwable)iOException);
            return;
        }
    }

    public static void close(BufferedWriter bufferedWriter) {
        try {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            return;
        }
        catch (IOException iOException) {
            a.error("", (Throwable)iOException);
            return;
        }
    }
}

