/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.zeng.config.KeyConfig;
import org.zeng.config.MessagesConfig;
import org.zeng.security.CryptException;
import org.zeng.util.StringUtil;

public class SecurityUtil {
    public static final String SUFFIX = ".zs";
    public static final String AES = "AES";

    public static String getMessageDigest(String object, byte[] byArray) throws NoSuchAlgorithmException {
        object = MessageDigest.getInstance((String)object);
        ((MessageDigest)object).update(byArray);
        byte[] byArray2 = ((MessageDigest)object).digest();
        object = byArray2;
        return StringUtil.byte2hex(byArray2);
    }

    public static String getMessageDigest(String string, String string2) throws NoSuchAlgorithmException {
        return SecurityUtil.getMessageDigest(string, string2.getBytes());
    }

    public static String times(String string, String string2, int n) throws NoSuchAlgorithmException {
        for (int i = 0; i < n; ++i) {
            string2 = SecurityUtil.getMessageDigest(string, string2);
        }
        return string2;
    }

    public static String getMessageDigest(String string, FileInputStream fileInputStream) throws NoSuchAlgorithmException, IOException {
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        return SecurityUtil.getMessageDigest(string, byArray);
    }

    private static void a(InputStream inputStream, OutputStream outputStream, Cipher cipher) throws IOException, GeneralSecurityException {
        int n = cipher.getBlockSize();
        int n2 = cipher.getOutputSize(n);
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            n3 = inputStream.read(byArray);
            if (n3 == n) {
                int n4 = cipher.update(byArray, 0, n, byArray2);
                outputStream.write(byArray2, 0, n4);
                continue;
            }
            bl = false;
        }
        byArray2 = n3 > 0 ? cipher.doFinal(byArray, 0, n3) : cipher.doFinal();
        outputStream.write(byArray2);
    }

    private static void a(File object, File object2, File object3, int n) throws FileNotFoundException, IOException, ClassNotFoundException, GeneralSecurityException {
        object3 = new ObjectInputStream(new FileInputStream((File)object3));
        Key key = (Key)((ObjectInputStream)object3).readObject();
        ((ObjectInputStream)object3).close();
        object = new FileInputStream((File)object);
        object2 = new FileOutputStream((File)object2);
        object3 = Cipher.getInstance(AES);
        ((Cipher)object3).init(n, key);
        SecurityUtil.a((InputStream)object, (OutputStream)object2, (Cipher)object3);
        ((InputStream)object).close();
        ((OutputStream)object2).close();
    }

    public static void encryptByAES(File file, File file2, File file3) throws FileNotFoundException, IOException, ClassNotFoundException, GeneralSecurityException {
        SecurityUtil.a(file, file2, file3, 1);
    }

    public static void encryptByAES(String string, String string2, String string3) throws FileNotFoundException, IOException, ClassNotFoundException, GeneralSecurityException {
        SecurityUtil.a(new File(string), new File(string2), new File(string3), 1);
    }

    public static void decryptByAES(File file, File file2, File file3) throws FileNotFoundException, IOException, ClassNotFoundException, GeneralSecurityException {
        SecurityUtil.a(file, file2, file3, 2);
    }

    public static void decryptByAES(String string, String string2, String string3) throws FileNotFoundException, IOException, ClassNotFoundException, GeneralSecurityException {
        SecurityUtil.a(new File(string), new File(string2), new File(string3), 2);
    }

    private static Key a(String object) throws CryptException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            object = ((String)object).getBytes("UTF-8");
            messageDigest.update((byte[])object);
            object = messageDigest.digest();
            object = new SecretKeySpec((byte[])object, AES);
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
        return object;
    }

    public static void encryptAESFile(File object, File object2, String object3) throws CryptException {
        Object object4 = object3 = SecurityUtil.a((String)object3);
        object3 = AES;
        try {
            object3 = Cipher.getInstance((String)object3);
            ((Cipher)object3).init(1, (Key)object4);
            object = new BufferedInputStream(new FileInputStream((File)object));
            object2 = new CipherOutputStream(new FileOutputStream((File)object2), (Cipher)object3);
            int n = ((Cipher)object3).getBlockSize();
            byte[] byArray = new byte[n];
            int n2 = ((FilterInputStream)object).read(byArray);
            while (n2 != -1) {
                ((CipherOutputStream)object2).write(byArray, 0, n2);
                n2 = ((FilterInputStream)object).read(byArray);
            }
            ((CipherOutputStream)object2).flush();
            ((BufferedInputStream)object).close();
            ((CipherOutputStream)object2).close();
            return;
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
    }

    public static void decryptAESFile(File object, File object2, String object3) throws CryptException {
        Object object4 = object3 = SecurityUtil.a((String)object3);
        object3 = AES;
        try {
            object3 = Cipher.getInstance((String)object3);
            ((Cipher)object3).init(2, (Key)object4);
            object = new CipherInputStream(new FileInputStream((File)object), (Cipher)object3);
            object2 = new BufferedOutputStream(new FileOutputStream((File)object2));
            int n = ((Cipher)object3).getBlockSize();
            byte[] byArray = new byte[n];
            int n2 = ((CipherInputStream)object).read(byArray);
            while (n2 != -1) {
                ((BufferedOutputStream)object2).write(byArray, 0, n2);
                n2 = ((CipherInputStream)object).read(byArray);
            }
            ((BufferedOutputStream)object2).flush();
            ((CipherInputStream)object).close();
            ((FilterOutputStream)object2).close();
            return;
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
    }

    public static void encryptAESFile(File file, String string) throws CryptException {
        File file2 = new File(file.getParentFile(), file.getName() + SUFFIX);
        SecurityUtil.encryptAESFile(file, file2, string);
    }

    public static void decryptAESFile(File file, String string) throws CryptException {
        SecurityUtil.decryptAESFile(file, string, false);
    }

    public static void decryptAESFile(File file, String string, boolean bl) throws CryptException {
        if (file.isDirectory()) {
            return;
        }
        Object object = file.getName();
        if (((String)object).endsWith(SUFFIX)) {
            object = new File(file.getParentFile(), ((String)object).substring(0, ((String)object).length() - 3));
            if (!bl && ((File)object).exists()) {
                throw new IllegalArgumentException(MessagesConfig.getInstance().infoSecurityDecryptDuplicate);
            }
            SecurityUtil.decryptAESFile(file, (File)object, string);
        }
    }

    public static void encryptAESFile(File file) throws CryptException {
        KeyConfig keyConfig = KeyConfig.getInstance();
        SecurityUtil.encryptAESFile(file, keyConfig.defaultKey);
    }

    public static void encryptAESFiles(File fileArray) throws CryptException {
        KeyConfig keyConfig = KeyConfig.getInstance();
        if (fileArray.isDirectory()) {
            if ((fileArray = fileArray.listFiles()) != null) {
                for (File file : fileArray) {
                    SecurityUtil.encryptAESFile(file, keyConfig.defaultKey);
                }
            }
            return;
        }
        SecurityUtil.encryptAESFile((File)fileArray, keyConfig.defaultKey);
    }

    public static void decryptAESFile(File file) throws CryptException {
        KeyConfig keyConfig = KeyConfig.getInstance();
        SecurityUtil.decryptAESFile(file, keyConfig.defaultKey);
    }

    public static void decryptAESFiles(File fileArray) throws CryptException {
        KeyConfig keyConfig = KeyConfig.getInstance();
        if (fileArray.isDirectory()) {
            if ((fileArray = fileArray.listFiles()) != null) {
                for (File file : fileArray) {
                    SecurityUtil.decryptAESFile(file, keyConfig.defaultKey);
                }
            }
            return;
        }
        SecurityUtil.decryptAESFile((File)fileArray, keyConfig.defaultKey);
    }

    public static void decryptAESFile(File file, boolean bl) throws CryptException {
        KeyConfig keyConfig = KeyConfig.getInstance();
        SecurityUtil.decryptAESFile(file, keyConfig.defaultKey, bl);
    }

    public static String encrypt(String string, String object) throws CryptException {
        object = SecurityUtil.a((String)object);
        return SecurityUtil.a(string, AES, (Key)object);
    }

    private static String a(String object, String object2, Key key) throws CryptException {
        try {
            object2 = Cipher.getInstance((String)object2);
            ((Cipher)object2).init(1, key);
            byte[] byArray = ((Cipher)object2).doFinal(((String)object).getBytes());
            object = byArray;
            object = StringUtil.byte2hex(byArray);
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
        return object;
    }

    public static String decrypt(String string, String object) throws CryptException {
        object = SecurityUtil.a((String)object);
        return SecurityUtil.b(string, AES, (Key)object);
    }

    private static String b(String object, String object2, Key key) throws CryptException {
        try {
            object2 = Cipher.getInstance((String)object2);
            ((Cipher)object2).init(2, key);
            object = StringUtil.hex2byte((String)object);
            object = new String(((Cipher)object2).doFinal((byte[])object));
        }
        catch (Exception exception) {
            throw new CryptException(exception);
        }
        return object;
    }
}

