/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.text.lrc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeng.constant.Symbol;
import org.zeng.file.ExtensionFileFilter;
import org.zeng.io.util.IOUtil;
import org.zeng.text.lrc.LrcRecord;
import org.zeng.util.EncodingUtils;

public class LrcFile {
    private static final Logger a = LoggerFactory.getLogger(LrcFile.class);
    public static final String LRC_FILE_TYPE = ".lrc";
    private static ExtensionFileFilter b = new ExtensionFileFilter();
    private List<String> c = new ArrayList<String>();
    private Map<Integer, LrcRecord> d = new TreeMap<Integer, LrcRecord>();
    private Map<Integer, Integer> e = new HashMap<Integer, Integer>();
    private static int f = 1000;
    private long g = 0L;
    private File h;

    public LrcFile(File file) {
        if (!b.accept(file)) {
            throw new RuntimeException("Invalid File Type!");
        }
        this.h = file;
        a.info("LrcFile=" + file.getName());
    }

    public LrcRecord getRecord(int n) {
        Integer n2 = this.e.get(n /= f);
        LrcRecord lrcRecord = this.d.get(n2);
        if (lrcRecord != null && (long)n < lrcRecord.getTime()) {
            lrcRecord = this.d.get(n2);
        }
        return lrcRecord;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFile() throws IOException {
        int n;
        String string;
        Object object = null;
        String string2 = EncodingUtils.getStringFromFile(this.h);
        object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.h), string2));
        ArrayList<LrcRecord> arrayList = new ArrayList<LrcRecord>();
        while ((string = ((BufferedReader)object).readLine()) != null) {
            n = LrcFile.parse(string, arrayList);
            if (n != 0 || string.length() <= 0) continue;
            this.c.add(string);
        }
        Collections.sort(arrayList);
        n = arrayList.size();
        if (n > 0) {
            this.g = ((LrcRecord)arrayList.get(n - 1)).getTime();
        }
        for (int i = 0; i < n; ++i) {
            LrcRecord lrcRecord = (LrcRecord)arrayList.get(i);
            this.d.put(i, lrcRecord);
        }
        this.a(arrayList);
        try {
            ((BufferedReader)object).close();
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            if (object == null) return;
            try {
                ((BufferedReader)object).close();
                return;
            }
            catch (IOException iOException) {
                IOException iOException3 = iOException;
                iOException.printStackTrace();
                return;
            }
        }
        catch (IOException iOException) {
            IOException iOException4 = iOException;
            iOException.printStackTrace();
            throw iOException4;
            {
                catch (Throwable throwable) {
                    if (object == null) throw throwable;
                    try {
                        ((BufferedReader)object).close();
                        throw throwable;
                    }
                    catch (IOException iOException5) {
                        object = iOException5;
                        iOException5.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
    }

    private void a(List<LrcRecord> list) {
        int n = (int)(this.g / (long)f);
        int n2 = 0;
        for (int i = 0; i <= n && n2 < list.size(); ++i) {
            LrcRecord lrcRecord = list.get(n2);
            int n3 = (int)(lrcRecord.getTime() / (long)f);
            if (i >= n3) {
                this.e.put(i, n2);
                ++n2;
                continue;
            }
            this.e.put(i, n2 - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean parse(String string, List<LrcRecord> list) {
        Object object;
        Object object2 = Pattern.compile("\\[\\d+:\\d+(\\.\\d+)?\\]");
        object2 = ((Pattern)object2).matcher(string);
        int n = 0;
        int n2 = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (((Matcher)object2).find()) {
            long l;
            void var9_16;
            object = new LrcRecord();
            String string2 = ((Matcher)object2).group();
            String string4 = string2;
            string4 = string2;
            string4 = string2.substring(1, string4.length() - 1);
            int n3 = string4.indexOf(":");
            String string5 = string4.substring(0, n3);
            int n4 = Integer.parseInt(string5);
            string4 = string4.substring(n3 + 1);
            int n5 = 0;
            n3 = string4.indexOf(".");
            if (n3 == -1) {
                String string22 = string4.substring(0);
            } else {
                String lrcRecord = string4.substring(0, n3);
                string4 = string4.substring(n3 + 1);
                n5 = Integer.parseInt(string4);
            }
            n = Integer.parseInt((String)var9_16);
            long l2 = l = (long)(n4 * 60 * 1000 + n * 1000 + n5 * 10);
            ((LrcRecord)object).setTime(l2);
            n = ((Matcher)object2).end();
            arrayList.add(object);
        }
        object = string.substring(n);
        for (LrcRecord lrcRecord : arrayList) {
            lrcRecord.setText((String)object);
        }
        if (arrayList.size() > 0) {
            list.addAll(arrayList);
        }
        return list.size() > n2;
    }

    public void write() throws IOException {
        this.write(this.h);
    }

    public void write(File iterator) throws IOException {
        if (((File)((Object)iterator)).isDirectory() || !b.accept((File)((Object)iterator))) {
            throw new RuntimeException("Invalid File Type!");
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter((File)((Object)iterator)));
            for (String object : this.c) {
                bufferedWriter.write(object);
                bufferedWriter.write(Symbol.ENTER);
            }
            for (Map.Entry entry : this.d.entrySet()) {
                LrcRecord lrcRecord = (LrcRecord)entry.getValue();
                bufferedWriter.write(lrcRecord.toString());
                bufferedWriter.write(Symbol.ENTER);
            }
        }
        catch (IOException iOException) {
            try {
                iterator = iOException;
                iOException.printStackTrace();
                throw iterator;
            }
            catch (Throwable throwable) {
                IOUtil.close(bufferedWriter);
                throw throwable;
            }
        }
        IOUtil.close(bufferedWriter);
        return;
    }

    public static void formatFiles(File fileArray) throws IOException {
        if (fileArray.isDirectory()) {
            File[] fileArray2 = fileArray.listFiles(b);
            fileArray = fileArray2;
            fileArray = fileArray2;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                LrcFile.a(file);
            }
            return;
        }
        LrcFile.a((File)fileArray);
    }

    private static void a(File object) throws IOException {
        object = new LrcFile((File)object);
        ((LrcFile)object).readFile();
        ((LrcFile)object).write();
    }

    static {
        b.addExtension(LRC_FILE_TYPE);
    }
}

