/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.text.srt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeng.file.ExtensionFileFilter;
import org.zeng.file.FileUtil;
import org.zeng.text.srt.SrtFileUtil;
import org.zeng.text.srt.SrtRecord;
import org.zeng.time.Timeline;
import org.zeng.util.StringUtil;

public class SrtFile
implements Comparable<SrtFile> {
    private static final Logger a = LoggerFactory.getLogger(SrtFile.class);
    public static final String EXTENSION = ".srt";
    private List<SrtRecord> b = new ArrayList<SrtRecord>();
    private File c;
    private static ExtensionFileFilter d = new ExtensionFileFilter();

    public SrtFile(File file) {
        if (!d.accept(file)) {
            throw new IllegalArgumentException("Invalid File Type!");
        }
        this.c = file;
    }

    public List<SrtRecord> getRecords() {
        return this.b;
    }

    public void setRecords(List<SrtRecord> list) {
        this.b = list;
    }

    public String getFileName() {
        return this.c.getName();
    }

    public String getPath() {
        return this.c.getParentFile().getPath();
    }

    /*
     * WARNING - void declaration
     */
    private void a(List<String> object3, String string) throws ParseException {
        Object object;
        int n;
        SrtRecord srtRecord = new SrtRecord();
        boolean bl = true;
        for (n = 0; n < object3.size(); ++n) {
            void var2_4;
            object = ((String)object3.get(n)).trim();
            if (n == 0) {
                int n2;
                block9: {
                    n2 = 0;
                    try {
                        n2 = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!((String)object).contains("\ufeff")) break block9;
                        object = ((String)object).replaceAll("\ufeff", "");
                        n2 = Integer.parseInt((String)object);
                    }
                }
                srtRecord.setNo(n2);
                continue;
            }
            if (n == 1) {
                Timeline timeline = Timeline.parse((String)object, " --> ".trim());
                srtRecord.setTimeline(timeline);
                continue;
            }
            if (var2_4 != null && ((String)object).contains((CharSequence)var2_4)) {
                bl = false;
                break;
            }
            srtRecord.addText((String)object);
        }
        if (bl) {
            if (this.b.contains(srtRecord)) {
                a.info("records.contains(record)");
                n = this.b.indexOf(srtRecord);
                object = this.b.get(n);
                for (String string2 : srtRecord.getTexts()) {
                    ((SrtRecord)object).addText(string2);
                }
                return;
            }
            this.b.add(srtRecord);
        }
    }

    public void copy(SrtFile object) {
        object = ((SrtFile)object).getRecords();
        for (int i = 0; i < this.b.size(); ++i) {
            SrtRecord srtRecord = this.b.get(i);
            SrtRecord srtRecord2 = (SrtRecord)object.get(i);
            if (!srtRecord.getNo().equals(srtRecord2.getNo())) continue;
            srtRecord.setTexts(srtRecord2.getTexts());
        }
    }

    public void read(String string, String string2) throws Exception {
        this.b.clear();
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.c);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string2));
            boolean bl = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = SrtFile.a(string2)).length() > 0) {
                    if (bl && StringUtil.isNumber(string2)) {
                        if (arrayList.size() >= 3) {
                            this.a(arrayList, string);
                        }
                        arrayList = new ArrayList();
                    }
                    arrayList.add(string2);
                    bl = false;
                    continue;
                }
                bl = true;
            }
            if (arrayList.size() >= 3) {
                this.a(arrayList, string);
            }
        }
        catch (Exception exception) {
            try {
                Exception exception2 = exception;
                exception.printStackTrace();
                throw exception2;
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw throwable;
            }
        }
        bufferedReader.close();
        fileInputStream.close();
        this.sort();
    }

    public void read() throws Exception {
        String string = FileUtil.getFileCode(this.c);
        if (string.equalsIgnoreCase("BIG5")) {
            string = "GBK";
        }
        this.read(null, string);
    }

    public void read(String string) throws Exception {
        String string2 = FileUtil.getFileCode(this.c);
        if (string2.equalsIgnoreCase("BIG5")) {
            string2 = "GBK";
        }
        this.read(string, string2);
    }

    public void rollTime(int n, int n2, int[] nArray) {
        if (nArray.length < 5) {
            throw new RuntimeException("not right int[]!");
        }
        int n3 = nArray[0] > 0 ? 1 : -1;
        int n4 = 1;
        while (n4 < nArray.length) {
            int n5 = n4++;
            nArray[n5] = nArray[n5] * n3;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, nArray[1]);
        calendar.set(12, nArray[2]);
        calendar.set(13, nArray[3]);
        calendar.set(14, nArray[4]);
        this.a(n, n2, calendar);
    }

    public void rollTime(int[] nArray) {
        if (nArray.length < 5) {
            throw new RuntimeException("not right int[]!");
        }
        int n = nArray[0] > 0 ? 1 : -1;
        int n2 = 1;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] * n;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, nArray[1]);
        calendar.set(12, nArray[2]);
        calendar.set(13, nArray[3]);
        calendar.set(14, nArray[4]);
        this.a(calendar);
    }

    private void a(int n, int n2, Calendar calendar) {
        if (n >= this.b.size()) {
            return;
        }
        if (n2 < 0 || n2 > this.b.size() - 1) {
            n2 = this.b.size();
        }
        --n;
        while (n < n2) {
            Comparable<SrtRecord> comparable = this.b.get(n);
            comparable = comparable.getTimeline();
            ((Timeline)comparable).rollTime(calendar);
            ++n;
        }
    }

    private void a(Calendar calendar) {
        for (Comparable<SrtRecord> comparable : this.b) {
            comparable = comparable.getTimeline();
            ((Timeline)comparable).rollTime(calendar);
        }
    }

    public void formatEnd() {
        for (int i = 0; i < this.b.size() - 1; ++i) {
            Comparable<SrtRecord> comparable = this.b.get(i);
            Comparable<SrtRecord> comparable2 = this.b.get(i + 1);
            comparable = ((SrtRecord)comparable).getTimeline();
            comparable2 = ((SrtRecord)comparable2).getTimeline();
            ((Timeline)comparable).setEndTime(((Timeline)comparable2).getStartTime());
        }
    }

    public void formatNo() {
        int n = 0;
        while (n < this.b.size()) {
            SrtRecord srtRecord = this.b.get(n);
            srtRecord.setNo(++n);
        }
    }

    public void formatTimeline() {
        SrtRecord srtRecord = this.b.get(0);
        for (int i = 1; i < this.b.size(); ++i) {
            Iterator<String> iterator = this.b.get(i);
            List<String> list = srtRecord.getTimeline();
            Timeline timeline = ((SrtRecord)((Object)iterator)).getTimeline();
            Date date = timeline.getStartTime();
            long l = ((Timeline)((Object)list)).getEndTime().getTime();
            if (date.getTime() < l) {
                if (SrtFileUtil.isCoincide(srtRecord, (SrtRecord)((Object)iterator))) {
                    if (timeline.getEndTime().after(((Timeline)((Object)list)).getEndTime())) {
                        ((Timeline)((Object)list)).setEndTime(timeline.getEndTime());
                    }
                    list = srtRecord.getTexts();
                    for (String string : ((SrtRecord)((Object)iterator)).getTexts()) {
                        list.add(string);
                    }
                    this.b.remove(i);
                    srtRecord = this.b.get(--i);
                    continue;
                }
                date.setTime(l + 100L);
            }
            if (date.getTime() >= timeline.getEndTime().getTime()) {
                list = srtRecord.getTexts();
                for (String string : ((SrtRecord)((Object)iterator)).getTexts()) {
                    list.add(string);
                }
                this.b.remove(i);
                --i;
                continue;
            }
            srtRecord = iterator;
        }
    }

    public void separate() throws IOException {
        Serializable serializable;
        Object object;
        ArrayList<SrtRecord> arrayList = new ArrayList<SrtRecord>();
        ArrayList<SrtRecord> arrayList2 = new ArrayList<SrtRecord>();
        int n = 1;
        int n2 = 1;
        for (SrtRecord object22 : this.b) {
            Object object2;
            object = new ArrayList();
            serializable = new ArrayList();
            for (String string : object22.getTexts()) {
                boolean bl = false;
                for (char c : string.toCharArray()) {
                    if (!StringUtil.isChineseChar(c)) continue;
                    bl = true;
                    object.add(string);
                    break;
                }
                if (bl) continue;
                serializable.add(string);
            }
            if (object.size() > 0) {
                object2 = new SrtRecord();
                ((SrtRecord)object2).setNo(n++);
                ((SrtRecord)object2).setTimeline(object22.getTimeline());
                ((SrtRecord)object2).setTexts((List<String>)object);
                arrayList.add((SrtRecord)object2);
            }
            if (serializable.size() <= 0) continue;
            object2 = new SrtRecord();
            ((SrtRecord)object2).setNo(n2++);
            ((SrtRecord)object2).setTimeline(object22.getTimeline());
            ((SrtRecord)object2).setTexts((List<String>)((Object)serializable));
            arrayList2.add((SrtRecord)object2);
        }
        String string = this.c.getParentFile().getPath();
        String string2 = this.c.getName();
        if (arrayList.size() > 0) {
            object = string2.replaceAll("\\.srt", ".chs.srt");
            serializable = new File(string, (String)object);
            this.write((File)serializable, (List<SrtRecord>)arrayList);
        }
        if (arrayList2.size() > 0) {
            object = string2.replaceAll("\\.srt", ".eng.srt");
            serializable = new File(string, (String)object);
            this.write((File)serializable, (List<SrtRecord>)arrayList2);
        }
    }

    public void sort() {
        TreeSet<SrtRecord> treeSet = new TreeSet<SrtRecord>(this.b);
        this.b = new ArrayList<SrtRecord>(treeSet);
        this.formatNo();
    }

    public void write() throws IOException {
        this.write(this.c);
    }

    public void write(File file) throws IOException {
        this.write(file, this.b);
    }

    public void write(File iterator, List<SrtRecord> object) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            new StringBuilder().append(((File)((Object)iterator)).getName()).append(".bak");
            String string = ((File)((Object)iterator)).getName();
            iterator = new FileOutputStream(new File(((File)((Object)iterator)).getParentFile(), string));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)((Object)iterator), "UTF-8"));
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                bufferedWriter.write(((SrtRecord)object).toString());
            }
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            try {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
                throw iOException2;
            }
            catch (Throwable throwable) {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                throw throwable;
            }
        }
        bufferedWriter.close();
        return;
    }

    public void writeText() throws IOException {
        this.writeText(this.c);
    }

    public void writeText(File serializable) throws IOException {
        if (this.b.size() == 0) {
            try {
                this.read();
            }
            catch (Exception exception) {
                serializable = exception;
                exception.printStackTrace();
                throw new IOException((Throwable)serializable);
            }
        }
        this.writeText((File)serializable, this.b);
    }

    public void writeText(File object, List<SrtRecord> object2) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8"));
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (SrtRecord)object.next();
                bufferedWriter.write(((SrtRecord)object2).toTextString());
            }
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                iOException.printStackTrace();
                throw object;
            }
            catch (Throwable throwable) {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                throw throwable;
            }
        }
        bufferedWriter.close();
        return;
    }

    @Override
    public int compareTo(SrtFile srtFile) {
        return this.getFileName().compareTo(srtFile.getFileName());
    }

    public void onlyClear(List<SrtRecord> list) throws IOException {
        for (SrtRecord srtRecord : list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list2 = srtRecord.getTexts();
            for (int i = 0; i < list2.size(); ++i) {
                String string = list2.get(i);
                if ((string = SrtFile.a(string)).length() <= 1) continue;
                arrayList.add(string);
            }
            srtRecord.setTexts(arrayList);
            if (srtRecord.getTexts().size() != 0) continue;
            list.remove(srtRecord);
        }
    }

    public void clear(List<SrtRecord> object) throws IOException {
        object = object.iterator();
        while (object.hasNext()) {
            SrtRecord srtRecord = (SrtRecord)object.next();
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = srtRecord.getTexts();
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                if ((string = SrtFile.a(string)).length() <= 1) continue;
                arrayList.add(string);
            }
            srtRecord.setTexts(arrayList);
        }
        this.write();
    }

    private static String a(String string) {
        string = string.replaceAll("\\{[^}]*\\}", "");
        string = string.replaceAll("\\[[^]]*\\]", "");
        return string;
    }

    static {
        d.addExtension(EXTENSION);
    }
}

