/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.text.srt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeng.file.FileUtil;
import org.zeng.text.SsaFile;
import org.zeng.text.srt.SrtFile;
import org.zeng.text.srt.SrtRecord;
import org.zeng.time.Timeline;
import org.zeng.util.StringUtil;

public class SrtFileUtil {
    private static final Logger a = LoggerFactory.getLogger(SrtFileUtil.class);

    public static void merge(SrtFile srtFile, SrtFile srtFile2) throws Exception {
        SrtFileUtil.merge(srtFile, srtFile2, true);
    }

    public static void merges(String string, String[] stringArray) throws Exception {
        SrtFileUtil.merges(new File(string), stringArray);
    }

    public static void merges(File fileArray, String[] stringArray) throws Exception {
        int n;
        Object object;
        if (!fileArray.isDirectory()) {
            return;
        }
        File[] fileArray2 = fileArray.listFiles();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (fileArray2 == null) {
            a.info("path=" + fileArray.getAbsolutePath());
            return;
        }
        fileArray = fileArray2;
        int n2 = fileArray2.length;
        for (int i = 0; i < n2; ++i) {
            object = fileArray[i];
            if (((File)object).isDirectory()) {
                SrtFileUtil.merges((File)object, stringArray);
                continue;
            }
            String[] stringArray2 = stringArray;
            n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                Object object2 = stringArray2[j];
                if (!((File)object).getName().endsWith((String)object2)) continue;
                object2 = new SrtFile((File)object);
                arrayList.add(object2);
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        Collections.sort(arrayList);
        int n3 = 0;
        SrtFile srtFile = (SrtFile)arrayList.get(0);
        while (n3 < arrayList.size()) {
            String string = "";
            object = srtFile.getFileName();
            int n4 = -1;
            n = 0;
            if (((String)object).endsWith(stringArray[0])) {
                n4 = ((String)object).lastIndexOf(stringArray[0]);
                n = 1;
            } else if (((String)object).endsWith(stringArray[1])) {
                n4 = ((String)object).lastIndexOf(stringArray[1]);
            }
            if (n4 != -1) {
                string = ((String)object).substring(0, n4);
            }
            if (++n3 == arrayList.size()) break;
            SrtFile srtFile2 = (SrtFile)arrayList.get(n3);
            if (srtFile2.getFileName().startsWith(string)) {
                if (n != 0) {
                    SrtFileUtil.merge(srtFile, srtFile2);
                } else {
                    SrtFileUtil.merge(srtFile2, srtFile);
                }
            }
            srtFile = (SrtFile)arrayList.get(n3);
        }
    }

    public static boolean isSrtFile(File file) {
        return file.getName().endsWith(".srt");
    }

    public static void merge(SrtFile object, SrtFile object2, boolean bl) throws Exception {
        List<SrtRecord> list = ((SrtFile)object).getRecords();
        List<SrtRecord> list2 = ((SrtFile)object2).getRecords();
        if (list.size() == 0) {
            ((SrtFile)object).read();
        }
        if (list2.size() == 0) {
            ((SrtFile)object2).read();
        }
        String string = ((SrtFile)object).getPath();
        object = ((SrtFile)object).getFileName();
        int n = ((String)object).lastIndexOf(".");
        object = ((String)object).substring(0, n);
        object2 = ((SrtFile)object2).getFileName();
        n = ((String)object2).lastIndexOf(".");
        n = ((String)object2).substring(0, n).lastIndexOf(".");
        object = (String)object + "-" + ((String)object2).substring(++n);
        if (((File)(object = new File(string, (String)object))).exists()) {
            return;
        }
        object = SrtFileUtil.a(list, list2, (File)object, bl);
        ((SrtFile)object).formatNo();
        ((SrtFile)object).write();
    }

    private static SrtFile a(List<SrtRecord> list, List<SrtRecord> list2, File file, boolean bl) {
        Comparable<SrtFile> comparable;
        Comparable<Timeline> comparable2;
        SrtRecord srtRecord;
        SrtRecord srtRecord2;
        SrtRecord srtRecord3;
        SrtRecord srtRecord4;
        int n = 0;
        int n2 = 0;
        ArrayList<SrtRecord> arrayList = new ArrayList<SrtRecord>();
        ArrayList<SrtRecord> arrayList2 = new ArrayList<SrtRecord>();
        while (n < list.size() && n2 < list2.size()) {
            srtRecord4 = list.get(n);
            srtRecord3 = list2.get(n2);
            srtRecord2 = new SrtRecord();
            srtRecord = new SrtRecord();
            if (SrtFileUtil.isCoincide(srtRecord4, srtRecord3)) {
                comparable2 = srtRecord4.getTimeline();
                comparable = srtRecord3.getTimeline();
                Date date = ((Timeline)comparable2).getStartTime().before(((Timeline)comparable).getStartTime()) ? ((Timeline)comparable2).getStartTime() : ((Timeline)comparable).getStartTime();
                comparable = ((Timeline)comparable2).getEndTime().after(((Timeline)comparable).getEndTime()) ? ((Timeline)comparable2).getEndTime() : ((Timeline)comparable).getEndTime();
                comparable2 = new Timeline(date, (Date)comparable);
                srtRecord2.setTimeline((Timeline)comparable2);
                srtRecord.setTimeline((Timeline)comparable2);
                srtRecord2.getTexts().addAll(srtRecord4.getTexts());
                srtRecord.getTexts().addAll(srtRecord3.getTexts());
                ++n;
                ++n2;
            } else {
                comparable = srtRecord3;
                comparable2 = srtRecord4;
                boolean bl2 = false;
                comparable2 = ((SrtRecord)comparable2).getTimeline();
                comparable = ((SrtRecord)comparable).getTimeline();
                if (((Timeline)comparable2).getStartTime().before(((Timeline)comparable).getStartTime())) {
                    bl2 = true;
                }
                if (bl2) {
                    comparable2 = srtRecord4.getTimeline();
                    srtRecord2.getTexts().addAll(srtRecord4.getTexts());
                    ++n;
                } else {
                    comparable2 = srtRecord3.getTimeline();
                    srtRecord.getTexts().addAll(srtRecord3.getTexts());
                    ++n2;
                }
                srtRecord2.setTimeline((Timeline)comparable2);
                srtRecord.setTimeline((Timeline)comparable2);
            }
            arrayList.add(srtRecord2);
            arrayList2.add(srtRecord);
        }
        while (n2 < list2.size()) {
            srtRecord3 = list2.get(n2++);
            comparable2 = srtRecord3.getTimeline();
            srtRecord2 = new SrtRecord();
            srtRecord = new SrtRecord();
            srtRecord2.setTimeline((Timeline)comparable2);
            srtRecord.setTimeline((Timeline)comparable2);
            srtRecord.getTexts().addAll(srtRecord3.getTexts());
            arrayList.add(srtRecord2);
            arrayList2.add(srtRecord);
        }
        while (n < list.size()) {
            srtRecord4 = list.get(n++);
            comparable2 = srtRecord4.getTimeline();
            srtRecord2 = new SrtRecord();
            srtRecord = new SrtRecord();
            srtRecord2.setTimeline((Timeline)comparable2);
            srtRecord.setTimeline((Timeline)comparable2);
            srtRecord2.getTexts().addAll(srtRecord4.getTexts());
            arrayList.add(srtRecord2);
            arrayList2.add(srtRecord);
        }
        comparable2 = new SrtFile(file);
        comparable = new SrtFile(file);
        SrtFile srtFile = new SrtFile(file);
        ((SrtFile)comparable).setRecords(arrayList);
        srtFile.setRecords(arrayList2);
        ((SrtFile)comparable).formatTimeline();
        srtFile.formatTimeline();
        for (n = 0; n < arrayList2.size(); ++n) {
            comparable = new SrtRecord();
            ((SrtRecord)comparable).setTimeline(((SrtRecord)arrayList2.get(n)).getTimeline());
            if (bl) {
                ((SrtRecord)comparable).getTexts().add(SrtFileUtil.a((SrtRecord)arrayList2.get(n)));
                ((SrtRecord)comparable).getTexts().addAll(((SrtRecord)arrayList.get(n)).getTexts());
            } else {
                ((SrtRecord)comparable).getTexts().addAll(((SrtRecord)arrayList.get(n)).getTexts());
                ((SrtRecord)comparable).getTexts().add(SrtFileUtil.a((SrtRecord)arrayList2.get(n)));
            }
            ((SrtFile)comparable2).getRecords().add((SrtRecord)comparable);
        }
        a.info("***************** " + ((SrtFile)comparable2).getFileName());
        return comparable2;
    }

    private static String a(SrtRecord iterator) {
        StringBuilder stringBuilder = new StringBuilder();
        iterator = ((SrtRecord)((Object)iterator)).getTexts();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append(string).append(" ");
        }
        return stringBuilder.toString();
    }

    public static boolean isCoincide(SrtRecord comparable, SrtRecord comparable2) {
        double d;
        double d2 = 0.5;
        boolean bl = false;
        comparable = ((SrtRecord)comparable).getTimeline();
        comparable2 = ((SrtRecord)comparable2).getTimeline();
        Date date = ((Timeline)comparable).getStartTime().after(((Timeline)comparable2).getStartTime()) ? ((Timeline)comparable).getStartTime() : ((Timeline)comparable2).getStartTime();
        Date date2 = ((Timeline)comparable).getEndTime().before(((Timeline)comparable2).getEndTime()) ? ((Timeline)comparable).getEndTime() : ((Timeline)comparable2).getEndTime();
        long l = ((Timeline)comparable).getEndTime().getTime() - ((Timeline)comparable).getStartTime().getTime();
        long l2 = ((Timeline)comparable2).getEndTime().getTime() - ((Timeline)comparable2).getStartTime().getTime();
        long l3 = date2.getTime() - date.getTime();
        double d3 = (double)l3 / (double)l;
        if (Math.max(d3, d = (double)l3 / (double)l2) > 0.5) {
            bl = true;
        }
        return bl;
    }

    protected static SrtFile readSsaFile(File object, String stringArray) throws IOException, ParseException {
        if (stringArray == null) {
            stringArray = FileUtil.getFileCode((File)object);
        }
        Object object2 = ((File)object).getName();
        int n = ((String)object2).lastIndexOf(".");
        if (((File)object).isDirectory() || !SsaFile.getFilter().accept((File)object)) {
            throw new IllegalArgumentException("Not ssa file!");
        }
        object2 = ((String)object2).substring(0, n) + ".srt";
        object2 = new File(((File)object).getParentFile(), (String)object2);
        object2 = new SrtFile((File)object2);
        List<SrtRecord> list = ((SrtFile)object2).getRecords();
        object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object), (String)stringArray));
        try {
            while ((stringArray = ((BufferedReader)object).readLine()) != null) {
                String[] stringArray2;
                if (!stringArray.startsWith("Dialogue:")) continue;
                SrtRecord srtRecord = new SrtRecord();
                Object object3 = stringArray.split(",");
                object3 = Timeline.parse(object3[1].replace('.', ',') + "0 --> " + object3[2].replace('.', ',') + "0", " --> ");
                srtRecord.setTimeline((Timeline)object3);
                for (int i = 0; i < 9; ++i) {
                    stringArray = stringArray.substring(stringArray.indexOf(",") + 1);
                }
                stringArray = StringUtil.remove((String)stringArray);
                stringArray = stringArray2 = stringArray.split("\\\\N");
                int n2 = stringArray2.length;
                for (int i = 0; i < n2; ++i) {
                    String string = stringArray[i];
                    srtRecord.addText(string);
                }
                list.add(srtRecord);
            }
        }
        catch (ParseException parseException) {
            ParseException parseException2 = parseException;
            throw parseException;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        finally {
            ((BufferedReader)object).close();
        }
        return object2;
    }

    protected static SrtFile readSSaFile(File file) throws IOException, ParseException {
        String string = FileUtil.getFileCode(file);
        return SrtFileUtil.readSsaFile(file, string);
    }

    public static void ssaToSrt(File file) throws IOException, ParseException {
        SrtFileUtil.ssaToSrts(file, null);
    }

    public static void ssaToSrts(File fileArray, String string) throws IOException, ParseException {
        if (fileArray.isDirectory()) {
            File[] fileArray2 = fileArray.listFiles(SsaFile.getFilter());
            fileArray = fileArray2;
            fileArray = fileArray2;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                if (file.isDirectory()) continue;
                SrtFileUtil.a(file, string);
            }
            return;
        }
        SrtFileUtil.a((File)fileArray, string);
    }

    private static void a(File comparable, String string) throws IOException, ParseException {
        comparable = SrtFileUtil.readSsaFile((File)comparable, string);
        ((SrtFile)comparable).formatNo();
        ((SrtFile)comparable).write();
    }

    public static void separates(File fileArray) throws Exception {
        if (fileArray.isDirectory()) {
            File[] fileArray2 = fileArray.listFiles();
            fileArray = fileArray2;
            fileArray = fileArray2;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                if (file.isDirectory()) {
                    SrtFileUtil.separates(file);
                    continue;
                }
                SrtFileUtil.a(file);
            }
            return;
        }
        SrtFileUtil.a((File)fileArray);
    }

    private static void a(File comparable) throws Exception {
        if (((File)comparable).getName().endsWith(".srt")) {
            comparable = new SrtFile((File)comparable);
            ((SrtFile)comparable).read();
            ((SrtFile)comparable).separate();
        }
    }

    public static File toText(SrtFile srtFile) throws IOException {
        srtFile.getFileName();
        Object object = StringUtil.replaceSubfix(srtFile.getFileName(), ".srt", ".txt");
        object = new File(srtFile.getPath(), (String)object);
        srtFile.writeText((File)object);
        return object;
    }

    public static void clears(File fileArray) throws Exception {
        if (fileArray.isDirectory()) {
            File[] fileArray2 = fileArray.listFiles();
            fileArray = fileArray2;
            fileArray = fileArray2;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                if (file.isDirectory()) {
                    SrtFileUtil.clears(file);
                    continue;
                }
                SrtFileUtil.clear(file);
            }
            return;
        }
        SrtFileUtil.clear((File)fileArray);
    }

    public static void clear(File comparable) throws Exception {
        if (((File)comparable).getName().endsWith(".srt")) {
            comparable = new SrtFile((File)comparable);
            ((SrtFile)comparable).read();
            ((SrtFile)comparable).clear(((SrtFile)comparable).getRecords());
        }
    }
}

