/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY = 3;
    public static final int HOUR = 4;
    public static final int MINUTE = 5;
    public static final int SECOND = 6;
    public static final int MILLISECOND = 7;
    public static final int YEAR_MONTH_DAY = 8;
    public static final int DAY_MONTH_YEAR = 9;
    private static final int[] a = new int[]{1, 2, 5, 11, 12, 13, 14};

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar truncDate(Date date) {
        return DateUtil.truncDate(date, 3);
    }

    public static Calendar truncDate(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        for (int i = n; i < a.length; ++i) {
            calendar.set(a[i], 0);
        }
        return calendar;
    }

    public static Calendar rollDate(Date date, int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(n, n2);
        return calendar;
    }

    public static boolean compareDate(Date date, Date comparable, int n, int n2) {
        Date date2;
        if (date.before((Date)comparable)) {
            date2 = date;
            date = comparable;
        } else {
            date2 = comparable;
        }
        comparable = DateUtil.rollDate(date2, n, n2);
        n = 0;
        if (((Calendar)comparable).getTime().compareTo(date) >= 0) {
            n = 1;
        }
        return n != 0;
    }

    public static Date parseDate(String string) {
        return DateUtil.parseDate(string, "yyyy-MM-dd");
    }

    public static Date parseDateTime(String string) {
        return DateUtil.parseDate(string, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseDate(String string, String object) {
        Date date = null;
        object = new SimpleDateFormat((String)object);
        try {
            date = ((DateFormat)object).parse(string);
        }
        catch (ParseException parseException) {}
        return date;
    }

    public static boolean isDate(String string) {
        return DateUtil.isDate(string, 8);
    }

    public static boolean isDate(String string, int n) {
        String string2;
        if (n == 8) {
            string2 = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1][0-9])|([2][0-3]))\\:([0-5]?[0-9])((\\s)?|(\\:([0-5]?[0-9])))))?$";
        } else if (n == 9) {
            string2 = "^((((((0?[1-9])|([1-2][0-9])|(3[01]))[\\-\\/\\s]?((0?[13578])|(1[02])))|(((0?[1-9])|([1-2][0-9])|(30))[\\-\\/\\s]?((0?[469])|(11)))|(((0?[1-9])|([1-2][0-9]))[\\-\\/\\s]?0?2))[\\-\\/\\s]?\\d{2}(([02468][048])|([13579][26])))|(((((0?[1-9])|([1-2][0-9])|(3[01]))[\\-\\/\\s]?((0?[13578])|(1[02])))|(((0?[1-9])|([1-2][0-9])|(30))[\\-\\/\\s]?((0?[469])|(11)))|(((0?[1-9])|(1[0-9])|(2[0-8]))[\\-\\/\\s]?0?2))[\\-\\/\\s]?\\d{2}(([02468][1235679])|([13579][01345789]))))(\\s(((0?[0-9])|([1][0-9])|([2][0-3]))\\:([0-5]?[0-9])((\\s)?|(\\:([0-5]?[0-9])))))?$";
        } else {
            throw new IllegalArgumentException("date type error!");
        }
        return string.matches(string2);
    }

    public static boolean isTime(String string) {
        String string2 = "((((0?[0-9])|([1][0-9])|([2][0-3]))\\:([0-5]?[0-9])((\\s)?|(\\:([0-5]?[0-9])))))?";
        return string.matches(string2);
    }

    public static int getWeek(Date comparable) {
        comparable = DateUtil.toCalendar(comparable);
        int n = ((Calendar)comparable).get(7);
        return n;
    }

    public static int getHour(Date comparable) {
        comparable = DateUtil.toCalendar(comparable);
        int n = ((Calendar)comparable).get(11);
        return n;
    }

    public static DateFormat createDateFormat(String string) {
        return new SimpleDateFormat(string);
    }

    public static DateFormat createDateFormat(String string, Locale locale) {
        return new SimpleDateFormat(string, locale);
    }
}

