/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.gui.table;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.zeng.util.StringUtil;

public abstract class ListTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = 5516563556793613845L;
    protected List<T> list = null;

    public ListTableModel() {
        this.list = new ArrayList<T>();
    }

    public ListTableModel(List<T> list) {
        if (list == null) {
            this.list = new ArrayList<T>();
            return;
        }
        this.list = list;
    }

    public abstract String[] getColumnNames();

    public abstract double[] getColumnSizeRate();

    public abstract String[] getFieldNames();

    @Override
    public int getRowCount() {
        int n = 0;
        if (this.list != null) {
            n = this.list.size();
        }
        return n;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (this.list.size() > 0) {
            T t = this.list.get(n);
            if (t != null && n2 >= 0 && n2 < this.getFieldNames().length) {
                try {
                    Object object2 = this.getFieldNames()[n2];
                    object2 = t.getClass().getDeclaredField((String)object2);
                    ((Field)object2).setAccessible(true);
                    object = ((Field)object2).get(t);
                    if (object instanceof Date) {
                        object = StringUtil.formatDateTime((Date)((Date)object));
                    }
                }
                catch (SecurityException securityException) {
                    SecurityException securityException2 = securityException;
                    securityException.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    IllegalAccessException illegalAccessException2 = illegalAccessException;
                    illegalAccessException.printStackTrace();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                }
            } else {
                object = t;
            }
        }
        return object;
    }

    public T getObject(int n) {
        return this.list.get(n);
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnNames()[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Object object;
        Class clazz = Object.class;
        if (n >= 0 && n < this.getColumnCount() && (object = this.getValueAt(0, n)) != null) {
            clazz = object.getClass();
        }
        return clazz;
    }

    public void clear() {
        this.list.clear();
        this.fireTableDataChanged();
    }

    public void addRow(T t) {
        if (!this.list.contains(t)) {
            this.list.add(t);
            this.fireTableDataChanged();
        }
    }

    public void deleteRows(List<T> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            this.list.remove(e2);
        }
        this.fireTableDataChanged();
    }

    public void flush(List<T> list) {
        if (this.list != list) {
            this.list.clear();
            this.list.addAll(list);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        T t = this.list.get(n);
        if (t != null && n2 >= 0 && n2 < this.getFieldNames().length) {
            try {
                Object object2 = this.getFieldNames()[n2];
                object2 = t.getClass().getDeclaredField((String)object2);
                ((Field)object2).setAccessible(true);
                ((Field)object2).set(t, object);
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                noSuchFieldException.printStackTrace();
                return;
            }
            catch (SecurityException securityException) {
                SecurityException securityException2 = securityException;
                securityException.printStackTrace();
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                illegalArgumentException.printStackTrace();
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                illegalAccessException.printStackTrace();
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }

    public List<T> getList() {
        return Collections.unmodifiableList(this.list);
    }
}

