/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public final class SwingUtils {
    private static Set<String> a = new HashSet<String>();

    private SwingUtils() {
        throw new Error("SwingUtils is just a container for static methods");
    }

    public static <T extends JComponent> List<T> getDescendantsOfType(Class<T> clazz, Container container) {
        return SwingUtils.getDescendantsOfType(clazz, container, true);
    }

    public static <T extends JComponent> List<T> getDescendantsOfType(Class<T> clazz, Container componentArray, boolean bl) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Component component : componentArray.getComponents()) {
            if (clazz.isAssignableFrom(component.getClass())) {
                arrayList.add(clazz.cast(component));
            }
            if (!bl && clazz.isAssignableFrom(component.getClass())) continue;
            arrayList.addAll(SwingUtils.getDescendantsOfType(clazz, (Container)component, bl));
        }
        return arrayList;
    }

    public static <T extends JComponent> T getDescendantOfType(Class<T> clazz, Container container, String string, Object object) throws IllegalArgumentException {
        return SwingUtils.getDescendantOfType(clazz, container, string, object, true);
    }

    public static <T extends JComponent> T getDescendantOfType(Class<T> clazz, Container object, String string, Object object2, boolean bl) throws IllegalArgumentException {
        object = SwingUtils.getDescendantsOfType(clazz, (Container)object, bl);
        return SwingUtils.a(clazz, object, string, object2);
    }

    public static <T extends JComponent> List<T> getDescendantsOfClass(Class<T> clazz, Container container) {
        return SwingUtils.getDescendantsOfClass(clazz, container, true);
    }

    public static <T extends JComponent> List<T> getDescendantsOfClass(Class<T> clazz, Container componentArray, boolean bl) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Component component : componentArray.getComponents()) {
            if (clazz.equals(component.getClass())) {
                arrayList.add(clazz.cast(component));
            }
            if (!bl && clazz.equals(component.getClass())) continue;
            arrayList.addAll(SwingUtils.getDescendantsOfClass(clazz, (Container)component, bl));
        }
        return arrayList;
    }

    public static <T extends JComponent> T getDescendantOfClass(Class<T> clazz, Container container, String string, Object object) throws IllegalArgumentException {
        return SwingUtils.getDescendantOfClass(clazz, container, string, object, true);
    }

    public static <T extends JComponent> T getDescendantOfClass(Class<T> clazz, Container object, String string, Object object2, boolean bl) throws IllegalArgumentException {
        object = SwingUtils.getDescendantsOfClass(clazz, (Container)object, bl);
        return SwingUtils.a(clazz, object, string, object2);
    }

    private static <T extends JComponent> T a(Class<T> clazz, List<T> object, String string, Object object2) throws IllegalArgumentException {
        Method method;
        try {
            method = clazz.getMethod("get" + string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = clazz.getMethod("is" + string, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new IllegalArgumentException("Property " + string + " not found in class " + clazz.getName());
            }
        }
        try {
            object = object.iterator();
            while (object.hasNext()) {
                JComponent jComponent = (JComponent)object.next();
                Object object3 = method.invoke((Object)jComponent, new Object[0]);
                if (!SwingUtils.equals(object2, object3)) continue;
                return (T)jComponent;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("Error accessing property " + string + " in class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Property " + string + " cannot be accessed in class " + clazz.getName());
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException("Property " + string + " cannot be accessed in class " + clazz.getName());
        }
        return null;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static Map<JComponent, List<JComponent>> getComponentMap(JComponent jComponent, boolean bl) {
        HashMap<JComponent, List<JComponent>> hashMap = new HashMap<JComponent, List<JComponent>>();
        for (JComponent jComponent2 : SwingUtils.getDescendantsOfType(JComponent.class, jComponent, false)) {
            if (!hashMap.containsKey(jComponent)) {
                hashMap.put(jComponent, new ArrayList());
            }
            hashMap.get(jComponent).add(jComponent2);
            if (!bl) continue;
            hashMap.putAll(SwingUtils.getComponentMap(jComponent2, bl));
        }
        return hashMap;
    }

    public static UIDefaults getUIDefaultsOfClass(Class object) {
        object = ((Class)object).getName();
        object = ((String)object).substring(((String)object).lastIndexOf(".") + 2);
        return SwingUtils.getUIDefaultsOfClass((String)object);
    }

    public static UIDefaults getUIDefaultsOfClass(String string) {
        UIDefaults uIDefaults = new UIDefaults();
        UIDefaults uIDefaults2 = UIManager.getLookAndFeelDefaults();
        Object object = Collections.list(uIDefaults2.keys());
        object = object.iterator();
        while (object.hasNext()) {
            String string2;
            Object e2 = object.next();
            if (!(e2 instanceof String) || !((String)e2).startsWith(string)) continue;
            String string3 = string2 = (String)e2;
            if (string2.contains(".")) {
                string3 = string2.substring(string2.indexOf(".") + 1);
            }
            uIDefaults.put(string3, uIDefaults2.get(e2));
        }
        return uIDefaults;
    }

    public static Object getUIDefaultOfClass(Class serializable, String string) {
        Object object = null;
        serializable = SwingUtils.getUIDefaultsOfClass((Class)serializable);
        Object object2 = Collections.list(((Hashtable)serializable).keys());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object e2 = object2.next();
            if (e2.equals(string)) {
                return ((UIDefaults)serializable).get(e2);
            }
            if (!e2.toString().equalsIgnoreCase(string)) continue;
            object = ((UIDefaults)serializable).get(e2);
        }
        return object;
    }

    public static Map<Object, Object> getProperties(JComponent jComponent) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Object object = jComponent.getClass();
        object = ((Class)object).getMethods();
        Method[] methodArray = object;
        int n = ((Method[])object).length;
        for (int j = 0; j < n; ++j) {
            object = methodArray[j];
            if (!((Method)object).getName().matches("^(is|get).*") || ((Method)object).getParameterTypes().length != 0) continue;
            try {
                Object object2 = ((Method)object).getReturnType();
                if (object2 == Void.TYPE || ((Class)object2).getName().startsWith("[") || a.contains(((Method)object).getName())) continue;
                object2 = ((Method)object).getName();
                if ((object = ((Method)object).invoke((Object)jComponent, new Object[0])) == null || object instanceof Component) continue;
                hashMap.put(object2, object);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return hashMap;
    }

    public static <T extends JComponent> Class getJClass(T object) {
        object = object.getClass();
        while (!((Class)object).getName().matches("javax.swing.J[^.]*$")) {
            object = ((Class)object).getSuperclass();
        }
        return object;
    }

    static {
        a.add("getFocusCycleRootAncestor");
        a.add("getAccessibleContext");
        a.add("getColorModel");
        a.add("getGraphics");
        a.add("getGraphicsConfiguration");
    }
}

