/*
 * Decompiled with CFR 0.152.
 */
package org.zeng.wp.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.zeng.util.DateUtil;
import org.zeng.util.StringUtil;

public class User
implements Serializable {
    private static final long serialVersionUID = 1745044605522515993L;
    private String username = "";
    private String password = "";
    private boolean isActive = true;
    private boolean isUsing = true;
    private boolean isAnonymous = false;
    private boolean haveSignature = false;
    private int post = 0;
    private int postSum = 0;
    private int reply = 0;
    private int replySum = 0;
    private Date createDate = new Date();
    private Date signinTime = null;
    private int integral = 0;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    public boolean isUsing() {
        return this.isUsing;
    }

    public void setUsing(boolean bl) {
        this.isUsing = bl;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public void setAnonymous(boolean bl) {
        this.isAnonymous = bl;
    }

    public boolean isHaveSignature() {
        return this.haveSignature;
    }

    public void setHaveSignature(boolean bl) {
        this.haveSignature = bl;
    }

    public int getPost() {
        return this.post;
    }

    public void setPost(int n2) {
        this.post = n2;
    }

    public int getPostSum() {
        return this.postSum;
    }

    public void setPostSum(int n2) {
        this.postSum = n2;
    }

    public int getReply() {
        return this.reply;
    }

    public void setReply(int n2) {
        this.reply = n2;
    }

    public int getReplySum() {
        return this.replySum;
    }

    public void setReplySum(int n2) {
        this.replySum = n2;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date date) {
        this.createDate = date;
    }

    public Date getSigninTime() {
        return this.signinTime;
    }

    public void setSigninTime(Date date) {
        this.signinTime = date;
    }

    public int getIntegral() {
        return this.integral;
    }

    public void setIntegral(int n2) {
        this.integral = n2;
    }

    public int hashCode() {
        int n2 = 31 + (this.username == null ? 0 : this.username.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (User)object;
        return !(this.username == null ? ((User)object).username != null : !this.username.equals(((User)object).username));
    }

    public String toString() {
        return "User [username=" + this.username + ", password=" + this.password + ", isActive=" + this.isActive + ", isUsing=" + this.isUsing + ", isAnonymous=" + this.isAnonymous + ", haveSignature=" + this.haveSignature + ", post=" + this.post + ", postSum=" + this.postSum + ", reply=" + this.reply + ", replySum=" + this.replySum + ", createDate=" + StringUtil.formatDateTime((Date)this.createDate) + ", signinTime=" + StringUtil.formatDateTime((Date)this.signinTime) + "]";
    }

    public boolean check() {
        boolean bl = StringUtil.isNotNull((String)this.username);
        bl = bl || StringUtil.isNotNull((String)this.password);
        return bl;
    }

    public boolean isSignined() {
        Date date = new Date();
        date = DateUtil.truncDate((Date)date).getTime();
        boolean bl = this.signinTime != null;
        bl = bl && this.signinTime.after(date);
        return bl;
    }

    public void addReplyTimes() {
        ++this.reply;
        ++this.replySum;
    }

    public void addPostTimes() {
        ++this.post;
        ++this.postSum;
    }

    public static List<User> getActiveUsers(List<User> object) {
        ArrayList<User> arrayList = new ArrayList<User>();
        object = object.iterator();
        while (object.hasNext()) {
            User user = (User)object.next();
            if (!user.isActive || !user.isUsing) continue;
            arrayList.add(user);
        }
        return arrayList;
    }
}

