--------------------------------------------------------------------------------
-- Utilitaire pour gestion de code postaux dans un formulaire d'une application
-- Une table CP  doit être créée(champs CP et City)
-- Utilise la librairie LUA nsbaseutils V1.2 mini
-- Exemple utilisation:
--  function MyForm:ActionOnLoad()
--    CPLib:set("edtCP","edtVille")
--  end
--------------------------------------------------------------------------------
-- Version 1.0
-- Author  Jean-Luc NEUTS
--------------------------------------------------------------------------------

CPLib={}
CPLib.__index = CPLib
CPLib.cpt=1
CPLib.items={}

--------------------------------------------------------------------------------
-- Fonction publique pour initialiser le formulaire
--------------------------------------------------------------------------------
function CPLib:set(edtCP,edtCity)
  if windowControlExist==nil then
    error("lib nsbaseutils >=1.2 not installed")
  end
  if not appObjectExist("CP") then
    error("Table CP not created")
  end
  if not windowControlExist(edtCP) then
    error("Control "..edtCP.." not exists")
  end
  if not windowControlExist(edtCity) then
    error("Control "..edtCP.." not exists")
  end
  local parent=getWindowControl(edtCP).parent
  local item={}
  item.edtCP=edtCP
  item.edtCity=edtCity
  item.listBox='ListBoxForLibCP' .. self.cpt
  item.frm=nsbase.window.active
  item.frm.setProperty(item.edtCP..'.ActionOnKeypressed',"CPLib:edtCPActionOnKeypressed("..self.cpt..",'key')")
  item.frm.setProperty(item.edtCity..'.ActionOnKeypressed',"CPLib:edtCityActionOnKeypressed("..self.cpt..",'key')")
  item.frm.createControl('ListBox',parent,item.listBox,0,0,400,100)
  item.frm.setProperty(item.listBox..'.Visible',0)
  item.frm.setProperty(item.listBox..'.ActionOnDblClick',"CPLib:ListBoxActionOnDblClick("..self.cpt..")")
  item.frm.setProperty(item.listBox..'.ActionOnKeypressed',"CPLib:LisBoxActionOnKeypressed("..self.cpt..",'key')")
  item.frm.setProperty(item.listBox..'.ActionOnFocus',"CPLib:LisBoxActionOnFocus("..self.cpt..")")
  item.frm.setProperty(item.listBox..'.ActionOnBlur',"CPLib:LisBoxActionOnBlur("..self.cpt..")")
  self.items[self.cpt]=item
  self.cpt=self.cpt+1
end

function CPLib:edtCPActionOnKeypressed(ix,key)
  local item=self.items[ix]
  if key=='#27' then
    item.frm.setProperty(item.listBox..'.Visible',0)
    return
  end
  if string.sub(key,0,1)=="#" then
    key=""
  end
  local s=item.frm.getProperty(item.edtCP..'.Text')..key
  if string.len(s)>2 then
    local ds=nsbase.datasetCreate("SQLQuery")
    ds.SQL="select CP,CITY from CP where CP like '"..s.. "%'"
    item.frm.setProperty(item.listBox..'.Items',ds.getItems())
    item.frm.setProperty(item.listBox..'.Top',item.frm.getProperty(item.edtCP..'.Top')+item.frm.getProperty(item.edtCP..'.Height'))
    item.frm.setProperty(item.listBox..'.Left',item.frm.getProperty(item.edtCP..'.Left'))
    item.frm.setProperty(item.listBox..'.Visible',1)
    item.frm.setProperty(item.listBox..'.TabOrder',item.frm.getProperty(item.edtCP..'.TabOrder')+1)
    item.focus=item.edtCP
    item.i1=0
    item.i2=1
    self.items[ix]=item
  end
end

function CPLib:edtCityActionOnKeypressed(ix,key)
  local item=self.items[ix]
  if key=='#27' then
    item.frm.setProperty(item.listBox..'.Visible',0)
    return
  end
  if string.sub(key,0,1)=="#" then
    key=""
  end
  local s=item.frm.getProperty(item.edtCity..'.Text')..key
  if string.len(s)>1 then
    local ds=nsbase.datasetCreate("SQLQuery")
    ds.SQL="select CITY,CP  from CP where CITY like '"..s.. "%'"
    item.frm.setProperty(item.listBox..'.Items',ds.getItems())
    item.frm.setProperty(item.listBox..'.Top',item.frm.getProperty(item.edtCity..'.Top')+item.frm.getProperty(item.edtCity..'.Height'))
    item.frm.setProperty(item.listBox..'.Left',item.frm.getProperty(item.edtCity..'.Left'))
    item.frm.setProperty(item.listBox..'.Visible',1)
    item.frm.setProperty(item.listBox..'.TabOrder',item.frm.getProperty(item.edtCity..'.TabOrder')+1)
    item.focus=item.edtCity
    item.i1=1
    item.i2=0
    self.items[ix]=item
  end
end

function CPLib:ListBoxActionOnDblClick(ix)
  local item=self.items[ix]
  item.frm.setProperty(item.listBox..'.ColumnsLinkIndex',item.i1)
  item.frm.setProperty(item.edtCP..'.Text',item.frm.getProperty(item.listBox..'.ColumnsLinkValue'))
  item.frm.setProperty(item.listBox..'.ColumnsLinkIndex',item.i2)
  item.frm.setProperty(item.edtCity..'.Text',item.frm.getProperty(item.listBox..'.ColumnsLinkValue'))
  item.frm.setProperty(item.listBox..'.Visible',0)
  item.frm.setFocus(item.focus)
end

function CPLib:LisBoxActionOnKeypressed(ix,key)
  if key=='#13' then
     CPLib:ListBoxActionOnDblClick(ix)
  elseif key=='#27' then
    local item=self.items[ix]
    item.frm.setProperty(item.listBox..'.Visible',0)
  end
end

function CPLib:LisBoxActionOnFocus(ix)
  local item=self.items[ix]
  if item.frm.getProperty(item.listBox..'.Items')~="" then
    item.frm.setProperty(item.listBox..'.ItemIndex',0)
  end
end

function CPLib:LisBoxActionOnBlur(ix)
  local item=self.items[ix]
  item.frm.setProperty(item.listBox..'.ItemIndex',-1)
end
