--------------------------------------------------------------------------------
-- NSBase lists functions used for wizard  lists and other
-- Use nsbaseutils>=V1.3
--------------------------------------------------------------------------------
-- Version 1.2
-- Author  Jean-Luc NEUTS
--------------------------------------------------------------------------------


--------------------------------------------------------------------------------
-- This function load a list into a list type component
-- from the data of a field in a table
--------------------------------------------------------------------------------
function loadListComponentFromTable(form, tableName, componentName, fieldName)
  if not appObjectExist(tableName) then
    error("Object [" .. tableName .. "]  not found")
  end
  if getAppObject(tableName).type~="TABLE" then
    error("The tableName [" .. tableName .. "]  is not a table")
  end
  local formName=getFormName(form)
  local dataset=nsbase.datasetCreate("SQLQuery")
  dataset.sql="select distinct " .. fieldName .. " from " .. tableName .. " order by 1"
  nsbase.window.setProperty(formName .. "." .. componentName .. ".items",dataset.getItems(fieldName))
end

--------------------------------------------------------------------------------
-- This function load a list into a list type componentName
-- from the data of a form source field for the field itself
--------------------------------------------------------------------------------
function loadAutoListComponent(form, componentName)
  local formName=getFormName(form)
  local datasource=nsbase.window.getProperty(formName .. ".datasource")
  local fieldName=nsbase.window.getProperty(formName .. "." .. componentName .. ".fieldname")
  return loadListComponentFromTable(formName,datasource,componentName,fieldName)
end

--------------------------------------------------------------------------------
-- This function load a list into a list type componentName
-- from the data of the fields of a data source
--------------------------------------------------------------------------------
function loadListComponentFromDatasource(form, datasource,componentName)
  local formName=getFormName(form)
  local dataset=nsbase.datasetCreate("SQLQuery")
  dataset.sql=nsbase.application.getSQLFromDatasource(datasource)
  nsbase.window.setProperty(formName .. "." .. componentName .. ".items",dataset.getItems())
end

