--------------------------------------------------------------------------------
-- NSBase utilities
--------------------------------------------------------------------------------
-- Version 1.3
-- Author  Jean-Luc NEUTS
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Apply a conditional format if the fieldname value of the form control
-- is verified as true by the formula
-- If the formula is empty, the formatting is applied
-- Sample (in ActionOnChange):
--  applyConditionalFormat(self,"edtTotalDepreciation1","","clWhite","clBlack",0)
--  applyConditionalFormat(self,"edtTotalDepreciation1",">100","clRed","clWhite",0)
--------------------------------------------------------------------------------
function applyConditionalFormat(form,control,formula,color,fontColor,fontStyle)
  local formName=getFormName(form)
  local ds=nsbase.datasetCreate(formName)
  local fieldName=nsbase.window.getProperty(formName..'.'..control..'.fieldname')
  if fieldName~="" then
    local value=ds.getFieldname(fieldName)
  else
    value=nsbase.window.getProperty(formName..'.'..control..'.text')
  end
  local ok=true
  if formula~="" then
    if not tonumber(value) then
      value="'"..value.."'"
    end
    ok=evalExpr(value..formula)
  end
  if ok then
    if color~="" then
      nsbase.window.setProperty(formName..'.'..control..'.color',color)
    end
    if fontColor~="" then
      nsbase.window.setProperty(formName..'.'..control..'.font.color',fontColor)
    end
    if fontStyle~="" then
      nsbase.window.setProperty(formName..'.'..control..'.font.style',fontStyle)
    end
  end
end;

--------------------------------------------------------------------------------
-- Evaluate a string string expression and return the result
--------------------------------------------------------------------------------
function evalExpr(s)
  local f=load("return " .. s)
  return f()
end

--------------------------------------------------------------------------------
-- Evaluate a string without return
--------------------------------------------------------------------------------
function eval(s)
  local f=load(s)
  f()
end

--------------------------------------------------------------------------------
-- Return Form Name string
--------------------------------------------------------------------------------
function getFormName(form)
  if type(form)=="table" then
    return form.name
  else
    return form
  end
end

--------------------------------------------------------------------------------
-- these two functions for get informations of objects application
--------------------------------------------------------------------------------
function getAppObject(objectName)
  objectName=string.lower(objectName)
  local objects=nsbase.application.getObjects("table")
  for _,object in ipairs(objects) do
    if  string.lower(object.name)==objectName then
      return object
    end
  end
  return nil
end

function appObjectExist(objectName)
  return getAppObject(objectName)~=nil
end

--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-- these two functions for get control informations
--------------------------------------------------------------------------------
function getWindowControl(controlName)
  controlName=string.lower(controlName)
  local controls=nsbase.window.active.getControls("table")
  for _,control in ipairs(controls) do
    if  string.lower(control.name)==controlName then
      return control
    end
  end
  return nil
end

function windowControlExist(controlName)
  return getWindowControl(controlName)~=nil
end

--------------------------------------------------------------------------------
-- these two functions encode and decode control characters
--------------------------------------------------------------------------------
function decodeControlsCar(str)
  local s,i=string.gsub(str,"\\n","\n")
  s,i=string.gsub(s,"\\r","\r")
  s,i=string.gsub(s,"\\t","\t")
  return s
end

function encodeControlsCar(str)
  local s,i=string.gsub(str,"\n","\\n")
  s,i=string.gsub(s,"\r","\\r")
  s,i=string.gsub(s,"\t","\\t")
  return s
end

--------------------------------------------------------------------------------
-- This function changes all the tags identifying a field in the database
-- by their value
--
-- The parameters are:
-- * objwin: name of the report or form
-- * src: string containing the raw phase in the form :
--     "Hello <#name>, your personal email is <#email>"
-- * Return value: the chain changed
--------------------------------------------------------------------------------
function changeTags(objwin,src)
  local ds=nsbase.datasetCreate(objwin)
  local InTag=0
  local Tag=""
  local result=""
  for i=1,src:len() do
    car=src:sub(i,i)
    if car=="<" then
      InTag=1
    elseif InTag==1 then
      if car=="#" then
        InTag=2
      else
        InTag=0
        result=result .. "<" .. car
      end
    elseif InTag==2 then
      if car==">" then
        InTag=0
        result=result .. ds.getFieldname(Tag)
        Tag=""
      else
        Tag=Tag .. car
      end
    elseif InTag==0 then
      result=result .. car
    end
  end
  if InTag==2 then
    error("function changeTags : > excepted after " .. Tag .. " in src")
  end
  return result
end


