---------------------------------------------------------------------------------------
-- Library for extension string class
--
-- Version 2.0
---------------------------------------------------------------------------------------
-- Exemples :
-- mystring1=" querty  "
-- mystring2="banana"
-- print(mystring1:trim())
-- res=mystring2:startswith("a")
-- res=mystring2:endswith("b")
---------------------------------------------------------------------------------------

function string.trim(self)
  local from = self:match"^%s*()"
  return from > #self and "" or self:match(".*%S", from)
end

---------------------------------------------------------------------------------------

function string.startswith(self, str)
  return string.sub(self, 1, string.len(str)) == str
end

---------------------------------------------------------------------------------------

function string.endswith(self, str)
  return #self >= #str and self:find(str, #self-#str+1, true) and true or false
end

---------------------------------------------------------------------------------------
function string.split(self, separator)
  if separator == nil then
    separator = "%s"
  end
  local result={}
  local i=1
  for str in string.gmatch(self, "([^"..separator.."]+)") do
    result[i] = str
    i = i + 1
  end
  return result
end

