local require = GLOBAL.require
local rawget = GLOBAL.rawget
local STRINGS = GLOBAL.STRINGS
local RECIPETABS = GLOBAL.RECIPETABS
local Ingredient = GLOBAL.Ingredient

GLOBAL.DebugMode = GetModConfigData("DebugMode") --读取配置变量
require "libs/debug"
require "libs/compatible"
local compatible = GLOBAL.compatible

PrefabFiles = {
	"warmbear",
	"honeyspear",
	"bee_h",
	-- "bloogon",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/warmbear.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/warmbear.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/warmbear.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/warmbear.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/warmbear_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/warmbear_silho.xml" ),

    Asset( "IMAGE", "bigportraits/warmbear.tex" ),
    Asset( "ATLAS", "bigportraits/warmbear.xml" ),
	
	Asset( "IMAGE", "images/map_icons/warmbear.tex" ),
	Asset( "ATLAS", "images/map_icons/warmbear.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_warmbear.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_warmbear.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_warmbear.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_warmbear.xml" ),

}
AddMinimapAtlas("images/map_icons/warmbear.xml")

-- overrides
GLOBAL.Debug("Load overrides.")

--重写玩家状态显示栏
local _statusdisplays = require "overrides/widgets/statusdisplays"
AddClassPostConstruct("widgets/statusdisplays", _statusdisplays)
--重写玩家网络变量的文件
if compatible.isdst then
	local _player_classified = require "overrides/prefabs/player_classified"
	AddPrefabPostInit("player_classified", _player_classified)
end
if compatible.isROG or compatible.isSW or compatible.isdst then
	local _sanity = require "overrides/components/sanity"
	AddClassPostConstruct("components/sanity", _sanity)
	local _moisture = require "overrides/components/moisture"
	AddClassPostConstruct("components/moisture", _moisture)
	local _equippable = require "overrides/components/equippable"
	AddClassPostConstruct("components/equippable", _equippable)
end

-- The character select screen lines
STRINGS.CHARACTER_TITLES.warmbear = "The Mildness Warm"
STRINGS.CHARACTER_NAMES.warmbear = "Warmbear"
STRINGS.CHARACTER_DESCRIPTIONS.warmbear = "*Love honey\n*Grow fat\n*Fat Defend winter and hurt"
STRINGS.CHARACTER_QUOTES.warmbear = "\"Can we just not fight?\""

if GLOBAL.compatible.isdst then
	Recipe("honeyspear",
		{Ingredient("honey", 5),
		Ingredient("honeycomb", 1),
		Ingredient("spear", 1),},
		RECIPETABS.WAR,
		{SCIENCE=0},
		nil,
		nil,
		nil,
		nil,
		"warmbear",
		GLOBAL.resolvefilepath("images/inventoryimages/honeyspear.xml"))
	Recipe("honeycomb",
		{Ingredient("bee", 5),
		Ingredient("stinger", 10),
		Ingredient("honey", 5),},
		RECIPETABS.SURVIVAL,
		{SCIENCE=0},
		nil,
		nil,
		nil,
		nil,
		"warmbear")
else
    local honeyspear_recipe = Recipe("honeyspear", {Ingredient("honey", 5), Ingredient("honeycomb", 1), Ingredient("spear", 1),}, RECIPETABS.WAR, {SCIENCE=0})
    local honeycomb_recipe = Recipe("honeycomb", {Ingredient("bee", 5), Ingredient("stinger", 10), Ingredient("honey", 5),}, RECIPETABS.SURVIVAL, {SCIENCE=0})
    honeyspear_recipe.atlas = "images/inventoryimages/honeyspear.xml"
end

STRINGS.NAMES.HONEYSPEAR = "Honey Spear"
STRINGS.RECIPE_DESC.HONEYSPEAR = "Sweet Spear"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HONEYSPEAR = "Sweet!" 

STRINGS.RECIPE_DESC.HONEYCOMB = "Provide your favourite~"

STRINGS.NAMES.BEE_H = "Your Bee"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BEE_H = "It works for me~" 

-- Custom speech strings
STRINGS.CHARACTERS.WARMBEAR = require "speech_warmbear"

-- The character's name as appears in-game 
STRINGS.NAMES.WARMBEAR = "Warmbear"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WARMBEAR = 
{
	GENERIC = "It's Warmbear!",
	ATTACKER = "That Warmbear looks weird.",
	MURDERER = "I can't believe that!",
	REVIVER = "Warmbear, friend of me.",
	GHOST = "I should save him.",
}

local show_type = GetModConfigData("show_type") --读取配置变量
--重写获取物品字符串的函数以实现蜂蜜长矛的蜜蜂数量显示
if show_type == 1 or show_type == 3 then
	local ItemTile = require "widgets/itemtile"
	local ItemTile_GetDescriptionString_base = ItemTile.GetDescriptionString

	function ItemTile:GetDescriptionString()
		local str = ItemTile_GetDescriptionString_base(self)
		-- print(str)
		if self.item:HasTag("honeyspear") then
			local ptr=string.find(str,"\n")
			if ptr ~= nil then
				local tmp=string.sub(str,-(string.len(str)-ptr))
				str=string.sub(str,1,ptr)
				-- print(tmp)
				-- print(str .. "\n" .. self.item.components.childspawner.childreninside .. " Bees inside" .. tmp)
				str = str .. self.item.components.childspawner.childreninside .. " Bees inside" .. "\n" .. tmp-- .. "\nDamage: " .. self.item.components.weapon.damage
			end
		end
		return str or ""
	end
end

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("warmbear", "MALE")
