local function onmax(self, max) -- 对最大值进行设置
    Debug({"On Fat Max Set: ", max})
    if self.inst.player_classified ~= nil then
        Debug("Send to net")
        self.inst.player_classified:SetValue("maxfat", max)
    end
end

local function oncurrent(self, current) -- 对当前值进行设置
    Debug({"On Fat Current Set: ", current})
    if self.inst.player_classified ~= nil then
        Debug("Send to net")
        self.inst.player_classified:SetValue("currentfat", current)
    end
end

local function onratescale(self, ratescale)
    Debug({"On Fat Rate Scale Set: ", ratescale})
    if self.inst.player_classified ~= nil then
        Debug("Send to net")
        self.inst.player_classified:SetValue("fatratescale",ratescale)
    end
end

local Fat = Class(function(self, inst)
    self.inst = inst

    self.max = 200
    self.current = 0

    self.rate = 0
    self.ratescale = RATE_SCALE.NEUTRAL

    self.task = nil
end,
nil,
{
    max = onmax,
    current = oncurrent,
    ratescale = onratescale,
})

function Fat:OnSave()
    Debug("Save Fat")
    return {fat = self.current}
end

function Fat:OnLoad(data)
    if data.fat then
        Debug({"Load Fat: ", data.fat})
        self.current = data.fat
        self:DoDelta(0, true)
    end
end

function Fat:SetMax(amount)
    self.max = amount
end

function Fat:SetRate(rate)
    -- self:Stop()
    self.rate = rate
    self.ratescale = -- 更新速率等级
        (self.rate > 1 and RATE_SCALE.INCREASE_HIGH) or
        (self.rate > .5 and RATE_SCALE.INCREASE_MED) or
        (self.rate > .1 and RATE_SCALE.INCREASE_LOW) or
        (self.rate < -1 and RATE_SCALE.DECREASE_HIGH) or
        (self.rate < -.5 and RATE_SCALE.DECREASE_MED) or
        (self.rate < -.1 and RATE_SCALE.DECREASE_LOW) or
        RATE_SCALE.NEUTRAL
    if self.player_classified ~= nil then
        self.player_classified:SetValue("fatratescale",self.ratescale)
    end
    -- self.inst:PushEvent("fatratechange",{rate=rate})
end

function Fat:SetCurrent(current, overtime)
    self.current = current
    self:DoDelta(0,overtime)
end

function Fat:SetPercent(p, overtime)
    self.current  = p * self.max
    self:DoDelta(0, true)
end

function Fat:GetMax()
    return self.max
end

function Fat:GetRate()
    return self.rate
end

function Fat:GetCurrent()
    return self.current
end

function Fat:GetPercent()
    return self.current / self.max
end

function Fat:GetRateScale()
    return self.ratescale
end

function Fat:Start()
    if self.task == nil then
        self.task = self.inst:DoPeriodicTask(3,function ()
            self:DoDelta(self.rate/2, true)
        end)
    end
end

function Fat:Pause()
    -- if self.task then
    --     self.task:Cancel()
    --     self.task = nil
    -- end
    -- self.rate = 
    self:SetRate(0)
end

function Fat:Stop()
    if self.task then
        self.task:Cancel()
        self.task = nil
    end
    self.rate = 0
end

function Fat:DoDelta(delta, overtime)
    local oldpercent = self.current/self.max
    local tmp = self.current + delta

    if tmp >= 0 and tmp <= self.max then
        self.current = tmp
    else
        if tmp <= 0 then 
            self.current = 0
        end
        if tmp >= self.max then
            self.current = self.max
        end
        if self.rate ~= 0 then self:Pause() end
    end
    self.inst:PushEvent("fatdelta", {oldpercent = oldpercent, newpercent = self.current/self.max, overtime = overtime})
end

function Fat:GetDebugString()
    return string.format("Fat: %2.2f / %2.2f; Rate: %2.2f", self.current, self.max, self.rate)
end

return Fat