local _isDST = rawget(_G, "RATE_SCALE") ~= nil and true or false  -- 存储是否是DST的变量
local _isROG = _G.IsDLCEnabled(1)  -- 存储是否开启巨人统治的变量
local _isSW  = _G.IsDLCEnabled(2)  -- 存储是否开启沉船的变量

Debug({"_isDST : ", _isDST, "\n_isROG", _isROG, "\n_isSW", _isSW})

local function iswinter()
	if _isDST then
		return _G.TheWorld.state.iswinter
	else
		return _G.GetSeasonManager():IsWinter()
	end
end

local function temperature()
	if _isDST then
		return _G.TheWorld.state.temperature
	else
		return _G.GetSeasonManager():GetTemperature()
	end
end

local function ismastersim()
	if _isDST then
		return _G.TheWorld.ismastersim
	else
		return true
	end
end

local function isWet(inst)
	if _isDST then
		return inst:GetIsWet()
	else
	    local mm = GetWorld().components.moisturemanager
    
    	if mm then return mm:IsEntityWet(inst) end
	end
	return false
end

_G.compatible={
	isSW = _isSW,
	isROG = _isROG,
	isdst = _isDST,
	isWet = isWet,
	iswinter = iswinter,
	ismastersim = ismastersim,
	temperature = temperature
}

if not _isDST then
    Debug("Set RATE_SCALE")
    _G.RATE_SCALE = {
        INCREASE_HIGH = 3,
        INCREASE_MED = 2,
        INCREASE_LOW = 1,
        NEUTRAL = 0,
        DECREASE_LOW = -1,
        DECREASE_MED = -2,
        DECREASE_HIGH = -3
    }
end