if DebugMode then  -- 不是debug模式不提供以下函数

	function nilmask(var)  -- 用于使nil可以显示
		return var == nil and "nil" or var
	end

	function DebugPrint(inst, level)  -- 用于调试打印一个表下所有对象，深度可选
		local _level = level - 1
		if _level == 0 then
			return
		else
		   	for k,v in pairs(inst) do
		        if type(v) == "table" then
		            DebugPrint(v, _level)
		        else
		            print(k..":"..tostring(v))
		        end
		    end
		end
	end
	_G.DebugPrint = function(inst, level)
		print("----------")
		DebugPrint(inst, level)
		print("----------")
	end 

	local function _tostring(str)
		if type(str) == "string" then return str
		else return tostring(str) end
	end

	function Debug(str)  -- 调试打印函数，屏蔽调试模式没有显示
		if type(str) == "table" then
			local s = ""
			for k,v in ipairs(str) do
				s = s.._tostring(v)
			end
			print("[Warmbear]: "..s)
		else
			print("[Warmbear]: ".._tostring(str))
		end

	end
else
	function Debug(str) return end
	function nilmask(str) return end
end

_G.Debug = Debug
_G.nilmask = nilmask