local function OnFatDelta(parent, data)
    Debug("OnFatDelta_Classified")
    if data.overtime then
        parent.player_classified.isfatpulse:set_local(false)
    else
        --Force dirty, we just want to trigger an event on the client
        -- SetDirty(parent.player_classified.isfatpulse, true)
        parent.player_classified.isfatpulse:set_local(true)
        parent.player_classified.isfatpulse:set(true)
    end
end

local function OnFatDirty(inst)
    Debug("OnFatDirty")
    if inst._parent ~= nil then
        local percent = inst.currentfat:value() / inst.maxfat:value()
        inst._parent:PushEvent("fatdelta", { oldpercent = inst._oldfatpercent, newpercent = percent, overtime = not inst.isfatpulse:value() })
        inst._oldfatpercent = percent
    else
        inst._oldfatpercent = 1
    end
    inst.isfatpulse:set_local(false)
end

local function RegisterNetListeners_Warmbear(inst)
	Debug("RegisterNetListeners_Warmbear.")
    if TheWorld.ismastersim then
        inst:ListenForEvent("fatdelta", OnFatDelta, inst._parent)
    else
        inst:ListenForEvent("fatdirty", OnFatDirty)
    end
end

function fn(inst)
	Debug("player_classified Hack start.")
    inst._oldfatpercent = 1
    inst.currentfat = net_ushortint(inst.GUID, "fat.current", "fatdirty")
	inst.maxfat = net_ushortint(inst.GUID, "fat.max", "fatdirty")
    inst.fatratescale = net_tinybyte(inst.GUID, "fat.ratescale")
    inst.isfatpulse = net_bool(inst.GUID, "fat.dodeltaovertime", "fatdirty")
    -- inst:DoTaskInTime(0,RegisterNetListeners_Warmbear)
    RegisterNetListeners_Warmbear(inst)
end

return fn
