local FatBadge = require "widgets/fatbadge"

local function OnSetPlayerMode_Fat(inst, self)
    --加入脂肪值更新的函数
    Debug("OnSetPlayerMode_Fat")
    if self.fat ~= nil and self.onfatdelta == nil then
        self.onfatdelta = function(owner, data) self:FatDelta(data) end
        self.inst:ListenForEvent("fatdelta", self.onfatdelta, self.owner)
        self.fat:SetPercent(self.owner:GetFat())
    end
end

local function OnSetPlayerMode(inst, self)
	Debug("OnSetPlayerMode")
    self.modetask = nil

    if self.onhealthdelta == nil then
        self.onhealthdelta = function(owner, data) self:HealthDelta(data) end
        self.inst:ListenForEvent("healthdelta", self.onhealthdelta, self.owner)
        self:SetHealthPercent(self.owner.replica.health:GetPercent())
    end

    if self.onhungerdelta == nil then
        self.onhungerdelta = function(owner, data) self:HungerDelta(data) end
        self.inst:ListenForEvent("hungerdelta", self.onhungerdelta, self.owner)
        self:SetHungerPercent(self.owner.replica.hunger:GetPercent())
    end

    if self.onsanitydelta == nil then
        self.onsanitydelta = function(owner, data) self:SanityDelta(data) end
        self.inst:ListenForEvent("sanitydelta", self.onsanitydelta, self.owner)
        self:SetSanityPercent(self.owner.replica.sanity:GetPercent())
    end

    if self.onmoisturedelta == nil then
        self.onmoisturedelta = function(owner, data) self:MoistureDelta(data) end
        self.inst:ListenForEvent("moisturedelta", self.onmoisturedelta, self.owner)
        self:SetMoisturePercent(self.owner:GetMoisture())
    end

    if self.beaverness ~= nil and self.onbeavernessdelta == nil then
        self.onbeavernessdelta = function(owner, data) self:BeavernessDelta(data) end
        self.inst:ListenForEvent("beavernessdelta", self.onbeavernessdelta, self.owner)
        self:SetBeavernessPercent(self.owner:GetBeaverness())
    end

    OnSetPlayerMode_Fat(inst, self)
end

local function OnSetGhostMode(inst, self)
	Debug("OnSetGhostMode")
    self.modetask = nil

    if self.onhealthdelta ~= nil then
        self.inst:RemoveEventCallback("healthdelta", self.onhealthdelta, self.owner)
        self.onhealthdelta = nil
    end

    if self.onhungerdelta ~= nil then
        self.inst:RemoveEventCallback("hungerdelta", self.onhungerdelta, self.owner)
        self.onhungerdelta = nil
    end

    if self.onsanitydelta ~= nil then
        self.inst:RemoveEventCallback("sanitydelta", self.onsanitydelta, self.owner)
        self.onsanitydelta = nil
    end

    if self.onmoisturedelta ~= nil then
        self.inst:RemoveEventCallback("moisturedelta", self.onmoisturedelta, self.owner)
        self.onmoisturedelta = nil
    end

    if self.onbeavernessdelta ~= nil then
        self.inst:RemoveEventCallback("beavernessdelta", self.onbeavernessdelta, self.owner)
        self.onbeavernessdelta = nil
    end

    --删除脂肪值更新函数
    if self.onfatdelta ~= nil then
        self.inst:RemoveEventCallback("fatdelta", self.onfatdelta, self.owner)
        self.onfatdelta = nil
    end
end

local function ShowStatusNumbers(self)
    self.brain.num:Show()
    self.stomach.num:Show()
    self.heart.num:Show()
    self.moisturemeter.num:Show()
    if self.beaverness ~= nil then
        self.beaverness.num:Show()
    end
    if self.fat ~= nil then --和其他值一起显示
    	self.fat.num:Show()
    end
end

local function HideStatusNumbers(self) --和其他一起隐藏
    self.brain.num:Hide()
    self.stomach.num:Hide()
    self.heart.num:Hide()
    self.moisturemeter.num:Hide()
    if self.beaverness ~= nil then
        self.beaverness.num:Hide()
    end
    if self.fat ~= nil then
    	self.fat.num:Hide()
    end
end

local function SetGhostMode(self, ghostmode)
    Debug({"SetGhostMode: ", ghostmode, "(isghostmode: ", nilmask(self.isghostmode), ")"})
    if not self.isghostmode == not ghostmode then --force boolean
        return
    elseif ghostmode then
        self.isghostmode = true

        self.heart:Hide()
        self.stomach:Hide()
        self.brain:Hide()
        self.moisturemeter:Hide()

        self.heart:StopWarning()
        self.stomach:StopWarning()
        self.brain:StopWarning()

        if self.beaverness ~= nil then
            self.beaverness:Hide()
            self.beaverness:StopWarning()
        end
        if self.fat ~= nil then
        	self.fat:Hide()
        end
    else
        self.isghostmode = nil

        self.heart:Show()
        self.stomach:Show()
        self.brain:Show()
        self.moisturemeter:Show()

        if self.beaverness ~= nil then
            self.beaverness:Show()
        end
        if self.fat ~= nil then
        	self.fat:Show()
        end
    end

    if self.rezbuttontask ~= nil then
        self.rezbuttontask:Cancel()
        self.rezbuttontask = nil
    end
    self:EnableResurrect(self.owner.components.attuner ~= nil and self.owner.components.attuner:HasAttunement("remoteresurrector"))

    if self.modetask ~= nil then
        self.modetask:Cancel()
    end
    self.modetask = self.inst:DoTaskInTime(0, ghostmode and OnSetGhostMode or OnSetPlayerMode, self)
end


--添加脂肪值显示
local function AddFat(self)
	if self.fat == nil then
		self.fat = self:AddChild(FatBadge(self.owner))
		self.brain:SetPosition(40,-55,0)
        self.fat:SetPosition(-40, -55, 0)--设置图标位置
        Debug({"isghostmode: ", nilmask(self.isghostmode), "; modetask: ", nilmask(self.modetask), "; onfatdelta is nil: ", nilmask(self.onfatdelta)})
	    if self.isghostmode then
            self.fat:Hide()
        elseif self.modetask == nil and self.onfatdelta == nil then
            self.onfatdelta = function(owner, data) self:FatDelta(data) end
            self.inst:ListenForEvent("fatdelta", self.onfatdelta, self.owner)
            self.fat:SetPercent(self.owner:GetFat())
        end
    end
end

local function FatDelta(self, data)
    Debug({"FatDelta: ", data.newpercent})
	self.fat:SetPercent(data.newpercent)
    if not data.overtime then
        if data.newpercent > data.oldpercent then
            self.fat:PulseGreen()
            TheFrontEnd:GetSound():PlaySound("dontstarve/HUD/hunger_up")
        elseif data.newpercent < data.oldpercent then
            TheFrontEnd:GetSound():PlaySound("dontstarve/HUD/hunger_down")
            self.fat:PulseRed()
        end
    end
end

function fn(self)
	Debug("statusdisplays Hack start.")
    if self.owner:HasTag("warmbear") then
    	self.ShowStatusNumbers = ShowStatusNumbers
    	self.HideStatusNumbers = HideStatusNumbers
        self.AddFat = AddFat
        self.SetGhostMode = SetGhostMode

    	self.FatDelta = FatDelta

    	Debug({'HasTag("fat"): ', self.owner:HasTag("fat")})
    	if self.owner:HasTag("fat") then --检查是否是有脂肪值这个需求的标签
    		self:AddFat() --添加脂肪值的显示
    		self.onfatdelta = nil --脂肪值变化时的显示控制
    	end

        -- 由于继承称来的函数已经做过了产生玩家的初始化函数，覆盖跟不上，只能在这里加入一条强制初始化
        if not self.isghostmode  and not self.onfatdelta then
            Debug("Force FatBadge Init")
            OnSetPlayerMode_Fat(self.inst, self)
        end
    end
end

return fn
